<?php
/**
 * @package linea21.utils
 * @subpackage report_sdi
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

// extended TCPF with custom functions
class eTCPDF extends TCPDF {


  //Page header
  public function Header() {

    global $report_settings;
    global $lang;
    // Logo
    $image_file = override('../report_sdi/inc_report/logo_p.png', THEME_PUBLIC_PATH);
    $this->Image($image_file, 20, 10, 0, 7, '', '', 'T', false, 300, '', false, false, 0, false, false, false);

    $today = date("d/m/Y");
    $content = formatText($report_settings['title']) .' - '. SITE_NAME;

    $this->SetTextColorArray(getColor('DOC_COLOR_HEADER'));
    $this->SetFont(DOC_POLICE, 'B', MIN_SIZE);
    // Title
    $this->Cell(0, MIN_SIZE, SITE_NAME . ' - ' .$today, 0, 1, 'R', 0, '', 0, false, 'M', 'M');
    $this->SetFont(DOC_POLICE, '', MIN_SIZE);
    $this->Cell(0, MIN_SIZE, $content, 0, 1, 'R', 0, '', 0, false, 'M', 'M');
    $this->SetLineStyle(array('color'=> array(100,100,100)));
    $this->Line($this->GetX(), $this->GetY(), $this->GetX()+180, $this->GetY());
  }


  // Page footer
  public function Footer() {

    global $report_settings;
    global $lang;
    $content = $report_settings['author'];
    if(!empty($report_settings['mail_author']))  {
      $content .= ' ('.$report_settings['mail_author'].')';
      $mailto='mailto:'.$report_settings['mail_author'];
    } else $mailto='';
    $content_comp= !empty($report_settings['service_author']) ? ' -- '.$report_settings['service_author'] : '';
    $content_comp.= !empty($report_settings['adress_author']) ? ' -- '.$report_settings['adress_author'] : '';

    $this->SetTextColorArray(getColor('DOC_COLOR_HEADER'));
    $this->SetFont(DOC_POLICE, '', MIN_SIZE);
    $this->SetY(-10);
    $this->SetLineStyle(array('color'=> array(100,100,100)));
    $this->Line($this->GetX(), $this->GetY(), $this->GetX()+180, $this->GetY());

    $this->Cell($this->GetStringWidth($content), MIN_SIZE, $content, 0, 0, 'L', 0, $mailto);
  	$this->Cell(0, MIN_SIZE, $content_comp, 0, 0, 'L');
  	$this->Cell(0, MIN_SIZE, $lang['divers']['page'].' ' . $this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, 0, 'R');
  
  }

}
?>