<?php
/**
 * @package linea21.modules
 * @subpackage resources
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Resource' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$resources_object= new resources;

if($type=='P') {
  $requete= SQL_getPublicationTitle($parent);
  $result=$sql_object->DBSelect($requete);
  $current_title=FormatText($result[0]['publi_title'], '2HTML');
  $complete_type='PUBLICATION';
  $publi_owner=$result[0]['publi_posted_by'];

  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
  if ($l21auth->GetSessionElement('id')!=$publi_owner && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
  ///////////
}
if($type=='W') {
  $requete= SQL_getWorkshopTitle($parent);
  $result=$sql_object->DBSelect($requete);
  $current_title=FormatText($result[0]['workrep_title'], '2HTML');
  $complete_type='WORKSHOP';
  $workshop_id=$result[0]['workrep_workshop_id'];

  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
  if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $workshop_id) && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
  ///////////
}
if(!isset($_POST['valider'])) {
  $requete= SQL_getMultiInfo($id);
  $result=$sql_object->DBSelect($requete);
  $form_name=formatText($result[0]['multires_name'], '2FIELD');
  $form_description=formatText($result[0]['multires_description'], '2FIELD');
  $form_url=$result[0]['multires_media_uri'];
}
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu',$mod_inc); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('resources',$mod_inc.'_type')." : ". $current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$resources_object->ModifyMultiRes($id, $data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&type=".$type."&id=".$parent;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

if(isset($_POST['valider'])) {
  $table[0]=$_POST['multi_name'];
  $table[1]=$_POST['multi_description'];
  $table[2]=$_POST['multi_url'];

  $integrity=$resources_object->CheckDataIntegrity($table,'MULTI');

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_name=formatText($_POST['multi_name'], $text_format);
  $form_description=formatText($_POST['multi_description'], $text_format);
  $form_url=formatText($_POST['multi_url'], $text_format);

  $table=urlencode(serialize($table));
}


include_once(THEME_ADMIN_PATH."quickicons.php");

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
 <script type="text/javascript">
	$(document).ready(function(){
		$("#browse_server").colorbox({iframe:true, innerWidth:"80%", innerHeight:"80%" });
		/**
		// @todo remove
		$("#browse_server").click(function() {
			 BrowseServer($('#browse_server').attr('href'), 'multi_url');
			 return false;
			});
		*/
	});
 </script>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($current_title); ?></h2>
<form id="modmulti" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
  <p>
    <label for="multi_name"><?php echo mb_ucfirst(_t('resources','multi_name')); ?> : *</label>
    <input name="multi_name" type="text" class="textfield" id="multi_name" maxlength="200" value="<?php echo $form_name; ?>" />
  </p>
  <p>
  	<label for="multi_description"><?php echo mb_ucfirst(_t('resources','multi_description')); ?> : *</label>
  	<textarea id="multi_description" name="multi_description" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_description; ?></textarea>
  </p>
  <p>
  	<label for="multi_url"><?php echo mb_ucfirst(_t('resources','url')); ?> : *</label>
  	<input name="multi_url" type="text" class="textfield-shorten" id="multi_url" maxlength="255" value="<?php echo $form_url; ?>" />
	<a id="browse_server" href="../library/access.php?langCode=<?php echo U_L; ?>" title="<?php echo _t('filemanager','browse'); ?>"><i class=" icon-folder-open"></i><span><?php echo _t('filemanager','browse'); ?></span></a>
  </p>
  <div>
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
    <input name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" /> 
    <?php echo cancel_button($cancel_link); ?> 
    <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
  </div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?></div>
<?php
// Récapitulatif
} else	{

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('resources','multi_name'))." :</dt>\n";
echo "<dd>".$form_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('resources','multi_description'))." :</dt>\n";
echo "<dd>".$form_description."</dd>\n";
echo "<dt>".mb_ucfirst(_t('resources','url'))." :</dt>\n";
echo "<dd>".$form_url."</dd>\n";
echo "</dl>\n";
?>
<form id="modmulti" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
    <input name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" /> 
    <?php echo cancel_button($cancel_link); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>
<?php
}
?>