<?php
/**
 * @package linea21.core
 * @subpackage scale
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$req_det= SQL_getdetscale($id);
$result=$sql_object->DBSelect($req_det);
$current_title=$result[0]['scale_denomination'];

$root_id=$result[0]['scale_root'];
$current_dep=$result[0]['scale_dependencies'];
$display_root=formatText($result[0]['scale_denomination_root'], '2HTML');
$display_surface=$result[0]['scale_surface'];
$display_inhabitantsnumber=$result[0]['scale_inhabitantsnumber'];
$display_comment=formatText(empty_nc($result[0]['scale_comment'], '2HTML'));
$display_last_modify=$result[0]['scale_last_modify'];
$display_date_crea=$result[0]['scale_date_crea'];
$display_status=display_statut($result[0]['scale_statut']);


$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','scale')?></a></li>
	<li><span><?php echo formatnavTitle(_t('scale','det') .' : '.$current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2($current_title); ?></h2>
<?php
if ($root_id<>0) echo "<a href=\"".$link_sup.$id."\" title=\""._t('scale','sup')."\" class=\"ico_sup2\"><i class=\"icon-trash\"></i><span>" . _t('scale','sup') . "</span></a>";
echo "<a href=\"".$link_mod.$id."\" title=\""._t('scale','mod')."\" class=\"ico_mod2\"><i class=\"icon-pencil\"></i><span>" . _t('scale','mod') . "</span></a>";
?>
<dl class="summary">
<?php
if ($current_dep!=0) {
  ?>
	<dt><?php echo mb_ucfirst(_t('scale','root')); ?> :</dt>
	<dd><?php echo "<a href=\"".$link_det.$root_id."\">".$display_root."</a>"; ?></dd>
<?php
}
?>
	<dt><?php echo mb_ucfirst(_t('scale','surface')); ?> (<?php echo SURFACE_UNIT; ?>) :</dt>
	<dd><?php echo $display_surface ?></dd>
	<dt><?php echo mb_ucfirst(_t('scale','population')); ?> :</dt>
	<dd><?php echo $display_inhabitantsnumber; ?></dd>
	<dt><?php echo mb_ucfirst(_t('scale','comment')); ?> :</dt>
	<dd><?php echo $display_comment;?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','last_modify')); ?> :</dt>
	<dd><?php echo $display_last_modify; ?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','date_crea')); ?> :</dt>
	<dd><?php echo $display_date_crea ; ?></dd>
	<?php /*<dt><?php echo mb_ucfirst(_t('divers','statut')); ?>  :</dt>
	<dd><?php echo $display_status;?></dd> */ ?>
</dl>
</div>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>