<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop') && !$l21auth->isSuperAdmin())
	ReloadIndex('admin');
////////////

if(!isset($_GET['statut']) || $_GET['statut']==-1) $statut=-1;
elseif($_GET['statut']!=-1) $statut=$_GET['statut'];

//statut public pour les non super administrateurs
if (!$l21auth->isSuperAdmin()) $statut='public';

if(!isset($_GET['debut'])) $debut=0;
else $debut=$_GET['debut'];

$mask_statut_1='';
$mask_statut_2='';
$mask_statut_3='';
$mask_statut_4='';
if($statut=='public') $mask_statut_1='selected="selected"';
if($statut=='draft') $mask_statut_2='selected="selected"';

// Nombre d'enregistrement total dans la bdd
$result_nb_req=$sql_object->DBSelect($req_count_workshop);
$bdd_nb_workshop=$result_nb_req[0]['num_rows'];
$bdd_nb_workshop_display = $bdd_nb_workshop." "._t('workshop','nb_total')."<br />\n";

if($statut!=-1) {
  $link_back="<div class=\"filter\"><a href=\"".$rub_link."&amp;todo=list\">"._t('workshop','all')."</a></div>";
  $req_count_workshop=SQL_getCountWorkshopList($statut);
  $result_nb_req=$sql_object->DBSelect($req_count_workshop);
  $count_request=$result_nb_req[0]['num_rows'];
  $req_list_workshop=SQL_getWorkshopList($debut, SELECT_LIMIT, $statut);
  $result_workshop_list=$sql_object->DBSelect($req_list_workshop);
} else {
  $link_back='';
  $count_request=$bdd_nb_workshop;
  $req_list_workshop=SQL_getWorkshopList($debut, SELECT_LIMIT, $statut);
  $result_workshop_list=$sql_object->DBSelect($req_list_workshop);
}

if($count_request<=1) $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','record')."<br />\n";
else $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','records')."<br />\n";


$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_statut=$rub_link."&amp;todo=list&amp;statut=";
$link_self=$link_statut.$statut;


// Liste des statuts disponibles
$select_statut="<select name=\"statut_filter\" id=\"statut_filter\">\n";
$select_statut.="<option value=\"-1\">"._t('workshop','statut_filter')."</option>\n";
$select_statut.="<option value=\"".$link_statut."public\"".$mask_statut_1.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"".$link_statut."draft\"".$mask_statut_2.">".display_statut('D')."</option>\n";
$select_statut.="</select>\n";

$js = "	$('#statut_filter').change(function() {
					window.location = $(this).val();
				});";

footerAddInlineJS($js);
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo _t('workshop','list') ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">
<?php if ($l21auth->isSuperAdmin()) {
  echo $link_back;
  ?>
<div class="filterselect"><?php
echo $select_statut;
?></div>
<?php }?>
<p><?php
echo $bdd_nb_workshop_display;
echo $count_request_display;
?></p>
<?php
echo linkin_page($link_self, $count_request, $debut);

if($result_workshop_list!=0) {
  echo "<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable multisort\" id=\"sort-table\">\n";
  echo "<thead>\n";
  echo "<tr>\n";
  echo "<td>".mb_ucfirst(_t('workshop','title'))."</td>\n";
  echo "<td>".mb_ucfirst(_t('divers','date_crea'))."</td>\n";
  echo "<td class=\"sorter-false\">&nbsp;<span class=\"semnone\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  echo "</tr>\n";
  echo "</thead>\n";
  echo "<tbody>\n";


  for($i=0; $i<count($result_workshop_list); $i++) {
    $workshop_title=formatText(cutText($result_workshop_list[$i]['workshop_denomination'], 60, 1), '2HTML');
    echo "<tr id=\"workshop-".$result_workshop_list[$i]['workshop_id']."\">\n";
    echo "<td><a href=\"".$link_det.$result_workshop_list[$i]['workshop_id']."\" title=\""._t('workshop','det')."\">".$workshop_title."</a></td>\n";
    echo "<td>".$result_workshop_list[$i]['workshop_date_crea_display']."</td>\n";

    if ($l21auth->isSuperAdmin() || $l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $result_workshop_list[$i]['workshop_id']) ) {
      echo "<td width=\"10%\"><div class=\"iconetab\">";
      if ($l21auth->isSuperAdmin()) {
      	echo "<a href=\"".$link_sup.$result_workshop_list[$i]['workshop_id']."\" title=\""._t('workshop','sup')."\" class=\"ico_sup\"><i class=\"icon-trash\"></i><span>" . _t('workshop','sup') . "</span></a>\n";
      }
      echo "<a href=\"".$link_mod.$result_workshop_list[$i]['workshop_id']."\" title=\""._t('workshop','mod')."\" class=\"ico_mod\"><i class=\"icon-pencil\"></i><span>" . _t('workshop','mod') . "</span></a></div></td>";
    }
    else echo "<td width=\"10%\">&nbsp;</td>";
    echo "</tr>\n";
  }

  echo "</tbody>";
  echo "</table>";

} else {
  echo "<div class=\"info\">"._t('workshop','noresult')."</div>";
}
echo linkin_page($link_self, $count_request, $debut);

?></div>

<?php
// Ability to sort table
addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
$str = '$("table.multisort").tablesorter({	});';
footerAddInlineJS($str);

// Ability to drag'n drop items
if ($l21auth->isSuperAdmin()) {
	footerAddJS('../lib/js/jquery.tablednd_0_5.js');
	dragTableSettings();
}
?>
<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>