<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author Simon Georget <simon@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

/** Préparation du mail
 * $email_html_body
 * $email_text_body
 * $email_subject
 * $email_recipient
 **/
switch($a['action']) {
  case 'file_alert':
  	if(isset($a['is_shared']) && $a['is_shared'] === true) {
    	$intro = _t('workshop','mail_file_body1b');
    	$url =  SITE_ROOT_URL. 'public/' .get_permalink($wlinkworkgroups);
    	$email_subject = mb_ucfirst(_t('workshop','mail_file_subject_b'));
  	} else {
  		$intro = sprintf(_t('workshop','mail_file_body1'), $wname);
  		$url =  SITE_ROOT_URL. 'public/' .get_permalink($wlinkfiles);
  		$email_subject = mb_ucfirst(sprintf(_t('workshop','mail_file_subject'), $wname, SITE_NAME));
  	}
  	$email_html_body = "<p>". $intro . "</p>".END_LINE;
    $email_html_body .= "<p>". sprintf(_t('workshop','mail_file_body2'), $a['owner']) . "</p>".END_LINE;
    $email_html_body .= "<em>".END_LINE;
    if(isset($a['files'])) {
      foreach($a['files'] as $file) {
        $email_html_body .= "- ".$file."<br />".END_LINE;
      }
    }
    $email_html_body .= "</em><br /><br />".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_body_url') . "<br />".END_LINE;
    $email_html_body .= "<a href=" . $url. ">" . $url . "</a></p>".END_LINE;
    $email_html_body .= "<p>"._t('workshop','mail_body_auth') . "</p>".END_LINE;

    $email_text_body = strip_tags($email_html_body);

    $email_recipient = $user->profile_email;
    break;
  case 'topic_alert':
    $email_html_body = "<p>". sprintf(_t('workshop','mail_topic_body1'), $a['owner'], formatText($a['topic_subject'], '2HTML'), formatText($wname, '2HTML')) . "</p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_msg_content') . " :</p>".END_LINE;
    $email_html_body .= "<p><em>". formatText($a['topic_body'], '2HTML') ."</em></p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_body_url') . "<br />".END_LINE;
    $email_html_body .= "<a href=\"" . SITE_ROOT_URL. 'public/' .get_permalink($wlinkforum). "\">". SITE_ROOT_URL. 'public/'  .get_permalink($wlinkforum). "</a></p>".END_LINE;
    $email_html_body .= "<p>"._t('workshop','mail_body_auth') . "</p>".END_LINE;
    	
    $email_text_body = strip_tags($email_html_body);

    $email_subject = mb_ucfirst(sprintf(_t('workshop','mail_topic_subject'), $wname, SITE_NAME));
    $email_recipient = $user->profile_email;
    break;
  case 'post_alert':
    $email_html_body = "<p>". sprintf(_t('workshop','mail_post_body1'), $a['owner'], formatText($a['topic_subject'], '2HTML'), formatText($wname, '2HTML')) . "</p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_msg_content') . " :</p>".END_LINE;
    $email_html_body .= "<p><em>". formatText($a['topic_body'], '2HTML') ."</em></p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_body_url') . "<br />".END_LINE;
    $email_html_body .= "<a href=\"" . SITE_ROOT_URL. 'public/' .get_permalink($wlinkforum). "\">". SITE_ROOT_URL. 'public/'  .get_permalink($wlinkforum). "</a></p>".END_LINE;
    $email_html_body .= "<p>"._t('workshop','mail_body_auth') . "</p>".END_LINE;

    $email_text_body = strip_tags($email_html_body);

    $email_subject = mb_ucfirst(sprintf(_t('workshop','mail_post_subject'), $wname, SITE_NAME));
    $email_recipient = $user->profile_email;
    break;
    case 'event_alert':
    	$email_html_body = "<p>". sprintf(_t('workshop','mail_calendar_body1'), $a['owner'], formatText($a['task_subject'], '2HTML') , $wname, formatText($a['task_date'], '2HTML')) . "</p>".END_LINE;
	    $email_html_body .= "<p>". _t('workshop','mail_calendar_body2') . "</p>".END_LINE;
	    $email_html_body .= "<p><em>".formatText($a['task_body'], '2HTML')."</em></p>".END_LINE;
    	$email_html_body .= "<p>". _t('workshop','mail_body_url') . "<br />".END_LINE;
    	$email_html_body .= "<a href=\"" . SITE_ROOT_URL. 'public/' .get_permalink($wlinkcalendar). "\">". SITE_ROOT_URL. 'public/'  .get_permalink($wlinkcalendar). "</a></p>".END_LINE;
    	// $email_html_body .= "<p>"._t('workshop','mail_body_auth') . "</p>".END_LINE;
    
    	$email_text_body = strip_tags($email_html_body);
    
    	$email_subject = mb_ucfirst(sprintf(_t('workshop','mail_calendar_subject'), $wname, SITE_NAME));
    	$email_recipient = $user->profile_email;
    	break;
  case 'workgroup_request':
    $email_html_body = "<p>" . sprintf(_t('workshop', 'workgroup_request'), $_SESSION['userlogin']). "</p>".END_LINE;
    $email_html_body .= "<p>". $groups . "</p>".END_LINE;
    $email_html_body .= "<p><em>". _t('divers', 'comment')."</em> : ". formatText($_POST['comment'], '2HTML') ."</p>".END_LINE;
    $email_html_body .= "<p>". _t('workshop','mail_body_url') . "<br /><a href=" . $a['moderate_link'] . ">" . $a['moderate_link'] . "</a><br />";
    $email_html_body .= "("._t('workshop','mail_body_auth') . ")</p>".END_LINE;
    
    $email_text_body  = strip_tags(sprintf(_t('workshop', 'workgroup_request'), $_SESSION['userlogin'])).END_LINE;
    $email_text_body .= strip_tags($groups).END_LINE.END_LINE;
    $email_text_body .= _t('divers', 'comment'). ' : '. formatText($_POST['comment'], '2HTML') .END_LINE.END_LINE;
    $email_text_body .= ucfirst(_t('workshop', 'mail_body_url')) . ' : '. $a['moderate_link'].END_LINE;
    $email_text_body .= "("._t('workshop','mail_body_auth') . ")".END_LINE;

    $email_subject = mb_ucfirst(sprintf(_t('workshop','mail_request_subject'). '- %s', SITE_NAME));
    $email_recipient = $user_recipient;
    break;
  default:
    exit();
}

?>