<?php
/**
 * @package linea21.modules
 * @subpackage workshoprep
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$req_det= SQL_getoneCompleteWorkshopRep($id);
$result=$sql_object->DBSelect($req_det);
if(count($result)>1) exit();

$workrep_title=formatText($result[0]['workrep_title'], '2HTML');
$workrep_resume=formatText($result[0]['workrep_resume'], '2HTML');
$workrep_comment=formatText(empty_none($result[0]['workrep_comment']), '2HTML');
$workrep_statut=display_statut($result[0]['workrep_statut']);
$display_date_crea=$result[0]['workrep_date_crea_display'];
$display_last_modify=$result[0]['workrep_last_modify_display'];
if($result[0]['workrep_published_date_display']=='01-01-0001') $display_published_date=_t('workshoprep','not_published');
else $display_published_date=$result[0]['workrep_published_date_display'];
$workrep_workshop_name=formatText($result[0]['workshop_denomination'], '2HTML');
$workshop_title=' ('.$workrep_workshop_name.')';
$work_id=$result[0]['workrep_workshop_id'];

$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";

// formattage des données
include_once('../class/class.resources.php');
$resources_object = new resources;


//prepa affichage des infos générales

$reca_generals ="<h3 class=\"part\">"._t('workshoprep','generals')." : </h3>\n";
$reca_generals.="<dl class=\"summary\">\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshoprep','title'))." :</dt>\n";
$reca_generals.="<dd>". $workrep_title."</dd>\n";
$reca_generals.="<dt>". mb_ucfirst(_t('workshoprep','resume')). " :</dt>\n";
$reca_generals.="<dd>".$workrep_resume."</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshoprep','workshop_product')). " :</dt>\n";
$reca_generals.="<dd>".$workrep_workshop_name."</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshoprep','published_on')) ." :</dt>\n";
$reca_generals.="<dd>".$display_published_date. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('divers','date_crea')) ." :</dt>\n";
$reca_generals.="<dd>". $display_date_crea. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('divers','last_modify')) ." :</dt>\n";
$reca_generals.="<dd>". $display_last_modify. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
$reca_generals.="<dd>". $workrep_statut. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshoprep','comment'))." :</dt>\n";
$reca_generals.="<dd>". $workrep_comment. "</dd>\n";
$reca_generals.="</dl>\n";


//prepa affichage des différentes parties du dossier
$part_link_add="?rub=contents&amp;todo=add&amp;parent=".$id."&amp;type=W";
$part_link_sup="?rub=contents&amp;todo=sup&amp;parent=".$id."&amp;type=W&amp;id=";
$part_link_mod="?rub=contents&amp;todo=mod&amp;parent=".$id."&amp;type=W&amp;id=";
$part_link_det="?rub=contents&amp;todo=det&amp;parent=".$id."&amp;type=W&amp;id=";
$req_parts=SQL_getWorkshopParts($id);
$result=$sql_object->DBSelect($req_parts);
if($result==0) $contents_parts="<div class=\"info\">"._t('workshoprep','no_part')."</div>";
else {
  
  $contents_parts ="<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable\" id=\"sort-part\">\n";
  $contents_parts.="<tbody>\n";
  
  for($i=0; $i<count($result); $i++) {
    
    $contents_parts.="<tr id=\"part-".$result[$i]['workrepcon_id']."\">\n";
    $contents_parts.="<td><a href=\"".$part_link_det.$result[$i]['workrepcon_id']."\" title=\"Détails du thème\">".formatText($result[$i]['workrepcon_title'], '2HTML')."</a></td>\n";
    $contents_parts.="<td style=\"width:80px\">\n";
    if($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) || $l21auth->isSuperAdmin()) {
      $contents_parts.="<div class=\"iconetab\">\n";
      $contents_parts.="\t<a href=\"".$part_link_sup.$result[$i]['workrepcon_id']."\" class=\"ico_sup\" title=\""._t('workshoprep','del_part')."\"><i class=\"icon-trash\"></i><span>" . _t('workshoprep','del_part') . "</span></a>\n";
      $contents_parts.="\t<a href=\"".$part_link_mod.$result[$i]['workrepcon_id']."\" class=\"ico_mod\" title=\""._t('workshoprep','mod_part')."\"><i class=\"icon-pencil\"></i><span>" . _t('workshoprep','mod_part') . "</span></a>\n";
      $contents_parts.="</div>\n";
    }
    $contents_parts.="</td>\n";
    $contents_parts.="</tr>\n";
  }
  $contents_parts.="</tbody>\n";
  $contents_parts.="</table>\n";
}

$reca_parts ="<br class=\"brendstep\" />\n";
$reca_parts.="<div class=\"toggle_title\">\n";
$reca_parts.="<a id=\"publipart\" href=\"#\" class=\"open\">"._t('workshoprep','parts')."</a>\n";
$reca_parts.="</div>\n";
$reca_parts.="<div id=\"publi_part\">\n";
if($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) || $l21auth->isSuperAdmin()) {
  $reca_parts.="\t<a href=\"".$part_link_add."\" class=\"ico_add2\" title=\""._t('workshoprep','add_new_part')."\"><i class=\"icon-plus-circled\"></i><span>".  _t('workshoprep','add_new_part')."</span></a><br class=\"brendstep\" />\n";
}
$reca_parts.=$contents_parts;
$reca_parts.="</div>\n";

$reca_parts.="<br class=\"brendstep\" />\n";

//prepa affichage des ressources LINK associées
$link_res_add="?rub=resources&amp;todo=add_l&amp;parent=".$id."&amp;type=W";
$link_res_sup="?rub=resources&amp;todo=sup&amp;parent=".$id."&amp;type=W&amp;res=link&amp;id=";
$link_res_mod="?rub=resources&amp;todo=mod_l&amp;parent=".$id."&amp;type=W&amp;res=link&amp;id=";
$result=SQL_GetResources($id, 'WORKSHOP', 'LINK', $sql_object);
if($result==0) {
  $contents_link="<div class=\"info\">"._t('workshoprep','no_link')."</div>";
} else {
  $contents_link ="<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable\" id=\"sort-link\">\n";
  $contents_link.="<tbody>\n";
  
  for($i=0; $i<count($result); $i++) {
    $contents_link.="<tr id=\"link-".$result[$i]['linkres_id']."\">\n";
    $contents_link.="<td><a href=\"".$result[$i]['linkres_text']."\" class=\"out\">".formatText($result[$i]['linkres_mask'], '2HTML')."</a></td>\n";
    $contents_link.="<td style=\"width:80px\">\n";
    if($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) || $l21auth->isSuperAdmin()) {
      $contents_link.="<div class=\"iconetab\">\n";
      $contents_link.="\t<a href=\"".$link_res_sup.$result[$i]['linkres_id']."\" class=\"ico_sup\" title=\""._t('workshoprep','del_link')."\"><i class=\"icon-trash\"></i><span>" . _t('workshoprep','del_link') . "</span></a>\n";
      $contents_link.="\t<a href=\"".$link_res_mod.$result[$i]['linkres_id']."\" class=\"ico_mod\" title=\""._t('workshoprep','mod_link')."\"><i class=\"icon-pencil\"></i><span>" . _t('workshoprep','mod_link') . "</span></a>\n";
      $contents_link.="</div>\n";
    }
    $contents_link.="</td>\n";
    $contents_link.="</tr>\n";
  }
  $contents_link.="</tbody>\n";
  $contents_link.="</table>\n";
}
$reca_link='';
$reca_link.="<div class=\"toggle_title\">\n";
$reca_link.="<a id=\"reslink\" href=\"#\">"._t('workshoprep','link_res')."</a>\n";
$reca_link.="</div>\n";
$reca_link.="<div id=\"res_link\" style=\"display:none;\" >\n";
if($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) || $l21auth->isSuperAdmin()) {
  $reca_link.="\t<a href=\"".$link_res_add."\" class=\"ico_add2\" title=\""._t('workshoprep','add_new_linkres')."\"><i class=\"icon-plus-circled\"></i><span>".  _t('workshoprep','add_new_linkres')."</span></a><br class=\"brendstep\" />\n";
}
$reca_link.=$contents_link;
$reca_link.="</div>\n";
$reca_link.="<br class=\"brendstep\" />\n";



//prepa affichage des ressources biblio associés
$biblio_res_add="?rub=resources&amp;todo=add_b&amp;parent=".$id."&amp;type=W";
$biblio_res_sup="?rub=resources&amp;todo=sup&amp;parent=".$id."&amp;type=W&amp;res=biblio&amp;id=";
$biblio_res_mod="?rub=resources&amp;todo=mod_b&amp;parent=".$id."&amp;type=W&amp;id=";
$result=SQL_GetResources($id, 'WORKSHOP', 'BIBLIO', $sql_object);
if($result==0) {
  $contents_biblio="<div class=\"info\">"._t('workshoprep','no_biblio')."</div>";
} else {
  $contents_biblio ="<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable\" id=\"sort-biblio\">\n";
  $contents_biblio.="<tbody>\n";
  
  for($i=0; $i<count($result); $i++) {
    if(!empty($result[$i]['bibliores_sub_title'])) $subtitle=formatText($result[$i]['bibliores_sub_title'], '2HTML').'. ';
    else $subtitle='';
    if(!empty($result[$i]['bibliores_editor'])) $editor=formatText($result[$i]['bibliores_editor'], '2HTML').'. ';
    else $editor='';
    if(!empty($result[$i]['bibliores_date'])) $biblio_date=formatText($result[$i]['bibliores_date'], '2HTML');
    else $biblio_date='';
    
    $contents_biblio.="<tr id=\"biblio-".$result[$i]['bibliores_id']."\">\n";
    $contents_biblio.="<td>\n";
    $contents_biblio.="<span class=\"text_det\">".formatText($result[$i]['bibliores_author'], '2HTML')." - </span><span class=\"text_det_it\">".formatText($result[$i]['bibliores_title'], '2HTML').",</span>\n";
    $contents_biblio.="<p class=\"text_det\">".$subtitle.$editor.$biblio_date."</p>\n";
    $contents_biblio.="</td>\n";
    $contents_biblio.="<td style=\"width:80px\">\n";
    
    if($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) || $l21auth->isSuperAdmin()) {
      $contents_biblio.="<div class=\"iconetab\">\n";
      $contents_biblio.="\t<a href=\"".$biblio_res_sup.$result[$i]['bibliores_id']."\" class=\"ico_sup\" title=\""._t('workshoprep','del_biblio')."\"><i class=\"icon-trash\"></i><span>" . _t('workshoprep','del_biblio') . "</span></a>\n";
      $contents_biblio.="\t<a href=\"".$biblio_res_mod.$result[$i]['bibliores_id']."\" class=\"ico_mod\" title=\""._t('workshoprep','mod_biblio')."\"><i class=\"icon-pencil\"></i><span>" . _t('workshoprep','mod_biblio') . "</span></a>\n";
      $contents_biblio.="</div>\n";
    }
    $contents_biblio.="</td>\n";
    $contents_biblio.="</tr>\n";
  }
  $contents_biblio.="</tbody>\n";
  $contents_biblio.="</table>\n";
}
$reca_biblio='';
$reca_biblio.="<div class=\"toggle_title\">\n";
$reca_biblio.="<a id=\"resmulti\" href=\"#\">"._t('workshoprep','biblio_res')."</a>\n";
$reca_biblio.="</div>\n";
$reca_biblio.="<div id=\"res_biblio\" style=\"display:none;\" >\n";
if($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) || $l21auth->isSuperAdmin()) {
  $reca_biblio.="\t<a href=\"".$biblio_res_add."\" class=\"ico_add2\" title=\""._t('workshoprep','add_new_bibliores')."\"><i class=\"icon-plus-circled\"></i><span>".  _t('workshoprep','add_new_bibliores')."</span></a><br class=\"brendstep\" />\n";
}
$reca_biblio.=$contents_biblio;
$reca_biblio.="</div>\n";
$reca_biblio.="<br class=\"brendstep\" />\n";
$rub_link="index.php?rub=workshop";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','workshop'); ?></a></li>
	<li><span><?php echo formatnavTitle(_t('workshoprep','det'). " : " .$workrep_title.$workshop_title); ?></span>
	</li>
</ul>
</div>
<!--end barre haute -->
<?php
include_once(THEME_ADMIN_PATH."quickicons.php");
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
echo "<h2>".formatTitleh2($workrep_title.$workshop_title)."</h2>\n";
if($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) || $l21auth->isSuperAdmin()) {
  echo "\t<a href=\"".$link_sup.$id."\" class=\"ico_sup2\" title=\""._t('workshoprep','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('workshoprep','sup') . "</span></a>\n";
  echo "\t<a href=\"".$link_mod.$id."\" class=\"ico_mod2\" title=\""._t('workshoprep','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('workshoprep','mod') . "</span></a>\n";
}
echo $reca_generals;
echo $reca_parts;
echo $reca_link;
echo $reca_biblio;
?></div>

<?php
// Ability to drag'n drop items
if($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) || $l21auth->isSuperAdmin()) {
	footerAddJS('../lib/js/jquery.tablednd_0_5.js');
	dragTableSettings();
}
?>

<?php include_once(override($dir.'/help.php', THEME_ADMIN_PATH)); ?>
</div>