<?php
/**
 * Ajax sort table
 * 
 * Dynamically save new sort tables passed in parameters
 *  
 * @package linea21\core\admin
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
session_start();
$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight($_REQUEST['rub'])) ReloadIndex('admin');
////////////

if(!isset($_REQUEST['rub'])) die();

include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');


switch ($_REQUEST['rub']) {
  case "project":
    $items = $_REQUEST['sort-table'];
    include_once('../class/class.project.php');
    $o = new project;
    break;
  case "news":
    $items = $_REQUEST['sort-table'];
    include_once('../class/class.news.php');
    $o = new news;
    break;
  case "publication":
    if(isset($_REQUEST['sort-table'])) {
      $items = $_REQUEST['sort-table'];
      include_once('../class/class.publication.php');
      $o = new publication;
    }
    if(isset($_REQUEST['sort-part'])) {
      $items = $_REQUEST['sort-part'];
      $extra = 'publication';
      include_once('../class/class.contents.php');
      $o = new contents;
    }
    if(isset($_REQUEST['sort-link'])) {
      $items = $_REQUEST['sort-link'];
      $extra = 'link';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    if(isset($_REQUEST['sort-biblio'])) {
      $items = $_REQUEST['sort-biblio'];
      $extra = 'biblio';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    if(isset($_REQUEST['sort-multi'])) {
      $items = $_REQUEST['sort-multi'];
      $extra = 'multi';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    break;
  case "workshop":
    $items = $_REQUEST['sort-table'];
    include_once('../class/class.workshop.php');
    $o = new workshop;
    break;
  case "workshoprep":
    if(isset($_REQUEST['sort-part'])) {
      $items = $_REQUEST['sort-part'];
      $extra = 'workshop';
      include_once('../class/class.contents.php');
      $o = new contents;
    }
    if(isset($_REQUEST['sort-link'])) {
      $items = $_REQUEST['sort-link'];
      $extra = 'link';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    if(isset($_REQUEST['sort-biblio'])) {
      $items = $_REQUEST['sort-biblio'];
      $extra = 'biblio';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    if(isset($_REQUEST['sort-multi'])) {
      $items = $_REQUEST['sort-multi'];
      $extra = 'multi';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    break;
  default:
    $class= 'error';
  $msg = 'incorrect $_REQUEST["rub"] parameter';
  break;

}

$data = sortItems($_REQUEST['rub'], $items);

if(isset($extra)) {
  $res = $o->changeRanges($data, $GLOBALS['sql_object'], $extra);
} else {
  $res = $o->changeRanges($data, $GLOBALS['sql_object']);
}


if($res == 1) {
  $class = "succeed";
  $msg = _t('msg', 'update_successful');
} else {
  $class = "failed";
  $msg = _t('msg', 'update_failed');
}

$a = array("class"=>$class,"msg"=>$msg);

echo json_encode($a);
?>