<?php
/**
 * contents class
 * 
 * Provides methods related to publication and workgroup report modules
 * 
 * @package linea21\modules\content
 * @see workshop, publication
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Content Management
 */

class contents {
  /* @param
   * */
  var $TDB_LIAISON = J_PARTS;
  var $ACTIVE_TABLE;
  var $ACTIVE_TYPE; // valeur 'P' || 'W'
  var $WR_ID;
  var $WR_TITLE;
  var $WR_BODY;
  var $WR_DATE_CREA;
  var $WR_LAST_MODIFY;
  var $WR_TABLE = T_WORK_REP_CONT;

  var $P_ID;
  var $P_TITLE;
  var $P_BODY;
  var $P_DATE_CREA;
  var $P_LAST_MODIFY;
  var $P_TABLE = T_PUBLI_CONT;

  protected $dispatcher = null;

  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'contents.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }
  /**
   * contents::CheckDataIntegrity()
   * vérifie l'integrité d'un partie avant Insertion
   *
   * @access public
   * @param array $table contient les composants d'une partie
   * @param string $type 'P', 'W'
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */
  function CheckDataIntegrity($table, $type)
  {
  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'contents.before_datacheck', array('data' => $table)), $table);
  	$table = $r->getReturnValue();

    if (strlen($table[0]) < 2) return _t('contents','no_title');
    if (strlen($table[1]) < 10) return _t('contents','no_body');

    // Notify the beginning of the current method
    $this->dispatcher->notify(new sfEvent($this, 'contents.after_datacheck', array('data' => $table)));

    return true;
  }


  /**
   * contents::_wichType()
   * initialisation des tables SQL
   *
   * @access private
   * @param string $type : type du CONTENU 'WORKSHOP' ou 'PUBLICATION'
   * @return string -void
   */
  function _wichType($type)
  {
    switch ($type) {
      case 'WORKSHOP':
        $this->ACTIVE_TABLE = $this->WR_TABLE;
        $this->ACTIVE_TYPE = 'W';
        break;
      case 'PUBLICATION':
        $this->ACTIVE_TABLE = $this->P_TABLE;
        $this->ACTIVE_TYPE = 'P';
        break;
      default:
        return "error";
    }
  }

  /**
   * contents::AddContents()
   * ajout d'une partie de contenu
   *
   * @access public
   * @param integer $ID identifiant du père (rattachement)
   * @param array $contents_table tableau contenant les infos ressources
   * @param string $type 'WORKSHOP' ou 'PUBLICATION'
   * @param object $
   * @return integer $last_id
   */
  function AddContents($ID, $contents_table, $type, $sql_object)
  {
  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'contents.before_add', array('data' => $contents_table, 'parentid' => $ID, 'type' => $type)), $contents_table);
  	$contents_table = $r->getReturnValue();

    $contents_table=$sql_object->DBescape($contents_table);
    if ($this->_wichType($type) == "error") exit;
    $q = "INSERT INTO " . $this->ACTIVE_TABLE ;
    if ($type == "WORKSHOP") {
      $this->WR_TITLE = strip_input($contents_table[0]);
      $this->WR_BODY = strip_input($contents_table[1], true);
      $q.= " (workrepcon_title, workrepcon_body, workrepcon_date_crea, workrepcon_last_modify, workrepcon_validity)";
      $q .= " VALUES('" . $this->WR_TITLE . "', '" . $this->WR_BODY . "', NOW(),NOW(), 'Y');";
    }
    if ($type == "PUBLICATION") {
      $this->P_TITLE = strip_input($contents_table[0]);
      $this->P_BODY = strip_input($contents_table[1], true);
      
      $q.= " (publicon_title, publicon_body, publicon_date_crea, publicon_last_modify, publicon_validity)";
      $q .= " VALUES('" . $this->P_TITLE . "', '" . $this->P_BODY . "', NOW(),NOW(), 'Y');";
    }
    $last_id = $sql_object->DBInsert ($q, 1);

    if (is_numeric($last_id)) {
      $q = "INSERT INTO " . $this->TDB_LIAISON . " VALUES(" . $ID . "," . $last_id . ", '" . $this->ACTIVE_TYPE . "');";
      $result = $sql_object->DBInsert ($q);
    }

    // Notify the end of the current method
    $this->dispatcher->notify(new sfEvent($this, 'contents.after_add', array('data' => $contents_table, 'id' => $last_id, 'parentid' => $ID, 'type' => $type)));

    return $result;
  }

  /**
   * contents::ModifyContents()
   * modification d'une partie de contenu
   *
   * @access public
   * @param integer $ID : identifiant de la partie à modifier
   * @param array $contents_table : tableau contenant les infos ressources
   * @param string $type 'WORKSHOP' ou 'PUBLICATION'
   * @param object $sql_object
   * @return boolean $result
   */
  function ModifyContents($ID, $contents_table, $type, $sql_object)
  {
  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'contents.before_modify', array('data' => $contents_table, 'id' => $ID, 'type' => $type)), $contents_table);
  	$contents_table = $r->getReturnValue();

    $contents_table=$sql_object->DBescape($contents_table);
    if ($this->_wichType($type) == "error") exit;
    if (!is_numeric($ID)) return false;
    if ($type == "WORKSHOP") $this->WR_ID = $ID;
    if ($type == "PUBLICATION") $this->P_ID = $ID;

    $q = "UPDATE " . $this->ACTIVE_TABLE . " SET ";
    if ($type == "WORKSHOP") {
      $this->WR_TITLE = strip_input($contents_table[0]);
      $this->WR_BODY = strip_input($contents_table[1], true);
      $q .= "workrepcon_title='" . $this->WR_TITLE . "', workrepcon_body='" . $this->WR_BODY . "', workrepcon_last_modify=NOW() WHERE workrepcon_id='" . $this->WR_ID . "';";
    }
    if ($type == "PUBLICATION") {
      $this->P_TITLE = strip_input($contents_table[0]);
      $this->P_BODY = strip_input($contents_table[1], true);

      $q .= "publicon_title='" . $this->P_TITLE . "', publicon_body='" . $this->P_BODY . "', publicon_last_modify=NOW() WHERE publicon_id='" . $this->P_ID . "';";
    }
    $result = $sql_object->DBQuery($q);

    // Notify the end of the current method
    $this->dispatcher->notify(new sfEvent($this, 'contents.after_modify', array('data' => $contents_table, 'id' => $this->ID, 'type' => $type)));

    return $result;
  }

  /**
   * contents::changeRanges()
   * changes contents range
   *
   * @access public
   * @param array : Id (key) and ranges (value)
   * @param object $sql_object
   * @return bool $result
   */

  function changeRanges($array, $sql_object, $element)
  {

    switch ($element) {
      case "publication":
        $table = $this->P_TABLE;
        $field_id = 'publicon_id';
        $field_range = 'publicon_range';
        break;
      case "workshop":
        $table = $this->WR_TABLE;
        $field_id = 'workrepcon_id';
        $field_range = 'workrepcon_range';
        break;
    }
    foreach ($array as $key => $value) {
      $query = "UPDATE " . $table . " set ".$field_range." ='".$value."' WHERE ".$field_id." ='" . $key . "';";
      $result = $sql_object->DBQuery($query);
    }

    // Notify the beginning of the current method
    $this->dispatcher->notify(new sfEvent($this, 'contents.change_ranges', array('data' => $array)));

    return $result;
  }

  /**
   * contents::DeleteContents()
   * suppression d'une partie
   *
   * @access public
   * @param integer $ID : identifiant du contents a supprimer
   * @param string $type :  'WORKSHOP' ou 'PUBLICATION'
   * @param object $sql_object
   * @return boolean $result
   */
  function DeleteContents($ID, $type, $sql_object)
  {
  	// Notify the end of the current method
  	$this->dispatcher->notify(new sfEvent($this, 'contents.delete', array('id' => $ID, 'type' => $type)));

    if (is_numeric($ID)) {
      if ($type == "WORKSHOP") {
        $champ1 = "workrepcon_id";
        $champ2 = "jwp_contents_id";
        $champ3 = "workrepcon_validity";
        $champ4 = "workrepcon_last_modify";
      }
      if ($type == "PUBLICATION") {
        $champ1 = "publicon_id";
        $champ2 = "jpp_contents_id";
        $champ3 = "publicon_validity";
        $champ4 = "publicon_last_modify";
      }
    } else return false;
    if ($this->_wichType($type) == "error") return false;
    $q = "UPDATE " . $this->ACTIVE_TABLE . " SET " . $champ3 . "='N', ".$champ4."=NOW()  WHERE " . $champ1 . "='" . $ID . "';";
    $result = $sql_object->DBQuery($q);

    return $result;
  }
}

?>
