<?php
/**
 * Page class
 * 
 * Povides methods related to page module
 * 
 * @package linea21\modules\page
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Page Management
 */

class page {
  /* @param
   * */
  public $TDB_PAGE = T_PAGE; // nom de la table.
  public $ID;
  public $TITLE;
  public $HEADER;
  public $BODY;
  public $IS_HOMEPAGE;
  public $POSTED_BY;
  public $POST_DATE;
  public $PUBLISHED_DATE;
  public $STATUS;
  protected $dispatcher = null;


  public function __construct()
  {
    $this->dispatcher = $GLOBALS['dispatcher'];
  }

  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'page.extensible_function', array(
      'method'    => $method,
      'arguments' => $arguments
    )));
    if (!$event->isProcessed())
    {
      throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }

    return $event->getReturnValue();
  }


  /**
   * _getDate()
   * date courante et ajout
   *
   * @access private
   * @param int $m chiffre des mois
   * @param int $d chiffre des jours
   * @param int $y chiffre des années
   * @return string $format_date
   * @return
   */
  private function _getDate($m = 0, $d = 0, $y = 0)
  {
    $format_date = mktime(date("H"), date("i"), date("s"), date("m") + $m, date("d") , date("Y"), -1);
    $format_date = strftime('%Y-%m-%d %H:%M:%S', $format_date);

    return $format_date;
  }


  /**
   * checkDataIntegrity()
   * Vérification intégrité des données
   *
   * @access public
   * @param array $array : contient les composants nécessaires d'une page
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */

  public function checkDataIntegrity($array)
  {

  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'page.before_datacheck', array('data' => $array)), $array);
  	$array = $r->getReturnValue();

    if (strlen($array[0]) < 3) return _t('page','no_title');
    if (strlen($array[1]) < 3) return _t('page','no_header');
    if (strlen($array[2]) < 3) return _t('page','no_body');

    // Notify the beginning of the current method
  	$this->dispatcher->notify(new sfEvent($this, 'page.after_datacheck', array('data' => $array)));

    return true;
  }

  /**
   * addPage()
   * Ajout d'une page
   *
   * @access public
   * @param array $array : contient les composants d'une page
   * @param object $sql_object
   * @return integer $last_id
   */
  public function addPage($array, $sql_object)
  {

  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'page.before_add', array('data' => $array)), $array);
  	$array = $r->getReturnValue();

    $array=$sql_object->DBescape($array);

    if ($array[0] != '') {
      $this->TITLE = strip_input(trim($array[0]), true);
    }
    if ($array[1] != '') {
      $this->HEADER = strip_input(trim($array[1]), true);
    }
    if ($array[2] != '') {
      $this->BODY = strip_input(trim($array[2]), true);
    }
    if (is_numeric($array[3])) {
      $this->POSTED_BY = $array[3];
    }
    if ($array[4] != '') {
      $this->STATUS = strtoupper($array[4]);
    }
    if ($array[5] != '') {
    	$this->IS_HOMEPAGE = $array[5];
    }
    if ($this->STATUS == 'P') {
      $this->PUBLISHED_DATE = $this->_getDate();
    } else {
      $this->PUBLISHED_DATE = '0001-01-01';
    }
    $q = "INSERT INTO " . $this->TDB_PAGE . " (page_title, page_header, page_body, page_posted_by, page_published_date, page_status, page_date_crea) " . "VALUES('" . $this->TITLE . "', '" . $this->HEADER . "', '" . $this->BODY . "', " . $this->POSTED_BY . ", '" . $this->PUBLISHED_DATE . "', '" . $this->STATUS . "', now());";

    $last_id = $sql_object->DBInsert ($q, 1);

    $this->ID = $last_id;

    $this->updateHomePage($sql_object);

    // Notify the end of the current method
    $this->dispatcher->notify(new sfEvent($this, 'page.after_add', array('data' => $array, 'id' => $last_id)));

    return $last_id;
  }

  /**
   * updateHomePage()
   * Met à jour la homepage
   *
   * @return boolean true
   */
  
  public function updateHomePage($sql_object)
  {

  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'page.before_homepage_update', array('id' => $this->ID )), $array);
  	$array = $r->getReturnValue();
  	 

  	if($this->IS_HOMEPAGE == false)  {

  		// we update only the current record without modifying others
  		$q = "UPDATE " . $this->TDB_PAGE . " SET page_homepage = 'N' WHERE page_id = '" . $this->ID . "' ";
  		$sql_object->DBQuery($q);

  	}
  	 
  	if($this->IS_HOMEPAGE == true)  {

  		// first, we remove the current homepage
  		$q = "UPDATE " . $this->TDB_PAGE . " SET page_homepage = 'N'";
  		$r = $sql_object->DBQuery($q);

  		// and we set the new homepage with given ID
  		if($r) {
  			$q = "UPDATE " . $this->TDB_PAGE . " SET page_homepage = 'Y' WHERE page_id = '" . $this->ID . "' ";
  			$sql_object->DBQuery($q);
  		}
  	}

  	// Notify the beginning of the current method
  	$this->dispatcher->notify(new sfEvent($this, 'page.after_homepage_update', array('id' => $this->ID )));

  	return true;
  }


  /**
   * deletePage()
   * suppression d'une page
   *
   * @access public
   * @param int $ID : identifiant de la page
   * @param object $sql_object
   * @return bool $result
   */

  public function deletePage($ID, $sql_object)
  {
  	// Notify the beginning of the current method
  	$this->dispatcher->notify(new sfEvent($this, 'page.delete', array('id' => $ID)));

    $this->ID = $ID;
    $q = "UPDATE  " . $this->TDB_PAGE . " set page_status='E', page_last_modify=NOW() WHERE page_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($q);
    return $result;
  }

  /**
   * modifyPage()
   * modification d'une page
   *
   * @access public
   * @param integer $ID : identifiant de la page
   * @param object $sql_object
   * @param array $array : contient les composants d'une page
   * @return boolean $result
   */
  public function modifyPage($ID, $array, $sql_object)
  {

  	// Filter data event + return value
  	$r = $this->dispatcher->filter(new sfEvent($this, 'page.before_modify', array('data' => $array, 'id' => $ID)), $array);
  	$array = $r->getReturnValue();

    $array=$sql_object->DBescape($array);
    if (is_numeric($ID)) {
      $this->ID = $ID;
    }
    if ($array[0] != '') {
      $this->TITLE = strip_input(trim($array[0]), true);
    }
    if ($array[1] != '') {
      $this->HEADER = strip_input(trim($array[1]), true);
    }
    if ($array[2] != '') {
      $this->BODY = strip_input(trim($array[2]), true);
    }
    if (is_numeric($array[3])) {
      $this->POSTED_BY = $array[3];
    }
    if ($array[4] != '') {
      $this->STATUS = $array[4];
    }

    $mask = $this->_HavePublishedDate($array[5]);

    if ($array[6] != '') {
    	$this->IS_HOMEPAGE = $array[6];
    }

    $q = "UPDATE  " . $this->TDB_PAGE . " set page_title='" . $this->TITLE . "', page_header='" . $this->HEADER . "', page_body='" . $this->BODY . "' , page_posted_by=" . $this->POSTED_BY . ", page_status ='" . $this->STATUS . "', page_last_modify=NOW() " . $mask . " WHERE page_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($q);

    // we update the homepage
    $this->updateHomePage($sql_object);

    // Notify the end of the current method
    $this->dispatcher->notify(new sfEvent($this, 'page.after_modify', array('data' => $array, 'id' => $this->ID)));

    return $result;
  }


  /**
   * homepage_exists()
   * check if homepage exists
   *
   * @access public
   * @return bool
   */
  
  public function homepage_exists()
  {
  	global $sql_object;
  	
  	// Notify the beginning of the current method
  	$this->dispatcher->notify(new sfEvent($this, 'page.homepage_exists'));
  	 

  	$q = "SELECT * FROM  " . $this->TDB_PAGE . " WHERE page_homepage = 'Y' AND page_status='P';";
  	$r = $sql_object->DBSelect($q);

  	if(isset($r[0]))
  		return true;
  	else {
  		return false;
  	}
  	
  }

  /**
   * get_homepage_id()
   * return homepage_id
   *
   * @access public
   * @return int $ID : identifiant de la page
   */
  
  public function get_homepage_id()
  {
  	global $sql_object;
  
  	$q = "SELECT * FROM  " . $this->TDB_PAGE . " WHERE page_homepage = 'Y' AND page_status='P';";
  	$r = $sql_object->DBSelect($q);

  	if(isset($r[0])) return $r[0]['page_id'];

  	return false;  	
  }


  /**
   * _havePublishedDate()
   * Détermine la date de publication a inserer dans la bdd
   *
   * @access private
   * @param string $current_status : statut actuel de l'actualité
   * @return string $sql_mask
   */
  private function _havePublishedDate($current_status)
  {
    switch ($this->STATUS) {
      case 'P':
        if ($current_status == 'D') $sql_mask = ", page_published_date= NOW()";
        else $sql_mask = '';
        break;
      case 'D':
        $sql_mask = ", page_published_date= '0001-01-01'";
        break;
      default:
        $sql_mask = '';
    }
    return $sql_mask;
  }
}

?>