<?php
/**
 * Workshop_com class
 * 
 * Povides methods to handle discussions / forum for worgroups module
 * 
 * @package linea21\modules\workshop
 * @see workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Workgroup Forum Management
 */

class workshop_com {
	/* @param
	 * */

	var $TDB_COM = T_WORK_COM; // nom de la table.
	var $ID;
	var $SUBJECT;
	var $BODY;
	var $PARENT;
	var $USER_ID;
	var $WORKSHOP_ID;
	var $DATE_CREA;
	var $LAST_MODIFY;
	var $STATUT;
	protected $dispatcher = null;

	public function __construct()
	{
		$this->dispatcher = $GLOBALS['dispatcher'];
	}

	public function __call($method, $arguments)
	{
		$event = $this->dispatcher->notifyUntil(new sfEvent($this, 'workshop_com.extensible_function', array(
				'method'    => $method,
				'arguments' => $arguments
		)));
		if (!$event->isProcessed())
		{
			throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
		}

		return $event->getReturnValue();
	}

	/**
	 * workshop_com::CheckDataIntegrity()
	 * Vérification intégrité des données
	 *
	 * @access public
	 * @param array $table contient les composants d'une discussion
	 * @return boolean true
	 * si verifié, sinon string 'message d'erreur'
	 */
	function CheckDataIntegrity($table, $sql_object)
	{
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent($this, 'workshopcom.before_datacheck', array('data' => $table)), $table);
		$table = $r->getReturnValue();

		if (strlen($table[0]) < 3) return _t('workshop','com_no_subject');
		if (strlen($table[1]) < 10) return _t('workshop','com_no_body');

		// we check if user id is numeric and belongs to the workgroup
		// test to prevent SQL error if provided ID is wrong (can happen with TextBoxList js plugin
		if(!is_numeric($table[3])) return _t('workshop','author_not_allowed');
		$q = "SELECT * FROM l21_j_work_users where jwu_user_id = ".$table[3]." AND jwu_workshop_id =".$table[4].";";
		$r = $sql_object->DBSelect($q);
		if(!isset($r[0]['jwu_id'])) return _t('workshop','author_not_allowed');

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'workshopcom.after_datacheck', array('data' => $table)));

		return true;
	}
	
	/**
	 * 
	 * @param integer $id
	 * @param SQL object $sql_object
	 * @return boolean
	 */
	public function incrementViewsCounter($id, $sql_object) {
		
		if(!is_numeric($id)) return false;
		
		$q = 'UPDATE '.$this->TDB_COM.' SET workcom_viewed = workcom_viewed + 1, workcom_last_modify = workcom_last_modify WHERE  workcom_id='.$id;
		$r = $sql_object->DBQuery($q);
		
		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'workshopcom.increment_views', array('id' => $id)));
		
		return true;
	}

	/**
	 * workshop_com::AddCom()
	 * Ajout d'une nouvelle discussion
	 *
	 * @access public
	 * @param array $table_com : contient les composants d'une discussion
	 * @param object $sql_object
	 * @return integer $last_id
	 */
	function AddCom($table_com, $sql_object)
	{
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent($this, 'workshopcom.before_add', array('data' => $table_com)), $table_com);
		$table_com = $r->getReturnValue();

		$table_com=$sql_object->DBescape($table_com);

		$this->SUBJECT = strip_input(trim($table_com[0]));
		$this->BODY = strip_input(trim($table_com[1]), '<a><img><sup><sub><span><br>');
		$this->BODY = str_replace('<br>', '<br />', $this->BODY); // necessary for nicEdit

		if ($table_com[2] != '') {
			$this->PARENT_ID = $table_com[2];
		} else $this->PARENT_ID = 0;
		$this->USER_ID = $table_com[3];
		$this->WORKSHOP_ID = $table_com[4];
		$this->STATUT = "P";

		if ($this->PARENT_ID == 0) {
			$q = "INSERT INTO " . $this->TDB_COM . " (workcom_subject, workcom_body, workcom_parent, workcom_user_id, workcom_workshop_id, workcom_statut, workcom_date_crea, workcom_last_modify ) " . "VALUES('" . $this->SUBJECT . "', '" . $this->BODY . "', " . $this->PARENT_ID . ", " . $this->USER_ID . ", " . $this->WORKSHOP_ID . ", '" . $this->STATUT . "', NOW(), NOW());";
			$last_id = $sql_object->DBInsert ($q, 1);
		} else {
			$q_root = "UPDATE  " . $this->TDB_COM . " SET workcom_last_modify=NOW() WHERE workcom_id=" . $this->PARENT_ID . ";";
			$result_root = $sql_object->DBQuery($q_root);
			$q = "INSERT INTO " . $this->TDB_COM . " (workcom_subject, workcom_body, workcom_parent, workcom_user_id, workcom_workshop_id, workcom_statut, workcom_date_crea, workcom_last_modify ) " . "VALUES('" . $this->SUBJECT . "', '" . $this->BODY . "', " . $this->PARENT_ID . ", " . $this->USER_ID . ", " . $this->WORKSHOP_ID . ", '" . $this->STATUT . "', NOW(), NOW());";
			$last_id = $sql_object->DBInsert ($q, 1);
		}

		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'workshopcom.after_add', array('data' => $table_com, 'id' => $last_id)));

		return $last_id;
	}


	/**
	 * workshop_com::DeleteCom()
	 * suppression d'un message
	 *
	 * @access public
	 * @param int $com_id identifiant du message
	 * @param int $parent_id identifiant du parent
	 * @param object $sql_object
	 * @return bool $result
	 */
	function DeleteCom($ID, $com_id, $parent_id, $sql_object)
	{

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'workshopcom.delete', array('id' => $ID, 'comid' => $com_id, 'parentid' => $parent_id)));

		if (is_numeric($ID)) {
			$this->ID = $ID;
		} else return false;

		if ($parent_id == 0) {
			$q_son = "SELECT workcom_id FROM " . $this->TDB_COM . " WHERE workcom_statut <> 'E' AND workcom_parent=$com_id  AND workcom_workshop_id=$ID";

			$result_son = $sql_object->DBSelect($q_son);

			if ($result_son <> 0) {
				$q = "UPDATE " . $this->TDB_COM . " SET workcom_statut='E' WHERE workcom_id=$com_id;";
				$result = $sql_object->DBQuery ($q);
				for($i = 0; $i < count($result_son); $i++) {
					$q_son_e = "UPDATE " . $this->TDB_COM . " SET workcom_statut='E' WHERE workcom_id=" . $result_son[$i]['workcom_id'] . ";";
					$result_son_e = $sql_object->DBQuery ($q_son_e);
				}
				return $result;
			} else {
				$q = "UPDATE " . $this->TDB_COM . " SET workcom_statut='E' WHERE workcom_id=$com_id;";
				$result = $sql_object->DBQuery ($q);
				return $result;
			}
		} else {
			$q = "UPDATE " . $this->TDB_COM . " SET workcom_statut='E' WHERE workcom_id=$com_id;";
			$result = $sql_object->DBQuery ($q);
			return $result;
		}
	}

	/**
	 * workshop_com::LockCom()
	 * vérouillage d'un message
	 *
	 * @access public
	 * @param int $ID identifiant du workshop
	 * @param int $com_id identifiant du message
	 * @param int $parent_id identifiant du message parent
	 * @param int $lock
	 * @param object $sql_object
	 * @return bool $result
	 */
	function LockCom($ID, $com_id, $parent_id, $lock, $sql_object)
	{
		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'workshopcom.lock', array('id' => $ID, 'comid' => $com_id, 'parentid' => $parent_id, 'lock' => $lock)));

		if ($lock == 0) $statut = 'C';
		else $statut = 'P';

		if (is_numeric($ID)) {
			$this->ID = $ID;
		} else return false;

		if ($parent_id == 0) {
			$q_son = "SELECT workcom_id FROM " . $this->TDB_COM . " WHERE workcom_statut <> 'E' AND workcom_parent=$com_id  AND workcom_workshop_id=$ID";
			$result_son = $sql_object->DBSelect($q_son);

			if ($result_son <> 0) {
				$q = "UPDATE " . $this->TDB_COM . " SET workcom_statut='" . $statut . "' WHERE workcom_id=$com_id;";
				$result = $sql_object->DBQuery ($q);
				for($i = 0; $i < count($result_son); $i++) {
					$q_son_e = "UPDATE " . $this->TDB_COM . " SET workcom_statut='" . $statut . "' WHERE workcom_id=" . $result_son[$i]['workcom_id'] . ";";
					$result_son_e = $sql_object->DBQuery ($q_son_e);
				}
				return $result;
			} else {
				$q = "UPDATE " . $this->TDB_COM . " SET workcom_statut='" . $statut . "' WHERE workcom_id=$com_id;";
				$result = $sql_object->DBQuery ($q);
				return $result;
			}
		} else {
			$q = "UPDATE " . $this->TDB_COM . " SET workcom_statut='" . $statut . "' WHERE workcom_id=$com_id;";
			$result = $sql_object->DBQuery ($q);
			return $result;
		}
	}

	/**
	 * workshop_com::ModifyCom()
	 * modification d'un message
	 *
	 * @access public
	 * @param int $ID identifiant du message
	 * @param array $table_com contient les composants d'un message
	 * @param object $sql_object
	 * @return bool $result
	 */
	function ModifyCom($ID, $table_com, $sql_object)
	{
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent($this, 'workshopcom.before_modify', array('data' => $table_com, 'id' => $ID)), $table_com);
		$table_com = $r->getReturnValue();

		$table_com=$sql_object->DBescape($table_com);

		if ($table_com[0] != '') {
			$this->SUBJECT = strip_input(trim($table_com[0]));
		}
		if ($table_com[1] != '') {
			$this->BODY = strip_input(trim($table_com[1]), '<a><img><sup><sub><span>');
			$this->BODY = str_replace('<br>', '<br />', $this->BODY); // necessary for nicEdit
		}
		$this->USER_ID = $table_com[3];

		$q = "UPDATE  " . $this->TDB_COM . " SET workcom_subject='" . $this->SUBJECT . "', workcom_body='" . $this->BODY .  "', workcom_user_id=" . $this->USER_ID . " , workcom_last_modify=NOW() WHERE workcom_id=" . $ID . ";";
		$result = $sql_object->DBQuery($q);

		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'workshopcom.after_modify', array('data' => $table_com, 'id' => $ID)));

		return $result;
	}

	/**
	 * workshop_com::ModifyComUser()
	 * modification d'un message utilisateur authentifié
	 *
	 * @access public
	 * @param int $ID identifiant du message
	 * @param array $table_com contient les composants d'un message
	 * @param int $user_id identifiant de l'utilisateur
	 * @param object $sql_object
	 * @return bool $result
	 */
	function ModifyComUser($ID, $table_com, $user_id, $sql_object, $hasrights)
	{
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent($this, 'workshopcom.before_modify_auth', array('data' => $table_com, 'id' => $ID, 'user_id' => $user_id)), $table_com);
		$table_com = $r->getReturnValue();

		$table_com=$sql_object->DBescape($table_com);

		if ($table_com[0] != '') {
			$this->SUBJECT = strip_input(trim($table_com[0]));
		}
		if ($table_com[1] != '') {
			$this->BODY = strip_input(trim($table_com[1]), '<a><img><sup><sub><span>');
			$this->BODY = str_replace('<br>', '<br />', $this->BODY); // necessary for nicEdit
		}
		$result_user = $this->_getUserId($ID, $sql_object);
		if ($result_user != $user_id && $hasrights == false) {
			$result = _t('workshop','not_author');
		} else {
			$q = "UPDATE  " . $this->TDB_COM . " SET workcom_subject='" . $this->SUBJECT . "', workcom_body='" . $this->BODY . "' , workcom_last_modify=NOW() WHERE workcom_id=" . $ID . ";";
			$result = $sql_object->DBQuery($q);
		}

		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'workshopcom.after_modify_auth', array('data' => $table_com, 'id' => $ID, 'user_id' => $user_id, 'is_admin' => $isadmin)));

		return $result;
	}

	/**
	 * workshop_com::_getUserId()
	 * obtention de l'id d'un auteur de message
	 *
	 * @param object $sql_object
	 * @param integer $mes_id
	 * @return id_utilisateur $result[0]['workcom_user_id']
	 */
	function _getUserId($mes_id, $sql_object)
	{
		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'workshopcom.get_userid', array('id' => $mes_id)));

		$q = "SELECT  workcom_user_id FROM " . $this->TDB_COM . " WHERE workcom_id=" . $mes_id . ";";

		$result = $sql_object->DBSelect($q);
		return $result[0]['workcom_user_id'];
	}
}

?>