<?php
/**
 * Main config file
 * 
 * This file is a kind of bootstrap files - it is included in both admin/public UI
 * 
 * @package linea21\core\config_files
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//BE CAREFULL THIS FILE IS A SYSTEM FILE : use config.ini for settings

/////////////////////////////////////
//	GLOBALS
/////////////////////////////////////

// Defining CURRENT_APP
if(strpos($_SERVER["SCRIPT_FILENAME"], 'admin') !== false) define('CURRENT_APP', 'admin');
else define('CURRENT_APP', 'public');

// Defining APPS
// $GLOBALS['APPS'] = array('admin', 'public');


define('END_LINE',		"\n"); 	// @todo to remove in next versions
define('TAB_LINE',		"\t");

$GLOBALS['current_title'] = array(); // HTML <title> tag

$GLOBALS['links'] = array(); // Localized variables
$GLOBALS['filters'] = array(); // Localized (filters) variables

$GLOBALS['menuitems'] = array (
              'home',
    					'news',
              'project',
						  'dashboard',
    					'workgroup',
						  'workgroup-subscription',
						  'publication',
    					'directory',
    					'contribute',
						  'contact'
              );


// Event Dispatcher Init
include_once("../lib/vendor/sfEventDispatcher/sfEventDispatcher.php");
$dispatcher = new sfEventDispatcher();

// INI file to PHP Constants
include_once ("../class/class.config_file.php");

// include Simple HTML DOM library
include_once ('../lib/vendor/simple_html_dom.php');

// if installing app, we use the default define release file
if(isset($installation_process)) {
	$l21config = new config_file('config.ini.default');
} else {
	$l21config = new config_file();
}
$l21config->init();


require_once '../lib/vendor/php-debugbar/src/autoload.php';

use DebugBar\StandardDebugBar;
use DebugBar\JavascriptRenderer;

define('CURRENT_APP_URL', SITE_ROOT_URL. CURRENT_APP. '/');
define('THEME_ADMIN_PATH',		"../".THEME_DIRECTORY."/admin/".THEME_ADMIN."/");
define('THEME_PUBLIC_PATH',		"../".THEME_DIRECTORY."/public/".THEME_PUBLIC."/");


// Debuger Init
if(defined('MOD_DEBUG') && MOD_DEBUG == true) {

	$debugbar = new StandardDebugBar();
	
	// adding config tab
	if(file_exists('../config/config.ini')) {
		$data = parse_ini_file ('../config/config.ini');
		$data['DB_USER'] = $data['DB_PASS'] = '**********';
		$debugbar->addCollector(new DebugBar\DataCollector\ConfigCollector($data));
	}
	
	// since PDO is not used 
	// 	$pdo = new DebugBar\DataCollector\PDO\TraceablePDO(new PDO('sqlite::memory:'));
	// 	$debugbar->addCollector(new DebugBar\DataCollector\PDO\PDOCollector($pdo));

	
	$debugbarRenderer = $debugbar->getJavascriptRenderer();
	$debugbarRenderer->setBaseUrl('../lib/vendor/php-debugbar/src/DebugBar/Resources');
	$debugbar["messages"]->addMessage('Admin theme : '.THEME_ADMIN.' | Public theme : '.THEME_PUBLIC);
	$debugbar['time']->startMeasure('pre', 'Pre-execute and includes');
	
// 	$debugbar["messages"]->info("hello world!");
// 	$debugbar['messages']->warning('hello world 2');
// 	$debugbar['messages']->error('hello world 3');

}

// Bootstrap (common includes)
include_once("../config/server.php");
include_once("../lib/items.php");
include_once("../lib/lib_common.php");

// Culture Init
include_once('../lib/lang.php');
include_once('../class/class.culture.php');
culture::getInstance();
define('U_L', culture::getInstance()->getVar('current'));

// Database connexion
include_once("../class/system/class.".SQL.".php");

if(isset($debugbar)) {
	
	$debugbar['time']->stopMeasure('pre');
	$debugbar['time']->startMeasure('sqlfiles', '... loading SQL files');
}

// if define.php is called from install script
// we do not instanciate SQL object since the connexion
// is not set yet
if(!isset($installation_process)) {
	$sql_entity=SQL;
	$sql_object = new $sql_entity;
	$sql_object -> DBInitialise();
	$sql_object -> DBConnexion();
}

// Auth Init - can be overridden by plugin
include_once('../class/class.auth.php');
$l21auth = new auth();

// Include ONLY the desired language PRODUCTION mode
include(override('../languages/' .U_L. '/define.php'));
$GLOBALS['links'] = array_merge($GLOBALS['links'], $l10n_links);
$GLOBALS['filters'] = array_merge($GLOBALS['filters'], $l10n_filters);

// if define.php is called from install script
// we do not instanciate plugins
if(!isset($installation_process)) {
	// Plugins Init - installed plugins
	if(defined('MOD_PLUGINS') && MOD_PLUGINS == 1 && !isset($noplugin)) {
		include_once('../class/class.plugin.php');
		foreach(availablePlugins() as $plugin) {
		  $plug = new plugin($plugin);
		  if($plug->is_active()) $plug->loadPlugin();
		}
	}
}


// finally, we include user configuration file if exists
if(CURRENT_APP == 'admin') {
  $user_conf = override('../config/define.php', THEME_ADMIN_PATH, false);
} else {
  $user_conf = override('../config/define.php', THEME_PUBLIC_PATH, false);
}
if(file_exists($user_conf)) include_once($user_conf);
?>