<?php
/**
 * Dashboard module
 * 
 * Common functions used in both front and back-office to 
 * displays dashboard informations and charts
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

if(!function_exists('getPositionfromValue')) {

	function getPositionfromValue ($value, $indicator, $threshold_value){
		if ($indicator['sdii_max_value']==0) {
			$max_value=0.000001;
		} else {
			$max_value=$indicator['sdii_max_value'];
		}
		if ($indicator['sdii_min_value']==0) {
			$min_value=0.000001;
		} else {
			$min_value=$indicator['sdii_min_value'];
		}
		if ($indicator['sdii_threshold_relative']=='Y') {
			$unitup	= 50 / ($max_value - $threshold_value);
			$unitdown	= 50 / ( $threshold_value - $min_value);
			if ($value > $threshold_value) $result = 50 + (($value - $threshold_value) *$unitup);
			else $result = 50 -( ($threshold_value - $value ) *$unitdown );
		}
		else{
			if(($max_value - $threshold_value) <> 0) $unitdown = 50 / ($max_value - $threshold_value);
			if(($threshold_value - $min_value) <> 0) $unitup = 50 / ($threshold_value - $min_value);
			if ($value > $threshold_value) $result=50 -( ($value - $threshold_value) * $unitdown);
			else $result = 50 + (( $threshold_value - $value ) * $unitup);
		}
		return (int)$result;
	}

}

if(!function_exists('getIndicatorInfoBox')) {

	function getIndicatorInfoBox($current_value, $indicator, $threshold_value, $class= '') {

		$content = 	"<div class=\"indicator-info ".$class."\"><p>".ucfirst(_t('dashboard','value'))." : <strong>".fnumber_format($current_value, 'auto', false)." (".formatText($indicator['sdii_unit']).")</strong></p>".
				"<p>".ucfirst(_t('sdi','min_value'))." : <strong>".empty_nc($indicator['sdii_min_value'])."</strong></p>".
				"<p>".ucfirst(_t('sdi','max_value'))." : <strong>".empty_nc($indicator['sdii_max_value'])."</strong></p>".
				"<p>".ucfirst(_t('sdi','threshold_value'))." : <strong>".empty_nc($threshold_value)."</strong></p>".
				"</div>";

		return $content;
	}

}

if(!function_exists('getGaugeViz')) {

	function getGaugeViz($sql_object, $scale_id, $indicator, $threshold_value, $cursorcssposition) {

		//$cursorcssposition is used to adjust cursor position depending on the container/context

		$req_sdiav=SQL_getAllValue("SCA", $scale_id, $indicator['sdii_id']);
		$result_value = $sql_object -> DBSelect($req_sdiav);

		// values are stored
		if ($result_value <> false){

			// we handle multivalues
			if(!empty($result_value[0]['sdiv_multivalue'])) {
				$data = unserialize($result_value[0]['sdiv_multivalue']);
				$current_value = $data[0]['_total'];
				// we handle simple values
			} else {
				$current_value = $result_value[0]['sdiv_value'];
			}

			$value_cursor1 = getPositionfromValue ($current_value, $indicator, $threshold_value);
			$value_cursor = 111 - $value_cursor1 + $cursorcssposition;
			$value_cursor = -111 + $value_cursor1 + $cursorcssposition; // 3 is half width of the cursor image. Positionning $value_cursor to -111 will display the cursor at the begining of the gauge

		}
		else {
			$value_cursor = 0;
		}

		// there is no value
		if ($result_value == false) {

			$gauge= 'gauge_grey.gif';
			$current_value = _t('dashboard','novalue');
			$cursor_visibility = 'hidden';
			$class="indicator-no-data";

		}
		// min, max and threshold are not set together. No display allowed
		elseif(is_null($indicator['sdii_max_value']) || is_null($indicator['sdii_min_value']) || is_null($threshold_value)) {

			$gauge= 'gauge_red.gif';
			$current_value = $result_value[0]['sdiv_value'];
			$cursor_visibility = 'hidden';
			$class="indicator-no-cursor";

		}
		// there is at least one value and min, max and threshold are set together
		else {

			$gauge= 'gauge.gif';

			$cursor_visibility = 'visible';
			$class="";

			// we handle multivalues
			if(!empty($result_value[0]['sdiv_multivalue'])) {
				$data = unserialize($result_value[0]['sdiv_multivalue']);
				$current_value = $data[0]['_total'];
				// we handle simple values
			} else {
				$current_value = $result_value[0]['sdiv_value'];
			}

		}

		if(CURRENT_APP == 'admin') {
			$link = "index.php?rub=dashboard&amp;todo=det&amp;id=".$indicator['sdii_id']."&amp;scale_id=".$scale_id;
		} else {
			$link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$indicator['sdii_id'], 'parentid'=> $scale_id));
		}

		$listing =	"<div class=\"dashboard-indicator-gauge indicator-info-container\">
		<a href=\"".$link."\" class=\"infobox\">
		<img src=\"" .THEME_ADMIN_PATH. "images/".$gauge."\" alt=\"".ucfirst(_t('dashboard','value'))." : ". fnumber_format($current_value, 'auto', false) ." (".formatText($indicator['sdii_unit']).") ".
		"\n ".ucfirst(_t('sdi','min_value'))." : ".empty_nc($indicator['sdii_min_value']).
		"\n ".ucfirst(_t('sdi','max_value'))." : ".empty_nc($indicator['sdii_max_value']).
		"\n ".ucfirst(_t('sdi','threshold_value'))." : ".empty_nc($threshold_value)."\"  /></a>";
		$listing .= getIndicatorInfoBox($current_value, $indicator, $threshold_value, $class);
		$listing .= "<img src=\"" .THEME_ADMIN_PATH. "images/cursor.gif\" title=\""._t('dashboard','value')." : ". fnumber_format($current_value, 'auto', false) ." ". formatText($indicator['sdii_unit']) . " - "._t('dashboard','barre')."\" class=\"cursor\" style=\"visibility:".$cursor_visibility.";left:".$value_cursor."px;\"/>";


		$listing .= getTendency($result_value);

		$listing .= "\t<span class=\"value\"> (".strtolower($current_value).")</span>\n";
		$listing .= "\t</div>\n";

		return 	$listing;
	}

}

if(!function_exists('getRawViz')) {

	function getRawViz($sql_object, $scale_id, $indicator, $threshold_value) {

		$req_sdiav=SQL_getAllValue("SCA", $scale_id, $indicator['sdii_id']);
		$result_value = $sql_object -> DBSelect($req_sdiav);

		$str = '<div class="dashboard-indicator-raw">';

		// there is no value
		if ($result_value==false) {
			$str .= '<span class="infobox no-value">-</span>';
			$current_value = _t('dashboard','novalue');
			$class="indicator-no-data";
			// some values are there
		} else {
			
			// we handle multivalues
			if(!empty($result_value[0]['sdiv_multivalue'])) {
				$data = unserialize($result_value[0]['sdiv_multivalue']);
				$str .= '<span class="infobox value">'.fnumber_format($data[0]['_total'], 'auto', false).'</span>';
				$current_value = $data[0]['_total'];
				// we handle simple values
			} else {

				$a = getBooleanValues($indicator);
				
				if($result_value[0]['sdiv_value'] == 0) $class= " boolean-false";
				else  $class= " boolean-true";

				if($a && $indicator['sdii_type'] == 'boolean') {

					$current_value = $a[$result_value[0]['sdiv_value']];
					$classbmask = ' boolean-mask';

				} else {
					
					$classbmask = '';
					$current_value = fnumber_format($result_value[0]['sdiv_value'], 'auto', false);
					
				}
				
				$str .= '<span class="infobox value '.$class.$classbmask.'">'.$current_value.'</span>';
			}

			$class="";

		}
		$str .= getIndicatorInfoBox($current_value, $indicator, $threshold_value, $class);

		$str .= '<span class="unit">'.formatText($indicator['sdii_unit']).'</span>';
		$str .= '</div>';

		$str .= getTendency($result_value);

		return $str;

	}

}

if(!function_exists('getSparklineViz')) {

	function getSparklineViz($sql_object, $scale_id, $indicator, $threshold_value) {

		// getting all values
		$req_sdiav=SQL_getAllValue("SCA", $scale_id, $indicator['sdii_id']);
		$result_value = $sql_object -> DBSelect($req_sdiav);

		$str = '<div class="dashboard-indicator-sparkline">';

		// there is no value
		if ($result_value==false) {
			$str .= '<span class="infobox no-value">-</span>';

			// some values are there
		} else {
			$data = array();
			// we reverse the array to display eldest first
			$values = array_reverse($result_value);

			foreach($values as $value) {

				// we handle multivalues
				if(!empty($value['sdiv_multivalue'])) {
					$dataindic = unserialize($value['sdiv_multivalue']);
					array_push($data, $dataindic[0]['_total']);
					// we handle simple values
				} else {
					array_push($data, $value['sdiv_value']);
				}

			}
			$str .= '<p><span class="inlinebar">'.join(',',$data).'</span></p>';
		}

		$str .= '</div>';



		$str .= getTendency($result_value);

		return $str;

	}

}

if(!function_exists('getViz')) {

	function getViz($sql_object, $scale_id, $indicator, $threshold_value, $overwrite = null, $cursorcssposition = 0) {

		if(!is_null($overwrite)) {
			$vizualisation_type = $overwrite;
		} else {
			$vizualisation_type = $indicator['sdii_dashboard_viz'];
		}

		if($vizualisation_type == 'raw') {
			$viz = getRawViz($sql_object, $scale_id, $indicator, $threshold_value);
		}
		if($vizualisation_type == 'gauge') {
			$viz = getGaugeViz($sql_object, $scale_id, $indicator, $threshold_value, $cursorcssposition);
		}
		if($vizualisation_type == 'sparkline') {
			$viz = getSparklineViz($sql_object, $scale_id, $indicator, $threshold_value, $cursorcssposition);
		}

		return $viz;
	}

}

/**
 * getBooleanValues()
 * Return boolean values enter in comment fields
 * or false if no mask is set or if not boolean
 * as {0=oui;1=non} format
 * @param array $indicator
 * @return mixed (false or array)
 */
if(!function_exists('getBooleanValues')) {

	function getBooleanValues($indicator) {

		if($indicator['sdii_type'] == 'boolean') {
			
			// get content with the following pattern
			// For example {0=non signée;1=signée}
			$pattern = '/{(.*?)}/'; 
			
			$r =preg_match($pattern, $indicator['sdii_comment'], $matches);
			
			if($r == 0) return false;
			
			$matches[1];
			list($maskfalse, $masktrue) = explode(";1", $matches[1]);
			
			$toremove = array("0", "1", "=");
			
			$maskfalse = trim(str_replace($toremove, "", $maskfalse));
			$masktrue = trim(str_replace($toremove, "", $masktrue));
			
			return array($maskfalse, $masktrue);
			
		}
			
		return false;
		
	}
}

/**
 * getTendency()
 * Return indicator tendency based on value
 * (not based on performance)
 * @param array $values
 */

if(!function_exists('getTendency')) {

	function getTendency($values) {

		$tendency = '<div class="dashboard-indicator-tendency">';

		// we handle multivalues
		// if there is a previous value
		if(!empty($values[1]['sdiv_multivalue'])) {
			$data = unserialize($values[0]['sdiv_multivalue']);
			$dataPlusOne = unserialize($values[1]['sdiv_multivalue']);

			$percentage = ($data[0]['_total'] - $dataPlusOne[0]['_total']) / $dataPlusOne[0]['_total'] * 100;
			$evolution = ' ('.round($percentage, 0). '%)';
			if ($data[0]['_total'] >= $dataPlusOne[0]['_total']) {
				$tendency.="<img src=\"" .THEME_ADMIN_PATH. "images/ico_asc.gif\" alt=\""._t('dashboard','value_tendance')."\" title=\"".sprintf(_t('dashboard','previous_value'), $dataPlusOne[0]['_total']).$evolution."\" />";
			} else {
				$tendency.="<img src=\"" .THEME_ADMIN_PATH. "images/ico_desc.gif\" alt=\""._t('dashboard','value_tendance')."\" title=\"".sprintf(_t('dashboard','previous_value'), $dataPlusOne[0]['_total']).$evolution."\" />";
			}

			// we handle simple values
			// if there is a previous value
		} elseif(isset($values[1]['sdiv_value'])) {
			$percentage = ($values[0]['sdiv_value'] - $values[1]['sdiv_value']) / $values[1]['sdiv_value'] * 100;
			$evolution = ' ('.round($percentage, 0). '%)';
			if ($values[0]['sdiv_value'] >= $values[1]['sdiv_value']) {
				$tendency.="<img src=\"" .THEME_ADMIN_PATH. "images/ico_asc.gif\" alt=\""._t('dashboard','value_tendance')."\" title=\"".sprintf(_t('dashboard','previous_value'), $values[1]['sdiv_value']).$evolution."\" />";
			} else {
				$tendency.="<img src=\"" .THEME_ADMIN_PATH. "images/ico_desc.gif\" alt=\""._t('dashboard','value_tendance')."\" title=\"".sprintf(_t('dashboard','previous_value'), $values[1]['sdiv_value']).$evolution."\" />";
			}
		}
		$tendency .= '</div>';

		return $tendency;
	}

}