<?php
/**
 * Dashboard module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../dashboard/' . SQL . '.inc.php'));
include_once(override('../dashboard/common.php'));
/**
 * DisplayListValuesByThemes()
 * affichage du tableau de bord
 * @param integer $id_filter
 * @param integer $filter
 * @return
 **/

if(!function_exists('DisplayListValuesByThemes')) {

	function DisplayListValuesByThemes($id_filter = -1, $filter = -1)
	{
		$result = $GLOBALS['sql_object'] -> DBSelect(SQL_getListtheme());
		$result_sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("P", $valueparam = 0));
		$listing = "";

		$a = array(); // to not display twice an indicator

		$current_sdtheme = '';

		for ($i = 0;$i < count($result);$i++) {
			if ($result[$i]['sdtheme_id'] != $current_sdtheme && $current_sdtheme <> '') {
				$listing .= "</tbody>" . PHP_EOL;
				$listing .= "</table>" . PHP_EOL;
			}
			if ($result[$i]['sdtheme_id'] != $current_sdtheme) {

				$current_sdtheme = $result[$i]['sdtheme_id'];
				$listing .= "<h2 class=\"dashboard theme-".$current_sdtheme."\">" . formatText($result[$i]['sdtheme_name'], '2HTML') . "</h2>".PHP_EOL;
				$listing .= '<table cellspacing="0" cellpadding="5" class="table_dashboard" summary="'.sprintf(_t('dashboard','list_public_summary'), formatText($result[$i]['sdtheme_name'], '2HTML')).'">' . PHP_EOL;
				$listing .= '<thead>' . PHP_EOL;
				$listing .= '<tr>' . PHP_EOL;
				$listing .= '<td class="graphic-values pt2">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . PHP_EOL;
				$listing .= '<td class="pt3">'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . PHP_EOL;
				$listing .= '</tr>' . PHP_EOL;
				$listing .= '</thead>' . PHP_EOL;
				$listing .= '<tbody>' . PHP_EOL;

			}
			for ($j = 0;$j < count($result_sdi);$j++) {
				if ($result[$i]['theme_id'] == $result_sdi[$j]['sdii_theme']) {

					// we display the value only if attached to dashboard
					// and if not yet displayed
					if ($result_sdi[$j]['sdii_to_dashboard']=='Y' && !in_array($result_sdi[$j]['sdii_id'], $a)) {
						// setting $threshold_value
						// By default initial value
						$threshold_value = $result_sdi[$j]['sdii_threshold_value'];
						// if set, we get the latest for the given scale
						$r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($result_sdi[$j]['sdii_id'], $id_filter));
						if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
							$threshold_value = $r[0]['sdiv_threshold'];
						}

						$link_det_sdi= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$result_sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $result_sdi[$j]['sdii_name']);
						$listing .= "<tr>" . PHP_EOL;
						$listing .= "<td class=\"graphic-values indicator-".$result_sdi[$j]['sdii_type']."\">";
						$listing .= getViz($GLOBALS['sql_object'], $id_filter, $result_sdi[$j], $threshold_value);
						$listing .= "</td>";
						$listing .= "<td class=\"nomargin\"><a href=\"" . HrefMaker($link_det_sdi) . "\" title=\"" . formatText($result_sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText($result_sdi[$j]['sdii_name'], '2HTML') . "</a></td>" . PHP_EOL;
						$listing .= "</tr>" . PHP_EOL;

						array_push($a, $result_sdi[$j]['sdii_id']); // we add the id into array for not displaying it twice
					}
				}
			}
		}
		$listing .= "</tbody>" . PHP_EOL;
		$listing .= "</table>" . PHP_EOL;

		hoverJsBox();

		// including sparkline code
		footerAddJS('../lib/js/jquery.sparkline.min.js');
		footerAddInlineJS("$('.inlinebar').sparkline('html', {type: 'bar', barColor: '#8DA8CB'} );");

		echo $listing;
	}
}

/**
 * DisplayListValuesByProjects()
 * affichage du tableau de bord
 * @param integer $id_filter
 * @param integer $filter
 * @return
 **/

if(!function_exists('DisplayListValuesByProjects')) {

	function DisplayListValuesByProjects($id_filter = -1, $filter = -1)
	{
		$result = $GLOBALS['sql_object'] -> DBSelect(SQL_getListProjects());
		$result_sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("P", $valueparam = 0));
		$listing = "";

		$current_project = '';

		for ($i = 0;$i < count($result);$i++) {
			if ($result[$i]['project_id'] != $current_project && $current_project <> '') {
				$listing .= "</tbody>" . PHP_EOL;
				$listing .= "</table>" . PHP_EOL;
			}
			if ($result[$i]['project_id'] != $current_project) {

				$current_project = $result[$i]['project_id'];
				$listing .= "<h2 class=\"dashboard project-".$current_project."\">" . formatText($result[$i]['project_name'], '2HTML') . "</h2>".PHP_EOL;
				$listing .= '<table cellspacing="0" cellpadding="5" class="table_dashboard" summary="'.sprintf(_t('dashboard','list_public_summary'), formatText($result[$i]['project_name'], '2HTML')).'">' . PHP_EOL;
				$listing .= '<thead>' . PHP_EOL;
				$listing .= '<tr>' . PHP_EOL;
				$listing .= '<td class="graphic-values">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . PHP_EOL;
				$listing .= '<td>'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . PHP_EOL;
				$listing .= '</tr>' . PHP_EOL;
				$listing .= '</thead>' . PHP_EOL;
				$listing .= '<tbody>' . PHP_EOL;
					
			}
			for ($j = 0;$j < count($result_sdi);$j++) {
				if ($result[$i]['project_id'] == $result_sdi[$j]['jps_project_id']) {
						
					// we display the value only if attached to dashboard
					//if ($result_sdi[$j]['sdii_to_dashboard']=='Y') {
						// setting $threshold_value
						// By default initial value
						$threshold_value = $result_sdi[$j]['sdii_threshold_value'];
						// if set, we get the latest for the given scale
						$r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($result_sdi[$j]['sdii_id'], $id_filter));
						if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
							$threshold_value = $r[0]['sdiv_threshold'];
						}
							
						$link_det_sdi= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$result_sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $result_sdi[$j]['sdii_name']);
						$listing .= "<tr>" . PHP_EOL;
						$listing .= "<td class=\"graphic-values indicator-".$result_sdi[$j]['sdii_type']."\">";
						$listing .= getViz($GLOBALS['sql_object'], $id_filter, $result_sdi[$j], $threshold_value);
						$listing .= "</td>";
						$listing .= "<td class=\"nomargin\"><a href=\"" . HrefMaker($link_det_sdi) . "\" title=\"" . formatText($result_sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText($result_sdi[$j]['sdii_name'], '2HTML') . "</a></td>" . PHP_EOL;
						$listing .= "</tr>" . PHP_EOL;
					//}
				}
			}
		}
		$listing .= "</tbody>" . PHP_EOL;
		$listing .= "</table>" . PHP_EOL;

		hoverJsBox();

		// including sparkline code
		footerAddJS('../lib/js/jquery.sparkline.min.js');
		footerAddInlineJS("$('.inlinebar').sparkline('html', {type: 'bar', barColor: '#8DA8CB'} );");
		
		echo $listing;
	}
}

function hoverJsBox() {

	$js = '<script type="text/javascript">
	$(document).ready(function() {
	$(".dashboard-indicator-gauge .cursor").removeAttr("title");
	$(".infobox").hover(
		function() {
			$(this).next().fadeIn("fast");
		},
		function() {
			$(this).next().hide();
		}
	);
	});
	</script>';
	footerAddInlineJS($js, 'default', false);
}


/**
 * DisplayOneSdi()
 * affichage d'un indicateur et infos résumé
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('DisplayOneSdi')) {

	function DisplayOneSdi($sdi_id, $scale_id)
	{
		echo GetSdiTitle($sdi_id, $scale_id);
		echo getDashboardNavigation($sdi_id,$scale_id);
		echo GetAllValue($sdi_id, $scale_id);
		echo GetOneSdiInfo($sdi_id);
	}
}

/**
 * DisplayOneSdirules()
 * affichage d'un indicateur et toutes ses infos
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('DisplayOneSdirules')) {

	function DisplayOneSdirules($sdi_id, $scale_id)
	{
		echo GetSdiTitle($sdi_id, $scale_id);
		echo getDashboardNavigation($sdi_id,$scale_id);
		echo GetOneSdiRules($sdi_id);
	}
}
/**
 * DisplayOneSdievaluation()
 * affichage d'un indicateur et toutes ses infos
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('DisplayOneSdievaluation')) {

	function DisplayOneSdievaluation($sdi_id, $scale_id)
	{
		echo GetSdiTitle($sdi_id, $scale_id);
		echo getDashboardNavigation($sdi_id,$scale_id);
		echo GetOneSdiEvaluation($sdi_id);
	}
}
/**
 * DisplayOneSdiprovider()
 * affichage d'un indicateur et toutes ses infos
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('DisplayOneSdiprovider')) {

	function DisplayOneSdiprovider($sdi_id, $scale_id)
	{
		echo GetSdiTitle($sdi_id, $scale_id);
		echo getDashboardNavigation($sdi_id,$scale_id);
		echo GetOneSdiProvider($sdi_id);
	}
}
/**
 * GetAllValue()
 * afficahge de l'ensemble des valeurs publiques d'un IDD
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('GetAllValue')) {

	function GetAllValue($sdi_id, $scale_id)
	{
		$result_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getAllValue("SCD", $scale_id, $sdi_id));
		$result_sdi_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getInfoSdiforvalue($sdi_id));

		// setting $default_threshold value
		// By default initial value
		$default_threshold = $result_sdi_value[0]['sdii_threshold_value'];

		$content = '<div id="indicator-value" class="internal-content">' . PHP_EOL;
		$content .= '<h2>'._t('dashboard','historic').'</h2>' . PHP_EOL;
		if(!empty($default_threshold)) $content .= '<div id="indicator-threshold">'._t('sdi','initial_threshold_value').' : <span>'.$result_sdi_value[0]['sdii_threshold_value'].' '.$result_sdi_value[0]['sdii_unit'].'</span></div>' . PHP_EOL;

		if ($result_value <> false) {
			if (count($result_value) > 2) {
				$content .= '<h3>'._t('dashboard','rep_graph').' </h3>' . PHP_EOL;

				$graph_path = override('../dashboard/graph.php');

				$content .= "<img src=\"".$graph_path."?id=" . $sdi_id . "&amp;scale_id=" . $scale_id . "&amp;display=true\"  id=\"imggraph\" class=\"graph\" alt=\"".formatText(_t('dashboard','rep_graph'), '2ATT')."\"/>" . PHP_EOL;
			}
			$content .= '<h3>'._t('dashboard','value').'</h3>' . PHP_EOL;

			$content .= '<table cellspacing="0" cellpadding="5" class="table_dashboard_det"  summary="'._t('dashboard','all_values_summary').'">' . PHP_EOL;
			$content .= '<thead>' . PHP_EOL;
			$content .= '<tr>' . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','date'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','value'))." (".$result_sdi_value[0]['sdii_unit'].")</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','threshold_value'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','rate'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','comment'))."</td>" . PHP_EOL;
			$content .= "</tr>" . PHP_EOL;
			$content .= "</thead>" . PHP_EOL;
			$content .= "<tbody>" . PHP_EOL;

			for ($i = 0;$i < count($result_value);$i++) {
				$comment = '';
				$current_val = '';

				// indicator is multivalues
	 			if(!empty($result_value[$i]['sdiv_multivalue'])) {

	  			$data = unserialize($result_value[$i]['sdiv_multivalue']);
				
					foreach($data as &$val) {
						$current_val .= '<p class="indicator-multivalue">';
						if(!empty($val['label'])) $current_val .= $val['label']. ' : ';
						$current_val .= fnumber_format($val['value'], 'auto', false). '<span class="value-percent"> ('.fnumber_format($val['_percentage'], 2, false).' %)</span>';
					  
						$current_val .= '</p>';
					}
					// we display the total
					$current_val .= '<p class="value-total indicator-multivalue">';
					$current_val .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : ' . fnumber_format($data[0]['_total'], 'auto', false);
					$current_val .= ' <span>(<a class="ajaxload" href="'. override('../dashboard/pie.php').'?id='.$sdi_id.'&amp;value='.$result_value[$i]['sdiv_id'].'&amp;display=true">'._t('dashboard', 'to_detail_chart').'</a>)</span>';
					$current_val .= '</p>';

					// we compute rate
					if(isset($result_value[$i+1]['sdiv_multivalue'])) {
						$dataPlusOne = unserialize($result_value[$i+1]['sdiv_multivalue']);
						$evol = ($data[0]['_total'] - $dataPlusOne[0]['_total']) / $dataPlusOne[0]['_total'] * 100;
						//_debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$data[0]['_total']. ' - ' . $dataPlusOne[0]['_total']. ') / '. $dataPlusOne[0]['_total']);
						$evol = fnumber_format($evol, 2). ' %';
					} else {
						$evol = empty_nc('');
					}

					// indicator is NOT multivalues
				} else {
					
					// If indicator is boolean
					if($result_sdi_value[0]['sdii_type'] == 'boolean') {
						$a = getBooleanValues($result_sdi_value[0]);
						if($a) {
							$current_val .= $a[$result_value[$i]['sdiv_value']];
						} else {
							$current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
						}
						 
					} else {
						$current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
					}
					
					// $current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);

					// we compute rate
					if(isset($result_value[$i+1]['sdiv_value']) && is_numeric($result_value[$i+1]['sdiv_value'])) {
						$evol = ($result_value[$i]['sdiv_value'] - $result_value[$i+1]['sdiv_value']) / $result_value[$i+1]['sdiv_value'] * 100;
						_debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$result_value[$i]['sdiv_value']. ' - ' . $result_value[$i+1]['sdiv_value']. ') / '. $result_value[$i+1]['sdiv_value']);
						$evol = fnumber_format($evol, 2). ' %';
					} else {
						$evol = empty_nc('');
					}
				}

				// if set, we get it from the table
				if(!is_null($result_value[$i]['sdiv_threshold'])) {
					$threshold = fnumber_format($result_value[$i]['sdiv_threshold'], 'auto', false);
				} else {
					$threshold = fnumber_format($default_threshold, 'auto', false);
				}

			  if(!empty($result_value[$i]['sdiv_comment']) && $result_value[$i]['sdiv_comment_display']=='Y') {
			  	$comment  = '<div class="valuecomment">';
			  	$comment .= '<img src="'.THEME_PUBLIC_PATH.'images/indic-comment.png" />';
			  	$comment .= '<div class="cont"><strong>'.ucfirst(_t('dashboard', 'comment')).' :</strong> '.$result_value[$i]['sdiv_comment'].'</div>';
			  	$comment .= '</div>';
			  }
			  $content .= "<tr>" . PHP_EOL;
			  $content .= "<td>" . formatText($result_value[$i]['date_p'], '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td>" . formatText($current_val, '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td class=\"threshold\">" . formatText($threshold, '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td class=\"rate\">". $evol. "</td>" . PHP_EOL;
			  $content .= "<td>". $comment. "</td>" . PHP_EOL;
			  $content .= "</tr>" . PHP_EOL;

			}

			$content .= "</tbody>" . PHP_EOL;
			$content .= "</table>" . PHP_EOL;
			$content .= '</div>' . PHP_EOL;
			return $content;
		}
	}
}

/**
 * GetSdiTitle()
 * affichage nom d'un indicateur
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('GetSdiTitle')) {

	function GetSdiTitle($sdi_id, $scale_id)
	{
		$link_self= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id' => $sdi_id, 'parentid' => $_REQUEST['parentid']);
		$data_sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getOnesdiname($sdi_id, array('P')));

		if($data_sdi == 0) error_redirect();

		$data_scale = $GLOBALS['sql_object'] -> DBSelect(SQL_getonescale($scale_id));
		$sdi_name = formatText($data_sdi[0]['sdii_name'], '2HTML');
		$sdi_description = formatText($data_sdi[0]['sdii_description'], '2HTML');
		$scale_name = formatText(cutText($data_scale[0]['scale_denomination'], 150), '2HTML');
		$content  = '<div id="indicator-main">' . PHP_EOL;
		$content .= '<h1>' . mb_ucfirst($sdi_name) . '</h1>' . PHP_EOL;
		$content .='<p class="published_by">'.PHP_EOL;
		$content .= formatted_permalink($link_self);
		$content .='</p>'.PHP_EOL;
		$content .= '<div id="indicator-desc" class="body">' . $sdi_description . '</div>' . PHP_EOL;
		$content .= '<p class="scale"> échelle : <span>' . $scale_name . '</span></p>' . PHP_EOL;
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiInfo()
 * récupération des infos générales d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiInfo')) {

	function GetOneSdiInfo($sdi_id)
	{
		$data = $GLOBALS['sql_object'] -> DBSelect(SQL_getInfoSdi($sdi_id));

		$sdi_name = formatText($data[0]['sdii_name'], '2HTML');
		$sdi_theme = formatText(cutText($data[0]['theme_name'], 150), '2HTML');
		$sdi_description = formatText($data[0]['sdii_description'], '2HTML');
		$sdi_comment = formatText($data[0]['sdii_comment'], '2HTML');
		$sdi_goal = formatText($data[0]['sdii_goal'], '2HTML');
		$sdi_consulting = formatText($data[0]['sdii_consulting'], '2HTML');

		$content = '<div id="indicator-info" class="internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('dashboard','det_sdi2')).'</h2>' . PHP_EOL;
		$content .= '<h3> '.mb_ucfirst(_t('sdi','goal_public')).' </h3>' . PHP_EOL;
		$content .= '<div id="indicator-goal" class="body">' . $sdi_goal . '</div>' . PHP_EOL;
		$content .= '<h3>'.mb_ucfirst(_t('sdi','consulting_public')).'</h3>' . PHP_EOL;
		$content .= '<div id="indicator-advices" class="body">' . $sdi_consulting . '</div>' . PHP_EOL;
		$content .= '</div><br />' . PHP_EOL;
		return $content;
	}
}

/**
 * GetOneSdiRules()
 * récupération des réglementations d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiRules')) {

	function GetOneSdiRules($sdi_id)
	{
		$result_r = $GLOBALS['sql_object'] -> DBSelect(SQL_getRules($sdi_id, $GLOBALS['sql_object'], -1));
		$r_title = formatText($result_r[0]['sdir_title'], '2HTML');
		$r_body = formatText($result_r[0]['sdir_body'], '2HTML');
		if(!empty($result_r[0]['sdir_referer_uri'])) {
			$url = "<a href=\"" . formatText($result_r[0]['sdir_referer_uri'], '2HTML') . "\" title=\"" . formatText($result_r[0]['sdir_mask_uri'], '2ATT') . "\">" . formatText($result_r[0]['sdir_mask_uri'], '2HTML') . "</a>";
		}

		$content = '<div id="indicator-rules" class="internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','r_body')).'</h2>' . PHP_EOL;
		if ($result_r[0]['sdir_title'] == "") {
			$content .= "<p class=\"info\">"._t('divers','nodata')." </p>" . PHP_EOL;
		} else {
			$content .= "<h3>" . $r_title . "</h3>" . PHP_EOL;
			$content .= "<div class=\"body\">" . $r_body . "</div>" . PHP_EOL;
			if(isset($url)) {
				$content .= "<p>" . $url . "</p>" . PHP_EOL;
			}
		}
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiEvaluation()
 * récupération des critères d'évaluation d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiEvaluation')) {

	function GetOneSdiEvaluation($sdi_id)
	{
		$result_e = $GLOBALS['sql_object'] -> DBSelect(SQL_getEvaluation($sdi_id, $GLOBALS['sql_object'], -1));

		$content = '<div id="indicator-evaluation" class="internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','e_title')).'</h2>' . PHP_EOL;
		$content .= '<table cellspacing="0" cellpadding="5" class="table_dashboard_det" summary="'._t('dashboard','evaluation_values_summary').'">' . PHP_EOL;
		$content .= '<thead>' . PHP_EOL;
		$content .= '<tr>' . PHP_EOL;
		$content .= "<td>"._t('sdi','e_scale_compare')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_fiability')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_accessibility')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_lisibility')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_relevance')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_global_performance')."</td>" . PHP_EOL;
		$content .= "</tr>" . PHP_EOL;
		$content .= "</thead>" . PHP_EOL;
		$content .= "<tbody>" . PHP_EOL;
		$content .= "<tr>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_scale_compare'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_fiability'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_accessibility'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_lisibility'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_relevance'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_global_performance'] . "</td>" . PHP_EOL;
		$content .= "</tr>" . PHP_EOL;
		$content .= "</tbody>" . PHP_EOL;
		$content .= "</table>" . PHP_EOL;
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiProvider()
 * récupération des infos du fournisseurs d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiProvider')) {

	function GetOneSdiProvider($sdi_id)
	{
		$result_p = $GLOBALS['sql_object'] -> DBSelect(SQL_getProvider($sdi_id, $GLOBALS['sql_object'], -1));

		$p_name = formatText($result_p[0]['sdip_name'], '2HTML');
		$p_description = formatText($result_p[0]['sdip_description'], '2HTML');

		$content = '<div id="indicator-provider" class="internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','p_title')).'</h2>' . PHP_EOL;
		if ($result_p[0]['sdip_name'] == "") {
			$content .= "<p class=\"info\">"._t('divers','nodata')." </p>" . PHP_EOL;
		} else {
			$content .= '<p>' . $p_name . '</p>' . PHP_EOL;
			$content .= '<div class="body">' . $p_description . '</div>' . PHP_EOL;
		}
		$content .= '</div>' . PHP_EOL;
		return $content;
	}
}

/**
 * getDataVizMode()
 * return a link to switch display mode
 * @param $scale_id
 * @return string
 * @todo remove or use to display tabular data
 **/
if(!function_exists('getDataVizSwitcher')) {

	function getDataVizSwitcher($altmode, $scale_id)
	{
		if( $altmode )  {
			$link = array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $scale_id);
			$msg = _t('dashboard', 'mode_by_finality');
		} else {
			$link = array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $scale_id, 'altmode' => true);
			$msg = _t('dashboard', 'mode_by_project');
		}
		// adding these vars to url allow to display the right scale into filter box
		// @todo filters should be enhanced
		if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter'] == $GLOBALS['filters'][U_L]['scale']['linkvalue']) {
			$link = array_merge($link, array('filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue']));
		}
		
		
		$str   = '<div class="switchnav">';
		$str  .= '<a class="button" href="'.HrefMaker($link).'" title="'.$msg.'">'.$msg.'</a>'.PHP_EOL;
		$str  .= '</div>';

		return $str;
	}
}

/**
 * getDashboardNavigation()
 * Return a string with the internal navigation
 * @param int
 * @param int
 * @return string
 **/
if(!function_exists('getDashboardNavigation')) {

	function getDashboardNavigation($sdi_id,$scale_id)
	{
		$data = $GLOBALS['sql_object'] -> DBSelect(SQL_getOnesdiname($sdi_id));
		$link_aff_info = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id' => $sdi_id, 'parentid' => $scale_id, 'name' => $data[0]['sdii_name']));
		$link_aff_rules = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['dashboard-rules']['linkvalue'], 'id' => $sdi_id, 'parentid' => $scale_id, 'name' => $data[0]['sdii_name']));

		$link_aff_provider = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['dashboard-provider']['linkvalue'],'id' => $sdi_id, 'parentid' => $scale_id, 'name' => $data[0]['sdii_name']));
		$link_aff_evaluation = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['dashboard-assessment']['linkvalue'], 'id' => $sdi_id, 'parentid' => $scale_id, 'name' => $data[0]['sdii_name']));

		ActiveItemKey($GLOBALS['activeitem'])=='dashboard' ? $info_class='active' : $info_class='';
		ActiveItemKey($GLOBALS['activeitem'])=='dashboard-rules' ? $rules_class='active' : $rules_class='';
		ActiveItemKey($GLOBALS['activeitem'])=='dashboard-assessment' ? $assessment_class='active' : $assessment_class='';
		ActiveItemKey($GLOBALS['activeitem'])=='dashboard-provider' ? $provider_class='active' : $provider_class='';

		$content ="<div class=\"internal-nav\" id=\"indicator-nav\">". PHP_EOL;
		$content .="<ul>". PHP_EOL;
		$content .="<li>". PHP_EOL;
		$content .= '<a href="' . $link_aff_info . '" title="'.formatText(_t('dashboard','mode_aff_info'), '2ATT').'" class="'.$info_class.'">'._t('dashboard','mode_aff_info').'</a>' . PHP_EOL;
		$content .="</li><!-- @whitespace". PHP_EOL;
		$content .="--><li>". PHP_EOL;
		$content .= '<a href="' . $link_aff_rules . '" title="'.formatText(_t('dashboard','mode_aff_rules'), '2ATT').'" class="'.$rules_class.'">'._t('dashboard','mode_aff_rules').'</a>' . PHP_EOL;
		$content .="</li><!-- @whitespace". PHP_EOL;
		$content .="--><li>". PHP_EOL;
		$content .= '<a href="' . $link_aff_provider . '" title="'._t('dashboard','mode_aff_provider').'" class="'.$provider_class.'">'._t('dashboard','mode_aff_provider').'</a>' . PHP_EOL;
		$content .="</li><!-- @whitespace". PHP_EOL;
		$content .="--><li>". PHP_EOL;
		$content .= '<a href="' . $link_aff_evaluation . '" title="'.formatText(_t('dashboard','mode_aff_evaluation'), '2ATT').'" class="'.$assessment_class.'">'._t('dashboard','mode_aff_evaluation').'</a>' . PHP_EOL;
		$content .="</li>". PHP_EOL;
		$content .="</ul>". PHP_EOL;
		$content .="</div>". PHP_EOL;

		return $content;
	}
}


?>