<?php
/**
 * Dashboard module
 * 
 * Export indicators information and values into XML format
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/***********************
 * paramétrage du fichier XML
 *
 * *************************/

/*********************
 * contenu du fichier XML
 * valeurs posssibles :
 * P (format public)
 * A (format admin)
 ************************/
$format="P";

/*********************
 * liste des indicateurs
 * valeurs posssibles :
 * R (statut<>'E')
 * P (statut='P')
 ************************/
if ($format=="A")$filter_sdi="R";
else $filter_sdi="P";
/*********************
 * liste des valeurs
 * valeurs posssibles :
 * D (statut<>'E')
 * SCP (statut='P') sdiv_date_published ASC
 * SCD (statut='P') sdiv_date_published DESC
 * SCA (statut<>'E') sdiv_date_published DESC
 ************************/

if ($format=="A") $filter_value="D";
else $filter_value="SCD";

define('TAB_LINE',"   ");

include_once("../config/define.php");
include_once("../lib/no_cache.php");
IncludeAdminLang("dashboard");

include_once(SQL.'.inc.php');
include_once('../class/class.sdi.php');

$sdi_object= new sdi;
$result=$sql_object->DBSelect($req_list_theme);

$req_sdi=SQL_getListSdi($filter_sdi, $valueparam=0);
$result_sdi = $sql_object -> DBSelect($req_sdi);
header('Content-Type: text/xml');
$listing="<?xml version=\"1.0\" encoding=\"".CHARSET."\"?>".PHP_EOL."<dashboard>" . PHP_EOL;

$current_sdtheme='';
$current_theme='';
for ($i=0;$i<count($result);$i++){
  if ($result[$i]['sdtheme_id']!=$current_sdtheme) {
    $current_sdtheme=$result[$i]['sdtheme_id'];
    $aff_theme=false;
    if ($i!=0)$listing.=TAB_LINE."</theme>".PHP_EOL."</sdtheme>" . PHP_EOL;
    $listing.="<sdtheme id=\"".$result[$i]['sdtheme_id']."\" title=\"".formatText($result[$i]['sdtheme_name'], '2XML')."\">" . PHP_EOL;

  }
  else $aff_theme=true;

  if ($result[$i]['theme_id']!=$current_theme) {
    $current_theme=$result[$i]['theme_id'];
    if ($aff_theme==true) $listing.=TAB_LINE."</theme>" . PHP_EOL;
    $listing.= TAB_LINE."<theme id=\"".$result[$i]['theme_id']."\" title=\"".formatText($result[$i]['theme_name'], '2XML')."\">" . PHP_EOL;
  }


  for ($j=0;$j<count($result_sdi);$j++){
    if ($result[$i]['theme_id']==$result_sdi[$j]['sdii_theme']) {


      $req_sdii=SQL_getInfoSdi($result_sdi[$j]['sdii_id']);
      $result_sdii = $sql_object -> DBSelect($req_sdii);

      $req_sdir=SQL_getRules( $result_sdi[$j]['sdii_id'], $sql_object, -1);
      $result_r = $sql_object -> DBSelect($req_sdir);

      $req_sdie=SQL_getEvaluation( $result_sdi[$j]['sdii_id'], $sql_object,-1);
      $result_e = $sql_object -> DBSelect($req_sdie);

      $req_sdip=SQL_getProvider( $result_sdi[$j]['sdii_id'], $sql_object,-1);
      $result_p = $sql_object -> DBSelect($req_sdip);

      $req_scale=SQL_getlistscale(0);
      $resultscale = $sql_object -> DBSelect($req_scale);

      //formattage des infos générales
      $listing.=TAB_LINE.TAB_LINE."<indicator id=\"".$result_sdi[$j]['sdii_id']."\">" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<title>".formatText($result_sdi[$j]['sdii_name'], '2XML')."</title>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<description>".formatText($result_sdii[0]['sdii_description'], '2XML')."</description>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<comment>".formatText($result_sdii[0]['sdii_comment'], '2XML')."</comment>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<range>".formatText($result_sdii[0]['sdii_range'], '2XML')."</range>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<goal>".formatText($result_sdii[0]['sdii_goal'], '2XML')."</goal>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<consulting>".formatText($result_sdii[0]['sdii_consulting'], '2XML')."</consulting>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<unit>".formatText($result_sdii[0]['sdii_unit'], '2XML')."</unit>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<max_value>".formatText(empty_nc($result_sdii[0]['sdii_max_value']), '2XML')."</max_value>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<min_value>".formatText(empty_nc($result_sdii[0]['sdii_min_value']), '2XML')."</min_value>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<threshold_value>".formatText(empty_nc($result_sdii[0]['sdii_threshold_value']), '2XML')."</threshold_value>" . PHP_EOL;
      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<threshold_relative>".formatText($result_sdii[0]['sdii_threshold_relative'], '2XML')."</threshold_relative>" . PHP_EOL;

      if ($format=="A"){
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<frequency>".formatText($result_sdii[0]['sdii_frequency'], '2XML')."</frequency>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($result_sdii[0]['sdii_date_crea'], '2XML')."</date_crea>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($result_sdii[0]['sdii_last_modify'], '2XML')."</last_modify>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<statut>".formatText($result_sdii[0]['sdii_statut'], '2XML')."</statut>" . PHP_EOL;
        //formattage des infos du fournisseur
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<provider id=\"".$result_p[0]['sdip_id']."\">". PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<title>".formatText($result_p[0]['sdip_name'], '2XML')."</title>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<service>".formatText($result_p[0]['sdip_service'], '2XML')."</service>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<description>".formatText($result_p[0]['sdip_description'], '2XML')."</description>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<incharge>".formatText($result_p[0]['sdip_incharge'], '2XML')."</incharge>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<address>".formatText($result_p[0]['sdip_address'], '2XML')."</address>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<phone>".formatText($result_p[0]['sdip_phone'], '2XML')."</phone>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<fax>".formatText($result_p[0]['sdip_fax'], '2XML')."</fax>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<email>".formatText($result_p[0]['sdip_email'], '2XML')."</email>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($result_p[0]['date_c'], '2XML')."</date_crea>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($result_p[0]['date_m'], '2XML')."</last_modify>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."</provider>". PHP_EOL;

        //formattage des infos de réglementation
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<reglementation id=\"".$result_r[0]['sdir_id']."\">". PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<title>".formatText($result_r[0]['sdir_title'], '2XML')."</title>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<body>".formatText($result_r[0]['sdir_body'], '2XML')."</body>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<referer_uri>".formatText($result_r[0]['sdir_referer_uri'], '2XML')."</referer_uri>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<mask_uri>".formatText($result_r[0]['sdir_mask_uri'], '2XML')."</mask_uri>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($result_p[0]['date_c'], '2XML')."</date_crea>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($result_p[0]['date_m'], '2XML')."</last_modify>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."</reglementation>". PHP_EOL;

        //formattage des infos d'évaluation
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<evaluation id=\"".$result_e[0]['sdie_id']."\">". PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<scale_compare>".formatText($result_e[0]['sdie_scale_compare'], '2XML')."</scale_compare>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<fiability>".formatText($result_e[0]['sdie_fiability'], '2XML')."</fiability>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<accessibility>".formatText($result_e[0]['sdie_accessibility'], '2XML')."</accessibility>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<lisibility>".formatText($result_e[0]['sdie_lisibility'], '2XML')."</lisibility>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<relevance>".formatText($result_e[0]['sdie_relevance'], '2XML')."</relevance>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<global_performance>".formatText($result_e[0]['sdie_global_performance'], '2XML')."</global_performance>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($result_p[0]['date_c'], '2XML')."</date_crea>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($result_p[0]['date_m'], '2XML')."</last_modify>" . PHP_EOL;
        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."</evaluation>". PHP_EOL;
      }
      //formattage des valeurs
      for ($z=0;$z<count($resultscale);$z++){

        $req_sdiav=SQL_getAllValue($filter_value, $resultscale[$z]['scale_id'], $result_sdi[$j]['sdii_id']);
        $result_value = $sql_object -> DBSelect($req_sdiav);
        if ($result_value[0]['sdiv_value']<>""){
          $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<scale id=\"".$resultscale[$z]['scale_id']."\">". PHP_EOL;
          $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<title>".formatText($resultscale[$z]['scale_denomination'], '2XML')."</title>" . PHP_EOL;
          for ($h=0;$h<count($result_value);$h++){
            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<value id=\"".$result_value[$h]['sdiv_id']."\">". PHP_EOL;
            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<num_value>".formatText($result_value[$h]['sdiv_value'], '2XML')."</num_value>" . PHP_EOL;
            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_published>".formatText($result_value[$h]['date_p'], '2XML')."</date_published>" . PHP_EOL;
            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($result_value[$h]['date_c'], '2XML')."</date_crea>" . PHP_EOL;
            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($result_value[$h]['date_m'], '2XML')."</last_modify>" . PHP_EOL;
            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<statut>".formatText($result_value[$h]['sdiv_statut'], '2XML')."</statut>" . PHP_EOL;
            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."</value>". PHP_EOL;
          }
          $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."</scale>". PHP_EOL;
        }
      }

      $listing.=TAB_LINE.TAB_LINE."</indicator>" . PHP_EOL;
    }
  }

}
$listing.=TAB_LINE."</theme>".PHP_EOL."</sdtheme>" . PHP_EOL."</dashboard>" . PHP_EOL;

echo $listing;

?>