<?php
/**
 * Dashboard module
 * 
 * Modify indicator given value from back-office
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if (!isset($_GET['value_id']) && !isset($_POST['value_id'])) {
	$value_id = 1;
} else {
	if (isset($_POST['value_id'])) $value_id = $_POST['value_id'];
	if (isset($_GET['value_id'])) $value_id = $_GET['value_id'];
}
if (!isset($_GET['id']) && !isset($_POST['id'])) {
	$id = 1;
} else {
	if (isset($_POST['id'])) $id = $_POST['id'];
	if (isset($_GET['id'])) $id = $_GET['id'];
}
if (!isset($_GET['scale_id']) && !isset($_POST['scale_id'])) {
	$scale_id = 1;
} else {
	if (isset($_POST['scale_id'])) $scale_id = $_POST['scale_id'];
	if (isset($_GET['id'])) $scale_id = $_GET['scale_id'];
}

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('dashboard') && !$l21auth->hasRight('indicator', $id)) ReloadIndex('admin');
////////////

include_once("../lib/input_helpers.php");
include_once("../dashboard/common.php");

$req_sdii=SQL_getInfoSdi($id);
$result_sdii = $sql_object -> DBSelect($req_sdii);
$indicator_name =  formatText($result_sdii[0]['sdii_name'], '2HTML');

// Do record exists?
if(!isset($result_sdii[0]['sdii_name'])) redirect_to('@module_default');

$navtitle=_t('dashboard','mod')." : ". $indicator_name;

if($result_sdii[0]['sdii_type'] == 'boolean') {
	$a = getBooleanValues($result_sdii[0]);
	
	if($a) {
		$mask = '<strong>0 = '. $a[0]. ', 1 = '. $a[1].'</strong>';
		$mask = sprintf(_t('sdi', 'boolindicator_mask'), $mask);
		
		$maskminvalue = $a[0];
		$maskmaxvalue = $a[1];
		
	} else {
		$mask = _t('sdi', 'boolindicator_nomask');
	}
	$bool_msg = _t('sdi', 'bool_indicator'). ' ' . $mask;
}

$sdi_object = new sdi;
$req_sdiov=SQL_getOneValue($value_id);
$result_value = $sql_object -> DBSelect($req_sdiov);
//$result_value = $sdi_object -> GetOneValue($value_id, $sql_object);

$link_det_sdi = "index.php?&amp;rub=sdi&amp;todo=det&amp;id=";
$link_cancel=$rub_link."&amp;todo=det&amp;id=".$id."&amp;scale_id=".$scale_id;

if (isset($_POST['enregistrer'])) {
  $data_table = unserialize(urldecode($_POST['data_table']));
  $data_table['user_id'] = $l21auth->GetSessionElement('id');
  
  $sdi_object = new sdi;
  $result = $sdi_object -> ModifyValue($value_id, $data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id."&scale_id=".$scale_id;
  if (isset($result)) header("Location: " . $link_confirm);
  else system_error();
}

// we get initial values
if(!empty($result_value[0]['sdiv_multivalue'])) {
	$form_values = unserialize($result_value[0]['sdiv_multivalue']);
} else {
	$form_value = $result_value[0]['sdiv_value'];
}
$form_sdi_id = $id;
$form_scale_id = $scale_id;

// setting $form_threshold value
// By default initial value
$default_threshold = $result_sdii[0]['sdii_threshold_value'];
// if set, we get it from the table
if(!is_null($result_value[0]['sdiv_threshold'])) {
	$form_threshold = $result_value[0]['sdiv_threshold'];
} else {
	$form_threshold = $default_threshold;
}

$form_date = $result_value[0]['date_p'];
$form_statut = $result_value[0]['sdiv_statut'];
$form_comment = $result_value[0]['sdiv_comment'];
$form_statutc = $result_value[0]['sdiv_comment_display'];
if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
if($form_statutc=='Y') $mask_statutc_public="checked=\"checked\""; else $mask_statutc_public='';
if($form_statutc=='N') $mask_statutc_private="checked=\"checked\""; else $mask_statutc_private='';

if (isset($_POST['valider1'])) {


  $table[1] = $_POST['id'];
  $table[2] = $_POST['threshold'];
  $table[3] = $_POST['scale'];
  $table[4] = $_POST['date'];
  $table[5] = $_POST['statut'];
  $table[6] = $_POST['comment'];
  $table[7] = $_POST['statutc'];

  // we populate the form and the array
  if(isset($_POST['value'])) {

  	$form_value = $_POST['value'];
  	$table[0] = $form_value;

  } else {

  	$form_values = array();
		$i = 0;
		foreach($_POST['values']  as &$value) {
			$form_values[$i]['value'] = $value;
			$i++;
		}
		$i = 0;
		foreach($_POST['labels']  as &$label) {
			$form_values[$i]['label'] = $label;
			$i++;
		}

		$table[0] = $form_values;
  }

  $sdi_object = new sdi;
  $integrity = $sdi_object -> CheckDataIntegrity_value($table, $sql_object);

  $form_sdi_id = $_POST['id'];
  $form_threshold = $_POST['threshold'];
  $form_scale_id = $_POST['scale'];
  $form_date = $_POST['date'];
  $form_statut = $_POST['statut'];
  $form_statutc = $_POST['statutc'];
  if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  if($form_statutc=='Y') $mask_statutc_public="checked=\"checked\""; else $mask_statutc_public='';
  if($form_statutc=='N') $mask_statutc_private="checked=\"checked\""; else $mask_statutc_private='';
  $table = urlencode(serialize($table));
}


$resultscale = $sql_object -> DBSelect($req_list_scale);
$listing=ScaleSelectBox($resultscale, "scale" ,$form_scale_id);


footerAddJS('../lib/js/jquery.datePicker.l10n/jquery.ui.datepicker-'.U_L.'.js');
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','dashboard'); ?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->


<script type="text/javascript">
	$(function()
	{

		var rowNum = <?php echo isset($form_values) ? (count($form_values) - 1) : 0; ?>;
		$('#addValueButton').click(function(e) {
			e.preventDefault();
			rowNum++;
			var row = '<p id="rowNum'+rowNum+'">' +
								'<label for="indic_label_'+rowNum+'" class="autowidth"><?php echo mb_ucfirst(_t('dashboard','multivalue_label')) ?> : <\/label> <input type="text" name="labels[]" maxlength="255" id="indic_label_'+rowNum+'" value="" class="tinytextfield" \/> ' +
								'<label for="indic_value_'+rowNum+'" class="autowidth"><?php echo mb_ucfirst(_t('dashboard','multivalue_value')) ?> : <\/label> <input type="text" name="values[]" maxlength="255" id="indic_value_'+rowNum+'" value="" class="tinytextfield" \/> ' +
								'<a class="rmValue" href="#" title="<?php echo addslashes(mb_ucfirst(_t('dashboard','sup'))); ?>"><i class="icon-minus-circled"><\/i><span><?php echo addslashes(mb_ucfirst(_t('dashboard','sup'))); ?><\/span><\/a><\/p>';

			$('#indicator-values').append(row);

			// for dynamic fields
			$('a.rmValue').click(function(e) {
				e.preventDefault();
				$(this).parent().remove();
			});

		});

		// for initial fields
		$('a.rmValue').click(function(e) {
			e.preventDefault();
			$(this).parent().remove();
		});


		var dateFormat = "<?php echo DATE_FORMAT; ?>";
		dateFormat = dateFormat.replace("yyyy", "yy");

		$(".date-pick").datepicker({
			showOn: "button",
			buttonImage: "../lib/js/calendar.png",
			buttonImageOnly: true,
			dateFormat: dateFormat,
			dateMin: new Date(2000, 1 - 1, 1)
		});
		$( ".date-pick" ).datepicker( $.datepicker.regional[ "<?php echo U_L; ?>" ] );

		var thresholds = <?php echo json_encode($sdi_object->getScalesThresholds($id, $default_threshold, $sql_object)); ?>;

		// update threshold value when changing scale
		$('#scale').change(function() {
			  var key = $("#scale").val()
			  $("#threshold").val(thresholds[key]);
			});

    });
</script>

<?php
if (!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if (isset($integrity) && is_string($integrity)) display_errors($integrity);
?>

<h2><?php echo formatTitleh2(mb_ucfirst(_t('dashboard','mod'))); ?></h2>
<div id="dashboard-subtitle" class="subtitle"><i class="icon-chart-bar"></i><?php echo $indicator_name; ?></div>

<form id="addvalue" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">

<?php if($result_sdii[0]['sdii_value_type'] == 'unique') { ?>
<p>
	<label for="value"><?php echo mb_ucfirst(_t('dashboard','value')) ?> (<?php echo formatText($result_sdii[0]['sdii_unit'], '2HTML'); ?>) : *</label>
	<input name="value" type="text" id="value" maxlength="255" value="<?php echo $form_value; ?>" class="textfield" />
	<?php 
	if(isset($bool_msg)) echo '<span class="soft-emphase input-notice">'.$bool_msg.'</span>';
	?>
</p>
<?php } else { ?>
<div id="indicator-values" class="radioinline">

	<?php
	$cnt = 0;
	foreach($form_values as $val) {
	?>
		<p>
		<label for="indic_label_<?php echo $cnt; ?>" class="autowidth"><?php echo mb_ucfirst(_t('dashboard','multivalue_label')) ?> : </label>
		<input name="labels[]" type="text" id="indic_label_<?php echo $cnt; ?>" maxlength="255" value="<?php echo formatText($val['label'], 'HTML'); ?>" class="tinytextfield" />
		<label for="indic_value_<?php echo $cnt; ?>" class="autowidth"><?php echo mb_ucfirst(_t('dashboard','multivalue_value')) ?> : </label>
		<input name="values[]" type="text" id="indic_value_<?php echo $cnt; ?>" maxlength="255" value="<?php echo $val['value']; ?>" class="tinytextfield" />
		<?php if($cnt == 0) { ?>
			<a href="#" id="addValueButton" title="<?php echo mb_ucfirst(_t('dashboard','add')); ?>"><i class="icon-plus-circled"></i><span><?php echo mb_ucfirst(_t('dashboard','add')); ?></span></a>
		<?php } else { ?>
			<a class="rmValue" href="#" title="<?php echo addslashes(mb_ucfirst(_t('dashboard','sup'))); ?>"><i class="icon-minus-circled"></i><span><?php echo addslashes(mb_ucfirst(_t('dashboard','sup'))); ?></span></a>
		<?php } ?>
		<?php $cnt++; ?>
		</p>
		<?php } ?>

</div>
<hr />
<?php } ?>

<p>
	<label for="scale"><?php echo mb_ucfirst(_t('dashboard','scale')) ?> : *</label>
    <?php echo $listing; ?>
</p>
<p>
	<label for="threshold"><?php echo mb_ucfirst(_t('sdi','threshold_value')) ?> :</label>
	<input name="threshold" type="text" id="threshold" maxlength="100" value="<?php echo $form_threshold; ?>" class="textfield" />
</p>
<div class="label"><?php echo mb_ucfirst(_t('divers','statut')); ?> : *</div>
<div class="rightpanel">
	<input name="statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> />
	<label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
	<input name="statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
	<label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
</div>

<p>
	<label for="date"><?php echo mb_ucfirst(_t('dashboard','date')); ?> * : </label>
	<input name="date" type="text" maxlength="10" id="date" class="date-pick shorttextfield" value="<?php echo $form_date; ?>" />
</p>
<p>
	<label for="comment"><?php echo mb_ucfirst(_t('dashboard','comment')) ?> : </label>
	<textarea id="comment" name="comment" <?php echo AREA_SETTINGS; ?>	class="largetextfield"><?php echo $form_comment; ?></textarea>
</p>

<div class="label"><?php echo mb_ucfirst(_t('dashboard','comment_status')); ?> * : </div>
<div class="rightpanel">
	<input name="statutc" type="radio" id="statutc_P" value="Y" <?php echo $mask_statutc_public; ?> />
	<label for="statutc_P"><?php echo mb_ucfirst(_t('dashboard','public')); ?></label>
	<input name="statutc" type="radio" id="statutc_D" value="N" <?php echo $mask_statutc_private; ?> />
	<label for="statutc_D"><?php echo mb_ucfirst(_t('dashboard','private')); ?></label>
</div>


<div class="toggle_title">
	<a href="#" id="affeval"><?php echo _t('sdi','info_mesure'); ?></a>
</div>
<div id="units" style="display: none;" class="mtm">
<table cellspacing="0" cellpadding="3">
	<thead>
		<tr>
		<?php
		echo "<td>" . mb_ucfirst(_t('sdi','unit')) . "</td>\n";
		echo "<td>" . mb_ucfirst(_t('sdi','min_value')) . "</td>\n";
		echo "<td>" . mb_ucfirst(_t('sdi','max_value')) . "</td>\n";
		echo "<td>" . mb_ucfirst(_t('sdi','initial_threshold_value')) . "</td>\n";

		?>
		</tr>
	</thead>
	<tbody>
	<?php 
	
	isset($maskminvalue) ? $display_min = $maskminvalue : $display_min = empty_nc($result_sdii[0]['sdii_min_value']);
	isset($maskmaxvalue) ? $display_max = $maskmaxvalue : $display_max = empty_nc($result_sdii[0]['sdii_max_value']);
	
	echo "<tr>\n";
	echo "<td>" . $result_sdii[0]['sdii_unit'] . "</td>\n";
	echo "<td>" . $display_min. "</td>\n";
	echo "<td>" . $display_max . "</td>\n";
	echo "<td>" . empty_nc($result_sdii[0]['sdii_threshold_value']) . "</td>\n";
	echo "</tr>\n";

	?>
	</tbody>
</table>
</div>
<div>
	<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
	<input name="scale_id" type="hidden" value="<?php echo $scale_id; ?>" id="scale_id" />
	<input name="value_id" type="hidden" value="<?php echo $value_id; ?>" id="value_id" />
	<?php echo cancel_button($link_cancel); ?>
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<input name="valider1" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
    <?php
    // Récapitulatif
} else {
  if (!isset($integrity5) || is_string($integrity5)) {
  	$table = unserialize(urldecode($table));
  	$req_scale = SQL_getonescale($table[3]);
  	$resultscale2 = $sql_object -> DBSelect($req_scale);

  	$display_comment = formatText(empty_none($_POST['comment']), '2HTML');

  	($form_statutc == 'Y') ? $display_comment_status = _t('dashboard', 'public') : $display_comment_status = _t('dashboard', 'private');

  	$display_sdi_value = '';
  	$total = 0;

  	if(is_array($table[0])) {

  		foreach($table[0] as &$value) {
  			$total += $value['value'];

  			$display_sdi_value .= '<p>';
  			$display_sdi_value .= mb_ucfirst(formatText($value['label'], 'HTML')).' : ';
  			$display_sdi_value .= fnumber_format($value['value'], 'auto', false);
  			$display_sdi_value .= ' ('.$result_sdii[0]['sdii_unit'].')';
  			$display_sdi_value .= '</p>'.PHP_EOL;

  		}
  		// we display the total
  		$display_sdi_value .= '<p class="value-total">';
  		$display_sdi_value .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : ' . fnumber_format($total, 'auto', false);
  		$display_sdi_value .= '</p>';

  	} else {
  		$display_sdi_value .= $table[0]." ".$result_sdii[0]['sdii_unit']  ;
  	}
  	$display_threshold_value = empty_nc($table[2]);
  	// afficher nom de scale
  	$display_sdi_scale = formatText($resultscale2[0]['scale_denomination'], '2HTML');
  	$display_sdi_date = $table[4];
  	$display_sdi_statut = $table[5];
  	$table = urlencode(serialize($table));

?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo _t('recap','title') ;?></h2>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('dashboard','value'));	?> :</dt>
	<dd><?php echo $display_sdi_value; ?>
	</dd>
	<dt><?php echo mb_ucfirst(_t('sdi','name2')); ?> :</dt>
	<dd><?php echo formatText($result_sdii[0]['sdii_name'], '2HTML'); ?> </dd>
	<dt><?php echo mb_ucfirst(_t('divers','statut')); ?> :</dt>
	<dd><?php echo display_statut($display_sdi_statut); ?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','date'));	?> :</dt>
	<dd><?php echo $display_sdi_date; ?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','scale'));	?> :</dt>
	<dd><?php echo $display_sdi_scale;	?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','threshold_value'));	?> :</dt>
	<dd><?php echo $display_threshold_value;	?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','comment')); ?> :</dt>
	<dd><?php echo $display_comment ;?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','comment_status')); ?> :</dt>
	<dd><?php echo $display_comment_status ;?></dd>
</dl>
<form id="addvalue2" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="scale_id" type="hidden" value="<?php echo $scale_id; ?>" id="scale_id" />
    <input name="value_id" type="hidden" value="<?php echo $value_id; ?>" id="value_id" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <?php echo cancel_button($link_cancel); ?>
    <input	name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
  }
}
?>