<?php
/**
 * Dashboard module
 * 
 * Generate pie charts displayed in both admin and public UIs
 * for multi-values indicators
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


/**
 * Warning : If a trailing whitespace is present in any embedded file (for example, a plugin file), this graph won't display
 */

ob_start();
session_start();
include_once("../config/define.php");
//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
	include_once("../lib/lib_common.php");
	ReloadIndex('admin');
}
////////////

$id = $_GET['id']; // indicator id
$value = $_GET['value']; // value id


include_once("../class/class.sdi.php");
include_once("../languages/". U_L . "/lang_dashboard." . CHARSET . ".php");
include_once(SQL.".inc.php");


isset($_GET['display']) ? $display = true : $display = false;

generateGraphic($id, $value, $display, '');


/**
 *
 * @param integer $id
 * @param integer $scale_id
 * @param string $type
 * @param string $workingpath
 */
function generateGraphic($id, $value, $display = false, $workingpath = '') {

	global $sql_object;

	$m = 0; // margin
	
	// we get values
	$req_sdiav=SQL_getOneValue($value);
	$value = $sql_object->DBSelect($req_sdiav);
	
	$req_sdii=SQL_getInfoSdi($id);
	$result_sdii = $sql_object->DBSelect($req_sdii);

	// format date
	list($day, $month, $year)=explode('-',$value[0]['date_p']);
	$date = $day . '-' .$month. '-'. substr($year, 2, 2);
	
	$unit=$result_sdii[0]['sdii_unit'];
	$full_title=formatText($result_sdii[0]['sdii_name']);
	$title=cutText($full_title, 50, 0);

	// we retrieved pie data
	$data = unserialize($value[0]['sdiv_multivalue']);
	$a_labels = array();
	$a_values = array();

	$negativeValue_flag = false;

	foreach($data as &$val) {

		if($val['value'] < 0) $negativeValue_flag = true;

		// we exclude negative numbers
		if($val['value'] >= 0) {
			array_push($a_labels,$val['label']. ' ('. fnumber_format($val['value'], 0, false).')');
			array_push($a_values,$val['value']);
		}
	}

	/* pChart library inclusions */
	include_once("../class/system/pChart/class/pData.class.php");
	include_once("../class/system/pChart/class/pDraw.class.php");
	include_once("../class/system/pChart/class/pPie.class.php");
	include_once("../class/system/pChart/class/pImage.class.php");

	/* Create and populate the pData object */
	$MyData = new pData();

	// ability for user to specify a palette for each individual indicator
	$palette = override('../dashboard/palettes/'.$id. '.color');
	if(file_exists($palette)) {
		$MyData->loadPalette($palette, TRUE);
	} else {
		$MyData->loadPalette(override('../dashboard/palettes/default.color'), TRUE);
	}
	
	$MyData->addPoints($a_values,"Values");
// 	$MyData->setSerieDescription("Values","Application A");
	
	/* Define the absissa serie */
	$MyData->addPoints($a_labels,"Labels");
	$MyData->setAbscissa("Labels");
	
	/* Create the pChart object */
	$myPicture = new pImage(580,500,$MyData);
	
/* Draw a solid background */
//$Settings = array("R"=>170, "G"=>183, "B"=>87, "Dash"=>1, "DashR"=>190, "DashG"=>203, "DashB"=>107);
$Settings = array("R"=>255, "G"=>255, "B"=>255);
$myPicture->drawFilledRectangle(0,0,580,500,$Settings);
	
	/* Overlay with a gradient */
	$Settings = array("StartR"=>219, "StartG"=>231, "StartB"=>139, "EndR"=>1, "EndG"=>138, "EndB"=>68, "Alpha"=>50);
// 	$myPicture->drawGradientArea(0,0,300,260,DIRECTION_VERTICAL,$Settings);
// 	$myPicture->drawGradientArea(0,0,300,20,DIRECTION_VERTICAL,array("StartR"=>0,"StartG"=>0,"StartB"=>0,"EndR"=>50,"EndG"=>50,"EndB"=>50,"Alpha"=>100));

	/* Add a border to the picture */
// 	$myPicture->drawRectangle(0,0,299,259,array("R"=>0,"G"=>0,"B"=>0));
	
	/* Write the picture title */
$myPicture->setFontProperties(array("FontName"=>"../class/system/pChart/fonts/verdana.ttf","FontSize"=>12,"R"=>80,"G"=>80,"B"=>80));
$myPicture->drawText(15,20,$title. ' - '. $unit. ' ('. $date .')',array("R"=>0,"G"=>0,"B"=>0));

if($negativeValue_flag == true) {
	$myPicture->setFontProperties(array("FontName"=>"../class/system/pChart/fonts/verdana.ttf","FontSize"=>8,"R"=>80,"G"=>80,"B"=>80));
	$myPicture->drawText(15,35,_t('dashboard', 'negative_values_notice'),array("R"=>80,"G"=>80,"B"=>80));
	$m += 10;
}
	
	/* Set the default font properties */
	$myPicture->setFontProperties(array("FontName"=>"../class/system/pChart/fonts/verdana.ttf","FontSize"=>7,"R"=>80,"G"=>80,"B"=>80));
	
	/* Enable shadow computing */
// 	$myPicture->setShadow(TRUE,array("X"=>2,"Y"=>2,"R"=>0,"G"=>0,"B"=>0,"Alpha"=>50));
	
	/* Create the pPie object */
	$PieChart = new pPie($myPicture,$MyData);
	
	/* Draw an AA pie chart */
	// BUG setting radius with draw2DRing()
// 	$PieChart->draw2DRing(250,250,array("Radius"=> 80, "WriteValues"=>TRUE,"ValueR"=>50,"ValueG"=>50,"ValueB"=>50,"Border"=>TRUE, "LabelStacked"=>TRUE, "ValuePadding"=>10));

// 	$PieChart->draw3DPie(250,250,array("Radius"=>150,"DrawLabels"=>TRUE,"LabelStacked"=>TRUE,"WriteValues"=>TRUE,"ValuePosition"=>PIE_VALUE_INSIDE,"ValueR"=>0,"ValueG"=>0,"ValueB"=>0));
	$PieChart->draw3DPie(290,360,array("Radius"=>200,"WriteValues"=>PIE_VALUE_PERCENTAGE,"Border"=>TRUE,"ValuePadding"=>30,"ValuePosition"=>PIE_VALUE_OUTSIDE,"ValueR"=>80,"ValueG"=>80,"ValueB"=>80));
	
	/* Write the legend box */
	$myPicture->setShadow(FALSE);
	$PieChart->drawPieLegend(20,60 + $m,array("Alpha"=>20));
	
	/* Render the picture (choose the best way) */
	if($display == true) {
			/* Render the picture - display it */
			$myPicture->autoOutput("simple.png");
		} else {
			/* Save the picture */
			if(!file_exists($workingpath)) mkdir($workingpath);
			$myPicture->render($workingpath.'/'.$id.'_'.$scale_id.'.png');
		}

	return true;
	
}


?>