<?php
/**
 * Export module - pdf
 * 
 * Write pdf report last page
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

///////////////////////////////////
// Récupération de données
///////////////////////////////////

// liste des échelles sélectionées
$scale_content='';
for($i=0; $i<count($scale_array); $i++) {
  $scale_content.=$scale_denomination_array[$scale_array[$i]].'<br />'.PHP_EOL;
}

// liste des indicateurs sélectionés
$sdi_content='';
for($i=0; $i<count($sdi); $i++) {
  $sdi_content.=$sdi[$i]['sdii_name'].'<br />'.PHP_EOL;
}
//////////////////////////////////


$pdf->AddPage();
$pdf->SetY($pdf->GetY()+20);
$pdf->SetX($pdf->GetX()+152);
$pdf->Bookmark($lang['dashboard']['rap_infopubli']);
// logo
$image_file = override('../export/inc_report/logo_p.png', THEME_PUBLIC_PATH);
$pdf->Image($image_file,$pdf->GetX(), $pdf->GetY(), 0, 0, 'PNG', SITE_LINEA_URL);


//////////////////////////////////
// 	tableau récapitulatif
//////////////////////////////////
$margin = 20;
$pdf->SetY($pdf->GetY()+20);
$pdf->SetFont(DOC_POLICE, ARRAY_DATA_STYLE, ARRAY_DATA_SIZE);

$tbl = '
<table cellspacing="0" cellpadding="5">
	<thead>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['dashboard']['rap_title']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['title']).'</td>
    </tr>
    </thead>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['divers']['date_crea']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.date("d-m-Y H:i:s").'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['dashboard']['rap_author']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['author']).'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['dashboard']['rap_mail_author']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['mail_author']).'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['dashboard']['rap_service']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['service_author']).'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['dashboard']['rap_adress']) .' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['adress_author']).'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['dashboard']['rap_indicators']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.$sdi_content.'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['dashboard']['rap_scale']) .' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.$scale_content.'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['dashboard']['rap_generated'].'('.$lang['divers']['seconds'].')').' : </td>
        <td>'.round($total_time, 2).'</td>
    </tr>
</table>';

$pdf->writeHTML($tbl, true, false, false, false, '');

$pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
?>