<?php
/**
 * Export module - word
 * 
 * Header and footer definition
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */



// Add HEADER
$today = date("d/m/Y");
$content = formatText($report_settings['title']);

$pStyle = array('align' => 'right', 'spaceBefore' => 0, 'spaceAfter' => 0);
$styleTableHeader = array('borderBottomSize' => 5, 'borderBottomColor' => '333333',  'cellMargin' => 25);

$cell1_width = 2050;

$subsequent = $section->addHeader();
$table = $subsequent->addTable($styleTableHeader);
$row = $table->addRow();
$row->addCell($cell1_width)->addImage(override('../export/inc_report/logo_p.png'), array('width' => 70));
$cell = $row->addCell(PAGE_WIDTH - $cell1_width);
$cell->addText(SITE_NAME . ' - ' . $today, array('name' => DOC_HEADER_FONT, 'size' => FONT_SIZE_MIN, 'bold'=>true), $pStyle);
$cell->addText($content, array('name' => DOC_HEADER_FONT, 'size' => FONT_SIZE_MIN), $pStyle);
$subsequent->addTextBreak(1);
// $linestyle = array('weight' => 1, 'width' => 100, 'height' => 100, 'color' => 635552);
// $subsequent->addLine($lineStyle);


// Add FOOTER

// content preparation
$content = $report_settings['author'];
if(!empty($report_settings['mail_author']))  {
	$content .= ' ('.$report_settings['mail_author'].')';
	$mailto='mailto:'.$report_settings['mail_author'];
} else $mailto='';
$content_comp = !empty($report_settings['service_author']) ? ' / '.$report_settings['service_author'] : '';
$content_comp.= !empty($report_settings['adress_author']) ? ' / '.$report_settings['adress_author'] : '';

// footer creation
$footer = $section->addFooter();
$table = $footer->addTable();
$row = $table->addRow();
$cell = $row->addCell(PAGE_WIDTH - $cell1_width);

$textrun = $cell->addTextRun();
if(!empty($mailto)) $textrun->addLink($mailto, $content, array('name' => DOC_HEADER_FONT, 'size' => FONT_SIZE_MIN));
else $textrun->addText($content, array('name' => DOC_HEADER_FONT, 'size' => FONT_SIZE_MIN));
$textrun->addText($content_comp, array('name' => DOC_HEADER_FONT, 'size' => FONT_SIZE_MIN));
$cell = $row->addCell($cell1_width)->addPreserveText('{PAGE}/{NUMPAGES}', array('name' => DOC_HEADER_FONT, 'size' => FONT_SIZE_MIN), array('align' => 'right'));

?>