<?php
/**
 * Export module - word
 * 
 * Main Word report generation page
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

// https://github.com/PHPOffice/PHPWord

include_once(override('../export/word/word.report.inc.php', THEME_ADMIN_PATH));

// http://endmemo.com/convert/topography.php
define('PAGE_WIDTH', 9070);
define('FONT_SIZE_MIN', 9);
// define('WORD_DEFAULT_FONT', 'Times New Roman');
define('DOC_DEFAULT_FONT', 'Tahoma');
define('DOC_HEADER_FONT', 'Arial');
define('DOC_DEFAULT_SIZE', 10);
define('ARRAY_HEADER_BG', 'D8D7D7');


# bench start tag
$start_time=getmicrotime();


require_once '../lib/vendor/PHPWord/src/PhpWord/Autoloader.php';
\PhpOffice\PhpWord\Autoloader::register();


$phpWord = new \PhpOffice\PhpWord\PhpWord();
$phpWord->setDefaultFontName(DOC_DEFAULT_FONT);
$phpWord->setDefaultFontSize(DOC_DEFAULT_SIZE);

$phpWord->addFontStyle('noValueFor', array('bold' => true, 'color'=>'1B2232'));
$phpWord->addFontStyle('arrayValue', array('size' => FONT_SIZE_MIN));
$phpWord->addFontStyle('arrayheader', array('size' => FONT_SIZE_MIN, 'bold' => true, 'color'=>'666666'));
$phpWord->addFontStyle('percentageValue', array('size' => FONT_SIZE_MIN, 'color'=>'666666'));
$phpWord->addFontStyle('attachedTheme', array('size' => DOC_DEFAULT_SIZE - 1, 'color'=>'355C6B', 'bold' => true));
$phpWord->addFontStyle('softLabel', array('color'=>'848484'));
$phpWord->addFontStyle('softLabelMin', array('size' => FONT_SIZE_MIN, 'color'=>'848484'));
$phpWord->addFontStyle('strongLabel', array('color'=>'848484', 'bold' => true));

$pageBreak = array('pageBreakBefore' => true);

$cellalign = array('borderRightSize' => 1, 'borderRightColor' => ARRAY_HEADER_BG, 'valign' => 'center');
$styleTable = array('borderSize' => 1, 'borderColor' => ARRAY_HEADER_BG,  'cellMargin' => 25);
$firstRowStyle = array('bgColor' => ARRAY_HEADER_BG);

// For number on title
$phpWord->addNumberingStyle(
		'hNum',
		array('type' => 'multilevel', 'levels' => array(
				array('pStyle' => 'Heading1', 'format' => 'decimal', 'text' => '%1 '),
				array('pStyle' => 'Heading2', 'format' => 'decimal', 'text' => '%1.%2')
		)
		)
);
$phpWord->addTitleStyle(1, array('size' => 14), array('numStyle' => 'hNum', 'numLevel' => 0));
$phpWord->addTitleStyle(2, array('size' => 12), array('numStyle' => 'hNum', 'numLevel' => 1));




// Every element you want to append to the word document is placed in a section.
// To create a basic section:
$section = $phpWord->addSection();

require_once(override('../export/word/header_footer.php', THEME_ADMIN_PATH));


include_once(override('../export/word/word.firstpage.php', THEME_ADMIN_PATH));

// because $section->addPageBreak() does not work in current version
$section->addTextBreak(null, null, $pageBreak);

$section->addTextBreak(5);
$section->addText(formatText($lang['dashboard']['rap_summary']), array('bold' => 'true') ,array('align' => 'center')); 
$section->addTextBreak(1);

$section->addTOC(array('spaceAfter' => 60, 'size' => FONT_SIZE_MIN - 1));

// because $section->addPageBreak() does not work in current version
$section->addTextBreak(null, null, $pageBreak);

for($i=0; $i<count($sdi); $i++) {
	DisplayOneSdi($i);
}


# bench stop tag
$stop_time=getmicrotime();

$total_time=(float) $stop_time-$start_time;

#inclusion page d'infos de génération
if($report_settings['publi_infos']===true) include_once(override('../export/word/word.lastpage.php', THEME_ADMIN_PATH));



if($export_format == 'word') {
	$writer = 'Word2007';
	$extension = '.docx';
}

if($export_format == 'html') {
	$writer = 'HTML';
	$extension = '.html';
}

// Not implemented yet
// if($export_format == 'odt') {
// 	$writer = 'ODText';
// 	$extension = '.odt';
// }

// Not implemented yet
// $export_format = 'pdf_word';
// if($export_format == 'pdf_word') {
// 	\PhpOffice\PhpWord\Settings::setPdfRendererPath('../class/system/tcpdf/');
// 	\PhpOffice\PhpWord\Settings::setPdfRendererName('TCPDF');
// 	$writer = 'PDF';
// 	$extension = '.pdf';
// }

$file = 'rapport'.date("dmY_His").$extension;
header("Content-Description: File Transfer");
header('Content-Disposition: attachment; filename="' . $file . '"');
//header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
header("Content-Type: application/octet-stream");
header('Content-Transfer-Encoding: binary');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Expires: 0');
$xmlWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, $writer);
$xmlWriter->save("php://output");

exit();
?>