<?php
/**
 * @package linea21.externals
 * @subpackage Class Installer
 * @author Simon Georget
 * @license GNU Lesser General Public License
 */
session_start();
$installation_process = true; // necessary for test in /config/define.php
include_once("../config/define.php");
include_once('../lib/input_helpers.php');

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 1.6
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
if(file_exists('../config/define_release.ini')) {
	
	if(!is_writable ('../config/')) die("'config/' folder is not writable. Please change permissions and refresh the page.");
	
	// config.ini file does not exists, we take values from config.ini.default - $installation_process set to true
	
	// update main ini file
    $ini_r = array();
	
	// we parse the old DB ini file
	$ini_db = parse_ini_file("../config/define_db.ini");
	
	// we set database values into the new config.ini file
	$ini_r['DB_HOST'] = $ini_db['DB_HOST'];
	$ini_r['DB_USER'] = $ini_db['DB_USER'];
	$ini_r['DB_PASS'] = $ini_db['DB_PASS'];
	$ini_r['DB_NAME'] = $ini_db['DB_NAME'];
	$ini_r['DB_ADMINMAIL'] = $ini_db['DB_ADMINMAIL'];
	
    
	// we parse the old ini file
	$ini_release = parse_ini_file("../config/define_release.ini");
	
	// we parse the new ini file to check if keys exists
	$ini_config = parse_ini_file("../config/config.ini.default");

	foreach ($ini_release as $key => $value) {
		
		// if the key exists in the default ini file, we overwrite the default value by the previous
		if(isset($ini_config[$key])) $ini_r[$key] = $value;
	}
	
	$l21config->setParams($ini_r);
	
	// var_dump($ini_r);



	// we write the new file
    if($l21config->writeReleaseParams()) {
		echo "Writing new configuration file : /config/config.ini</br>";
	} else {
		echo "Problem writing new configuration file : /config/config.ini</br>";
	}

	// we backup old config files before removing them
	$dest = '../tmp/backup/config/';
	
	if(!file_exists($dest)) mkdir($dest, 0755, true);

	if (!copy("../config/define_release.ini", $dest . "define_release.ini")) {
		echo "Failed to backup define_release.ini file.</br>";
	} else {
		echo "Backup define_release.ini file : ok.</br>";
		
		if(unlink("../config/define_release.ini")) {
			echo "Removing define_release.ini file form /config/ folder.</br>";
		}
	}
    
    	if (!copy("../config/define_db.ini", $dest . "define_db.ini")) {
		echo "Failed to backup define_db.ini file.</br>";
	} else {
		echo "Backup define_db.ini file : ok.</br>";
		
		if(unlink("../config/define_db.ini")) {
			echo "Removing define_db.ini file form /config/ folder.</br>";
		}
	}
	
	@unlink('../newsletter/x7iYhD98w_sendmail.php');

}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 1.7
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// /report_sdi/ folder replaced by /export/ folder
@copy('../report_sdi/inc_report/logo_g.png', '../export/inc_report/logo_g.png');
@copy('../report_sdi/inc_report/logo_p.png', '../export/inc_report/logo_p.png');
@SureRemoveDir('../report_sdi/', true);
@SureRemoveDir('../scripts_sql/', true);
@SureRemoveDir('../level/', true);




// we update the main config.ini file
if(!is_writable ('../config/config.ini')) die("'config/config.ini' file is not writable. Please change permissions and refresh the page.");

// we parse the current config.ini file (before update)
$config_ini = parse_ini_file("../config/config.ini");

// we parse the new ini file to check if keys exists
$default_ini = parse_ini_file("../config/config.ini.default");

foreach ($default_ini as $key => $value) {
	// if key does not exists in current $config_ini, we add it from $default_ini
	if(!isset($config_ini[$key])) $config_ini[$key] = $value;
}

// we switch to new admin template 
$config_ini['THEME_ADMIN'] = '2015';

$l21config->setParams($config_ini);

// we write the new file
if($l21config->writeReleaseParams()) {
	echo "Writing new configuration file : /config/config.ini</br>";
} else {
	echo "Problem writing new configuration file : /config/config.ini</br>";
}



// Final message
echo '<p>Update is done!</p>';

echo '<p>Please go to the <a href="../admin/">admin page to log-in</a>.</p>';

