<?php
/**
 * Common helpers
 * 
 * Provides common helpers
 * 
 * @package linea21\utils\lib
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * ThemeSelectBox()
 * Génére une select-box pour les thèmes
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current_theme
 * @param string $URL
 * @return string $select_theme
 */
function ThemeSelectBox($data, $field_name, $current_theme = 0, $URL = -1)
{
  $current_sdtheme = '';
  $theme_list = '';
  $close = '';
  for ($i = 0;$i < count($data);$i++) {
    if ($data[$i]['sdtheme_id'] != $current_sdtheme) {
      $current_sdtheme = $data[$i]['sdtheme_id'];
      $current_sdtheme_display = formatText(cutText($data[$i]['sdtheme_name'], 100));
      $theme_list .= $close . "<optgroup label=\"" . $current_sdtheme_display . "\">\n";
      $close = "</optgroup>\n";
    }
    if ($data[$i]['theme_id'] == $current_theme) {
      $mask = " selected=\"selected\"";
    } else $mask = "";
    $current_theme_display = formatText(cutText($data[$i]['theme_name'], 100));
    if ($URL <> -1)$theme_list .= "<option value=\"" . $URL . $data[$i]['theme_id'] . "\"" . $mask . ">" . $current_theme_display . "</option>\n";
    else $theme_list .= "<option value=\"" . $data[$i]['theme_id'] . "\"" . $mask . ">" . $current_theme_display . "</option>\n";
  }
  $theme_list .= "</optgroup>\n";

  $select_theme = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
  $select_theme .= "<option value=\"0\">" . _t('divers','select_choice') . "</option>\n";

  $select_theme .= $theme_list;
  $select_theme .= "</select>\n";

  if ($URL <> -1) {
	  $js = "	$('#". $field_name ."').change(function() {
					  	window.location = $(this).val();
					  });";
	  
	  footerAddInlineJS($js);
  }

  return $select_theme;
}

/**
 * SDThemeSelectBox()
 * Génére une select-box pour les thèmes Développement Durable
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current_sdtheme
 * @return string $select_sdtheme
 */
function SDThemeSelectBox($data, $field_name, $current_sdtheme = 0)
{
  $sdtheme_list = '';
  for($i = 0; $i < count($data); $i++) {
    if ($data[$i]['sdtheme_id'] == $current_sdtheme) $mask = " selected=\"selected\"";
    else $mask = "";
    $sdtheme_display = formatText(cutText($data[$i]['sdtheme_name'], 100), '2HTML');
    $sdtheme_list .= "<option value=\"" . $data[$i]['sdtheme_id'] . "\"" . $mask . ">" . $sdtheme_display . "</option>\n";
  }
  $select_sdtheme = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">";
  $select_sdtheme .= "<option value=\"0\">" . _t('divers','select_choice2') . "</option>";
  $select_sdtheme .= $sdtheme_list;
  $select_sdtheme .= "</select>";

  return $select_sdtheme;
}

/**
 * ScaleSelectBox()
 * Génére une select-box pour les échelles
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current_scale
 * @param string $URL
 * @return string $select_scale
 */
function ScaleSelectBox($data, $field_name, $current_scale = 0, $URL = -1)
{
  $scale_list = '';
  for ($i = 0;$i < count($data);$i++) {
    if ($data[$i]['scale_id'] == $current_scale) {
      $mask = " selected=\"selected\"";
    } else $mask = "";
    $scale_display = formatText(cutText($data[$i]['scale_denomination'], 46));
    if ($URL <> -1)$scale_list .= "<option value=\"" . $URL . $data[$i]['scale_id'] . "\"" . $mask . ">" . $scale_display . "</option>\n";
    else $scale_list .= "<option value=\"" . $data[$i]['scale_id'] . "\"" . $mask . ">" . $scale_display . "</option>\n";
  }

  $select_scale = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
  $select_scale .= "<option value=\"0\">" . _t('divers','select_choice') . "</option>\n";

  $select_scale .= $scale_list;
  $select_scale .= "</select>\n";

  if ($URL <> -1) {
  	$js = "	$('#". $field_name ."').change(function() {
					  	if($(this).val() != 0) window.location = $(this).val();
					  });";
  	 
  	footerAddInlineJS($js);
  }

  return $select_scale;
}

/**
 * PrioritySelectBox()
 * Génére une select-box pour les priorités
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current_priority
 * @param string $URL
 * @return string $select_priority
 */
function PrioritySelectBox($data, $field_name, $current_priority = 0)
{
  $priority_list = '';
  for ($i = 0;$i < count($data);$i++) {
    if ($data[$i]['priority_id'] == $current_priority) {
      $mask = " selected=\"selected\"";
    } else $mask = "";
    $priority_display = formatText(cutText($data[$i]['priority_name'], 46));
    $priority_list .= "<option value=\"" . $data[$i]['priority_id'] . "\"" . $mask . ">" . $priority_display . "</option>\n";
  }

  $select_priority  = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
  $select_priority .= "<option value=\"0\">" . _t('divers','select_choice') . "</option>\n";

  $select_priority .= $priority_list;
  $select_priority .= "</select>\n";

  return $select_priority;
}

/**
 * selectBox()
 * Génére une select-box générique
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $select
 */
function selectBox($data, $field_name, $current = 0, $default = null)
{

	if($current === 0 && !is_null($default) ) $current = $default;
	$list = '';

	foreach ($data as $key => $value) {
		if ($key == $current) {
			$mask = " selected=\"selected\"";
		} else $mask = "";

		$list .= "<option value=\"" . $key . "\"" . $mask . ">" . mb_ucfirst($value) . "</option>\n";

	}

	$select = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
	$select .= $list;
	$select .= "</select>\n";

	return $select;
}

/**
 * ProjectSelectBox()
 * Génére une select-box pour les projets
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current_project
 * @param string $URL
 * @return string $select_project
 */
function ProjectSelectBox($data, $field_name, $current_project = 0, $URL = -1, $exclude= array())
{

  $project_list = '';
  for ($i = 0;$i < count($data);$i++) {
    if(!in_array($data[$i]['project_id'], $exclude)) {
      if ($data[$i]['project_id'] == $current_project) {
        $mask = " selected=\"selected\"";
      } else $mask = "";
      $project_display = formatText(cutText($data[$i]['project_name'], 100));
      if ($URL <> -1) $project_list .= "<option value=\"" . $URL . $data[$i]['project_id'] . "\"" . $mask . ">" . $project_display . "</option>\n";
      else $project_list .= "<option value=\"" . $data[$i]['project_id'] . "\"" . $mask . ">" . $project_display . "</option>\n";
    }
  }

  $select_project = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
  $select_project .= "<option value=\"0\">" . _t('divers','none') . "</option>\n";

  $select_project .= $project_list;
  $select_project .= "</select>\n";

  if ($URL <> -1) {
  	$js = "	$('#". $field_name ."').change(function() {
					  	window.location = $(this).val();
					  });";
  
  	footerAddInlineJS($js);
  }

  return $select_project;
}

/**
 * WorkshopSelectBox()
 * Generate a workshop select-box
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $select
 */
function WorkshopSelectBox($data, $field_name, $current = 0)
{
  $list = '';
  for ($i = 0;$i < count($data);$i++) {
    if ($data[$i]['workshop_id'] == $current) {
      $mask = " selected=\"selected\"";
    } else $mask = "";
    $display = formatText(cutText($data[$i]['workshop_denomination'], 100));
    if($data[$i]['workshop_id'] <> "") $list .= "<option value=\"" . $data[$i]['workshop_id'] . "\"" . $mask . ">" . $display . "</option>\n";
  }
  $select = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
  $select .= "<option value=\"0\">" . _t('divers','select_choice') . "</option>\n";
  $select .= $list;
  $select .= "</select>\n";

  return $select;
}

/**
 * SDIMultiSelectBox()
 * Generate a SDI multiple select-box
 * (using jquery)
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $select
 */
function SDIMultiSelectBox($data, $field_name, $current, $disabled = false)
{
	if($disabled) { $disabled = 'disabled'; } else { $disabled = ''; }
  $list = '';
  for ($i = 0;$i < count($data);$i++) {
    if (in_array ($data[$i]['sdii_id'], $current)) {
      $mask = " selected=\"selected\"";
    } else $mask = "";
    $display = formatText(cutText($data[$i]['sdii_name'], 200));
    $list .= "<option value=\"" . $data[$i]['sdii_id'] . "\"" . $mask . ">" . $display . "</option>\n";
  }
  $select  = "<select name=\"" . $field_name . "[]\" id=\"" . $field_name . "\" multiple=\"multiple\" ".$disabled.">\n";
  //$select .= "<option value=\"0\">" . _t('divers','select_choice') . "</option>\n";
  $select .= $list;
  $select .= "</select>\n";


  return $select;
}

/**
 * workgroupsCheckbox()
 * Return Workgroups checkboxes
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $content
 */
function workgroupsCheckbox($data, $field_name, $current = array())
{
  $content = '';
  if($data == 0) return '<div>'. _t('divers', 'none') .'</div>' . PHP_EOL;

  for ($i = 0; $i < count($data);$i++) {
    if (in_array($data[$i]['id'],$current)) {
      $mask = ' checked="checked"';
    } else $mask = "";

    $wg_name = formatText($data[$i]['name']);
    $wg_id = $data[$i]['id'];
    $content .= '<input type="checkbox" name="'.$field_name.'" id="wg_'.$wg_id.'"  value="' .$wg_id . '"' . $mask . ' />' . PHP_EOL;
    $content .= '<label for="wg_'.$wg_id.'">'. $wg_name.'</label><br />' . PHP_EOL;
  }

  return $content;
}

/**
 * CultureSelectBox()
 * Generate a select-box with available languages
 * @param string $field_name
 * @param mixed $current
 * @return string $select
 */
function CultureSelectBox($field_name, $current = -1)
{
  $list = '';
  $array = culture::getInstance()->availableCultures();

  foreach($array as $culture => $value) {
    if ($culture == $current) {
      $mask = ' selected="selected"';
    } else $mask = "";
    $str= ucfirst($value['Language']);
    if(isset($value['Country'])) $str.= ' ('.ucfirst($value['Country']).')';
    $list .= '<option value="' . $culture . '"' . $mask . '>' . $str . '</option>'.PHP_EOL;
  }

  $select  = '<select name="' . $field_name . '" id="' . $field_name . '">'.PHP_EOL;
  $select .= $list;
  $select .= '</select>'.PHP_EOL;


  return $select;
}

/**
 * input_date()
 * Return input fields
 * with good direction
 * depending on DATE_FORMAT
 * as filter criteria
 * @param string $y
 * @param string $m
 * @param string $d
 * @return string $content
 */
function input_date($y, $m, $d) {

  $content = '';

  if(DATE_FORMAT == 'dd-mm-yyyy')
  {
    $content.='<input name="date_d" type="text" class="" size="2" id="date_d" maxlength="2" value="'.$d.'" />'.PHP_EOL;
    $content.='<input name="date_m" type="text" class="" size="2" id="date_m" maxlength="2" value="'.$m.'" />'.PHP_EOL;
    $content.='<input name="date_y" type="text" class="" size="4" id="date_y" maxlength="4" value="'.$y.'" />'.PHP_EOL;
  }
  elseif(DATE_FORMAT == 'yyyy-mm-dd')
  {
    $content.='<input name="date_y" type="text" class="" size="4" id="date_y" maxlength="4" value="'.$y.'" />'.PHP_EOL;
    $content.='<input name="date_m" type="text" class="" size="2" id="date_m" maxlength="2" value="'.$m.'" />'.PHP_EOL;
    $content.='<input name="date_d" type="text" class="" size="2" id="date_d" maxlength="2" value="'.$d.'" />'.PHP_EOL;
  }
  else
  {
    system_error();
  }
  return $content;
}

?>