CKEDITOR.editorConfig = function( config )
{
	// Define changes to default configuration here.
	
	 config.language = lang;
	 
	// Sets SCAYT language
	 if(lang == 'en') { 
		 langscayt = 'en_GB';
	 } else {
		 langscayt = lang + '_' + lang.toUpperCase();
	 }
	 config.scayt_sLang = langscayt;

	 config.entities = false;
	 config.entities_greek = false;
	 config.entities_latin = false;
	 config.toolbar = 'Linea21';
	 config.width = 600;
	 config.resize_maxWidth = 600;
	 config.resize_minWidth = 600;
	 
	 config.removePlugins = 'link';
	 config.extraPlugins = 'magicline,pastefromword,adv_link,oembed,widget';
	 config.autoGrow_maxHeight= 300;
	 config.allowedContent = true; // prevent ckeditor removing attributes like id or class from div
	 
	 // oembed options
	 // define a css class for the embeded content wrapper (div)
	 config.oembed_WrapperClass = 'embededContent';
	 
	 config.disableNativeSpellChecker = true;
	 
	 config.toolbar_Linea21 =
	 [
	     ['Cut','Copy','Paste','PasteText','PasteFromWord'],
	     ['Undo','Redo','-','Find','Replace','-','RemoveFormat'],
	     //['Source','About','-','Print'],
	     ['Source','About','-','Print','SpellChecker', 'Scayt'], // enable online spell checker Scayt
	     ['Maximize', 'ShowBlocks'],
	     '/',
	     ['Bold','Italic','Underline','Strike','-','Subscript','Superscript'],
	     ['NumberedList','BulletedList','-','Outdent','Indent','Blockquote'],
	     ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
	     ['Link','Unlink','Anchor'],
	     ['Image','oembed','Flash','Table','HorizontalRule','SpecialChar'],
	     ['Styles','Format','FontSize'],
	     // ['Styles','Format','Font','FontSize'],
	     // ['TextColor','BGColor']
	 ];
	 
	// Remove some buttons provided by the standard plugins, which are
		// not needed in the Standard(s) toolbar.
		// config.removeButtons = 'Underline,Subscript,Superscript';

		// Set the most common block elements.
		config.format_tags = 'p;h1;h2;h3;h4;pre';

};
