tinymce.init({
	// include newsletter css file
	setup: function(editor) {
        editor.on('PreInit', function(e) {
            if(typeof newslettercsspath !== "undefined") {
            	tinyMCE.activeEditor.dom.loadCSS(newslettercsspath);
            }
        });
    },

	menubar: "edit insert format view table",
	selector: "textarea.largetextfield",
	language : lang,
	theme : "modern",
	plugins : "advlist,charmap,fullscreen,hr,image,link,anchor,textcolor,table,media,print,preview,contextmenu,code",
	dialog_type : "modal",
	remove_script_host : false,
	relative_urls : false,
	entity_encoding : "raw",
	toolbar1: "undo redo | styleselect | bold italic underline subscript superscript | alignleft aligncenter alignright alignjustify ",
	toolbar2: " bullist numlist outdent indent | anchor link | media image | fullscreen preview print | code",
	/** toolbar options : http://www.tinymce.com/wiki.php/Controls */

	file_browser_callback : function(field_name, url, type, win) {
		
		// from http://andylangton.co.uk/blog/development/get-viewport-size-width-and-height-javascript
		var w = window,
	    d = document,
	    e = d.documentElement,
	    g = d.getElementsByTagName('body')[0],
	    x = w.innerWidth || e.clientWidth || g.clientWidth,
	    y = w.innerHeight|| e.clientHeight|| g.clientHeight;
			
		//alert("Field_Name: " + field_name + " nURL: " + url + " nType: " + type + " nWin: " + win); // debug/testing
		var cmsURL = '../library/access.php?field_name='+field_name+'&lang='+tinymce.settings.language;
		    
		    if(type == 'image') {		    
		    	cmsURL = cmsURL + "&type=images";
		    }
		
		    tinyMCE.activeEditor.windowManager.open({
		        file : cmsURL,
		        title : 'Filemanager',
		        width : x * 0.8,
		        height : y * 0.8,
		        resizable : true,
		        close_previous : "no"
		    });		    
		}

});
