# Contributing to PHPWord

PHPWord is build by the crowd and for the crowd. Every contributions are welcomed; either by [submitting](https://github.com/PHPOffice/PHPWord/issues) bug issues or suggesting improvements, or in a more active form like [requesting](https://github.com/PHPOffice/PHPWord/pulls) a pull.

We want to create a high quality document writer and reader library that people can use with more confidence and less bugs. We want to collaborate happily, code joyfully, and get a life merrily. Thus, below are some guidelines that we expect to be followed by each contributor.

- **Be brief, but be bold**: State your issues briefly, but speak out your ideas loudly, even if you can't or don't know how to implement it right away. The world will be better with limitless innovations.
- **Code in PSR**: We use PHP Standards Recommendation (PSR) from as the PHP Framework Interoperability Group (PHP-FIG). If you're not familiar with this standard, please [familiarize yourself now](https://github.com/php-fig/fig-standards). Use [PHPCodeSniffer](http://pear.php.net/package/PHP_CodeSniffer/) to check your code against this standard.
- **Test your code**: Nobody else knows your code better than you. So, please, test your own code before submitting your pull request. PHPWord uses [PHPUnit](http://phpunit.de/) as our testing framework.
- **Request pull in separate branch**: Do not submit your request to the master branch, but create a separate branch named specifically for the issue that you addressed. Read [GitHub manual](https://help.github.com/articles/using-pull-requests) to find out more about this. If you are new to GitHub, read [this short manual](https://help.github.com/articles/fork-a-repo) to get you familiar with forks and how git works in general.

That's it. Thank you for your interest in PHPWord, and welcome!

May the Force be with you.