<?php

function autoload($className)
{	

	$className = ltrim($className, '\\');
	$fileName  = '';
	$namespace = '';
	if ($lastNsPos = strripos($className, '\\')) {
		$namespace = substr($className, 0, $lastNsPos);
		$className = substr($className, $lastNsPos + 1);
		$fileName  = str_replace('\\', DIRECTORY_SEPARATOR, $namespace) . DIRECTORY_SEPARATOR;
	}
	$fileName .= str_replace('_', DIRECTORY_SEPARATOR, $className) . '.php';
	
	// echo "namespace : " . $namespace."-  classname : " . $className.' - FILE : ' . $fileName.'<br>';
	
	// we only load DebugBar and Psr classes to prevent other classes autoloading (for example SwiftMailer)
	if (strpos($namespace,'DebugBar') !== false || strpos($namespace,'Psr') !== false ) {

		require $fileName;
		return;
		
	}
}

spl_autoload_register('autoload');