<?php
/**
 * Mail module
 * 
 * Provide a function to format emails and get them ready to be sent
 * 
 * @package linea21\modules\mail
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

// ////////// Check Inclusion de pages ////////////
if (! class_exists ( 'auth' )) {
	include_once ("../lib/lib_common.php");
	ReloadIndex ( 'admin' );
}
// //////////

/**
 * Prepare email by setting recipient, subject, html and text bodies
 * Email is set regarding passed action ($a ['action'])
 * @param array $a Provide 'action' and wanted information to send
 * @return array $email Returns a formatted array containing email informations
 */
function prepare_email($a) {
	/**
	 * Préparation du mail
	 * $email_html_body
	 * $email_txt_body
	 * $email_subject
	 * $email_recipient
	 */
	$email = array ();
	
	switch ($a ['action']) {
		
		// USERS
		case 'add_user' :
			
			$email ['html_body'] = _t ( 'user', 'mail_add_body1' ) . "<br />\n";
			$email ['html_body'] .= _t ( 'user', 'mail_add_body2' ) . "<br /><br />\n";
			$email ['html_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "<br />\n";
			$email ['html_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "<br />\n";
			
			$email ['txt_body'] = _t ( 'user', 'mail_add_body1' ) . "\n";
			$email ['txt_body'] .= _t ( 'user', 'mail_add_body2' ) . "\n\n";
			$email ['txt_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "\n";
			$email ['txt_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "\n";
			
			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_add_subject' ) ) . ' - ' . SITE_NAME;
			$email ['recipient'] = $a['recipient'];
			
			break;
			
		case 'change_pass' :
			
			$email ['html_body'] = _t ( 'user', 'mail_changepass_body1' ) . "<br />\n";
			$email ['html_body'] .= _t ( 'user', 'mail_changepass_body2' ) . "<br /><br />\n";
			$email ['html_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "<br />\n";
			$email ['html_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "<br />\n";
			
			$email ['txt_body'] = _t ( 'user', 'mail_changepass_body1' ) . "\n";
			$email ['txt_body'] .= _t ( 'user', 'mail_changepass_body2' ) . "\n";
			$email ['txt_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "\n";
			$email ['txt_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "\n";
			
			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_changemail_subject' ) ) . ' - ' . SITE_NAME;
			$email ['recipient'] = $a['recipient'];
			
			break;
			
		case 'forgot_pass' :
			
			$email ['html_body'] = _t ( 'user', 'mail_forgotpass_body1' ) . "<br />\n";
			$email ['html_body'] .= '<em>' . _t ( 'user', 'mail_forgotpass_body2' ) . "</em><br /><br />\n";
			$email ['html_body'] .= "<a href='" . SITE_ROOT_URL . 'public/' . get_permalink ( $a['linkpassword'] ) . "'>" . SITE_ROOT_URL . 'public/' . get_permalink ( $a['linkpassword'] ) . "</a><br />\n";
			
			$email ['txt_body'] = _t ( 'user', 'mail_forgotpass_body1' ) . "\n";
			$email ['txt_body'] .= _t ( 'user', 'mail_forgotpass_body2' ) . "\n";
			$email ['txt_body'] .= SITE_ROOT_URL . 'public/' . get_permalink ( $a['linkpassword'] ) . "\n";
			
			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_forgotpass_subject' ) ) . ' - ' . SITE_NAME;
			$email ['recipient'] = $a['recipient'];
			
			break;
			
		case 'change_mail' :
			
			$email ['html_body'] = _t ( 'user', 'mail_changemail_body1' ) . "<br />\n";
			$email ['html_body'] .= _t ( 'user', 'mail_changemail_body2' ) . "<br /><br />\n";
			$email ['html_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "<br />\n";
			$email ['html_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "<br />\n";
			
			$email ['txt_body'] = _t ( 'user', 'mail_changemail_body1' ) . "\n";
			$email ['txt_body'] .= _t ( 'user', 'mail_changemail_body2' ) . "\n";
			$email ['txt_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "\n";
			$email ['txt_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "\n";
			
			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_changemail_subject' ) ) . ' - ' . SITE_NAME;
			$email ['recipient'] = $a['recipient'];
			
			break;
			
		case 'change_login' :
			
			$email ['html_body'] = _t ( 'user', 'mail_changelogin_body1' ) . '<b>' . $a['login'] . "</b><br />\n";
			
			$email ['txt_body'] = _t ( 'user', 'mail_changelogin_body1' ) . $a['login'] . "\n";
			
			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_changelogin_subject' ) ) . ' - ' . SITE_NAME;
			$email ['recipient'] = $a['recipient'];
			
			break;
		
		// comment
		case 'moderate_comment' :
			
			$email ['html_body'] = "<p>" . sprintf ( _t ( 'comment', 'mail_body1' ), $a ['name'], "<a href=\"" . $a ['item_link'] . "\">" . $a ['item_title'] . "</a> (" . $a ['item_type'] . ")" ) . " : </p>" . PHP_EOL;
			$email ['html_body'] .= "<p><em>" . formatText ( $a ['body'], '2HTML' ) . "</em></p>" . PHP_EOL;
			$email ['html_body'] .= "<p><a href=" . $a ['moderate_link'] . ">" . ucfirst ( _t ( 'comment', 'mail_body2' ) ) . "</a> ";
			$email ['html_body'] .= "(" . _t ( 'comment', 'mail_body_auth' ) . ")</p>" . PHP_EOL;
			
			$email ['txt_body'] = sprintf ( _t ( 'comment', 'mail_body1' ), $a ['name'], $a ['item_title'] . ' (' . $a ['item_type'] . ') : ' ) . PHP_EOL;
			$email ['txt_body'] .= " - " . $a ['item_link'] . PHP_EOL . PHP_EOL;
			$email ['txt_body'] .= formatText ( $a ['body'], '2HTML' ) . PHP_EOL . PHP_EOL;
			$email ['txt_body'] .= ucfirst ( _t ( 'comment', 'mail_body2' ) ) . ' : ' . $a ['moderate_link'] . PHP_EOL;
			$email ['txt_body'] .= "(" . _t ( 'comment', 'mail_body_auth' ) . ")" . PHP_EOL;
			
			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'comment', 'mail_subject_moderate' ), SITE_NAME ) );
			$email ['recipient'] = $a ['recipient'];
			
			break;
		
		case 'notify_comment' :
			
			$unsubscribe_link = $a ['unsubscribe_link'] . '&email=' . $a ['recipient'];
			
			$email ['html_body'] = "<p>" . sprintf ( _t ( 'comment', 'mail_body1' ), $a ['name'], "<a href=\"" . $a ['item_link'] . "\">" . $a ['item_title'] . "</a> (" . $a ['item_type'] . ")" ) . " : </p>" . PHP_EOL;
			$email ['html_body'] .= "<p><em>" . formatText ( $a ['body'], '2HTML' ) . "</em></p>" . PHP_EOL;
			if (! isset ( $a ['adminuser'] )) {
				$email ['html_body'] .= "<p>" . ucfirst ( _t ( 'comment', 'mail_body3' ) ) . "<a href=\"" . $unsubscribe_link . "\">" . $unsubscribe_link . "</a></p>" . PHP_EOL;
			}
			
			$email ['txt_body'] = sprintf ( _t ( 'comment', 'mail_body1' ), $a ['name'], $a ['item_title'] . ' (' . $a ['item_type'] . ') : ' ) . PHP_EOL;
			$email ['txt_body'] .= " - " . $a ['item_link'] . PHP_EOL . PHP_EOL;
			$email ['txt_body'] .= formatText ( $a ['body'], '2HTML' ) . PHP_EOL . PHP_EOL;
			if (! isset ( $a ['adminuser'] )) {
				$email ['txt_body'] .= ucfirst ( _t ( 'comment', 'mail_body3' ) ) . $unsubscribe_link . PHP_EOL;
			}
			
			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'comment', 'mail_subject_newcomment' ), SITE_NAME ) );
			$email ['recipient'] = $a ['recipient'];
			
			break;
		
		// workgroups
		case 'file_alert' :
			
			if (isset ( $a ['is_shared'] ) && $a ['is_shared'] === true) {
				$intro = _t ( 'workshop', 'mail_file_body1b' );
				$url = SITE_ROOT_URL . 'public/' . get_permalink ( $a['wlinkworkgroups'] );
				$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_file_subject_b' ), SITE_NAME ) );
			} else {
				$intro = sprintf ( _t ( 'workshop', 'mail_file_body1' ), $a ['wname'] );
				$url = SITE_ROOT_URL . 'public/' . get_permalink ( $a ['wlinkfiles'] );
				$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_file_subject' ), $a ['wname'], SITE_NAME ) );
			}
			$email ['html_body'] = "<p>" . $intro . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . sprintf ( _t ( 'workshop', 'mail_file_body2' ), $a ['owner'] ) . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<em>" . PHP_EOL;
			if (isset ( $a ['files'] )) {
				foreach ( $a ['files'] as $file ) {
					$email ['html_body'] .= "- " . $file . "<br />" . PHP_EOL;
				}
			}
			$email ['html_body'] .= "</em><br /><br />" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br />" . PHP_EOL;
			$email ['html_body'] .= "<a href=" . $url . ">" . $url . "</a></p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_auth' ) . "</p>" . PHP_EOL;
			
			$email ['txt_body'] = strip_tags ( $email ['html_body'] );
			
			$email ['recipient'] = $a ['recipient'];
			
			break;
		
		case 'topic_alert' :
			
			$email ['html_body'] = "<p>" . sprintf ( _t ( 'workshop', 'mail_topic_body1' ), $a ['owner'], formatText ( $a ['topic_subject'], '2HTML' ), formatText ( $a ['wname'], '2HTML' ) ) . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_msg_content' ) . " :</p>" . PHP_EOL;
			$email ['html_body'] .= "<p><em>" . formatText ( $a ['topic_body'], '2HTML' ) . "</em></p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br />" . PHP_EOL;
			$email ['html_body'] .= "<a href=\"" . SITE_ROOT_URL . 'public/' . get_permalink ( $a ['wlinkforum'] ) . "\">" . SITE_ROOT_URL . 'public/' . get_permalink ( $a ['wlinkforum'] ) . "</a></p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_auth' ) . "</p>" . PHP_EOL;
			
			$email ['txt_body'] = strip_tags ( $email ['html_body'] );
			
			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_topic_subject' ), $a ['wname'], SITE_NAME ) );
			$email ['recipient'] = $a ['recipient'];
			break;
		
		case 'post_alert' :
			
			$email ['html_body'] = "<p>" . sprintf ( _t ( 'workshop', 'mail_post_body1' ), $a ['owner'], formatText ( $a ['topic_subject'], '2HTML' ), formatText ( $a ['wname'], '2HTML' ) ) . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_msg_content' ) . " :</p>" . PHP_EOL;
			$email ['html_body'] .= "<p><em>" . formatText ( $a ['topic_body'], '2HTML' ) . "</em></p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br />" . PHP_EOL;
			$email ['html_body'] .= "<a href=\"" . SITE_ROOT_URL . 'public/' . get_permalink ( $a ['wlinkforum'] ) . "\">" . SITE_ROOT_URL . 'public/' . get_permalink ( $a ['wlinkforum'] ) . "</a></p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_auth' ) . "</p>" . PHP_EOL;
			
			$email ['txt_body'] = strip_tags ( $email ['html_body'] );
			
			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_post_subject' ), $a ['wname'], SITE_NAME ) );
			$email ['recipient'] = $a ['recipient'];
			break;
		
		case 'event_alert' :
			
			$email ['html_body'] = "<p>" . sprintf ( _t ( 'workshop', 'mail_calendar_body1' ), $a ['owner'], formatText ( $a ['task_subject'], '2HTML' ), $a ['wname'], formatText ( $a ['task_date'], '2HTML' ) ) . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_calendar_body2' ) . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<p><em>" . formatText ( $a ['task_body'], '2HTML' ) . "</em></p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br />" . PHP_EOL;
			$email ['html_body'] .= "<a href=\"" . SITE_ROOT_URL . 'public/' . get_permalink ( $a ['wlinkcalendar'] ) . "\">" . SITE_ROOT_URL . 'public/' . get_permalink ( $a ['wlinkcalendar'] ) . "</a></p>" . PHP_EOL;
			// $email ['html_body'] .= "<p>"._t('workshop','mail_body_auth') . "</p>".PHP_EOL;
			
			$email ['txt_body'] = strip_tags ( $email ['html_body'] );
			
			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_calendar_subject' ), $a ['wname'], SITE_NAME ) );
			$email ['recipient'] = $a ['recipient'];
			
			break;
		
		case 'workgroup_request' :
			
			$email ['html_body'] = "<p>" . sprintf ( _t ( 'workshop', 'workgroup_request' ), $_SESSION ['userlogin'] ) . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . $a ['wgroups'] . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<p><em>" . _t ( 'divers', 'comment' ) . "</em> : " . formatText ( $a['comment'], '2HTML' ) . "</p>" . PHP_EOL;
			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br /><a href=" . $a ['moderate_link'] . ">" . $a ['moderate_link'] . "</a><br />";
			$email ['html_body'] .= "(" . _t ( 'workshop', 'mail_body_auth' ) . ")</p>" . PHP_EOL;
			
			$email ['txt_body'] = strip_tags ( sprintf ( _t ( 'workshop', 'workgroup_request' ), $_SESSION ['userlogin'] ) ) . PHP_EOL;
			$email ['txt_body'] .= strip_tags ( $a ['wgroups'] ) . PHP_EOL . PHP_EOL;
			$email ['txt_body'] .= _t ( 'divers', 'comment' ) . ' : ' . formatText ( $a['comment'], '2HTML' ) . PHP_EOL . PHP_EOL;
			$email ['txt_body'] .= ucfirst ( _t ( 'workshop', 'mail_body_url' ) ) . ' : ' . $a ['moderate_link'] . PHP_EOL;
			$email ['txt_body'] .= "(" . _t ( 'workshop', 'mail_body_auth' ) . ")" . PHP_EOL;
			
			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_request_subject' ) . ' - %s', SITE_NAME ) );
			$email ['recipient'] = $a ['recipient'];
			
			break;
		
		// Yellowpages / directory
		case 'confirm_entry' :
			
			$email ['html_body'] = _t ( 'yp', 'mail_body1' ) . "<br />";
			$email ['html_body'] .= "<a href=\"" . $a ['link_entry'] . "\">" . $a ['link_entry'] . "</a><br/>\n";
			
			$email ['txt_body'] = strip_tags ( _t ( 'yp', 'mail_body1' ) . "\n" );
			$email ['txt_body'] .= $a ['link_entry'] . "\n";
			
			$email ['subject'] = mb_ucfirst ( _t ( 'yp', 'confirm_subscription' ) . ' - ' . SITE_NAME );
			$email ['recipient'] = $a ['recipient'];
			break;
		
		// added from back-office - notification sent to submitter
		case 'add_entry' :
			$email ['html_body'] = _t ( 'yp', 'mail_body_added1' ) . "<br />";
			$email ['html_body'] .= "<a href=\"" . $a ['link_entry'] . "\">" . $a ['link_entry'] . "</a><br/><br />\n";
			$email ['html_body'] .= _t ( 'yp', 'mail_body_added2' ) . "<br /><br />";
			
			$email ['txt_body'] = strip_tags ( _t ( 'yp', 'mail_body_added1' ) . "\n" );
			$email ['txt_body'] .= $a ['link_entry'] . "\n";
			$email ['txt_body'] .= strip_tags ( _t ( 'yp', 'mail_body_added2' ) . "\n" );
			
			$email ['subject'] = mb_ucfirst ( _t ( 'yp', 'mail_subject_added' ) . ' - ' . SITE_NAME );
			$email ['recipient'] = $a ['recipient'];
			break;
		
		default :
			exit ();
	}
	
	
	// adding common content 
	if(!isset($a['wrap']) || (isset($a['wrap']) && $a['wrap'] == true)) {
		
		// preparing footers
		if(isset($a['html_footer'])) {
			$html_footer = $a['html_footer'];
		} else {
			$html_footer = _t ( 'mail', 'footer' );
			$html_footer .= "<br />-------------------<br />";
			$html_footer .= "<small><a href=\"" . SITE_ROOT_URL . "public/\">" . SITE_NAME . "</a> - <a href=\"mailto:" . SITE_MAIL . "\">" . _t ( 'contact', 'contact_us' ) . "</a></small>";
		}
		
		if(isset($a['txt_footer'])) {
			$txt_footer = $a['txt_footer'];
		} else {
			$txt_footer = strip_tags ( _t ( 'mail', 'footer' ) );
			$txt_footer .= "\n-------------------\n";
			$txt_footer .= SITE_ROOT_URL . "public/ - " . _t ( 'contact', 'contact_us' ) . " : " . SITE_MAIL;
		}
		
		// preparing headers
		if(isset($a['html_header'])) {
			$html_header = $a['html_header'];
		} else {
			$html_header = _t ( 'mail', 'header_hello' ) . "<br /><br />";
		}
		if(isset($a['txt_header'])) {
			$txt_header = $a['txt_header'];
		} else {
			$txt_header = _t ( 'mail', 'header_hello' ). "\n\n" ;
		}
		// We add common content to bodies
		$email ['html_body'] = $html_header . $email ['html_body'] . $html_footer;
		$email ['html_body'] = '<div style="font-family: Arial, Helvetica, sans-serif;">' .$email ['html_body'] . '</div>';
		$email ['txt_body']  = $txt_header . $email ['txt_body'] . $txt_footer;
	}
	
	return $email;
}

?>
