<?php
/**
 * Page module
 * 
 * Delete given page from back-office.
 * 
 * @package linea21\modules\page
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];
$link_det=$rub_link."&amp;todo=det&amp;id=".$id;


if(isset($_POST['valider'])) {
  $page_object = new page;
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  $result=$page_object->DeletePage($id, $sql_object);
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

$requete= SQL_getPageTitle($id);
$result=$sql_object->DBSelect($requete);

// Do record exists?
if(!isset($result[0]['page_title'])) redirect_to('@module_default');

$title=FormatText($result[0]['page_title']);
$owner=FormatText($result[0]['page_posted_by']);

?>

<div id="chemin">
	<ul>
		<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
		<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','page'); ?></a></li>
		<li><span><?php echo formatNavTitle(_t('page','sup')." : ". $title); ?></span></li>
	</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
  <?php echo "<h2>". formatTitleh2($title)."</h2>"; ?>
  <form id="suptheme" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
    <p class="info"><i class="icon-trash"></i> <?php echo _t('divers','sup_confirm'); ?></p>
    <div>
      <input name="id" type="hidden" value="<?php echo $id; ?>" />
      <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
      <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
      <?php echo cancel_button('javascript:history.go(-1);'); ?>
      <input name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>" class="button" id="valider" />
    </div>
  </form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->