<?php
/**
 * Project module
 * 
 * Modify given project from back-office.
 * 
 * @package linea21\modules\project
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isProjectManager($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

// TextboxList CSS/JS inclusion
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
footerAddJS('../lib/js/jquery.textboxList/GrowingInput.js');
footerAddJS('../lib/js/jquery.textboxList/TextboxList.js');
footerAddJS('../lib/js/jquery.textboxList/TextboxList.Autocomplete.js');

// MultiSelect CSS/JS inclusion
addDynamicCSS('../lib/js/jquery-ui-multiselect/jquery.multiselect.css');
addDynamicCSS('../lib/js/jquery-ui-multiselect/jquery.multiselect.filter.css');
footerAddJS('../lib/js/jquery-ui-multiselect/src/jquery.multiselect.min.js');
footerAddJS('../lib/js/jquery-ui-multiselect/src/jquery.multiselect.filter.min.js');
footerAddJS('../lib/js/jquery-ui-multiselect/i18n/jquery.multiselect.'.U_L.'.js');
footerAddJS('../lib/js/jquery-ui-multiselect/i18n/jquery.multiselect.filter.'.U_L.'.js');

// getting tags
include_once('../class/class.tag.php');
$otag = new tag();
$form_tags = $otag->getTags('project', $id, true);

$project_object = new project;

$mask_statut_P='';
$mask_statut_D='';
$mask_archive_P='';
$mask_archive_D='';
$mask_archive_AA='';
$mask_archive_PA='';

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$project_object->ModifyProject($id, $data_table, $sql_object);
  
  if($result) {
  	$otag->modifyTags('project', $id, $data_table['19']);
  }

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

// Titre de l'actu en cours de modification
$requete=SQL_getProjectName($id);
$result=$sql_object->DBSelect($requete);

// Do record exists?
if(!isset($result[0]['project_name'])) redirect_to('@module_default');

$project_current_title=formatText($result[0]['project_name'],'2HTML');



// Obtention des données  de la BDD
$req_det= SQL_getoneCompleteProject($id);
$result=$sql_object->DBSelect($req_det);
if($result==0 || count($result)!=1) exit;

include_once(override('../project/display.php'));
$coordinator = getAssociatedActors($id, 'coordinator');
$partners = getAssociatedActors($id, 'partner');
$manager = getAssociatedManagers($id);

$form_name=formatText($result[0]['project_name'], '2FIELD');
$form_goal= formatText($result[0]['project_goal'], '2FIELD');
$form_description= formatText($result[0]['project_description'], '2FIELD');
$form_body= formatText($result[0]['project_body'], '2FIELD');
$form_budget=formatText($result[0]['project_budget'], '2FIELD');
$form_budget_comment= formatText($result[0]['project_budget_comment'], '2FIELD');
$form_coordinator=$coordinator;
$form_partners=$partners;
$form_manager=$manager;
$form_elected= formatText($result[0]['project_elected'], '2FIELD');
$form_team= formatText($result[0]['project_team'], '2FIELD');
$form_comment= formatText($result[0]['project_comment'], '2FIELD');
$form_parent_id = ($result[0]['project_parent_id']==0) ? 0 : $result[0]['project_parent_id'];
$form_theme_id = ($result[0]['project_theme_id']==0) ? 0 : $result[0]['project_theme_id'];
$form_workshop_id = ($result[0]['project_workshop_id']==0) ? 0 : $result[0]['project_workshop_id'];
$form_scale_id= $result[0]['project_scale_id'];
$form_priority_id= $result[0]['project_priority_id'];
$form_begin_date= isNullDate($result[0]['project_begin_date_display']) ? '' : $result[0]['project_begin_date_display'];
$form_estimated_date = isNullDate($result[0]['project_estimated_date_display']) ? '' : $result[0]['project_estimated_date_display'];
$form_end_date = isNullDate($result[0]['project_end_date_display']) ? '' : $result[0]['project_end_date_display'];
$form_progression = $result[0]['project_completed'];
$form_statut=$result[0]['project_statut'];
$current_status=$result[0]['project_statut'];
$project_owner = $result[0]['project_posted_by'];


if(isset($_POST['valider'])) {

  isset($_POST['choose_sdi']) ? $form_sdi=$_POST['choose_sdi'] : $form_sdi=array();

  $a[0]=$_POST['project_name'];
  $a[1]=$_POST['project_description'];
  $a[2]=$_POST['project_body'];
  $a[3]=$_POST['project_parent_id'];
  $a[4]=$_POST['project_scale_id'];
  $a[5]=$_POST['project_priority_id'];
  $a[6]=$_POST['project_begin_date'];
  $a[7]=$_POST['project_estimated_date'];
  $a[8]=$_POST['project_end_date'];
  $a[9]=$_POST['project_statut'];
  $a[10]=$current_status;
  $a[11]=$_POST['project_theme_id'];
  $a[12]=$_POST['project_workshop_id'];
  $a[13]=$form_sdi;
  $a[14]=$_POST['project_progression'];
  $a[15]=$_POST['project_budget'];
  $a[16]=$_POST['project_coordinator'];
  $a[17]=$_POST['project_partners'];
  $a[18]=$_POST['project_manager'];
  $a[19]=$_POST['project_tags'];
  $a['goal'] = $_POST['project_goal'];
  $a['budget_comment'] = $_POST['project_budget_comment'];
  $a['comment'] = $_POST['project_comment'];
  $a['elected'] = $_POST['project_elected'];
  $a['team'] = $_POST['project_team'];

  $project_object= new project;
  $integrity=$project_object->CheckDataIntegrity($a, $sql_object);


  if(is_string($integrity)) $text_format='2FIELD';
  else $text_format='2HTML';
  $form_name=formatText($_POST['project_name'],$text_format);
  $form_goal=formatText($_POST['project_goal'],$text_format);
  $form_description=formatText($_POST['project_description'], $text_format);
  $form_body=formatText($_POST['project_body'], $text_format);
  $form_budget=formatText($_POST['project_budget'], $text_format);
  $form_budget_comment=formatText($_POST['project_budget_comment'], $text_format);
  $form_elected=formatText($_POST['project_elected'], $text_format);
  $form_team=formatText($_POST['project_team'], $text_format);
  $form_comment=formatText($_POST['project_comment'], $text_format);
  $form_coordinator=formatText(str_replace(',', ', ', $_POST['project_coordinator']), $text_format);
  $form_partners=formatText(str_replace(',', ', ', $_POST['project_partners']), $text_format);
  $form_manager=formatText(str_replace(',', ', ', $_POST['project_manager']), $text_format);

  $form_begin_date=$_POST['project_begin_date'];
  $form_estimated_date=$_POST['project_estimated_date'];
  $form_end_date=$_POST['project_end_date'];
  $form_progression=$_POST['project_progression'];

  $form_parent_id=$_POST['project_parent_id'];
  $form_theme_id=$_POST['project_theme_id'];
  $form_workshop_id=$_POST['project_workshop_id'];
  $form_scale_id=$_POST['project_scale_id'];
  $form_priority_id=$_POST['project_priority_id'];

  $form_statut=$_POST['project_statut'];
  $form_tags=$_POST['project_tags'];

  if($_POST['project_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['project_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  $a=urlencode(serialize($a));
}


include_once("../lib/input_helpers.php");

// select-box de thèmes
$data=$sql_object->DBSelect($req_list_theme);
$select_theme=ThemeSelectBox($data, "project_theme_id", $form_theme_id);

// select-box de workshops
$data=$sql_object->DBSelect($req_list_workshop);
$select_workshop=WorkshopSelectBox($data, "project_workshop_id", $form_workshop_id);

// select-box des projets
$data=$sql_object->DBSelect(SQL_getProjectsList(0,1000, 'public'));
$select_parent=ProjectSelectBox($data, "project_parent_id", $form_parent_id, -1, (array) $id);

// select-box des échelles
$data=$sql_object->DBSelect($req_list_scale);
$select_scale=ScaleSelectBox($data, "project_scale_id", $form_scale_id);

// select-box des priorités
$data=$sql_object->DBSelect($req_list_priority);
$select_priority=PrioritySelectBox($data, "project_priority_id", $form_priority_id);

// Indicators select box with associated indicators selected
$data_sdi = $sql_object->DBSelect(SQL_getProjectSdi($id));
$tmp_sdi = array();
if($data_sdi != 0 || count($data_sdi)!=1) {
  foreach($data_sdi as $value) {
    array_push($tmp_sdi, $value['sdii_id']);
  }
}

$data=$sql_object->DBSelect($req_list_sdi);
(!$l21auth->isSuperAdmin()) ?  $disabled = true : $disabled = false;
$select_sdi=SDIMultiSelectBox($data, "choose_sdi", $tmp_sdi, $disabled);

// select-box statut
if($form_statut=='P') $mask_archive_P=' selected="selected"';
if($form_statut=='D') $mask_archive_D=' selected="selected"';
if($form_statut=='AA') $mask_archive_AA=' selected="selected"';
if($form_statut=='PA') $mask_archive_PA=' selected="selected"';
$select_statut="<select name=\"project_statut\" id=\"project_statut\">\n";
$select_statut.="<option value=\"P\"".$mask_archive_P.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"D\"".$mask_archive_D.">".display_statut('D')."</option>\n";
$select_statut.="<option value=\"AA\"".$mask_archive_AA.">".display_statut('AA')."</option>\n";
$select_statut.="<option value=\"PA\"".$mask_archive_PA.">".display_statut('PA')."</option>\n";
$select_statut.="</select>\n";

footerAddJS('../lib/js/jquery.datePicker.l10n/jquery.ui.datepicker-'.U_L.'.js');

?>


<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','project');?></a></li>
  	<li><span><?php echo formatNavTitle(_t('project','mod'). ' :  '.$project_current_title); ?></span></li>
  </ul>
</div>
<!--end barre haute -->



<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<script type="text/javascript">

$(document).ready( function()
{
	$("#choose_sdi").multiselect({ noneSelectedText: '<?php echo _t('divers','select_choice'); ?>', selectedList:0, minWidth:'596px' } ).multiselectfilter();

	$( "#project_slider" ).slider({
		range: "min",
			value:<?php echo $form_progression; ?>,
			min: 0,
			max: 100,
			step: <?php echo PROJECT_STEP; ?>,
			slide: function( event, ui ) {
				$( "#project_progression" ).val( ui.value );
				$( "#progression_value" ).html( ui.value + ' %' );
			}
		});
	  $( "#project_progression" ).val($( "#project_slider" ).slider( "value" ));
		$( "#project_progression" ).hide();
		$( "#progression_value" ).html( <?php echo $form_progression; ?> + ' %' );

		// Autocomplete initialization
		var t1 = new $.TextboxList('#project_coordinator', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		var t2 = new $.TextboxList('#project_partners', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		var t3 = new $.TextboxList('#project_manager', {unique: true, plugins: {autocomplete: {onlyFromValues: true, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		var t4 = new $.TextboxList('#project_tags', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		
		$.ajax({url: '../project/_ajax_actor_autocomplete.php', dataType: 'json', success: function(r){
			t1.plugins['autocomplete'].setValues(r);
			t2.plugins['autocomplete'].setValues(r);
		}});

		$.ajax({url: '../project/_ajax_user_autocomplete.php', dataType: 'json', success: function(r){
			t3.plugins['autocomplete'].setValues(r);
		}});

		$.ajax({url: '../admin/_ajax_tag_autocomplete.php', dataType: 'json', success: function(r){
			t4.plugins['autocomplete'].setValues(r);
		}});

		$("div.textboxlist").each(function() {
		    $(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
		});

		/** jquery UI datePicker integration
		---------------------------------------------------*/

		var dateFormat = "<?php echo DATE_FORMAT; ?>";
		dateFormat = dateFormat.replace("yyyy", "yy");

		$(".date-pick").datepicker({
			showOn: "button",
			beforeShow: getAvailableRange,
			buttonImage: "../lib/js/calendar.png",
			buttonImageOnly: true,
			dateFormat: dateFormat
		});
		$( ".date-pick" ).datepicker( $.datepicker.regional[ "<?php echo U_L; ?>" ] );


		function getAvailableRange(input)
		{
		    	var min = new Date(2000, 1 - 1, 1); //Set this to your absolute minimum date
		        var dateMin = min;
		        var dateMax = null;

		        if (input.id == "project_begin_date")
		        {
		        	dateMin = min; // absolute minimum date
		        }
		        else if (input.id == "project_estimated_date")
		        {
		                if ($("#project_begin_date").datepicker("getDate") != null)
		                {
		                        dateMin = $("#project_begin_date").datepicker("getDate");
		                        dateMin.setDate(dateMin.getDate() + 1);

		                }
		        }
		        else if (input.id == "project_end_date")
		        {
		                if ($("#project_begin_date").datepicker("getDate") != null)
		                {
		                        dateMin = $("#project_begin_date").datepicker("getDate");
		                        dateMin.setDate(dateMin.getDate() + 1);
		                }
		        }
		    return {
		                minDate: dateMin,
		                maxDate: dateMax,
		            };

		}

    });
</script>

<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($project_current_title); ?></h2>
<form id="modproject" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
  <label for="project_name"><?php echo mb_ucfirst(_t('project','name')); ?> : *</label>
  <input name="project_name" type="text" class="textfield" maxlength="200" id="project_name" value="<?php echo $form_name; ?>" />
</p>
<p>
  <label for="project_parent_id"><?php echo mb_ucfirst(_t('project','parent')); ?> : </label>
  <?php echo $select_parent; ?>
</p>
<p>
	<label for="project_goal"><?php echo mb_ucfirst(_t('project','goal')); ?> : </label>
	<textarea id="project_goal" name="project_goal" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_goal; ?></textarea>
</p>
<p>
  <label for="project_description"><?php echo mb_ucfirst(_t('project','description')); ?> : *</label>
  <textarea id="project_description" name="project_description" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_description; ?></textarea>
</p>
<p>
  <label for="project_body"><?php echo mb_ucfirst(_t('project','body')); ?> : </label>
  <textarea id="project_body" name="project_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
</p>
<p>
  <label for="project_priority_id"><?php echo mb_ucfirst(_t('project','priority')); ?> : *</label>
  <?php echo $select_priority; ?>
</p>
<p>
  <label for="project_theme_id"><?php echo mb_ucfirst(_t('project','theme')); ?> : </label>
  <?php echo $select_theme; ?>
</p>
<p>
  <label for="project_workshop_id"><?php echo mb_ucfirst(_t('project','workshop')); ?> : </label>
  <?php echo $select_workshop; ?>
</p>
<p>
  <label for="project_scale_id"><?php echo mb_ucfirst(_t('project','scale')); ?> : *</label>
  <?php echo $select_scale; ?>
</p>
<p>
  <label for="project_tags"><?php echo mb_ucfirst(_t('tag','name')); ?> : </label>
  <input name="project_tags" type="text" maxlength="500" id="project_tags" class="textfield" value="<?php echo $form_tags; ?>" />
</p>
<p>
  <label for="choose_sdi"><?php echo mb_ucfirst(_t('project','sdi')); ?> : </label>
  <?php echo $select_sdi; ?>
</p>
<p>
	<label for="project_comment"><?php echo mb_ucfirst(_t('project','comment')); ?> : </label>
	<textarea id="project_comment" name="project_comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_comment; ?></textarea>
</p>
<p>
  <label for="project_statut"><?php echo mb_ucfirst(_t('project','statut')); ?> : </label>
  <?php echo $select_statut; ?>
</p>

<h3 class="part"><?php echo mb_ucfirst(_t('project','calendar_title')); ?></h3>
<p>
  <label for="project_begin_date"><?php echo mb_ucfirst(_t('project','begin_date')); ?> : </label>
  <input name="project_begin_date" type="text" maxlength="10" id="project_begin_date" class="date-pick shorttextfield" value="<?php echo $form_begin_date; ?>" />
</p>
<p>
  <label for="project_estimated_date"><?php echo mb_ucfirst(_t('project','estimated_date')); ?> : </label>
  <input name="project_estimated_date" type="text" maxlength="10" id="project_estimated_date" class="date-pick shorttextfield" value="<?php echo $form_estimated_date; ?>" />
</p>
<p>
  <label for="project_end_date"><?php echo mb_ucfirst(_t('project','end_date')); ?> : </label>
  <input name="project_end_date" type="text" maxlength="10" id="project_end_date" class="date-pick shorttextfield" value="<?php echo $form_end_date; ?>" />
</p>
<div>
	<label for="project_progression"  class="label"><?php echo mb_ucfirst(_t('project','progression')); ?> : </label>
	<div id="project_slider"></div><div id="progression_value"></div>
	<input type="text" name="project_progression" id="project_progression" value="<?php echo $form_progression; ?>" maxlength="3" class="shorttextfield"  />
</div>


<h3 class="part"><?php echo mb_ucfirst(_t('project','steering_title')); ?></h3>

<p>
	<label for="project_elected"><?php echo mb_ucfirst(_t('project','elected')); ?> : </label>
	<input name="project_elected" type="text" maxlength="500" id="project_elected" class="textfield" value="<?php echo $form_elected; ?>" />
</p>
<p>
	<label for="project_coordinator"><?php echo mb_ucfirst(_t('project','coordinator')); ?> : </label>
	<input name="project_coordinator" type="text" maxlength="500" id="project_coordinator" class="textfield" value="<?php echo $form_coordinator; ?>" />
</p>
<p>
	<label for="project_manager"><?php echo mb_ucfirst(_t('project','manager')); ?> : </label>
	<input name="project_manager" type="text" maxlength="500" id="project_manager" class="textfield" value="<?php echo $form_manager; ?>" />
</p>
<p>
	<label for="project_team"><?php echo mb_ucfirst(_t('project','team')); ?> : </label>
	<textarea id="project_team" name="project_team" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_team; ?></textarea>
</p>
<p>
	<label for="project_partners"><?php echo mb_ucfirst(_t('project','partners')); ?> : </label>
	<input name="project_partners" type="text" maxlength="500" id="project_partners" class="textfield" value="<?php echo $form_partners; ?>" />
</p>

<h3 class="part"><?php echo mb_ucfirst(_t('project','budget_title')); ?></h3>
<p>
	<label for="project_budget"><?php echo mb_ucfirst(_t('project','budget')); ?> : </label>
	<input name="project_budget" type="text" maxlength="10" id="project_budget" class="textfield" value="<?php echo $form_budget; ?>" />
</p>
<p>
	<label for="project_budget_comment"><?php echo mb_ucfirst(_t('project','budget_comment')); ?> : </label>
	<textarea id="project_budget_comment" name="project_budget_comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_budget_comment; ?></textarea>
</p>


<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
	<?php
	// Récapitulatif
} else	{
  if($form_theme_id != 0) {
    $requete=SQL_getonethemeName($form_theme_id);
    $result=$sql_object->DBSelect($requete);
    if($result==0 || count($result)!=1) die('Theme was not found - (id:'.$form_theme_id.')');
    else $theme_denomination=formatText($result[0]['theme_name'], '2HTML');
  } else $theme_denomination=_t('divers','none');

  $requete=SQL_getonescaleDenomination($form_scale_id);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) die('Scale was not found - (id:'.$form_scale_id.')');
  else $scale_denomination=formatText($result[0]['scale_denomination'], '2HTML');

  $requete=SQL_getonepriorityName($form_priority_id);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) die('Priority was not found - (id:'.$form_priority_id.')');
  else $priority_name=formatText($result[0]['priority_name'], '2HTML');

  if($form_parent_id != 0) {
    $requete=SQL_getProjectName($form_parent_id);
    $result=$sql_object->DBSelect($requete);
    if($result==0 || count($result)!=1) die('Parent project was not found - (id:'.$form_parent_id.')');
    else $parent_name=formatText($result[0]['project_name'], '2HTML');
  } else $parent_name=_t('divers','none');

  if($form_workshop_id != 0) {
    $query=SQL_getWorkshopName($form_workshop_id);
    $result=$sql_object->DBSelect($query);
    if($result==0 || count($result)!=1) die('Workshop was not found - (id:'.$form_workshop_id.')');
    else $workshop_name=formatText($result[0]['workshop_denomination'], '2HTML');
  } else $workshop_name=_t('divers','none');

  if(count($form_sdi) > 0) {
    $sdi_list='<ul style="padding:0">';
    foreach ($form_sdi as &$value) {
      $query=SQL_getSdiName($value);
      $result = $sql_object->DBSelect($query);
      if($result==0 || count($result)!=1) die('Indicator was not found - (id:'.$result[0]['sdii_is'].')');
      else $sdi_list.= '<li>'.formatText($result[0]['sdii_name'], '2HTML').'</li>'.PHP_EOL;
    }
    $sdi_list.='</ul>';
  } else $sdi_list=_t('divers','none');

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('project','name'))." :</dt>\n";
echo "<dd>". $form_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','goal'))." :</dt>\n";
echo "<dd>". empty_nc($form_goal)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','parent'))." :</dt>\n";
echo "<dd>". $parent_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','description')). " :</dt>\n";
echo "<dd>".empty_nc(linkin_content($form_description))."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','body'))." :</dt>\n";
echo "<dd>".linkin_content(empty_none($form_body))."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','priority'))." :</dt>\n";
echo "<dd>".$priority_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','theme'))." :</dt>\n";
echo "<dd>".$theme_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','scale'))." :</dt>\n";
echo "<dd>".$scale_denomination."</dd>\n";
echo "<dt>".mb_ucfirst(_t('tag','name'))." :</dt>\n";
echo "<dd>".empty_none(str_replace(',', ', ', $form_tags))."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','workshop'))." :</dt>\n";
echo "<dd>".$workshop_name."</dd>\n";
echo "<dt>".mb_ucfirst(_t('project','sdi'))." :</dt>\n";
echo "<dd>".empty_none($sdi_list)."</dd>\n";
echo "<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
echo "<dd>". display_statut($_POST['project_statut']). "</dd>\n";
echo "</dl>\n";
?>

<h3 class="part"><?php echo mb_ucfirst(_t('project','calendar_title')); ?></h3>
<dl class="summary">
<dt><?php echo mb_ucfirst(_t('project','begin_date')); ?> : </dt>
<dd><?php echo empty_nc($form_begin_date); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','estimated_date')); ?> : </dt>
<dd><?php echo empty_nc($form_estimated_date); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','end_date')); ?> : </dt>
<dd><?php echo empty_nc($form_end_date); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','progression')); ?> : </dt>
<dd><?php echo getDynamicProgressbar($form_progression); ?></dd>
</dl>

<h3 class="part"><?php echo mb_ucfirst(_t('project','steering_title')); ?></h3>
<dl class="summary">
<dt><?php echo mb_ucfirst(_t('project','elected')); ?> : </dt>
<dd><?php echo empty_nc($form_elected); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','coordinator')); ?> : </dt>
<dd><?php echo empty_nc($form_coordinator); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','manager')); ?> : </dt>
<dd><?php echo empty_nc($form_partners); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','partners')); ?> : </dt>
<dd><?php echo empty_nc($form_manager); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','team')); ?> : </dt>
<dd><?php echo empty_nc($form_team); ?></dd>
</dl>

<h3 class="part"><?php echo mb_ucfirst(_t('project','budget_title')); ?></h3>
<dl class="summary">
<dt><?php echo mb_ucfirst(_t('project','budget')); ?> : </dt>
<dd class="money"><?php echo empty_nc(fnumber_format($form_budget,0, false)); ?></dd>
<dt><?php echo mb_ucfirst(_t('project','budget_comment')); ?> : </dt>
<dd><?php echo empty_none($form_budget_comment); ?></dd>
</dl>

<form id="modscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table" type="hidden" value="<?php echo $a; ?>" id="data_table" />
    <?php echo cancel_button('?rub=project&amp;todo=list'); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview'); ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save'); ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>