<?php
/**
 * Default front-office functions
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../user/'.SQL.'.inc.php');

if(!function_exists('prepareAjaxLogin')) {
	
	function prepareAjaxLogin() {
		
		global $l21auth;
		
		$str = '';
		
		if(!$l21auth->isAuthenticated()) {
			
			$str .= '<div id="loginmodal" style="display:none;">'.PHP_EOL;
			$str .= '<h2>'._t('divers','auth').'</h2>'.PHP_EOL;
			$str .= '<a class="modal_close" href="'. str_replace("&", "&amp;", $_SERVER['REQUEST_URI']). '"></a>'.PHP_EOL;
			$str .= AuthForm($todo = 'LOGON');
			$str .= '</div>'.PHP_EOL;
			
			
			$js = "$('.login-link').attr('href', '#loginmodal'); // on remplace le lien par défaut
						 $('.login-link').leanModal({ top : 200, overlay : 0.4, closeButton: '.modal_close' });";

			footerAddInlineJS($js);

			}

		echo $str;
	}
	
}

if(!function_exists('getPastEvents')) {
  function getPastEvents($nb) {

    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_pastEvents($nb));

    if($data!=0)
    {
      $content= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$data[$i]['workcal_workshop_id'], '#' => 'cal-'.$data[$i]['workcal_id']));
        $workshop_title =  _t('name', 'workshop_module') .' : '.formatText($data[$i]['workshop_denomination'], '2ATT');
        $workshop_task= formatText($data[$i]['workcal_task'], '2HTML');

        // no link if shared event
        if($data[$i]['workcal_workshop_id'] == 999999999) {
          $link = $_SERVER["PHP_SELF"].'#';
          $workshop_title =  _t('workshop_mod', 'event_common');
        }

        $content.= '<li><a href="'.$link.'" title="'.$workshop_title.'" class="tips">'.$data[$i]['task_date'].' : '.$workshop_task.'</a></li>';
      }
      $content.= '</ul>';
    } else {
      $content= '<p>'._t('divers', 'nodata').'</p>';
    }
    return $content;
  }
}

if(!function_exists('getIncomingEvents')) {
  function getIncomingEvents($nb) {
    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_incomingEvents($nb));

    if($data!=0)
    {
      $content= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$data[$i]['workcal_workshop_id'], '#' => 'cal-'.$data[$i]['workcal_id']));
        $workshop_title =  _t('name', 'workshop_module') .' : '.formatText($data[$i]['workshop_denomination'], '2ATT');
        $workshop_task= formatText($data[$i]['workcal_task'], '2HTML');

        // no link if shared event
        if($data[$i]['workcal_workshop_id'] == 999999999) {
          $link = $_SERVER["PHP_SELF"].'#';
          $workshop_title =  _t('workshop_mod', 'event_common');
        }

        $content.= '<li><a href="'.$link.'" title="'.$workshop_title.'" class="tips">'.$data[$i]['task_date'].' : '.$workshop_task.'</a></li>';

      }
      $content.= '</ul>';
    } else {
      $content= '<p>'._t('divers', 'nodata').'</p>';
    }
    return $content;
  }
}

if(!function_exists('getEvents')) {
	function getEvents($nb) {

		global $sql_object;

		$data= $sql_object->DBSelect(SQLget_Events($nb));

		if($data!=0)
		{
			$content= '<ul>';
			for($i=0; $i<count($data); $i++) {

				$link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$data[$i]['workcal_workshop_id'], '#' => 'cal-'.$data[$i]['workcal_id']));
				$workshop_title =  _t('name', 'workshop_module') .' : '.formatText($data[$i]['workshop_denomination'], '2ATT');
				$workshop_task= formatText($data[$i]['workcal_task'], '2HTML');

				// no link if shared event
				if($data[$i]['workcal_workshop_id'] == 999999999) {
					$link = $_SERVER["PHP_SELF"].'#';
					$workshop_title =  _t('workshop_mod', 'event_common');
				}

				$content.= '<li><a href="'.$link.'" title="'.$workshop_title.'" class="tips">'.$data[$i]['task_date'].' : '.$workshop_task.'</a></li>';
			}
			$content.= '</ul>';
		} else {
			$content= '<p>'._t('divers', 'nodata').'</p>';
		}
		return $content;
	}
}

if(!function_exists('getWorkgroupList')) {
  function getWorkgroupList($nb) {

    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_WorkshopList($nb));

    if($data!=0)
    {
      $content= '<ul id="vnav">';
      for($i=0; $i<count($data); $i++) {

        $workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
        $workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
        $content.='<li><a href="#tabs-'.$i.'" class="selected" title="'.formatText($workshop_title, '2ATT').'">'.$workshop_title.'</a></li>'.PHP_EOL;

      }
      $content.='</ul>';

      for($i=0; $i<count($data); $i++) {

        $link = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[$i]['workshop_id'],'name'=>$data[$i]['workshop_denomination']);
        $workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
        $workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
        $content.= '<div id="tabs-'.$i.'" class="ie6bugfix">';
        $content.= '<h3>'.$workshop_title.'</h3>'.PHP_EOL;
        $content.= '<div>'.$workshop_resume.'</div>';
        $content.= '<p><a href="'.HrefMaker($link).'" title="'.formatText($workshop_title, '2ATT').'" class="readmore">'._t('workshop', 'access_to').'</a></p>';
        $content.= '</div>';

      }
    }
    else
    {
      $content='<p class="info">'._t('divers','nodata').'</p>';
    }

    return $content;

  }
}
if (! function_exists ( 'DisplayLastNews' )) {
	function DisplayLastNews($nb) {
		include_once ('../lib/vendor/wideimage/lib/WideImage.php');
		require_once ('../news/mysql.inc.php');
		
		$data = $GLOBALS ['sql_object']->DBSelect ( SQL_getNewsList ( 0, $nb, 'public' ) );
		
		$content = '';
		
		$content .= '<h2>'._t('public','last_news_title').'</h2>';
		if ($data != 0) {
			
		for($i=0; $i<count($data); $i++) {
      
      	// get image with SIMPLEHTMLDOM
      
      	$html = new simple_html_dom();
      
      	$html->load($data[$i]['news_header']. $data[$i]['news_body']);
      
      	// we get the image with thumbnail class if provided
      	if($html->find('img.thumbnail', 0)) $imgsrc = $html->find('img.thumbnail', 0)->src;
      	else $imgsrc = false;
      
      	// if img.thumbnail does not exist we get the first image
      	if(!$imgsrc) {
      		// we get the first image if provided
      		if($html->find('img', 0)) $imgsrc = $html->find('img', 0)->src;
      	}
      	
      	// if there is still no image, we take default app image
      	if(!$imgsrc) {
      		$imgsrc = '../library/userfiles/no-image.png';
      	}
      
      	$thumbpath = '../library/userfiles/_thumbs/';
      	
				$path_parts = pathinfo ( $imgsrc );
				list($width, $height) = explode('x', THUMBNAIL_SIZE);
				
				$thumbname = $path_parts ['filename'] . '_' . $width . 'x' . $height . 'px.' . $path_parts ['extension'];
				
				$thumb_fullpath = $thumbpath . $thumbname;
				
				// if thumbnail does not exist
				if (! file_exists ( $thumb_fullpath )) {
					
					$image = WideImage::load ( $imgsrc );
					$resized = $image->resize ( $width, $height, 'outside' )->crop ( 'center', 'center', $width, $height );
					;
					$resized->saveToFile ( $thumb_fullpath );
					chmod ( $thumb_fullpath, 0755 );
					$imgsrc = $thumb_fullpath;
				} else {
					$imgsrc = $thumb_fullpath;
				}
      
      	$title=formatText($data[$i]['complete_news_title'],'2HTML');
      
      	// we remove all images contained in header
      	$html->load($data[$i]['news_header']);
      
      	foreach($html->find('img') as $element) {
      		$images = $element->outertext = '';
      	}
      
      
      
      	$link_table= array('rub'=> $GLOBALS['links'][U_L]['news']['linkvalue'],'id'=>$data[$i]['news_id'], 'name' => $data[$i]['news_title']);
      	$link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[$i]['news_posted_by'], 'name' => $data[$i]['user_login']);
      	$link_detail = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'id' => $data[$i]['news_id'], 'name' => $data[$i]['news_title']);
      
      	$news_posted_on = formatText($data[$i]['news_published_date_display'], '2HTML');
      	$news_posted_by = formatText($data[$i]['user_login'], '2HTML');
      
      	$content .= '<div class="onenews line mtm pas">'.PHP_EOL;
      	$content .= '<img src="' . $imgsrc . '" alt="' . $imgsrc . '" class="left nomouseover" />';
      	$content .= '<div class="mod">';
      	$content .= '<h2><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][U_L]['news']['desc'].' : '.$title, '2ATT').'">'.$title.'</a></h2>';
      	$content .= '<div>'.formatText($html, '2HTML').'</div>'.PHP_EOL;
      	$content .= '<a class="readmore" href="'.HrefMaker($link_detail).'">'._t('btn', 'read_more').'</a>';
      	$content .= '<p class="published_by">' . PHP_EOL;
      	$content .= '<span class="published-on">'._t('statut','published_on') . '</span> <span class="date">' . $news_posted_on . '</span> ';
      	$content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $news_posted_by . ')">' . $news_posted_by . '</a>';
      	$content .= '</p>' . PHP_EOL;
      	$content .= '</div>';
      	$content .= '</div>'.PHP_EOL;
      
      	// we clear SimpleHTMLDom to prevent memory leaks
      	$html->clear();
      	unset($html);
      }
      
    } else {
      $content .= '<p class="info">' . _t('divers','nodata') . '</p>';
    }
    
		
		echo $content;
	}
}

if(!function_exists('DisplayLastPublications')) {

  function DisplayLastPublications($nb, $plaintext = false) {
    $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_LastPublications($nb));

    $content ='<div id="home_publication">'.PHP_EOL;
    $content.='<h2>'._t('public','last_publications_title').'</h2>'.PHP_EOL;

    $link_publi= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue']);

    for($i=0; $i<count($data); $i++) {
      $publi_id=$data[$i]['publi_id'];
      $publi_title=formatText($data[$i]['publi_title'],'2HTML');
      $publi_resume=formatText($data[$i]['publi_resume'],'2HTML');
      
      if($plaintext) $publi_resume = strip_tags($publi_resume);
      $link_this= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'], 'id'=>$publi_id, 'name'=> $data[$i]['publi_title']);

      $content.= '<div class="onenews mtm pbl">';
      $content.= '<h3><a href="'.HrefMaker($link_this).'" title="'.formatText($GLOBALS['links'][U_L]['publication']['desc'].' : '.$publi_title, '2ATT').'">' . $publi_title .'</a></h3>';
      $content.= '<div>' . $publi_resume . '</div>';
      $content.= '<a class="readmore" href="'.HrefMaker($link_this).'">'._t('btn', 'read_more').'</a>';
      $content.= '</div>';
    }

    $content.= '</div>	'.PHP_EOL;

    echo $content;
  }
}

if(!function_exists('DisplayEdito')) {

  function DisplayEdito() {
    $content ='<div id="home_edito">'.PHP_EOL;
    $content.='<h2>'._t('header', 'welcome').'</h2>'.PHP_EOL;
    $content.='<p>';
    $content.=_t('public','edito');
    $content.='</p>'.PHP_EOL;
    $content.='</div>';
    echo $content;
  }
}

if(!function_exists('DisplayGDT')) {

  function DisplayGDT() {
    $link_gdt= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']);

    $content ='<div id="home_gdt">'.PHP_EOL;
    $content.='<h2>'._t('public','workgroup_h1').'</h2>'.PHP_EOL;
    $content.='<p>';
    $content.='<a href="'.HrefMaker($link_gdt).'" title="'.formatText($GLOBALS['links'][U_L]['workgroup']['desc'], '2ATT').'">';
    $content.=_t('public','workgroup_edito');
    $content.='</a>';
    $content.='</p>'.PHP_EOL;
    $content.='</div>';
    echo $content;
  }
}

if(!function_exists('DisplayIDD')) {

  function DisplayIDD() {
    $link_idd= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue']);
    $content ='<div id="home_idd">'.PHP_EOL;
    $content.='<h2>'._t('public','dashboard_h1').'</h2>'.PHP_EOL;
    $content.='<p>';
    $content.='<a href="'.HrefMaker($link_idd).'" title="'.formatText($GLOBALS['links'][U_L]['dashboard']['desc'], '2ATT').'">';
    $content.=_t('public','dashboard_edito');
    $content.='</a>';
    $content.='</p>'.PHP_EOL;
    $content.='</div>';
    echo $content;
  }
}


/**
 * DisplayMenu()
 * Affichage du menu
 *
 * @return void ( echo string )
 */
if(!function_exists('DisplayMenu')) {

  function DisplayMenu()
  {
    //$content .= '<a href="#contenu" class="semnone" title="'._t('header','goto_contents').'" accesskey="2">'._t('header','goto_contents').'</a>'.PHP_EOL;
    $content = '<ul class="clearfix">'.PHP_EOL;
    while (list($key, $value) = each ($GLOBALS['menuitems'])) {

      (ActiveItemAlias($GLOBALS['activeitem']) == $value) ? $classe = ' class="actif"' : $classe = '' ;
      $current_link = array('rub' => $GLOBALS['links'][U_L][$value]['linkvalue']);
      $content .= '<li id="menu_'.$value.'"'.$classe.'>';
      $content .= '<a href="' . HrefMaker($current_link) . '" title="' . $GLOBALS['links'][U_L][$value]['desc'] . '" accesskey="' . $GLOBALS['links'][U_L][$value]['accesskey'] . '" id="amenu_'.$value.'">' . mb_ucfirst($GLOBALS['links'][U_L][$value]['title']) . '</a>';
      $content .= '</li>' . PHP_EOL;
    }
    $content .= "</ul>";
    echo $content;
  }
}

/**
 * MyAccount()
 * Renvoie les liens de creation de compte ou de déconnexion
 * suivant le statut de l'utilisateur
 *
 * @return string content
 */
if(!function_exists('MyAccount')) {

  function MyAccount()
  {
  	global $l21auth;

    $link_account = array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);
    $link_create = array('rub' => $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
    $link_logout = array('rub' => $GLOBALS['links'][U_L]['logout']['linkvalue']);

    $content  = '<div id="myaccount">';
    if ($l21auth->isAuthenticated()) {
      if(isset($_SESSION['userfirstname'])) $title= ucfirst($_SESSION['userfirstname']);
      else $title= $_SESSION['userlogin'];
      $content .= '<h2>'._t('header','welcome'). ' '.$title.',</h2>';
      $str = ucfirst(_t('divers','myprofile'));
      $class = "profile-link";
    } else {
      $content .= '<h2>'._t('header','myaccount').'</h2>';
      $str = ucfirst(_t('divers','auth'));
      $class = "login-link";
    }
    $content .= '<ul>' . PHP_EOL;
    $content .= '<li><a href="' . HrefMaker($link_account) . '" accesskey="u" title="'._t('header','myaccount_title').'" class="'.$class.'">' . $str . '</a></li>';

    if ($l21auth->isAuthenticated()) {
    	if($l21auth->isSuperAdmin()) {
    		$content .= '<li><a href="../admin/" accesskey="l" title="'._t('divers','title_login').'">' . mb_ucfirst(_t('admin','console')) . '</a></li>';
    	}
    	$content .= '<li><a href="' . HrefMaker($link_logout) . '" accesskey="l" title="'._t('header','deconnexion_title').'">' . mb_ucfirst(_t('header','deconnexion')) . '</a></li>';

    }

    else {
    	$content .= '<li><a href="' . HrefMaker($link_create) . '" accesskey="c" title="'._t('divers','user_inscription_title').'">' . _t('divers','user_inscription') . '</a></li>';
    }
    $content .= '</ul></div>' . PHP_EOL;
    echo $content;
  }
}

/**
 * forgotPass()
 * Formulaire envoi d'un mot de passe
 *
 * @param string $todo
 * @return void (echo string)
 */
if(!function_exists('forgotPass')) {

  function forgotPass($back = 1 )
  {
  	include_once(override('../mail/mail_actions.php'));
  	include_once(override('../mail/send.php'));
  	$a = array();
  	
    if($back=== 1) $back=get_referer();
    $input_hidden = $GLOBALS['links'][U_L]['forgot-password']['linkvalue'];

    if(isset($_POST['valid'])) {
      $r = $GLOBALS['l21auth']->identifyWithLogin($_POST['login']);
      if(!($r)) {
        $msg = '<div class="error">'.sprintf(_t('auth', 'no_user'), $_POST['login']).'</div>';
      } else {

      	if($r['user_password'] == '@ldap_forward') {

      		$msg = '<div class="info">'.sprintf(_t('auth', 'ldap_user')).'</div>';

      	} else {

	        include_once('../class/class.user.php');
	        $user = new user;
	        $key = $user->generateNewPasskey($r['user_id'], $GLOBALS['sql_object']);

	        if($key != false) {
	          $a['action'] = 'forgot_pass';
	          $a['recipient'] = $r['profile_email'];
	          $a['linkpassword'] = array('rub' => $GLOBALS['links'][U_L]['forgot-password']['linkvalue'], 'token' => $key);
	          
	          $emailContainer = prepare_email($a);
	          $r = send_email($emailContainer);
	          
	          $msg =  '<div class="info">'.sprintf(_t('auth', 'sending_mail'), $a['recipient']).'</div>';
	        }
      	}

      }
    }

    $form = '<p>'. _t('auth','note') . '</p>' . PHP_EOL;
    if(isset($msg)) $form .= $msg . PHP_EOL;
    $form .= '<form action="index.php" method="post">' . PHP_EOL;
    $form .= '<div id="forgot_pass">' . PHP_EOL;
    $form .= '<p><label for="login" class="labelised">' . _t('divers','login') . ' : </label>' . PHP_EOL;
    $form .= '<input type="text" maxlength="20" class="tinytextfield" name="login" id="login" /></p>' . PHP_EOL;
    $form .= '<br />'.PHP_EOL;

    $form .= '<br />'.PHP_EOL;
    $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . PHP_EOL;
    $form .= '<input type="hidden" name="referer" id="referer" value="' . $back . '" />' . PHP_EOL;
    $form .= '<input type="submit" class="submitbut" value="'._t('btn','valid').'" title="'._t('btn','valid').'" name="valid" id="valid" />'.PHP_EOL;
    $form .= '</div>' . PHP_EOL;
    $form .= '</form>' . PHP_EOL;

    return $form;
  }
}

/**
 * AuthForm()
 * Formulaire d'authentification pour login ou inscription
 *
 * @param string $todo
 * @return void (echo string)
 */
if(!function_exists('AuthForm')) {

  function AuthForm($todo = 'LOGON', $back = 1 )
  {
    if($back === 1 && get_referer() != '') $back = get_referer();
    else $back = CURRENT_APP_URL;

    isset($_POST['login']) ? $form_login = $_POST['login'] : $form_login = '';
    isset($_POST['email']) ? $form_email = $_POST['email'] : $form_email = '';
    isset($_POST['firstname']) ? $form_firstname = strip_input(trim($_POST['firstname'])) : $form_firstname = '';
    isset($_POST['lastname']) ? $form_lastname = strip_input(trim($_POST['lastname'])) : $form_lastname = '';

    if ($todo == 'LOGON') {
      $input_hidden = $GLOBALS['links'][U_L]['user-prefs']['linkvalue'];
      $div_id = 'logon';
    } else {
      $input_hidden = $GLOBALS['links'][U_L]['user-registration']['linkvalue'];
      $div_id = 'subscribe';
    }
    $link_pass = array('rub' => $GLOBALS['links'][U_L]['forgot-password']['linkvalue']);
    $form = '<form action="index.php" method="post">' . PHP_EOL;
    $form .= '<div id="' . $div_id . '">' . PHP_EOL;
    $form .= '<p><label for="login" class="labelised">' . _t('divers','login') . ' : </label>' . PHP_EOL;
    $form .= '<input type="text" maxlength="20" class="tinytextfield" name="login" id="login" value="'.$form_login.'" />' . PHP_EOL;
    $form .= '</p>'.PHP_EOL;
    if ($todo == 'LOGON') {
      $form .= '<p><label for="password" class="labelised">' . _t('divers','password') . ' : </label>' . PHP_EOL;
      $form .= '<input type="password" maxlength="100" class="tinytextfield" name="password" id="password" /></p>' . PHP_EOL;
      
      if(defined('REMEMBER_ME') && REMEMBER_ME != 0) {
      	$form .= '<p class="login-remember">'. PHP_EOL;
      	$form .= '<input type="checkbox" name="rememberme" id="rememberme" />' . PHP_EOL;
      	$form .= '<label for="rememberme" class="labelised autowidth">' . _t('auth','rememberme') . '</label>' . PHP_EOL;
      }
      
      $form .= '<p class="forgot_pass"><a href="'.HrefMaker($link_pass).'">'._t('auth', 'forgot_password').'</a></p>' . PHP_EOL;
    } else {
      $form .= '<p><label for="email" class="labelised">' . _t('divers','email') . ' : </label>' . PHP_EOL;
      $form .= '<input type="text" maxlength="100" class="tinytextfield" name="email" id="email" value="'.$form_email.'" /></p>' . PHP_EOL;
      $form .= '<p><label for="firstname" class="labelised">' . ucfirst(_t('user','first_name')) . ' ('. _t('divers','optional') .') : </label>' . PHP_EOL;
      $form .= '<input type="text" maxlength="200" class="tinytextfield" name="firstname" id="firstname" value="'.$form_firstname.'" /></p>' . PHP_EOL;
      $form .= '<p><label for="lastname" class="labelised">' . ucfirst(_t('user','last_name')) . ' ('. _t('divers','optional') .') : </label>' . PHP_EOL;
      $form .= '<input type="text" maxlength="200" class="tinytextfield" name="lastname" id="lastname" value="'.$form_lastname.'" /></p>' . PHP_EOL;

      if(NEWSLETTER_AUTO_SUB == 1) {
      	$form .= '<div class="info">';
      	$form .= '<p>' . _t('user', 'newsletter_subscription_info') . '</p>';
      	if(isset($GLOBALS['lang']['user']['newsletter_law_reference'])) {
      		$form .= '<p>' . _t('user', 'newsletter_law_reference') . '</p>';
      	}
      	$form .= '</div>' . PHP_EOL;
      }
    }
    $form .= '<br />'.PHP_EOL;
    $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . PHP_EOL;
    $form .= '<input type="hidden" name="referer" id="referer" value="' . $back . '" />' . PHP_EOL;
    $form .= '<input type="submit" class="submitbut" value="'._t('btn','valid').'" title="'._t('btn','valid').'" name="valid" id="valid" />'.PHP_EOL;
    $form .= '</div>' . PHP_EOL;
    $form .= '</form>' . PHP_EOL;

    return $form;
  }
}

/**
 * MyGroups()
 * Return groups user has subscribed to
 * nothing if no groups
 * @return string
 */
if(!function_exists('MyGroups')) {
  function MyGroups()
  {

    if(!isset($_COOKIE['linea21']['workshop']) || !isset($_SESSION['authenticated'])) return false;

    global $sql_object;

    $link_account = array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

    // get and prepare user groups
    $groups = base64_decode($_COOKIE['linea21']['workshop']);
    if($groups[0]=='/') $groups = substr($groups, 1); // removing first separator
    if(!empty($groups)) {
      $groups = @explode('/',$groups);
      $data= $sql_object->DBSelect(SQL_Get_WorkshopsNames($groups));
    } else {
      $data=0;
    }

    $content  = '<div id="mygroups">'.PHP_EOL;
    $content .= '<h2>'._t('groups', 'mine').'</h2>'.PHP_EOL;
    if($data!=0)
    {
      $content .= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[$i]['workshop_id']);
        $workshop_title =  formatText($data[$i]['workshop_denomination'], '2HTML');

        $content .= '<li><a href="'.HrefMaker($link).'" title="'.formatText($data[$i]['workshop_denomination'], '2ATT').'">'.$workshop_title.'</a></li>';

      }
      $content .= '</ul>';
    } else {
      return false;
    }
    $content .= '</div>';

    return $content;
  }
}

if(!function_exists('DisplayProjectBoard')) {
  function DisplayProjectBoard() {
    $content ='';
    if(ActiveItemKey($GLOBALS['activeitem']) == 'home') {
      $content .= '<a href="'.HrefMaker(array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'])).'" title="'.$GLOBALS['links'][U_L]['project']['title'].'">'.$GLOBALS['links'][U_L]['project']['title'].'</a>';
      $content .= '<br />';
    }
    echo $content;
  }
}

if(!function_exists('DisplayNewsletterForm')) {
  function DisplayNewsletterForm() {
    $action=$GLOBALS['links'][U_L]['subscribe-newsletter']['linkvalue'];

    $form  = '<div id="newsletter-form">' . PHP_EOL;
    $form .= '<form action="index.php" method="post">' . PHP_EOL;
    $form .= '<h2>'.mb_ucfirst(_t('menu_alt','newsletter')).'</h2>';
    $form .= '<div class="sidebar-content">' . PHP_EOL;
    $form .= '<label for="newsletteremail">' . mb_ucfirst(_t('divers','email')) . ' : </label>' . PHP_EOL;
    $form .= '<input type="text" maxlength="200" size="19" class="tinytextfield" name="newsletteremail" id="newsletteremail" />' . PHP_EOL;
    $form .= '<input type="submit" value="'.mb_ucfirst(_t('btn','valid')).'" title="'._t('btn','valid').'" name="valid"  id="valid_newsletter" />'.PHP_EOL;
    $form .='<br />';
    $form .= '<input type="hidden" name="rub" id="rub_newsletter" value='.$GLOBALS['links'][U_L]['subscribe-newsletter']['linkvalue'].' />' . PHP_EOL;
    $form .='<p class="newsletter-unsubscribe">';
    $form .= '<input type="checkbox" name="del_action" id="del_action" style="float:left;margin:0em 1em 0 3.2em" />';
    $form .= '<label for="del_action" class="checkboxlab">'.mb_ucfirst(_t('newsletter','unsubscribe')).'</label>' . PHP_EOL;
    $form .='</p>';
    $form .= '</div>' . PHP_EOL;
    $form .= '</form>' . PHP_EOL;
    $form .= '</div>' . PHP_EOL;

    echo $form;
  }
}

if(!function_exists('DisplayBoardLastNews')) {
  function DisplayBoardLastNews($nb) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_Get_NewsBoard($nb));

    $content = '<div id="recentNews">'.PHP_EOL;
    //$content.= '<p>'._t('divers','actu_left').'</p>';
    $content.= '<h2>'._t('divers','actu_left').'</h2>';
    if($data!=0)
    {
      $content.= '<ul>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $title=formatText($data[$i]['news_title'],'2HTML');
        $link_table= array('rub'=> $GLOBALS['links'][U_L]['news']['linkvalue'],'id'=>$data[$i]['news_id'], 'name' => $data[$i]['news_title']);
        $content.='<li><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][U_L]['news']['desc'].' : '.$title, '2ATT').'">'.$title.'</a>';
        #$content.='<em>'._t('statut', 'published_on').' '.$data[$i]['news_published_date_display'].'</em>'.PHP_EOL;
        $content.='</li>'.PHP_EOL;
      }
      $content.= '</ul>'.PHP_EOL;
    }
    else
    {
      $content.='<p>'._t('divers','nodata').'</p>';
    }
    $content.= '</div>'.PHP_EOL;

    echo $content;
  }
}

if(!function_exists('DisplayBoardLastSdi')) {
  function DisplayBoardLastSdi($nb = 3) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_Get_SdiBoard($nb));

    $content = '<div id="recentIndicators">'.PHP_EOL;
    $content.= '<h2>'._t('divers','sdi_left').'</h2>';
    if($data!=0)
    {
      $content.= '<ul>'.PHP_EOL;
      $test=array();
      for($i=0; $i<count($data); $i++) {
        if (!in_array($data[$i]['sdii_id'], $test) && count($test)< $nb){
          $test[$i]=$data[$i]['sdii_id'];
          $title=formatText($data[$i]['sdii_name'],'2HTML');
          $link_table= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$data[$i]['sdii_id'], 'parentid'=>$data[$i]['sdiv_scale'], 'name' => $data[$i]['sdii_name'] );
          $content.='<li><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][U_L]['dashboard']['desc'].' : '.$title, '2ATT').'">'.$title.'</a>';
          $content.='</li>'.PHP_EOL;
        }
      }
      $content.= '</ul>'.PHP_EOL;
    }
    else
    {
      $content.=_t('divers','nodata');
    }
    $content.= '</div>'.PHP_EOL;

    echo $content;
  }
}


if(!function_exists('DisplaySearchForm')) {
  function DisplaySearchForm() {

    $action=$GLOBALS['links'][U_L]['search-result']['linkvalue'];

    $form ='<div id="search-input">'.PHP_EOL;
    $form.='<form action="index.php" method="get">'.PHP_EOL;
    $form.= '<h2>'._t('menu','search').'</h2>';
    $form.= '<div class="sidebar-content">' . PHP_EOL;
    $form.='<label for="search">'._t('menu','search').' </label>'.PHP_EOL;
    $form.='<input type="text" maxlength="100" name="search" id="search" accesskey="4" class="tinytextfield" />'.PHP_EOL;
    $form.='<input type="hidden" name="rub" id="rub_search" value="'.$GLOBALS['links'][U_L]['search-result']['linkvalue'].'" />' . PHP_EOL;
    $form.='<input type="submit" value="'.mb_ucfirst(_t('btn','valid')).'" name="valid" id="validsearch" />'.PHP_EOL;
    $form.='<p id="searchadv">';
    $form.='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['search']['linkvalue'])).'" title="'.formatText($GLOBALS['links'][U_L]['search']['title'], '2ATT').'">';
    $form.=mb_ucfirst(_t('menu','advancedsearch'));
    $form.='</a>';
    $form.='</p>';
    $form.='</div>'.PHP_EOL;
    $form.='</form>'.PHP_EOL;
    $form.='</div>'.PHP_EOL;


    echo $form;
  }
}

if(!function_exists('displayDefaultFooter')) {
  function displayDefaultFooter() {
    $content='<a href="mailto:'.SITE_MAIL.'" ';
    $content.='title="'.SITE_MAIL.'" >'._t('divers','contact').' </a> | ';
    $content.='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['accessibility']['linkvalue'])).'" ';
    $content.='title="'.formatText(_t('divers','accessibility'), '2ATT').'" accesskey="0"> '._t('divers','accessibility').' </a>  | <a href="rss2.php" title="RSS">RSS</a>';
    if(isset($_SESSION['authenticated']) && !$GLOBALS['l21auth']->isSimpleUser())  {
      	$content.=' | <a href="../admin/index.php" title="'. _t('header','title').'">'. _t('admin','console').'</a>';
    }
    echo $content;
  }
}

?>