<?php
/**
 * Default filters functions
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


// @todo the way filters are handled should be enhanced


/**
 * DisplayFilter()
 * Call specific filters functions
 * filters are defined in config/define_globals.php
 * filters methods are declared in this file.
 * @return void
 */
function DisplayFilter() {

  $content='';
  if(is_array($GLOBALS['filters'][U_L])) {
    $bool = (in_array(1, array_values($GLOBALS['filters'][U_L]))) ? true : false;
    if($bool) echo '<div id="filtercontent">'.PHP_EOL;
    while (list($key,$value) = each ($GLOBALS['filters'][U_L])) {
      if($value['active'] == 1 && function_exists('Get'.ucfirst($key).'Filter')) {
        eval('Get'.ucfirst($key).'Filter();');
      }
    }
    if($bool) echo '</div>'.PHP_EOL;
  }
}

/**
 * GetPriorityFilter()
 * Display a list of priorities
 * as filter criteria
 * @return void
 */
function GetPriorityFilter() {
  $result=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterPriority());
  $list="<div class=\"filterpriority\">".PHP_EOL;
  $list.= "<h2>"._t('divers','priority_choice')."</h2>".PHP_EOL;
  $list.= "<ul>".PHP_EOL;
  $item_active=ActiveItemAlias($GLOBALS['activeitem']);
  for ($i=0;$i<count($result);$i++){
    $name=formatText(cutText($result[$i]['priority_name'],50), '2HTML');
    if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter']==$GLOBALS['filters'][U_L]['priority']['linkvalue'] && $_REQUEST['id']==$result[$i]['priority_id']) {
      $list.="<li>".$name."</li>".PHP_EOL;
    } else {
      $url = array('rub' => $GLOBALS['links'][U_L][$item_active]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['priority']['linkvalue'], 'id' => $result[$i]['priority_id'], 'name'=> $result[$i]['priority_name']);
      $list.="<li><a href=\"".Hrefmaker($url)."\" title=\"".$GLOBALS['filters'][U_L]['priority']['desc'].' : '.$name."\">".$name."</a></li>".PHP_EOL;
    }
  }
  $list.="</ul></div>".PHP_EOL;
  echo $list;

}
/**
 * GetThemeFilter()
 * Display a list of themes
 * as filter criteria
 * @return void
 */
function GetThemeFilter() {
  $result_sdtheme=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterTheme());
  $sdtheme_list="<div class=\"filtertheme\">".PHP_EOL;
  $sdtheme_list.= "<h2>"._t('divers','themeref_choice')."</h2>".PHP_EOL;
  $sdtheme_list.= "<ul>".PHP_EOL;
  $item_active=ActiveItemAlias($GLOBALS['activeitem']);
  for ($i=0;$i<count($result_sdtheme);$i++){
    $sdtheme_display=formatText(cutText($result_sdtheme[$i]['sdtheme_name'],50), '2HTML');
    if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter']==$GLOBALS['filters'][U_L]['theme']['linkvalue'] && $_REQUEST['id']==$result_sdtheme[$i]['sdtheme_id']) {
      $sdtheme_list.="<li>".$sdtheme_display."</li>".PHP_EOL;
    } else {
      $URLtheme = array('rub' => $GLOBALS['links'][U_L][$item_active]['linkvalue'], 'filter' => $GLOBALS['filters'][U_L]['theme']['linkvalue'], 'id' => $result_sdtheme[$i]['sdtheme_id'], 'name'=> $result_sdtheme[$i]['sdtheme_name']);
      $sdtheme_list.="<li><a href=\"".Hrefmaker($URLtheme)."\" title=\"".$GLOBALS['filters'][U_L]['theme']['desc'].' : '.$sdtheme_display."\">".$sdtheme_display."</a></li>".PHP_EOL;
    }
  }
  $sdtheme_list.="</ul></div>".PHP_EOL;
  echo $sdtheme_list;
}

/**
 * GetScaleFilter()
 * Build the form and include
 * a select box filledd-up by scales
 * @return void
 */
function GetScaleFilter() {

	$rubname = $GLOBALS['activeitem'];

  $scale_list='<form action="index.php" method="get">'.PHP_EOL;
  $scale_list.="<div class=\"filterscale\">".PHP_EOL;
  $scale_list.="<h2>"._t('divers','scale_choice')."</h2>".PHP_EOL;
  if(isset($_REQUEST['parentid'])) {
  	$scale_list.=GetScaleSelectBox('parentid');
  	$scale_list.='<input type="hidden" value="'.$_REQUEST['id'].'" name="id" id="id_scale" />'.PHP_EOL;
  } else {
  	$scale_list.=GetScaleSelectBox();
  }

  $scale_list.='<input type="hidden" value="'.$GLOBALS['filters'][U_L]['scale']['linkvalue'].'" name="filter" id="filter" />'.PHP_EOL;
  $scale_list.='<input type="hidden" value="'.$rubname.'" name="rub" id="rub_scale" />'.PHP_EOL;
  if(isset($_REQUEST['altmode'])) {
  	$scale_list.='<input type="hidden" value="true" name="altmode" id="altmode_scale" />'.PHP_EOL;
  }
  $scale_list.='<input type="submit"  value="'._t('btn','valid').'" title="'._t('btn','valid').'" name="valid" id="valid" />'.PHP_EOL;
  $scale_list.="</div>".PHP_EOL;
  $scale_list.='</form>'.PHP_EOL;
  echo $scale_list;
}

/**
 * GetScaleSelectBox()
 * Called by GestFilterScale()
 * Prepare select Box items
 * @return string
 */
function GetScaleSelectBox($field_name = 'id') {
  if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter']==$GLOBALS['filters'][U_L]['scale']['linkvalue']) $current_id=$_REQUEST['id']; else $current_id=-1;
  if(ActiveItemAlias($GLOBALS['activeitem'])=='dashboard' && isset($_REQUEST['parentid'])) $current_id=$_REQUEST['parentid'];

  if (ActiveItemAlias($GLOBALS['activeitem'])==$GLOBALS['links'][U_L]['news']['linkvalue']) {
    $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterScale("I"));
  }
  else $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_FilterScale());

  $scale_list='';
  $item_active=ActiveItemAlias($GLOBALS['activeitem']);
  for ($i=0;$i<count($data);$i++){
    if($data[$i]['scale_id']==$current_id) {
      $mask=' selected="selected"';
    } else $mask='';
    $scale_display=formatText(cutText($data[$i]['scale_denomination'],20));
    $scale_list.="<option value=\"".$data[$i]['scale_id']."\"".$mask.">".$scale_display."</option>".PHP_EOL;
  }
  $select_scale ='<select name="'.$field_name.'" id="scaleFilter'.$field_name.'">'.PHP_EOL;
  $select_scale.='<option value="1">'._t('divers','select_choice2').'</option>'.PHP_EOL;
  $select_scale.=$scale_list;
  $select_scale.='</select>'.PHP_EOL;

  return $select_scale;
}

?>