<?php
/**
 * Default message template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
if( ActiveItemKey($GLOBALS['activeitem']) =='comment-unsubscribe') {
  // set HTML Title
  SetHTMLTitle(_t('comment','unsubscribe_title'));
  setBreadcrumb(array(_t('comment','unsubscribe_title') => false));
  $a['module']= $_GET['name'];
  $a['module_id']= $_GET['id'];
  $a['email']= $_GET['email'];
  include_once('../class/class.comment.php');
  $comm = new comment;
  $r = $comm->unsubscribe($a, $GLOBALS['sql_object']);

  $item = $comm->getCommentItem($a, $GLOBALS['sql_object']);
  $itemM = itemMapping($a['module']);

  $full_item = $item[0]['item_title'] .' ('.$itemM['name'].')';

  echo '<h1>'._t('comment','unsubscribe_title').'</h1>'.PHP_EOL;
  if($r === true) {
    echo '<div class="confirm">'.PHP_EOL;
    echo $full_item . ' : ' ._t('comment','unsubscribe_successful').PHP_EOL;
    echo '</div>'.PHP_EOL;
  }

}


if( ActiveItemKey($GLOBALS['activeitem']) =='subscribe-newsletter') {
  // set HTML Title
  SetHTMLTitle(_t('newsletter','subscribe_title'));
  setBreadcrumb(array(_t('newsletter','subscribe_title') => false));
  include_once('../newsletter/subscribe.php');
  echo '<h1>'._t('newsletter','subscribe_title').'</h1>'.PHP_EOL;
  echo '<div class="sub-title">'.PHP_EOL;
  echo _t('divers','newsletter_public_comment').PHP_EOL;
  echo '</div>'.PHP_EOL;
  if(isset($msg)) {
    echo '<div class="'.$msg['code'].'">'.PHP_EOL;
    echo $msg['string'].PHP_EOL;
    echo '</div>'.PHP_EOL;
  }

}

if( ActiveItemKey($GLOBALS['activeitem']) =='contact') {
  // set HTML Title
  SetHTMLTitle(_t('contact','contact_us'));
  setBreadcrumb(array(_t('contact','contact_us') => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['contact']['linkvalue']))));
  include_once('../class/system/class.form.php');

  $name='';
  $email='';
  $subject='';
  $body='';

  if(isset($_POST['name'])) {
    $passed = true;
    $name=$_POST['name'];
    $email=$_POST['email'];
    $subject=$_POST['subject'];
    $body=$_POST['body'];

    if(strlen($body)< 8) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'body'));
      $class='error';
      $passed = false;
    }
    if(strlen($subject)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'subject'));
      $class='error';
      $passed = false;
    }
    if(!validEmail($email)) {
      $msg=sprintf(_t('contact','email_error'), $email);
      $class='error';
      $passed = false;
    }
    if(strlen($email)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'email'));
      $class='error';
      $passed = false;
    }
    if(strlen($name)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'name'));
      $class='error';
      $passed = false;
    }
    if($passed == true) {
      $class = 'info';
      $msg = _t('contact', 'message_sent');
      include_once(override('../mail/send.php'));
      $emailContainer['recipient'] = SITE_MAIL;
      $emailContainer['from_name'] = $name;
      $emailContainer['from'] = $email;
      $emailContainer['reply_to'] = array( $email => $name);
      $emailContainer['subject'] = formatText($subject, '2HTML') . ' - '. SITE_NAME;
      $emailContainer['html_body'] = formatText($body, '2HTML');
      $emailContainer['txt_body'] = strip_tags($emailContainer['html_body']);
      $r = send_email($emailContainer);
      
      if(isset($_POST['receive_copy'])) {
      	$emailContainer['recipient'] = $email;
      	$emailContainer['subject'] .= $emailContainer['subject']. ' ('._t('contact','copy') .')';
      	$emailContainer['html_body'] = '<p><strong>'. _t('contact','copy'). ' : </strong></p> ' . $emailContainer['html_body'];
      	$emailContainer['txt_body'] = ''. _t('contact','copy'). ' :\n' .$emailContainer['txt_body'];
      	
      	$r = send_email($emailContainer);
      }
    }
  }

  echo '<h1>'._t('contact','contact_us').'</h1>'.PHP_EOL;
  if(isset($passed)) echo '<div class="'.$class.'">'.$msg.'</div>'.PHP_EOL;

  if(!isset($passed) || $passed == false) {
    $form = new genForm;
    $form->startForm('index.php', '#contactform');
    $form->textInput('name', mb_ucfirst(_t('contact', 'name')). ' : ', 'shorttextfield', 'labelised', 'title', 100, 30, false, $name, false);
    $form->insertBR();
    $form->textInput('email', mb_ucfirst(_t('contact', 'email')). ' : ', 'shorttextfield', 'labelised', 'title', 150, 30, false, $email, false);
    $form->insertBR();
    $form->textInput('subject', mb_ucfirst(_t('contact', 'subject')). ' : ', 'shorttextfield', 'labelised', 'title', 150, 30, false, $subject, false);
    $form->insertBR();
    $form->textareaInput('body',mb_ucfirst(_t('contact', 'body')) .' : ',false,'labelised', false, $body, 60, 10);
    $form->insertHTML('<div class="label-leftmargin">');
    $form->checkboxInput('checkbox', 'receive_copy', 1, _t('contact', 'receive_copy'), true, 'after', false, 'labelised autowidth');
    $form->insertHTML('</div>');
    $form->submitButton(false, _t('btn', 'valid'), true, 'submitbut');
    $form->hiddenInput('rub', $_REQUEST['rub']);
    $form->closeForm();
    if(!$output = $form->getForm()) { die("error: " . $form->error); }
    else { echo $output; }
  }
}

?>