<?php
/**
 * Default workgroup subscription template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../class/system/class.form.php');
include_once('../class/class.workshop.php');
include_once('../workshop/'.SQL.'.inc.php');

isset($_SESSION['authenticated']) ?  $isAuthentified = true : $isAuthentified = false;

if(isset($_REQUEST['id'])) {
  $_POST['workgroup_'.$_REQUEST['id']] = true;
  $link_back = HrefMaker(array('rub'=>$GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id'=> $_REQUEST['id']));
}
$link_registration = array('rub'=> $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
$link_account = array('rub'=> $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

function ischecked($id) {
  if(isset($_POST['workgroup_'.$id]))  return true;
  else return false;
}

function isWgselected($workgroups) {
  for($i=0; $i<count($workgroups); $i++) {
    $var = 'workgroup_'.$workgroups[$i]->workshop_id;
    if(isset($_POST[$var])) return true;
  }
  return false;
}

function getSelectedwg($workgroups) {
  $a = array();
  for($i=0; $i<count($workgroups); $i++) {
    $var = 'workgroup_'.$workgroups[$i]->workshop_id;
    if(isset($_POST[$var])) array_push($a, $workgroups[$i]->workshop_id);
  }

  return $a;
}
?>

<?php
// set HTML Title
SetHTMLTitle(_t('workshop','get_involve_long'));
setBreadcrumb(array(ucfirst(_t('workshop', 'section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']))));
setBreadcrumb(array(_t('workshop','get_involve') => false));

// workshops
$workgroups = $GLOBALS['sql_object']->DBSelect(SQL_Get_WorkshopsNames(), 'OBJECT');
// we init an array to see if user has already subscribed all groups
$subscribed = array();

if(isset($workgroups[0]->workshop_id)) {
	for($i=0; $i<count($workgroups); $i++) {
		
		// we do not test restricted workshop
		if($workgroups[$i]->workshop_restricted == 0) {
		  if($GLOBALS['l21auth']->isWorkgroupUser($workgroups[$i]->workshop_id, $GLOBALS['sql_object']) || $GLOBALS['l21auth']->isWorkgroupPendingUser($workgroups[$i]->workshop_id, $GLOBALS['sql_object'])) {
		    array_push($subscribed, true);
		  } else {
		    array_push($subscribed, false);
		  }
		}
	}
}
?>
<h1>

<?php echo _t('workshop','get_involve_long'); ?></h1>
<div>


<?php
$comment='';

if(isset($_POST['comment'])) {

  $msg='';

  // sélection d'au moins un groupe
  if (!isWgselected($workgroups)) $msg.=_t('workshop','nogroup_selected').'<br />';
  else {
    $allgroups='';
    $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_WorkshopsNames(getSelectedwg($workgroups)), 'OBJECT');

    $a = array();
    foreach($data as $el) {
      $allgroups.= " - ".$el->workshop_denomination. " <i>(id: ".$el->workshop_id.")</i><br />\n";

      // notify moderators by mail if set-up
			if(defined('ALERT_NEWSUB' && ALERT_NEWSUB == 1)) notifyUsersMsg(array('action' => 'workgroup_request','user' => $_SESSION['userlogin'], 'id' => $el->workshop_id, 'moderate_link' => SITE_ROOT_URL . 'admin/index.php#workgroup-users', 'comment' => strip_tags($_POST['comment'])));
    }
  }

  if(empty($msg)) {
    $passed = true;
    $class='confirm';
    $msg .= _t('workshop', 'confirm_request');
    if(isset($link_back)) $msg .= ' <a href="'.$link_back.'" title="'._t('workshop','workshop_back').'" >'._t('workshop','workshop_back').'</a>.'.PHP_EOL;
    // not used anymore -- $linkuser = 'index.php?rub=user&todo=mod&id='.base64_decode($_SESSION['userid']).'#groups';
    
    $workshop_object = new workshop;
    foreach($data as $el) {
    	$workshop_object->AddUserWorkshop($el->workshop_id, $_SESSION['userlogin'], 'A', $GLOBALS['sql_object']);
    }

    // Send mail to SITE_MAIL
    include_once(override('../mail/mail_actions.php'));
    include_once(override('../mail/send.php'));
    
    /** include email template */
    $a['action']='workgroup_request';
    $a['moderate_link'] = SITE_ROOT_URL . 'admin/index.php#workgroup-users';
    $a['wgroups'] = $allgroups; // settings '$groups' var here because also used by notifyUsersMsg method
    $a['comment'] = strip_tags($_POST['comment']);
    $a['recipient'] = SITE_MAIL;
    
    $emailContainer = prepare_email($a);
    $r = send_email($emailContainer);

  } else {
    $passed = false;
    $class='error';
  }
}

if(isset($passed)) echo '<div class="'.$class.'">'.$msg.'</div>';

if(!$isAuthentified) {

  echo '<p class="warning">'._t('workshop','note_account').' ' . '<a href="'.HrefMaker($link_account).'" title="'.formatText(_t('divers','auth'), '2ATT').'" >'._t('divers','auth').'</a>.<br />'.PHP_EOL;
  echo '<a href="'.HrefMaker($link_registration).'">'._t('user','info_inscription2').' </a></p>';

} else {
  // affichage s'il manque un champs
  if(!isset($passed) || $passed == false) {

    // the user has not subscribed all groups, we display the form
    if(in_array(false, $subscribed)) {

      $form = new genForm;
      $form->startForm('index.php', '#wg-subscription');
      $form->insertHTML('<div id="choosegdt">'._t('workshop','subscribe_to').' : </div>');
      $form->insertHTML('<div class="label-leftmargin">');
      for($i=0; $i<count($workgroups); $i++) {
        if(!$GLOBALS['l21auth']->isWorkgroupUser($workgroups[$i]->workshop_id, $GLOBALS['sql_object'])) {

        	// if group is restricted users are not allowed to subscribed
        	if($workgroups[$i]->workshop_restricted != 1) {
          	// we remove the workgroups user already belongs to
          	$form->checkboxInput('checkbox','workgroup_'.$workgroups[$i]->workshop_id, $workgroups[$i]->workshop_id, $workgroups[$i]->workshop_denomination, ischecked($workgroups[$i]->workshop_id), 'after', 'cb', 'labelised autowidth');
        	}
        }
      }
      $form->insertHTML('</div>');
      $form->textareaInput('comment',ucfirst(_t('divers', 'comment')).' ('._t('divers', 'optional').') : ',false,'labelised', false, $comment, 60, 10);
      $form->insertBR();
      $form->submitButton(false, _t('btn', 'valid'), true, 'submitbut');
      $form->hiddenInput('rub', $_REQUEST['rub']);
      if(isset($_REQUEST['id'])) $form->hiddenInput('id', $_REQUEST['id']);
      $form->closeForm();
      if(!$output = $form->getForm()) {
        die("error: " . $form->error);
      }
      else {
        echo $output;
      }
      // the user already subscribed all groups, we display a warning
    } else {
      echo '<p class="warning">'._t('workshop', 'allgroups_subscribed').'</p>'.PHP_EOL;
    }
  }
}

?></div>
