<?php
/**
 * Publication module
 * 
 * Publication detail page
 * 
 * @package linea21\modules\publication
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];


$req_det= SQL_getoneCompletePublication($id);
$result=$sql_object->DBSelect($req_det);

// Do record exists?
if(!isset($result[0]['publi_title'])) redirect_to('@module_default');

$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";

$publi_title=formatText($result[0]['publi_title'], '2HTML');
$publi_resume=formatText($result[0]['publi_resume'], '2HTML');
if(empty($result[0]['publi_comment'])) $publi_comment=_t('divers','none');
else $publi_comment=formatText($result[0]['publi_comment'], '2HTML');
$theme_denomination=formatText(empty_none($result[0]['theme_name'], '2HTML'));
$scale_denomination=formatText(empty_none($result[0]['scale_denomination'], '2HTML'));
$publi_user_login=formatText($result[0]['user_login'], '2HTML');
$publi_statut=display_statut($result[0]['publi_statut']);
$display_date_crea=$result[0]['publi_date_crea_display'];
$display_last_modify=$result[0]['publi_last_modify_display'];
if($result[0]['publi_published_date_display']=='01-01-0001') $display_published_date=_t('publication','not_published');
else $display_published_date=$result[0]['publi_published_date_display'];
$publi_theme_id=$result[0]['publi_theme'];
$publi_scale_id=$result[0]['publi_scale'];
$publi_owner=$result[0]['publi_posted_by'];

// getting tags
include_once('../class/class.tag.php');
$otag = new tag();
$display_tags = empty_none($otag->getTags('publication', $id, true));

// formattage des données
include_once('../class/class.resources.php');
$resources_object = new resources;


//prepa affichage des infos générales
$reca_generals="<h3 class=\"part\">\n"._t('publication','generals')." : </h3>\n";
$reca_generals.="<dl class=\"summary\">\n";
$reca_generals.="<dt>".mb_ucfirst(_t('publication','title'))." :</dt>\n";
$reca_generals.="<dd>". $publi_title."</dd>\n";
$reca_generals.="<dt>". mb_ucfirst(_t('publication','resume')). " :</dt>\n";
$reca_generals.="<dd>".$publi_resume."</dd>\n";
if($l21auth->isSuperAdmin()) {
	$reca_generals.="<dt>".mb_ucfirst(_t('publication','author'))." :</dt>\n";
	$reca_generals.='<dd><a href="?rub=user&amp;todo=det&amp;id='.$publi_owner.'">' . $publi_user_login . '</a></dd>'.PHP_EOL;
  $reca_generals.="<dt>".mb_ucfirst(_t('publication','theme'))." :</dt>\n";
  $reca_generals.='<dd><a href="?rub=theme&amp;todo=det&amp;id='.$publi_theme_id.'">' . $theme_denomination . '</a></dd>'.PHP_EOL;
  $reca_generals.="<dt>".mb_ucfirst(_t('publication','scale'))." :</dt>\n";
  $reca_generals.='<dd><a href="?rub=scale&amp;todo=det&amp;id='.$publi_scale_id.'">' . $scale_denomination . '</a></dd>'.PHP_EOL;
} else {
	$reca_generals.="<dt>".mb_ucfirst(_t('publication','author'))." :</dt>\n";
	$reca_generals.="<dd>".$publi_user_login."</dd>\n";
  $reca_generals.="<dt>".mb_ucfirst(_t('publication','theme'))." :</dt>\n";
  $reca_generals.="<dd>".$theme_denomination."</dd>\n";
  $reca_generals.="<dt>".mb_ucfirst(_t('publication','scale'))." :</dt>\n";
  $reca_generals.="<dd>".$scale_denomination."</dd>\n";
}
$reca_generals.="<dt>".mb_ucfirst(_t('tag','name'))." :</dt>\n";
$reca_generals.="<dd>".$display_tags."</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('publication','published_on')) ." :</dt>\n";
$reca_generals.="<dd>".$display_published_date. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('divers','date_crea')) ." :</dt>\n";
$reca_generals.="<dd>". $display_date_crea. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('divers','last_modify')) ." :</dt>\n";
$reca_generals.="<dd>". $display_last_modify. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
$reca_generals.="<dd>". $publi_statut. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('publication','comment'))." :</dt>\n";
$reca_generals.="<dd>". $publi_comment. "</dd>\n";
$reca_generals.="</dl>\n";


//prepa affichage des différentes parties du dossier
$part_link_add="?rub=contents&amp;todo=add&amp;parent=".$id."&amp;type=P";
$part_link_sup="?rub=contents&amp;todo=sup&amp;parent=".$id."&amp;type=P&amp;id=";
$part_link_mod="?rub=contents&amp;todo=mod&amp;parent=".$id."&amp;type=P&amp;id=";
$part_link_det="?rub=contents&amp;todo=det&amp;parent=".$id."&amp;type=P&amp;id=";
$req_parts=SQL_getPublicationParts($id);
$result=$sql_object->DBSelect($req_parts);
if($result==0) $contents_parts="<div class=\"info\">"._t('publication','no_part')."</div>";
else {

  $contents_parts ="<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable\" id=\"sort-part\">\n";
  $contents_parts.="<tbody>\n";


  for($i=0; $i<count($result); $i++) {
    $contents_parts.="<tr id=\"part-".$result[$i]['publicon_id']."\">\n";
    $contents_parts.="<td><a href=\"".$part_link_det.$result[$i]['publicon_id']."\">".formatText($result[$i]['publicon_title'],'2HTML')."</a></td>\n";
    $contents_parts.="<td style=\"width:80px\">\n";

    if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
      $contents_parts.="<div class=\"iconetab\">\n";
      $contents_parts.="\t<a href=\"".$part_link_sup.$result[$i]['publicon_id']."\" class=\"ico_sup\" title=\""._t('publication','del_part')."\"><i class=\"icon-trash\"></i><span>" . _t('publication','del_part') . "</span></a>\n";
      $contents_parts.="\t<a href=\"".$part_link_mod.$result[$i]['publicon_id']."\" class=\"ico_mod\" title=\""._t('publication','mod_part')."\"><i class=\"icon-pencil\"></i><span>" . _t('publication','mod_part') . "</span></a>\n";
      $contents_parts.="</div>\n";
    }
    $contents_parts.="</td>\n";
    $contents_parts.="</tr>\n";
  }
  $contents_parts.="</tbody>\n";
  $contents_parts.="</table>\n";
}

$reca_parts ="<br class=\"brendstep\" />\n";
$reca_parts.="<div class=\"toggle_title\">\n";
$reca_parts.="<a href=\"\" class=\"open\">"._t('publication','parts')."</a>\n";
$reca_parts.="</div>\n";
$reca_parts.="<div id=\"publi_part\" class=\"mtm\">\n";
if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
  $reca_parts.="\t<a href=\"".$part_link_add."\" class=\"ico_add2\" title=\""._t('publication','add_new_part')."\"><i class=\"icon-plus-circled\"></i><span>".  _t('publication','add_new_part')."</span></a><br class=\"brendstep\" />\n";
}
$reca_parts.=$contents_parts;
$reca_parts.="</div>\n";
$reca_parts.="<br class=\"brendstep\" />\n";

//prepa affichage des ressources LINK associées
$link_res_add="?rub=resources&amp;todo=add_l&amp;parent=".$id."&amp;type=P";
$link_res_sup="?rub=resources&amp;todo=sup&amp;parent=".$id."&amp;type=P&amp;res=link&amp;id=";
$link_res_mod="?rub=resources&amp;todo=mod_l&amp;parent=".$id."&amp;type=P&amp;res=link&amp;id=";
$result=SQL_GetResources($id, 'PUBLICATION', 'LINK', $sql_object);
if($result==0) {
  $contents_link = "<div class=\"info\">"._t('publication','no_link')."</div>";
} else {
  $contents_link ="<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable\" id=\"sort-link\">\n";
  $contents_link.="<tbody>\n";
  for($i=0; $i<count($result); $i++) {
    $contents_link.="<tr id=\"link-".$result[$i]['linkres_id']."\">\n";
    $contents_link.="<td><a href=\"".$result[$i]['linkres_text']."\" class=\"out\">".formatText($result[$i]['linkres_mask'], '2HTML')."</a></td>\n";
    $contents_link.="<td style=\"width:80px\">\n";
    if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
      $contents_link.="<div class=\"iconetab\">\n";
      $contents_link.="\t<a href=\"".$link_res_sup.$result[$i]['linkres_id']."\" class=\"ico_sup\" title=\""._t('publication','del_link')."\"><i class=\"icon-trash\"></i><span>" . _t('publication','del_link') . "</span></a>\n";
      $contents_link.="\t<a href=\"".$link_res_mod.$result[$i]['linkres_id']."\" class=\"ico_mod\" title=\""._t('publication','mod_link')."\"><i class=\"icon-pencil\"></i><span>" . _t('publication','mod_link') . "</span></a>\n";
      $contents_link.="</div>\n";
    }
    $contents_link.="</td>\n";
    $contents_link.="</tr>\n";
  }
  $contents_link.="</tbody>\n";
  $contents_link.="</table>\n";
}
$reca_link='';
$reca_link.="<div class=\"toggle_title\">\n";
$reca_link.="<a href=\"#\">"._t('publication','link_res')."</a>\n";
$reca_link.="</div>\n";
$reca_link.="<div id=\"res_link\" style=\"display:none;\"  class=\"mtm\">\n";
if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
  $reca_link.="\t<a href=\"".$link_res_add."\" class=\"ico_add2\" title=\""._t('publication','add_new_linkres')."\"><i class=\"icon-plus-circled\"></i><span>".  _t('publication','add_new_linkres')."</span></a><br class=\"brendstep\" />\n";
}
$reca_link.=$contents_link;
$reca_link.="</div>\n";
$reca_link.="<br class=\"brendstep\" />\n";

//prepa affichage des ressources multimedia associées
$multi_res_add="?rub=resources&amp;todo=add_m&amp;parent=".$id."&amp;type=P";
$multi_res_sup="?rub=resources&amp;todo=sup&amp;parent=".$id."&amp;type=P&amp;res=multi&amp;id=";
$multi_res_mod="?rub=resources&amp;todo=mod_m&amp;parent=".$id."&amp;type=P&amp;id=";
$result=SQL_GetResources($id, 'PUBLICATION', 'MULTI', $sql_object);
if($result==0) {
  $contents_multi="<div class=\"info\">"._t('publication','no_multi')."</div>";
} else {
  $contents_multi ="<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable\" id=\"sort-multi\">\n";
  $contents_multi.="<tbody>\n";
  for($i=0; $i<count($result); $i++) {

    if($result[$i]['multires_media_uri'][0]=='m') $multires_link='../'.$result[$i]['multires_media_uri'];
    else $multires_link=$result[$i]['multires_media_uri'];

    $contents_multi.="<tr id=\"multi-".$result[$i]['multires_id']."\">\n";
    $contents_multi.="<td><a href=\"".$multires_link."\" class=\"out\">".formatText($result[$i]['multires_name'],'2HTML')."</a>\n";
    $contents_multi.="<div class=\"text_det\">"._t('publication','description')." : ".formatText($result[$i]['multires_description'],'2HTML')."</div></td>";
    $contents_multi.="<td style=\"width:80px\">\n";
    if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
      $contents_multi.="<div class=\"iconetab\">\n";
      $contents_multi.="\t<a href=\"".$multi_res_sup.$result[$i]['multires_id']."\" class=\"ico_sup\" title=\""._t('publication','del_multi')."\"><i class=\"icon-trash\"></i><span>" . _t('publication','del_multi') . "</span></a>\n";
      $contents_multi.="\t<a href=\"".$multi_res_mod.$result[$i]['multires_id']."\" class=\"ico_mod\" title=\""._t('publication','mod_multi')."\"><i class=\"icon-pencil\"></i><span>" . _t('publication','mod_multi') . "</span></a>\n";
      $contents_multi.="</div>\n";
    }
    $contents_multi.="</td>\n";
    $contents_multi.="</tr>\n";
  }
  $contents_multi.="</tbody>\n";
  $contents_multi.="</table>\n";
}
$reca_multi='';
$reca_multi.="<div class=\"toggle_title\">\n";
$reca_multi.="<a href=\"#\">"._t('publication','multi_res')."</a>\n";
$reca_multi.="</div>\n";
$reca_multi.="<div id=\"res_multi\" style=\"display:none;\" class=\"mtm\">\n";
if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
  $reca_multi.="\t<a href=\"".$multi_res_add."\" class=\"ico_add2\" title=\""._t('publication','add_new_multires')."\"><i class=\"icon-plus-circled\"></i><span>".  _t('publication','add_new_multires')."</span></a><br class=\"brendstep\" />\n";
}
$reca_multi.=$contents_multi;
$reca_multi.="</div>\n";
$reca_multi.="<br class=\"brendstep\" />\n";

//prepa affichage des ressources biblio associés
$biblio_res_add="?rub=resources&amp;todo=add_b&amp;parent=".$id."&amp;type=P";
$biblio_res_sup="?rub=resources&amp;todo=sup&amp;parent=".$id."&amp;type=P&amp;res=biblio&amp;id=";
$biblio_res_mod="?rub=resources&amp;todo=mod_b&amp;parent=".$id."&amp;type=P&amp;id=";
$result=SQL_GetResources($id, 'PUBLICATION', 'BIBLIO', $sql_object);
if($result==0) {
  $contents_biblio="<div class=\"info\">"._t('publication','no_biblio')."</div>";
} else {
  $contents_biblio ="<table cellspacing=\"0\" cellpadding=\"3\" class=\"sortable\" id=\"sort-biblio\">\n";
  $contents_biblio.="<tbody>\n";

  for($i=0; $i<count($result); $i++) {
    if(!empty($result[$i]['bibliores_sub_title'])) $subtitle=formatText($result[$i]['bibliores_sub_title'], '2HTML').'. ';
    else $subtitle='';
    if(!empty($result[$i]['bibliores_editor'])) $editor=formatText($result[$i]['bibliores_editor'], '2HTML').'. ';
    else $editor='';
    if(!empty($result[$i]['bibliores_date'])) $biblio_date=formatText($result[$i]['bibliores_date'], '2HTML');
    else $biblio_date='';

    $contents_biblio.="<tr id=\"biblio-".$result[$i]['bibliores_id']."\">\n";
    $contents_biblio.="<td>\n";
    $contents_biblio.="<span class=\"text_det\">".formatText($result[$i]['bibliores_author'], '2HTML')." - </span><span class=\"text_det_it\">".formatText($result[$i]['bibliores_title'], '2HTML').",</span>\n";
    $contents_biblio.="<p class=\"text_det\">".$subtitle.$editor.$biblio_date."</p>\n";
    $contents_biblio.="</td>\n";
    $contents_biblio.="<td style=\"width:80px\">\n";

    if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
      $contents_biblio.="<div class=\"iconetab\">\n";
      $contents_biblio.="\t<a href=\"".$biblio_res_sup.$result[$i]['bibliores_id']."\" class=\"ico_sup\" title=\""._t('publication','del_biblio')."\"><i class=\"icon-trash\"></i><span>" . _t('publication','del_biblio') . "</span></a>\n";
      $contents_biblio.="\t<a href=\"".$biblio_res_mod.$result[$i]['bibliores_id']."\" class=\"ico_mod\" title=\""._t('publication','mod_biblio')."\"><i class=\"icon-pencil\"></i><span>" . _t('publication','mod_biblio') . "</span></a>\n";
      $contents_biblio.="</div>\n";
    }

    $contents_biblio.="</td>\n";
    $contents_biblio.="</tr>\n";
  }
  $contents_biblio.="</tbody>\n";
  $contents_biblio.="</table>\n";
}
$reca_biblio='';
$reca_biblio.="<div class=\"toggle_title\">\n";
$reca_biblio.="<a href=\"#\">"._t('publication','biblio_res')."</a>\n";
$reca_biblio.="</div>\n";
$reca_biblio.="<div id=\"res_biblio\" style=\"display:none;\" class=\"mtm\">\n";
if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
  $reca_biblio.="\t<a href=\"".$biblio_res_add."\" class=\"ico_add2\" title=\""._t('publication','add_new_bibliores')."\"><i class=\"icon-plus-circled\"></i><span>".  _t('publication','add_new_bibliores')."</span></a><br class=\"brendstep\" />\n";
}
$reca_biblio.=$contents_biblio;
$reca_biblio.="</div>\n";
$reca_biblio.="<br class=\"brendstep\" />\n";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','publication');?></a></li>
	<li><span><?php echo  formatNavTitle(_t('publication','det'). " : " .$publi_title); ?></span>
	</li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
echo "<h2>".formatTitleh2($publi_title)."</h2>\n";
if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
  echo "\t<a href=\"".$link_sup.$id."\" class=\"ico_sup2\" title=\""._t('publication','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('publication','sup') . "</span></a>\n";
  echo "\t<a href=\"".$link_mod.$id."\" class=\"ico_mod2\" title=\""._t('publication','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('publication','mod') . "</span></a>\n";
}
echo "<div>".$reca_generals."</div>";
echo $reca_parts;
echo $reca_link;
echo $reca_multi;
echo $reca_biblio;

// Ability to drag'n drop items
if ($l21auth->GetSessionElement('id') == $publi_owner || $l21auth->isSuperAdmin()) {
	footerAddJS('../lib/js/jquery.tablednd_0_5.js');
	dragTableSettings();
}
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->