<?php
/**
 * Resources module
 * 
 * Provide information regarding latest administration tasks
 * 
 * @package linea21\modules\resources
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Resource' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight($mod_inc)) ReloadIndex('admin');
///////////

$qbx_module=_t('menu',$mod_inc);
if($type=='W') {
  $quickbox_type=_t('resources','qb_title_type_W');
  $suffix_css='w';
}
if($type=='P') {
  $quickbox_type=_t('resources','qb_title_type_P');
  $suffix_css='p';
}


if ($todo == 'add_l') {
  $req_quickbox=GetAddedLink($parent, $type, 'CREA', 10);
  $result=$sql_object->DBSelect($req_quickbox);
  $qbx_liste='';
  $nb='';
  if($result==0) {
    $qbx_liste.="<li>"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_res_title=formatText(cutText($result[$i]['linkres_mask'], 25), '2HTML');
      $qbx_link=$result[$i]['linkres_text'];
      $qbx_liste.="<li><a href=\"".$qbx_link."\" class=\"out\" title=\""._t('divers','date_crea').": ".$result[$i]['linkres_date_crea_display']." \">". $qbx_res_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb._t('resources','qb_titleadd'). $quickbox_type;
}
if ($todo == 'add_b') {
  $req_quickbox=GetAddedBiblio($parent, $type, 'CREA', 10);
  $result=$sql_object->DBSelect($req_quickbox);
  $qbx_liste='';
  $nb='';
  if($result==0) {
    $qbx_liste.="<li>"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_res_title=formatText(cutText($result[$i]['bibliores_title'], 50), '2HTML');
      $qbx_liste.="<li><a href=\"#\" title=\""._t('divers','date_crea').": ".$result[$i]['bibliores_date_crea_display']." \">". $qbx_res_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb._t('resources','qb_titleadd'). $quickbox_type;
}

if ($todo == 'add_m') {
  $req_quickbox=GetAddedMulti($parent, $type, 'CREA', 10);
  $result=$sql_object->DBSelect($req_quickbox);
  $qbx_liste='';
  if($result==0) {
    $nb='';
    $qbx_liste.="<li>"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_res_title=formatText(cutText($result[$i]['multires_name'], 50), '2HTML');
      $qbx_link=$result[$i]['multires_media_uri'];
      $qbx_liste.="<li><a href=\"".$qbx_link."\" class=\"out\" title=\""._t('divers','date_crea').": ".$result[$i]['multires_date_crea_display']." \">". $qbx_res_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb._t('resources','qb_titleadd'). $quickbox_type;
}
if ($todo == 'mod_l') {
  $req_quickbox=GetAddedLink($parent, $type, 'MODIFY', 10);
  $result=$sql_object->DBSelect($req_quickbox);
  $qbx_liste='';
  $nb='';
  if($result==0) {
    $qbx_liste.="<li>"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_res_title=formatText(cutText($result[$i]['linkres_mask'], 25), '2HTML');
      $qbx_link=$result[$i]['linkres_text'];
      $qbx_liste.="<li><a href=\"".$qbx_link."\" class=\"out\" title=\""._t('divers','last_modify')." ".$result[$i]['linkres_last_modify_display']." - ("._t('divers','date_crea').": ".$result[$i]['linkres_date_crea_display'].") \">". $qbx_res_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb.''._t('resources','qb_titlemod'). $quickbox_type;
}
if ($todo == 'mod_m') {
  $req_quickbox=GetAddedMulti($parent, $type, 'MODIFY', 10);
  $result=$sql_object->DBSelect($req_quickbox);
  $qbx_liste='';
  $nb='';
  if($result==0) {
    $qbx_liste.="<li>"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_res_title=formatText(cutText($result[$i]['multires_name'], 50), '2HTML');
      $qbx_link=$result[$i]['multires_media_uri'];
      $qbx_liste.="<li><a href=\"".$qbx_link."\" class=\"out\" title=\""._t('divers','last_modify')." ".$result[$i]['multires_last_modify_display']." - ("._t('divers','date_crea').": ".$result[$i]['multires_date_crea_display'].") \">". $qbx_res_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb._t('resources','qb_titlemod'). $quickbox_type;
}


if ($todo == 'mod_b') {
  $req_quickbox=GetAddedBiblio($parent, $type, 'MODIFY', 10);
  $result=$sql_object->DBSelect($req_quickbox);
  $qbx_liste='';
  $nb='';
  if($result==0) {
    $qbx_liste.="<li>"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_res_title=formatText(cutText($result[$i]['bibliores_title'], 50), '2HTML');
      $qbx_liste.="<li><a href=\"#\" title=\""._t('divers','last_modify')." ".$result[$i]['bibliores_last_modify_display']." - ("._t('divers','date_crea').": ".$result[$i]['bibliores_date_crea_display'].") \">". $qbx_res_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb._t('resources','qb_titlemod'). $quickbox_type;
}
if ($todo == 'sup') {
  if($res=='link') {
    $req_quickbox=GetAddedLink($parent, $type, 'MODIFY', 10, 'N');
    $result=$sql_object->DBSelect($req_quickbox);
    $qbx_liste='';
    $nb='';
    if($result==0) {
      $qbx_liste.="<li>"._t('divers','nodata')."</li>";
    } else {
      if(count($result)>=10) $nb=10; else $nb=count($result);
      for($i=0; $i<count($result); $i++) {
        $qbx_res_title=formatText(cutText($result[$i]['linkres_mask'], 25), '2HTML');
        $qbx_link=$result[$i]['linkres_text'];
        $qbx_liste.="<li><a href=\"".$qbx_link."\" class=\"out\" title=\""._t('divers','date_sup')." ".$result[$i]['linkres_last_modify_display']." - ("._t('divers','date_crea').": ".$result[$i]['linkres_date_crea_display'].") \">". $qbx_res_title ."</a></li>\n";
      }
    }
    $qbx_h1=$nb._t('resources','qb_titlesup'). $quickbox_type;
  }
  if($res=='multi') {
    $req_quickbox=GetAddedMulti($parent, $type, 'MODIFY', 10, 'N');
    $result=$sql_object->DBSelect($req_quickbox);
    $qbx_liste='';
    $nb='';
    if($result==0) {
      $qbx_liste.="<li>"._t('divers','nodata')."</li>";
    } else {
      if(count($result)>=10) $nb=10; else $nb=count($result);
      for($i=0; $i<count($result); $i++) {
        $qbx_res_title=formatText(cutText($result[$i]['multires_name'], 50), '2HTML');
        $qbx_liste.="<li><a href=\"#\" title=\""._t('divers','date_sup')." ".$result[$i]['multires_last_modify_display']." - ("._t('divers','date_crea').": ".$result[$i]['multires_date_crea_display'].") \">". $qbx_res_title ."</a></li>\n";
      }
    }
    $qbx_h1=$nb._t('resources','qb_titlesup'). $quickbox_type;
  }
  if($res=='biblio') {
    $req_quickbox=GetAddedBiblio($parent, $type, 'MODIFY', 10, 'N');
    $result=$sql_object->DBSelect($req_quickbox);
    $qbx_liste='';
    $nb='';
    if($result==0) {
      $qbx_liste.="<li>"._t('divers','nodata')."</li>";
    } else {
      if(count($result)>=10) $nb=10; else $nb=count($result);
      for($i=0; $i<count($result); $i++) {
        $qbx_res_title=formatText(cutText($result[$i]['bibliores_title'], 50), '2HTML');
        $qbx_liste.="<li><a href=\"#\" title=\""._t('divers','date_sup')." ".$result[$i]['bibliores_last_modify_display']." - ("._t('divers','date_crea').": ".$result[$i]['bibliores_date_crea_display'].") \">". $qbx_res_title ."</a></li>\n";
      }
    }
    $qbx_h1=$nb._t('resources','qb_titlesup'). $quickbox_type;
  }

}
echo QuickBoxNow($qbx_module, $qbx_h1, $qbx_liste, $suffix_css);
?>