<?php
/**
 * Indicator / SDI module
 * 
 * Display indicators /SDI list in back-office
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

$result=$sql_object->DBSelect($req_list_theme);
$sdi_object= new sdi;
//$result_sdi=$sdi_object->GetListSdi($filter="R", $valueparam=0, $sql_object);
$req_sdi=SQL_getListSdi($filter="R", $valueparam=0);
$result_sdi = $sql_object -> DBSelect($req_sdi);

$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";


$listing='<ul>'.PHP_EOL;

$current_sdtheme='';
for ($i=0;$i<count($result);$i++){
  if ($result[$i]['sdtheme_id']!=$current_sdtheme) {
    if($i<>0) $listing.="</ul>\n</li>\n";
    $current_sdtheme=$result[$i]['sdtheme_id'];
    $listing.="<li class=\"li0\">\n";
    $listing.="\t<a  class=\"nolink\" href=\"#\">".formatText($result[$i]['sdtheme_name'], '2HTML')."</a>\n";
    $listing.="<ul>\n";
  }
  $listing.="<li class=\"li1\">\n";
  $listing.="\t<a class=\"nolink\" href=\"#\">".cutText(formatText($result[$i]['theme_name'], '2HTML'), 200, 1)."</a>\n";

  $content = '';
  for ($j=0;$j<count($result_sdi);$j++) {
    if ($result[$i]['theme_id']==$result_sdi[$j]['sdii_theme']) {
      // we open the  indicators UL if there are items (once only)
      if(empty($content)) $content.="<ul>\n";
      // we populate lists
      $content.="<li class=\"contextual-menu li2\">\n";
      $content.="\t<a href=\"".$link_det.$result_sdi[$j]['sdii_id']."\" title=\"".formatText($result_sdi[$j]['sdii_name'], '2HTML')."\">".cutText(formatText($result_sdi[$j]['sdii_name'], '2HTML'), 200, 1)."</a>\n";
      if ($result_sdi[$j]['sdii_statut']=='D') $content.="<span class=\"state\"> / "._t('statut','draft')."</span>";
      if ($result_sdi[$j]['sdii_to_dashboard']=='N') $content.="<span class=\"state\"> / "._t('sdi','not_attached_to_dashboard')."</span>";
      $content.="\t<a href=\"".$link_sup.$result_sdi[$j]['sdii_id']."\" title=\""._t('sdi','sup')."\" class=\"ico_sup\"><i class=\"icon-trash\"></i><span>" . _t('sdi','sup') . "</span></a>\n";
      $content.="\t<a href=\"".$link_mod.$result_sdi[$j]['sdii_id']."\" title=\""._t('sdi','mod')."\" class=\"ico_mod\"><i class=\"icon-pencil\"></i><span>" . _t('sdi','mod') . "</span></a>\n";
      $content.="</li>\n";
    }
  }
  // we close the indicators UL if there are items
  if(!empty($content))  $content.="</ul>\n";
  // we close the subtheme li  (li1) tag
  $listing.=$content."</li>\n";
}
// we finally close subthemes and themes ULs
$listing.="</ul></ul>\n";
?>
<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi');?></a></li>
  	<li><span><?php echo _t('sdi','list'); ?></span></li>
  </ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">
  <div id="tree">
    <?php echo $listing; ?>
  </div>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->