<?php
/**
 * Tag module
 * 
 * Tag detail page
 * 
 * @package linea21\core\tag
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];


$r=$sql_object->DBSelect(SQL_getTag($id));

// Do record exists? 
if(!isset($r[0]['tag_name'])) redirect_to('@module_default');

$current_title=formatText($r[0]['tag_name'], '2HTML');
$current_comment=empty_none(formatText($r[0]['tag_comment'], '2HTML'));
$display_date_crea=$r[0]['tag_date_crea_display'];
$display_last_modify=$r[0]['tag_last_modify_display'];

// getting Associated News
$newslist = '';
$data=$sql_object->DBSelect(SQL_getNewsByTag($id));
if(isset($data[0]['news_id'])) {
	$link = 'index.php?rub=news&amp;todo=det&amp;id=';
	
	$newslist  .= '<ul>'.PHP_EOL;
	foreach($data as &$el) {
		$newslist  .= '<li><a href="'.$link.$el['news_id'].'">'.$el['news_title'].'</a></li>'.PHP_EOL;
	}
	$newslist .= '</ul>'.PHP_EOL;
}

// getting Associated Publications
$publilist = '';
$data=$sql_object->DBSelect(SQL_getPublicationsByTag($id));
if(isset($data[0]['publi_id'])) {
	$link = 'index.php?rub=publication&amp;todo=det&amp;id=';

	$publilist  .= '<ul>'.PHP_EOL;
	foreach($data as &$el) {
		$publilist  .= '<li><a href="'.$link.$el['publi_id'].'">'.$el['publi_title'].'</a></li>'.PHP_EOL;
	}
	$publilist .= '</ul>'.PHP_EOL;
}

// getting Associated News
$projectlist = '';
$data=$sql_object->DBSelect(SQL_getProjectsByTag($id));
if(isset($data[0]['project_id'])) {
	$link = 'index.php?rub=project&amp;todo=det&amp;id=';

	$projectlist  .= '<ul>'.PHP_EOL;
	foreach($data as &$el) {
		$projectlist  .= '<li><a href="'.$link.$el['project_id'].'">'.$el['project_name'].'</a></li>'.PHP_EOL;
	}
	$projectlist .= '</ul>'.PHP_EOL;
}

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','tag'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('tag','det')." : ".$current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2($current_title); ?></h2>
<?php
echo "\t<a href=\"".$link_sup.$id."\" title=\""._t('tag','sup')."\" class=\"ico_sup2\"><i class=\"icon-trash\"></i><span>" . _t('tag','sup') . "</span></a>\n";
echo "\t<a href=\"".$link_mod.$id."\" title=\""._t('tag','mod')."\" class=\"ico_mod2\"><i class=\"icon-pencil\"></i><span>" . _t('tag','mod') . "</span></a>\n";
?>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('tag','denomination')); ?> :</dt>
	<dd><?php echo $current_title; ?></dd>
	<dt><?php echo mb_ucfirst(_t('tag','comment')); ?> :</dt>
	<dd><?php echo $current_comment; ?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','last_modify')); ?> :</dt>
	<dd><?php echo $display_last_modify;?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','date_crea')); ?> :</dt>
	<dd><?php echo $display_date_crea; ?></dd>
</dl>
<h3 class="part"><?php echo mb_ucfirst(_t('tag','associated_content')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('tag','in_news')); ?> :</dt>
	<dd><?php echo empty_none($newslist); ?></dd>
	<dt><?php echo mb_ucfirst(_t('tag','in_publication')); ?> :</dt>
	<dd><?php echo empty_none($publilist); ?></dd>
	<dt><?php echo mb_ucfirst(_t('tag','in_project')); ?> :</dt>
	<dd><?php echo empty_none($projectlist); ?></dd>
</dl>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->