<?php
/**
 * Tag module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\news
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../tag/' . SQL . '.inc.php'));



/**
 * DisplayListNews()
 * Affichage de la liste des news publique
 *
 * @param  $statut
 * @param  $filter
 * @param  $id_filter
 * @param  $debut
 * @return void echo content
 */
if(!function_exists('getNewsByTag')) {

  function getNewsByTag($tag_id, $limit, $title = false, $display_empty = false)
  {

    $data = $GLOBALS['sql_object']->DBSelect(SQL_getNewsByTag($tag_id));

    if($title === false) {
    	$title = mb_ucfirst(_t('tag', 'in_news')). ' : ';
    } else {
    	$title = mb_ucfirst($title);
    }

    $content = '<h3>'.$title.'</h3>' . PHP_EOL;
    
    if ($data != 0) {
			
    	$cnt = 0;
    	$content .= '<ul>'.PHP_EOL;

      for($i = 0; $i < count($data); $i++) {
      	
      	if($cnt < $limit) {
	        $link = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'id' => $data[$i]['news_id'], 'name' => $data[$i]['news_title']);
	        
	        $news_title = formatText($data[$i]['news_title'], '2HTML');
	        
	        if($data[$i]['news_statut']!= 'E' && $data[$i]['news_statut']!= 'D' && $data[$i]['news_statut']!= 'AA') {
	        	$content .= '<li><a href="' . HrefMaker($link) . '" title="' . formatText($news_title, '2ATT') . '">' . $news_title . '</a></li>' . PHP_EOL;
	        	$cnt++;
	        }
	        
      	}
      }
      $content .= '</ul>'.PHP_EOL;
      
    } else {
    	if($display_empty == false) return '';
      $content .= '<p class="info">' . _t('divers','nodata') . '</p>';
    }

    return $content;
  }
}

?>