<?php
/**
 * Theme module
 * 
 * Display themes list in back-office
 * 
 * @package linea21\core\theme
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////


//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

$current_title=_t('theme','list');
$result=$sql_object->DBSelect($req_list_theme);
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";

$listing="<ul>\n";

$current_sdtheme='';
for ($i=0;$i<count($result);$i++){
  if ($result[$i]['sdtheme_id']!=$current_sdtheme) {
    $current_sdtheme=$result[$i]['sdtheme_id'];

    if($i == 0)$listing.="<li class=\"contextual-menu li0\">\n";
    else $listing.="</ul></li><li class=\"contextual-menu li0\">\n";
    $listing.="\t<a href=\"".$link_det."s".$result[$i]['sdtheme_id']."\" title=\""._t('theme','det')."\">".formatText($result[$i]['sdtheme_name'],'2HTML')."</a>";
    $listing.="\t<a href=\"".$link_sup.'s'.$result[$i]['sdtheme_id']."\" class=\"ico_sup\" title=\""._t('theme','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('theme','sup') . "</span></a>\n";
    $listing.="\t<a href=\"".$link_mod.'s'.$result[$i]['sdtheme_id']."\" class=\"ico_mod\" title=\""._t('theme','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('theme','mod') . "</span></a>\n";
    $listing.="<ul>\n";

  }
  $listing.="<li class=\"contextual-menu li1\">\n";
  $listing.="\t<a href=\"".$link_det.$result[$i]['theme_id']."\" title=\""._t('theme','det')."\">".formatText($result[$i]['theme_name'],'2HTML')."</a>\n";
  if ($result[$i]['theme_statut']=='D') $listing.="<span class=\"state\">"._t('statut','draft')."</span>";
  $listing.="\t<a href=\"".$link_sup.$result[$i]['theme_id']."\" class=\"ico_sup\" title=\""._t('theme','sup')."\"><i class=\"icon-trash\"></i><span>" . _t('theme','sup') . "</span></a>\n";
  $listing.="\t<a href=\"".$link_mod.$result[$i]['theme_id']."\" class=\"ico_mod\" title=\""._t('theme','mod')."\"><i class=\"icon-pencil\"></i><span>" . _t('theme','mod') . "</span></a>\n";
  $listing.="</li>\n";
}
$listing.="</ul></li></ul>\n";
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','theme'); ?></a></li>
	<li><span><?php echo formatNavTitle($current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content">
	<div id="tree">
	<?php
	echo $listing;
	?>
	</div>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->