<?php
/**
 * User module
 * 
 * Modify given user from back-office
 * 
 * @package linea21\core\user
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once('../lib/input_helpers.php');

$user_object= new user;

// USER
if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

$mask_dashboard_1='';
$mask_dashboard_2='';
$mask_project_1='';
$mask_project_2='';
$mask_publication_1='';
$mask_publication_2='';
$mask_news_1='';
$mask_news_2='';
$mask_workshop_1='';
$mask_workshop_2='';
$mask_display_mail_1='';
$mask_display_mail_2='';


if(isset($_POST['switch_type'])) {
  $switch_type=$_POST['switch_type'];

  $user_object= new user;
  if($switch_type=='2SIMPLE_USER') $table_right=$user_object->InitUserRight('SIMPLE_USER');
  if($switch_type=='2ADMIN_USER') $table_right=$user_object->InitUserRight('ADMIN_USER');

  $result=$user_object->ModifyRight($id, $table_right, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."_t&id=".$id;
  if($result) header("Location: ".$link_confirm);
  else  system_error();
}

// préparation des listes Workgroups
$q=SQL_getWorkgroupsList();
$workgroups=$sql_object->DBSelect($q);
$r=$user_object->GetUserWorkshops($id, 'subscriber', $sql_object);
$default_wg= array();
if($r > 0) {
	foreach($r as $value) {
	  if($value['jwu_user_right']=='U')
	  array_push($default_wg, $value['jwu_workshop_id']);
	}
}

$requete=SQL_getAllUserInfo($id);
$data=$sql_object->DBSelect($requete, 'OBJECT');

// Do record exists?
if(!isset($data[0]->user_login)) redirect_to('@module_default');

$current_title = $data[0]->user_login;
$user_login = $data[0]->user_login;

$user_category = $data[0]->user_category;
if($user_category==1) {
  $switch_type='2SIMPLE_USER';
  $switch_link=_t('user','2SIMPLE_USER');
} else {
  $switch_type='2ADMIN_USER';
  $switch_link=_t('user','2ADMIN_USER');
}

$switch_form=	"<form id=\"switchform\" name=\"switchform\" action=\"".$_SERVER['SCRIPT_NAME']."\" method=\"post\" >\n";
$switch_form.=	"<div>\n";
$switch_form.=	"<input type=\"hidden\" name=\"switch_type\" id=\"switch_type\" value=\"".$switch_type."\" />\n";
$switch_form.=	"<input name=\"id\" type=\"hidden\" value=\"".$id."\" id=\"idswitch\" />\n";
$switch_form.=	"<input name=\"rub\" type=\"hidden\" value=\"".$rub."\" id=\"rubswitch\" />\n";
$switch_form.=	"<input name=\"todo\" type=\"hidden\" value=\"".$todo."\" id=\"todoswitch\" />\n";
$switch_form.=	"</div>\n";
$switch_form.=	"</form>\n";

// droits utilisateur
$rights_id=$data[0]->rights_id;
$form_rights_dashboard=$data[0]->rights_dashboard;
$form_rights_project=$data[0]->rights_project;
$form_rights_publication=$data[0]->rights_publication;
$form_rights_news=$data[0]->rights_news;
$form_rights_workshop=$data[0]->rights_workshop;


// profil utilisateur
$profile_id=$data[0]->profile_id;
$form_login = $current_login = formatText($data[0]->user_login, '2FIELD');

$form_profile_firstname=formatText($data[0]->profile_firstname, '2FIELD');
$form_profile_lastname=formatText($data[0]->profile_lastname, '2FIELD');
$form_profile_email = $current_email = $data[0]->profile_email;
$form_profile_email_display=$data[0]->profile_email_display;
$form_profile_city=formatText($data[0]->profile_city, '2FIELD');
$form_profile_birthdate= isNullDate($data[0]->profile_birthdate) ? '--' : formatDate($data[0]->profile_birthdate, true);
list($form_date_y, $form_date_m, $form_date_d)=explode('-', $form_profile_birthdate);
$form_profile_leisures=formatText($data[0]->profile_leisures, '2FIELD');
$form_profile_job=formatText($data[0]->profile_job, '2FIELD');
$form_profile_avatar=$data[0]->profile_avatar;
$form_profile_quotation=formatText($data[0]->profile_quotation, '2FIELD');
$form_profile_signature=formatText($data[0]->profile_signature, '2FIELD');
$form_profile_last_modify_display=$data[0]->profile_last_modify_display;

if(isset($_POST['valider'])) {

  $integrity=1;

  $form_login = $table_user[0] = $_POST['pseudo'];
  $form_profile_email = $table_profile[0] = $table_user[1] = $_POST['email'];

  $form_profile_email_display = $table_profile[1] = $_POST['email_display'];
  $form_profile_city = $table_profile[2] =  $_POST['city'];
  $form_date_d = $_POST['date_d'];
  $form_date_m = $_POST['date_m'];
  $form_date_y = $_POST['date_y'];
  $form_birthdate=$form_date_d . '-' . $form_date_m . '-' . $form_date_y;

  if(!empty($form_date_d) && !empty($form_date_m) && !empty($form_date_y)) {
    $date_integrity=checkdate_validity($form_birthdate);
  } else {
    $date_integrity=true;
  }
  if(is_string($date_integrity)) $integrity = $date_integrity;
  else {
    $table_profile[3]= $form_date_y.'-'.$form_date_m.'-'.$form_date_d;
    $form_profile_birthdate=$table_profile[3];
    $form_profile_birthdate=formatDate($form_profile_birthdate);
  }
  $table_profile[4] = $_POST['leisures'];
  $table_profile[5] = $_POST['job'];
  $table_profile[6] = $_POST['quotation'];
  $table_profile[7] = $_POST['signature'];
  $table_profile[8] = $_POST['first_name'];
  $table_profile[9] = $_POST['last_name'];
  $table_right['dashboard']=$_POST['dashboard'];
  $table_right['project']=$_POST['project'];
  $table_right['publication']=$_POST['publication'];
  $table_right['news']=$_POST['news'];
  $table_right['workshop']=$_POST['workshop'];

  if(is_string($integrity)) $format_text='2FIELD'; else $format_text='2HTML';
  $form_profile_firstname = formatText($_POST['first_name'], $format_text);
  $form_profile_lastname = formatText($_POST['last_name'], $format_text);
  $form_profile_leisures = formatText($_POST['leisures'], $format_text);
  $form_profile_job = formatText($_POST['job'], $format_text);
  $form_profile_quotation = formatText($_POST['quotation'], $format_text);
  $form_profile_signature = formatText($_POST['signature'], $format_text);
  $form_rights_dashboard = $_POST['dashboard'];
  $form_rights_project = $_POST['project'];
  $form_rights_publication = $_POST['publication'];
  $form_rights_news = $_POST['news'];
  $form_rights_workshop = $_POST['workshop'];

  $table_right=urlencode(serialize($table_right));
  $current_email=$_POST['current_email'];

  // check if we need to check the login or not
  if($table_user[0] == $user_login) $checklogin = false;
  else $checklogin = true;

  $data_user_integrity=$user_object->CheckDataIntegrity($table_user, $sql_object, $checklogin);
  $table_user=urlencode(serialize($table_user));

  if(is_string($data_user_integrity)) $integrity=$data_user_integrity;

  if(!is_string($integrity)) {
    if(isset($_FILES['avatar']) && $_FILES['avatar']['name']!='') {
      include_once('../class/system/class.upload.php');
      $upload_object= new upload;
      $upload=$_FILES['avatar'];
      $size_integrity=$upload_object->CheckMaxFile($upload['size'], $user_object->UPLOAD_MAX_MO);
      if(is_string($size_integrity)) $integrity=$size_integrity;
      $format_integrity=$upload_object->CheckExtImage($upload['name']);
      if(is_string($format_integrity)) $integrity=$format_integrity;
      if(!is_string($integrity)) {
        $final_name=$id.".".$upload_object->GetExtension($upload ['name']);
        $temp_name="temp_".$final_name;
        $destination="../".$user_object->URI_INPUT;
        $table_profile[10]=$user_object->URI_INPUT.$final_name;

        $form_profile_avatar=$user_object->URI_INPUT.$temp_name;

        $result_upload=$upload_object->UploadFile($upload, $temp_name, $destination);

        // we remove all images with same name except the image just uploaded
        $upload_object->deleteImages($destination.$final_name, true);
      }
    } else  {
      $table_profile[10]=$form_profile_avatar;
      $archive_it=0;
    }
  }
  $table_profile=urlencode(serialize($table_profile));

  if(isset($_POST['workgroups'])) {
    $table_workgroups=$_POST['workgroups'];
    $default_wg=$table_workgroups;
  }
  else $table_workgroups=array();
  $table_workgroups=urlencode(serialize($table_workgroups));
}

if(isset($_POST['enregistrer'])) {

  $current_email=$_POST['current_email'];
  include_once('../class/system/class.upload.php');
  /** include envoi de mail */
  include_once(override('../mail/mail_actions.php'));
  include_once(override('../mail/send.php'));
  $a = array();
  
  $table_right=unserialize(urldecode($_POST['table_right']));
  $table_profile=unserialize(urldecode($_POST['table_profile']));
  $table_workgroups=unserialize(urldecode($_POST['table_workgroups']));
  $table_user=unserialize(urldecode($_POST['table_user']));
  $new_email=$table_profile[0];
  $new_login=$table_user[0];

  $result1=$user_object->ModifyRight($id, $table_right, $sql_object);
  $result2=$user_object->ModifyProfile($id, $table_profile, $sql_object);
  $result3=$user_object->ModifyWorkshops($id, $table_workgroups, 'U' , $sql_object);

  if($new_email!=$current_email) {
    $a['password'] = $user_object->GetNewPassword();
    $user_object->UpdateUserPassword($id, $a['password'], $sql_object);

    /** include envoi de mail */
    $a['action'] = 'change_mail';
    $a['login'] = $user_login;
    $a['recipient'] = $new_email;
    
    $emailContainer = prepare_email($a);
    $r = send_email($emailContainer);
  }

  if($new_login != $current_login) {

  	$user_object->changeLogin($id, $new_login, $current_login, $sql_object);

  	if($new_email != $current_email) $a['recipient'] = $new_email;
  	else  $a['recipient'] = $current_email;

  	/** include envoi de mail */
  	$a['action'] = 'change_login';
  	$a['login'] = $new_login;
  	
  	$emailContainer = prepare_email($a);
  	$r = send_email($emailContainer);
  }

  $upload_object= new upload;
  $visual_uri="../".$table_profile[10];
  $result_rename=$upload_object->Archivefile($visual_uri);

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if($result1 && $result2 && $result3) header("Location: ".$link_confirm);
  else  system_error();
}

// préparation des données
if($form_rights_dashboard=='U') $mask_dashboard_1="checked=\"checked\"";
if($form_rights_dashboard=='O') $mask_dashboard_2="checked=\"checked\"";
if($form_rights_project=='U') $mask_project_1="checked=\"checked\"";
if($form_rights_project=='O') $mask_project_2="checked=\"checked\"";
if($form_rights_publication=='U') $mask_publication_1="checked=\"checked\"";
if($form_rights_publication=='O') $mask_publication_2="checked=\"checked\"";
if($form_rights_news=='U') $mask_news_1="checked=\"checked\"";
if($form_rights_news=='O') $mask_news_2="checked=\"checked\"";
if($form_rights_workshop=='U') $mask_workshop_1="checked=\"checked\"";
if($form_rights_workshop=='O') $mask_workshop_2="checked=\"checked\"";
if($form_profile_email_display=='Y') $mask_display_mail_1="checked=\"checked\"";
if($form_profile_email_display=='N') $mask_display_mail_2="checked=\"checked\"";

if(!empty($form_profile_avatar)) {
  $complete_uri='../'.$form_profile_avatar;
  $user_profile_avatar ='<div id="avatarcontainer"><img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$user_login.'" />';
  if(!isset($integrity)) {
 	 $user_profile_avatar.='<p><a class="ico_generic2" href="index.php?rub=user&amp;todo=delavatar&amp;id='.$profile_id.'" title="'._t('user','delete_avatar').'"><i class="icon-trash"></i><span>'._t('user','delete_avatar').'</span></a></p>';
  }
  $user_profile_avatar.='</div>';
  // ajax code
  $js = '$("a.delete_avatar").click(function() {

  		var url = "../user/delavatar.php?id='.$id.'&mode=ajax";
  		$.ajax({
  			type: "GET",
  			url: url,
  			dataType: "json",
  			success: function(data){
  				if(data.status==1) {
  					alertify.success(data.msg);
  					$("#avatarcontainer").fadeOut("slow");
  				} else {
  					alertify.error(data.msg);
  				}
  			}
  		});
  		return false;
  	});
  ';

  footerAddInlineJS($js);


} else $user_profile_avatar=_t('divers','none');


// preparation affichage detaillé
$rights_display='';
if(defined('MOD_SDI') && $user_category!=1) {
  $rights_display.= "<div><div class=\"rights\">⇨ "._t('menu','dashboard')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"dashboard_1\" class=\"radio\" name=\"dashboard\" value=\"U\" ".$mask_dashboard_1." /><label for=\"dashboard_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"dashboard_2\" class=\"radio\" name=\"dashboard\" value=\"O\" ".$mask_dashboard_2."/><label for=\"dashboard_2\">". _t('user','managerrights')."</label>\n";
  $rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"dashboard\" name=\"dashboard\" value=\"".$form_rights_dashboard."\" />\n";
if(defined('MOD_PROJECT') && $user_category!=1) {
	$rights_display.= "<div><div class=\"rights\">⇨ "._t('menu','project')." : </div>\n";
	$rights_display.= "<div class=\"rightpanel\">\n";
	$rights_display.= "<input type=\"radio\" id=\"project_1\" class=\"radio\" name=\"project\" value=\"U\" ".$mask_project_1." /><label for=\"project_1\">". _t('user','norights')."</label>\n";
	$rights_display.= "<input type=\"radio\" id=\"project_2\" class=\"radio\" name=\"project\" value=\"O\" ".$mask_project_2." /><label for=\"project_2\">". _t('user','managerrights')."</label>\n";
	$rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"project\" name=\"project\" value=\"".$form_rights_project."\" />\n";
if(defined('MOD_PUBLICATION') && $user_category!=1) {
  $rights_display.= "<div><div class=\"rights\">⇨ "._t('menu','publication')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"publication_1\" class=\"radio\" name=\"publication\" value=\"U\" ".$mask_publication_1." /><label for=\"publication_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"publication_2\" class=\"radio\" name=\"publication\" value=\"O\" ".$mask_publication_2." /><label for=\"publication_2\">". _t('user','redactorrights')."</label>\n";
  $rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"publication\" name=\"publication\" value=\"".$form_rights_publication."\" />\n";
if(defined('MOD_NEWS') && $user_category!=1) {
  $rights_display.= "<div><div class=\"rights\">⇨ "._t('menu','news')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"news_1\" class=\"radio\" name=\"news\" value=\"U\" ".$mask_news_1." /><label for=\"news_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"news_2\" class=\"radio\" name=\"news\" value=\"O\" ".$mask_news_2."/><label for=\"news_2\">". _t('user','redactorrights')."</label>\n";
  $rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"news\" name=\"news\" value=\"".$form_rights_news."\" />\n";
if(defined('MOD_WORKSHOP') && $user_category!=1) {
  $rights_display.= "<div><div class=\"rights\">⇨ "._t('menu','workshop')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"workshop_1\" class=\"radio\" name=\"workshop\" value=\"U\" ".$mask_workshop_1." /><label for=\"workshop_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"workshop_2\" class=\"radio\" name=\"workshop\" value=\"O\" ".$mask_workshop_2." /><label for=\"workshop_2\">". _t('user','animatorrights')."</label>\n";
  $rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"wokshop\" name=\"workshop\" value=\"".$form_rights_workshop."\" />\n";
if($user_category==1) {
  $rights_display.="<p class=\"info\">\n";
  $rights_display.=_t('user','admin_type_info');
  $rights_display.="\n</p>\n";
}

// Restriction on changing emails and passwords for LDAP users
if($data[0]->user_password  == '@ldap_forward') {
	$mask = ' readonly = "readonly"';
} else {
	$mask = '';
}
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','user'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('user','mod').' : '.$current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
if($data[0]->user_password == '@ldap_forward') {
	$suffix= '<i class="icon-universal-access"></i>';
} else {
	$suffix= ' ';
}
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php

if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2($current_title).$suffix; ?></h2>
<div class="mod_link">
<?php
// if user is authentified using LDAP, no ability to change password
if($data[0]->user_password != '@ldap_forward') {
?>
<a href="<?php echo $rub_link."&amp;todo=mod_p&amp;id=".$id; ?>"><?php echo _t('user','new_password'); ?></a><!-- @whitespace
<?php } ?>
--><a href="#" onclick="document.getElementById('switchform').submit()"><?php echo $switch_link; ?></a>
</div>
<form id="moduser" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data">

<h3 class="part"><?php echo mb_ucfirst(_t('user','update_rights')); ?></h3>
<?php echo $rights_display; ?>

<h3 class="part"><?php echo mb_ucfirst(_t('user','profile')); ?></h3>


<p>
	<label for="pseudo"><?php echo mb_ucfirst(_t('user','login')); ?> : *</label>
	<input name="pseudo" type="text" class="textfield" id="pseudo"<?php echo $mask; ?> maxlength="150" value="<?php echo $form_login; ?>" />
</p>
<p>
<label for="email"><?php echo mb_ucfirst(_t('user','email')); ?> : *</label>
<input name="email" type="text" class="textfield" id="email" maxlength="200"<?php echo $mask; ?> value="<?php echo $form_profile_email; ?>" />
</p>
<div class="label"><?php echo mb_ucfirst(_t('user','email_display')); ?> : </div>
<div class="rightpanel">
	<input type="radio" id="email_display_Y" name="email_display" value="Y" <?php echo $mask_display_mail_1; ?> />
	<label for="email_display_Y"><?php echo _t('divers','yes'); ?></label>
	<input type="radio" id="email_display_N" name="email_display" value="N" <?php echo $mask_display_mail_2; ?> />
	<label for="email_display_N"><?php echo _t('divers','no'); ?></label>
</div>
<p>
<label for="first_name"><?php echo mb_ucfirst(_t('user','first_name')); ?> :</label>
<input name="first_name" type="text" class="textfield" id="first_name" maxlength="200" value="<?php echo $form_profile_firstname; ?>" />
</p>
<p>
<label for="last_name"><?php echo mb_ucfirst(_t('user','last_name')); ?> :</label>
<input name="last_name" type="text" class="textfield" id="last_name" maxlength="200" value="<?php echo $form_profile_lastname; ?>" />
</p>
<div class="label"><?php echo mb_ucfirst(_t('user','workgroups')); ?> :</div>
<div class="rightpanel" id="groups"><?php echo workgroupsCheckbox($workgroups, 'workgroups[]', $default_wg); ?>
</div>

<dl class="dl_mod">
	<dt><?php echo _t('user','avatar'); ?></dt>
	<dd><?php echo $user_profile_avatar; ?></dd>
</dl>

<p>
<label for="avatar"><?php echo mb_ucfirst(_t('user','avatar')); ?> : </label>
<input name="avatar" type="file" id="avatar" size="47" class="file" />
</p>
<p>
<label for="birthdate_d"><?php echo mb_ucfirst(_t('user','birthdate')); ?> :</label>
<?php echo input_date($form_date_y, $form_date_m, $form_date_d); ?>
</p>
<p>
<label for="city"><?php echo mb_ucfirst(_t('user','city')); ?> :</label>
<input name="city" type="text" class="textfield" id="city" maxlength="100" value="<?php echo $form_profile_city; ?>" />
</p>
<p>
<label for="leisures"><?php echo mb_ucfirst(_t('user','leisures')); ?> :</label>
<input name="leisures" type="text" class="textfield" id="leisures" maxlength="150" value="<?php echo $form_profile_leisures; ?>" />
</p>
<p>
<label for="job"><?php echo mb_ucfirst(_t('user','job')); ?> :</label>
<input name="job" type="text" class="textfield" id="job" maxlength="150" value="<?php echo $form_profile_job; ?>" />
</p>
<p>
<label for="quotation"><?php echo mb_ucfirst(_t('user','quotation')); ?> :</label>
<input name="quotation" type="text" class="textfield" id="quotation" maxlength="150" value="<?php echo $form_profile_quotation; ?>" />
</p>
<p>
<label for="signature"><?php echo mb_ucfirst(_t('user','signature')); ?> :</label>
<input name="signature" type="text" class="textfield" id="signature" maxlength="200" value="<?php echo $form_profile_signature; ?>" />
</p>
<div>
  <input name="current_email" type="hidden" value="<?php echo $current_email; ?>" id="current_email" />
  <input name="current_login" type="hidden" value="<?php echo $current_login; ?>" id="current_login" />
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php echo cancel_button('javascript:history.go(-1);'); ?>
  <input name="valider" type="submit"	value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
	<?php echo $switch_form; ?>
	</div> <!-- closing #content -->
	</div> <!-- closing .contentcontainer -->

	<?php
	// Récapitulatif
} else	{

  $wg_display = '';
  if(isset($_POST['workgroups'])) {
    $q=SQL_Get_WorkshopsDenomination($_POST['workgroups']);
    $workgroups=$sql_object->DBSelect($q);
    foreach($workgroups as $wg) {
      $wg_display .= '- '.$wg['workshop_denomination'].'<br />'.PHP_EOL;
    }
  } else $wg_display .= _t('divers', 'none');

  //prepa affichage de droits
  $reca_droits='';
  $reca_droits.='<h3 class="part">'._t('user','rights').'</h3>';
  $reca_droits.="<dl class=\"summary\">\n";
  if(defined('MOD_SDI'))  {
    $reca_droits.="<dt> . "._t('menu','sdi')."</dt>\n";
    $reca_droits.="<dd>".GetDisplayUserRight($form_rights_dashboard, 'dashboard')."<br /></dd>\n";
  }
  if(defined('MOD_PROJECT'))  {
  	$reca_droits.="<dt> . "._t('menu','project')."</dt>\n";
  	$reca_droits.="<dd>".GetDisplayUserRight($form_rights_project, 'project')."<br /></dd>\n";
  }
  if(defined('MOD_PUBLICATION'))  {
    $reca_droits.="<dt>  . "._t('menu','publication')."</dt>\n";
    $reca_droits.="<dd>".GetDisplayUserRight($form_rights_publication)."<br /></dd>\n";
  }
  if(defined('MOD_WORKSHOP'))  {
    $reca_droits.="<dt>  . "._t('menu','workshop')."</dt>\n";
    $reca_droits.="<dd>".GetDisplayUserRight($form_rights_workshop, 'workshop')."<br /></dd>\n";
  }
  if(defined('MOD_NEWS'))  {
    $reca_droits.="<dt>  . "._t('menu','news')."</dt>\n";
    $reca_droits.="<dd>".GetDisplayUserRight($form_rights_news)."<br /></dd>\n";
  }
  $reca_droits.="</dl>\n";


  if($form_profile_email_display=='Y') $form_profile_email_string=_t('divers','yes');
  if($form_profile_email_display=='N') $form_profile_email_string=_t('divers','no');
  $form_profile_email='<a href="mailto:'.$form_profile_email.'">'.$form_profile_email.'</a>';
  $form_profile_firstname=empty_nc($form_profile_firstname);
  $form_profile_lastname=empty_nc($form_profile_lastname);
  $form_profile_city=empty_nc($form_profile_city);
  $form_profile_birthdate = ($form_profile_birthdate=='--') ? '' : $form_profile_birthdate;
  $form_profile_birthdate=empty_nc($form_profile_birthdate);
  $form_profile_leisures=empty_nc($form_profile_leisures);
  $form_profile_job=empty_nc($form_profile_job);
  $user_profile_avatar=empty_none($user_profile_avatar);
  $form_profile_signature=empty_nc($form_profile_signature);
  $form_profile_quotation=empty_nc($form_profile_quotation);
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
echo "<h2>".formatTitleh2(_t('recap','title')).$suffix."</h2>";
echo $reca_droits;
echo '<h3 class="part">'._t('user','profile').'</h3>';
echo "<dl class=\"summary\">\n";
echo "<dt>". mb_ucfirst(_t('user','login')). " :</dt>\n";
echo "<dd>".$form_login."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','email')). " :</dt>\n";
echo "<dd>".$form_profile_email."</dd>\n";
echo "<dt>".mb_ucfirst(_t('user','email_display'))." :</dt>\n";
echo "<dd>". $form_profile_email_string."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','first_name')). " :</dt>\n";
echo "<dd>".$form_profile_firstname."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','last_name')). " :</dt>\n";
echo "<dd>".$form_profile_lastname."</dd>\n";
echo "<dt>".ucfirst(_t('user','workgroups'))." :</dt>\n";
echo "<dd>". stripslashes($wg_display)."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','birthdate'))." :</dt>\n";
echo "<dd>". stripslashes($form_profile_birthdate)."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','city'))." :</dt>\n";
echo "<dd>". stripslashes($form_profile_city)."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','leisures'))." :</dt>\n";
echo "<dd>". stripslashes($form_profile_leisures)."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','job'))." :</dt>\n";
echo "<dd>". stripslashes($form_profile_job)."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','avatar'))." :</dt>\n";
echo "<dd>". stripslashes($user_profile_avatar)."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','quotation'))." :</dt>\n";
echo "<dd>". stripslashes($form_profile_quotation)."</dd>\n";
echo "<dt>". mb_ucfirst(_t('user','signature'))." :</dt>\n";
echo "<dd>". stripslashes($form_profile_signature)."</dd>\n";
echo "</dl>\n";
?>
<form id="moduser" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
   <div>
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="current_email" type="hidden" value="<?php echo $current_email; ?>" id="current_email" />
    <input name="current_login" type="hidden" value="<?php echo $current_login; ?>" id="current_login" />
    <input name="table_right" type="hidden" value="<?php echo $table_right; ?>" id="table_right" />
    <input name="table_profile" type="hidden" value="<?php echo $table_profile; ?>" id="table_profile" />
    <input name="table_user" type="hidden" value="<?php echo $table_user; ?>" id="table_user" />
    <input name="table_workgroups" type="hidden" value="<?php echo $table_workgroups; ?>" id="table_workgroups" />
    <?php echo cancel_button('?rub=user&amp;todo=list'); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>