<?php
/**
 * Workshop module - list calendar events
 * 
 * Display calendar events list in back-office
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop') && !$l21auth->isSuperAdmin())
	ReloadIndex('admin');
////////////

if (isset($_POST['id'])) $id = $_POST['id'];
if (isset($_GET['id'])) $id = $_GET['id'];

$req_det = SQL_getoneCompleteWorkshop($id);
$result = $sql_object -> DBSelect($req_det);
if (count($result) > 1) exit();

$link_det = $rub_link . "&amp;todo=det&amp;id=";
$link_sup = $rub_link . "&amp;todo=sup&amp;id=";
$link_mod = $rub_link . "&amp;todo=mod&amp;id=";
$link_det_u = "index.php?rub=user&amp;todo=det&amp;id=";
$link_sup_u = $rub_link . "&amp;todo=sup_u&amp;id=";
$link_add_cal = $rub_link . "&amp;todo=add_cal&amp;id=";
$link_mod_cal = $rub_link . "&amp;todo=mod_cal&amp;id=";
$link_sup_cal = $rub_link . "&amp;todo=sup_cal&amp;id=";
$link_list_cal = $rub_link . "&amp;todo=list_cal&amp;id=";

$workshop_denomination = formatText($result[0]['workshop_denomination'], '2HTML');
$workshop_resume = formatText($result[0]['workshop_resume'], '2HTML');

if (empty($result[0]['workshop_comment'])) $workshop_comment = _t('divers','none');
else $workshop_comment = formatText($result[0]['workshop_comment'], '2HTML');

$theme_denomination = formatText($result[0]['theme_name'], '2HTML');
$workshop_statut = display_statut($result[0]['workshop_statut']);
$display_date_crea = $result[0]['workshop_date_crea_display'];
$display_last_modify = $result[0]['workshop_last_modify_display'];


$req_list_cal = SQL_getoneListCalWorkshop($id);
$result_cal = $sql_object -> DBSelect($req_list_cal);

$reca_task = '';
$datenow= strtotime("now");
$inter=1*24*3600;
$reca_task = "";
$out_first=false;
if ($result_cal<>0) {
  for($i = 0; $i < count($result_cal); $i++) {

    $datetask=$result_cal[$i]['workcal_task_date_display'];
    $datetask=explode("-", $datetask);
    $jour = $datetask[0];
    $mois = $datetask[1];
    $annee = $datetask[2];
    $datetask2 = mktime (0, 0, 0, $mois, $jour, $annee);

    if($result_cal[$i]['workcal_workshop_id'] == 999999999) {
      $common_task = '<span class="task_common">' . _t('workshop', 'task_common') . '</span>';
    } else {
      $common_task = '';
    }

    if (($datetask2+$inter) > $datenow){
      $reca_task .= "\n<div class=\"task\">\n";
      $reca_task .="<div class=\"task_user_profile\">\n";
      $reca_task .='<img src="'.THEME_ADMIN_PATH.'/images/task_calendar.png" alt="'. formatText($result_cal[$i]['workcal_task_date_display'], '2HTML').'" class="user_profile"/>';
      $reca_task .= "\n<span class=\"auth_task\">" . $result_cal[$i]['workcal_task_date_display'] . "</span>\n";
      if ($l21auth->isSuperAdmin())
      $reca_task .= "<a href=\"" . $link_det_u.$result_cal[$i]['workcal_posted_by']."\" title=\"" . _t('workshop','com_author') . "\" class=\"task_date\">". formatText($result_cal[$i]['user_login'], '2HTML') . "</a>\n";
      else $reca_task .= "<span class=\"task_date\">". formatText($result_cal[$i]['user_login'], '2HTML') . "</span>\n";

      $reca_task .="</div>\n";
      $reca_task .="<div class=\"task_content\">\n";
      if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin()){
        $reca_task .= "<a href=\"" . $link_sup_cal . $id . "&amp;task_id=".$result_cal[$i]['workcal_id']."\" title=\"" . _t('workshop','sup_cal') . "\" class=\"ico_sup2\"><i class=\"icon-trash\"></i><span>" . _t('workshop','sup_cal') . "</span></a>";
        $reca_task .= "<a href=\"" . $link_mod_cal . $id . "&amp;task_id=".$result_cal[$i]['workcal_id']."\" title=\"" . _t('workshop','mod_cal') . "\" class=\"ico_mod2\"><i class=\"icon-pencil\"></i><span>" . _t('workshop','mod_cal') . "</span></a>";
      }
      $reca_task .= $common_task;
      $reca_task .= "<h3 class=\"task_title\">" . formatText($result_cal[$i]['workcal_task'], '2HTML') . "</h3>\n";
      $reca_task .= linkin_content(formatText($result_cal[$i]['workcal_task_details'], '2HTML'));
      $reca_task .= "</div></div>\n";

    }
    else {
      if(!$out_first) $reca_task .= "<hr class=\"task_separator\" />\n";
      $reca_task .= "\n<div class=\"task_out\">\n";
      $reca_task .="<div class=\"task_user_profile\">\n";
      $reca_task .='<img src="'.THEME_ADMIN_PATH.'/images/task_calendar_out.png" alt="'. formatText($result_cal[$i]['workcal_task_date_display'], '2HTML').'" class="user_profile"/>';
      $reca_task .= "\n<span class=\"auth_task\">" . $result_cal[$i]['workcal_task_date_display'] . "</span>\n";
      if ($l21auth->isSuperAdmin())
      $reca_task .= "<a href=\"" . $link_det_u.$result_cal[$i]['workcal_posted_by']."\" title=\"" . _t('workshop','com_author') . "\" class=\"task_date\">". formatText($result_cal[$i]['user_login'], '2HTML') . "</a>\n";
      else $reca_task .= "<span class=\"task_date\">". formatText($result_cal[$i]['user_login'], '2HTML') . "</span>\n";

      $reca_task .="</div>\n";
      $reca_task .="<div class=\"task_content\">\n";
      if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin()){
        $reca_task .= "<a href=\"" . $link_sup_cal . $id . "&amp;task_id=".$result_cal[$i]['workcal_id']."\" title=\"" . _t('workshop','sup_cal') . "\" class=\"ico_sup2\"><i class=\"icon-trash\"></i><span>" . _t('workshop','sup_cal') . "</span></a>";
        $reca_task .= "<a href=\"" . $link_mod_cal . $id . "&amp;task_id=".$result_cal[$i]['workcal_id']."\" title=\"" . _t('workshop','mod_cal') . "\" class=\"ico_mod2\"><i class=\"icon-pencil\"></i><span>" . _t('workshop','mod_cal') . "</span></a>";
      }
      $reca_task .= $common_task;
      $reca_task .= "<h3 class=\"task_title\">" . formatText($result_cal[$i]['workcal_task'], '2HTML') . "</h3>\n";
      $reca_task .= linkin_content(formatText($result_cal[$i]['workcal_task_details'], '2HTML'));
      $reca_task .= "</div></div>\n";
      $out_first=true;
    }
  }
}
else {
  $reca_task="<div class=\"info\">"._t('workshop','no_cal')."</div>";
}
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','workshop');	?></a></li>
	<li><span><?php echo formatnavTitle(_t('workshop','list_cal') . " : " . $workshop_denomination); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php afflinkbar($todo,$id, $lang); ?>
<h2><?php echo _t('workshop','list_cal'); ?></h2>
<div class="subtitle" id="workshop-subtitle"><?php echo $workshop_denomination; ?></div>
<?php
if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin())
echo "<a href=\"".$link_add_cal.$id."\" title=\""._t('workshop','add_cal')."\" class=\"ico_add2\"><i class=\"icon-plus-circled\"></i><span>".  _t('workshop','add_cal')."</span></a><br class=\"brendstep\" />";?>
<?php echo $reca_task; ?>
<br class="brendstep" />
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->