<?php
/**
 * Directory module - list entries
 * 
 * Display directory entries list in back-office
 * 
 * @package linea21\modules\yellowpages
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if(!isset($_GET['statut']) || $_GET['statut']==-1) $statut=-1;
elseif($_GET['statut']!=-1) {
  $statut=$_GET['statut'];
  $alphabeta=-1;
}

if(!isset($_GET['alphabeta']) || $_GET['alphabeta']==-1) $alphabeta=-1;
elseif($_GET['alphabeta']!=-1) {
  $alphabeta=$_GET['alphabeta'];
  $statut=-1;
}

if(!isset($_GET['debut'])) $debut=0;
else $debut=$_GET['debut'];

$mask_statut_1='';
$mask_statut_2='';
$mask_statut_3='';

if($statut=='P') $mask_statut_1='selected="selected"';
if($statut=='AA') $mask_statut_2='selected="selected"';
if($statut=='D') $mask_statut_3='selected="selected"';


// Nombre d'enregistrement total dans la bdd
$result_nb_req=$sql_object->DBSelect($req_count_yp);
$bdd_nb_yp=$result_nb_req[0]['num_rows'];
$bdd_nb_yp_display = $bdd_nb_yp." "._t('yp','nb_total')."<br />\n";

if($statut!=-1 || $alphabeta!=-1) {
  $link_back="<div class=\"filter\"><a href=\"".$rub_link."&amp;todo=list\">"._t('yp','all')."</a></div>";

  if($statut!=-1) {
    $req_count_yp=SQL_getCountypList($statut);
    $result_nb_req=$sql_object->DBSelect($req_count_yp);
    $count_request=$result_nb_req[0]['num_rows'];
    $req_list_yp=SQL_getypList($debut, SELECT_LIMIT, $statut);
    $result_yp_list=$sql_object->DBSelect($req_list_yp);
  }

  if($alphabeta!=-1) {
    $req_count_yp=SQL_getCountypList('ALPHA', $alphabeta);
    $result_nb_req=$sql_object->DBSelect($req_count_yp);
    $count_request=$result_nb_req[0]['num_rows'];
    $req_list_yp=SQL_getypList($debut, SELECT_LIMIT, 'ALPHA', $alphabeta);
    $result_yp_list=$sql_object->DBSelect($req_list_yp);
  }

} else {
  $link_back='';
  $count_request=$bdd_nb_yp;
  $req_list_yp=SQL_getypList($debut, SELECT_LIMIT, $statut);
  $result_yp_list=$sql_object->DBSelect($req_list_yp);
}

if($count_request<=1) $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','record')."<br />\n";
else $count_request_display = _t('divers','query_result')." : ".$count_request." "._t('divers','records')."<br />\n";


$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_statut=$rub_link."&amp;todo=list&amp;statut=";
$link_list_alphabetical=$rub_link."&amp;todo=list&amp;alphabeta=";
//&amp;groupe=".$groupe."&amp;alphabeta=".$alphabeta;"
$link_self=$link_statut.$statut."&amp;alphabeta=".$alphabeta;


// Liste des statuts disponible
$select_statut="<select name=\"statut_filter\" id=\"statut_filter\">\n";
$select_statut.="<option value=\"-1\">"._t('divers','select_choice2')."</option>\n";
$select_statut.="<option value=\"".$link_statut."D\"".$mask_statut_3.">"._t('yp','preinscription')."</option>\n";
$select_statut.="<option value=\"".$link_statut."P\"".$mask_statut_1.">".display_statut('P')."</option>\n";
$select_statut.="<option value=\"".$link_statut."AA\"".$mask_statut_2.">".display_statut('AA')."</option>\n";
$select_statut.="</select>\n";

$js = "	$('#statut_filter').change(function() {
					if($(this).val() != -1) window.location = $(this).val();
				});";

footerAddInlineJS($js);

// Liste alphabetique
$result_alphabetical=$sql_object->DBSelect($req_alphabetical);
$select_alphabetical="<select name=\"alhpabetical_filter\" id=\"alhpabetical_filter\">\n";
$select_alphabetical.="<option value=\"-1\">"._t('yp','alphabetical')."</option>\n";
for($i=0; $i<count($result_alphabetical); $i++)  {
  if($alphabeta==$result_alphabetical[$i]['first_letter']) $mask=" selected=\"selected\""; else $mask='';
  $select_alphabetical.="\t<option value=\"".$link_list_alphabetical.$result_alphabetical[$i]['first_letter']."\"".$mask.">".$result_alphabetical[$i]['first_letter']."</option>\n";
}
$select_alphabetical.="</select>\n";

$js = "	$('#alhpabetical_filter').change(function() {
					window.location = $(this).val();
				});";

footerAddInlineJS($js);

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','yellowpages')?></a></li>
	<li><span><?php echo _t('yp','list') ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
<div id="content"><?php
echo $link_back;
?>
<div class="filterselect"><?php
echo $select_statut;
echo $select_alphabetical;
?></div>
<p><?php
echo $bdd_nb_yp_display;
echo $count_request_display;
?></p>
<?php
echo linkin_page($link_self, $count_request, $debut);

if($result_yp_list!=0) {
  echo "<table cellspacing=\"0\" cellpadding=\"3\" class=\"multisort\">\n";
  echo "<thead>\n";
  echo "<tr>\n";
  echo "<td style=\"width:40%\">".mb_ucfirst(_t('yp','name2'))."</td>\n";;
  echo "<td>".mb_ucfirst(_t('divers','date_crea'))."</td>\n";
  echo "<td class=\"sorter-false\">&nbsp;<span class=\"semnone\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  echo "</tr>\n";
  echo "</thead>\n";
  echo "<tbody>\n";


  for($i=0; $i<count($result_yp_list); $i++) {
    $yp_title=formatText($result_yp_list[$i]['yellowp_name'], '2HTML');
    $yp_title=cutText($yp_title, 35, 1);
    echo "<tr>\n";
    echo "<td><a href=\"".$link_det.$result_yp_list[$i]['yellowp_id']."\" title=\""._t('yp','det')."\">".$yp_title."</a></td>\n";
    echo "<td>".$result_yp_list[$i]['yellowp_date_crea_display']."</td>\n";
    echo "<td><div class=\"iconetab\"><a href=\"".$link_sup.$result_yp_list[$i]['yellowp_id']."\" title=\""._t('yp','sup')."\" class=\"ico_sup\"><i class=\"icon-trash\"></i><span>" . _t('yp','sup') . "</span></a>";
    echo "<a href=\"".$link_mod.$result_yp_list[$i]['yellowp_id']."\" title=\""._t('yp','mod')."\" class=\"ico_mod\"><i class=\"icon-pencil\"></i><span>" . _t('yp','mod') . "</span></a></div></td>\n";
    echo "</tr>\n";
  }

  echo "</tbody>";
  echo "</table>";

} else {
  echo "<div class=\"info\">"._t('yp','noresult')."</div>";
}
echo linkin_page($link_self, $count_request, $debut);

// Ability to sort table
addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
$str = '$("table.multisort").tablesorter({	});';
footerAddInlineJS($str);
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->