/*
 * Decompiled with CFR 0.152.
 */
package com.highcharts.export.pool;

import com.highcharts.export.pool.ObjectFactory;
import com.highcharts.export.pool.ObjectPool;
import com.highcharts.export.pool.PoolException;
import com.highcharts.export.util.TempDir;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class AbstractPool<T>
implements ObjectPool<T> {
    final ObjectFactory<T> objectFactory;
    Queue<T> queue;
    final AtomicInteger poolSize = new AtomicInteger(0);
    int maxWait;
    final int capacity;
    final long retentionTime;
    protected static Logger logger = Logger.getLogger((String)"pool");

    public AbstractPool(ObjectFactory<T> objectFactory, int number, int maxWait, Long retentionTime) throws PoolException {
        this.objectFactory = objectFactory;
        this.capacity = number;
        this.maxWait = maxWait;
        this.retentionTime = retentionTime;
    }

    @Override
    public void createObject() {
        T object = this.objectFactory.create();
        this.queue.add(object);
        this.poolSize.getAndIncrement();
    }

    @Override
    public void destroyObject(T object) {
        this.objectFactory.destroy(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Scheduled(initialDelay=10000L, fixedRate=5000L)
    public void poolCleaner() throws InterruptedException, PoolException {
        logger.debug((Object)("HC: queue size: " + this.queue.size() + " poolSize " + this.poolSize.get()));
        int size = this.poolSize.get();
        for (int i = 0; i < size; ++i) {
            Object object = this.borrowObject();
            if (object == null) {
                logger.debug((Object)"HC: object is null");
                continue;
            }
            logger.debug((Object)("HC: validating " + object.toString()));
            if (!this.objectFactory.validate(object)) {
                logger.debug((Object)("HC: destroying " + object.toString()));
                this.destroyObject(object);
                continue;
            }
            this.returnObject(object, false);
        }
        int number = this.poolSize.get() - this.capacity;
        logger.debug((Object)("in cleanpool, the surplus or shortage is: " + number));
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            int iterations = Math.abs(number);
            for (int i = 0; i < iterations; ++i) {
                if (number < 1) {
                    this.createObject();
                    continue;
                }
                Object object = this.borrowObject();
                this.destroyObject(object);
            }
        }
    }

    @Override
    @Scheduled(initialDelay=15000L, fixedRate=60000L)
    public void tempDirCleaner() {
        IOFileFilter filter = new IOFileFilter(){

            public boolean accept(File file) {
                try {
                    Long now = new Date().getTime();
                    Path path = Paths.get(file.getAbsolutePath(), new String[0]);
                    BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    Long inBetween = now - attrs.lastAccessTime().toMillis();
                    if (inBetween > AbstractPool.this.retentionTime) {
                        return true;
                    }
                }
                catch (IOException ioex) {
                    logger.error((Object)("Error: while selection files for deletion: " + ioex.getMessage()));
                }
                return false;
            }

            public boolean accept(File file, String string) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        Collection oldFiles = FileUtils.listFiles((File)TempDir.outputDir.toFile(), (IOFileFilter)filter, null);
        for (File file : oldFiles) {
            file.delete();
        }
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }
}

