<?php
/**
 * Emailq class
 * 
 * Allows and handles email queue regarding notifications.
 * If email queue is enabled, mail are stored in database and then 
 * processed by using a cronjob
 * 
 * @package linea21\modules\emailq
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 
 */

class emailq {
	
	private $params;
	
	/**
	 * Number of email to send on each batch
	 * @var $default_limit
	 */
	private $default_limit = 90;
	
	protected $dispatcher = null;


	public function __construct($a = array())
	{
		$this->dispatcher = $GLOBALS['dispatcher'];
		$this->params = $a;
	}

	public function __call($method, $arguments)
	{
		$event = $this->dispatcher->notifyUntil(new sfEvent($this, 'comment.extensible_function', array(
				'method'    => $method,
				'arguments' => $arguments
		)));
		if (!$event->isProcessed())
		{
			throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
		}

		return $event->getReturnValue();
	}



	public function addToQueue($a, $sql_object) {

		
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent($this, 'emailq.before_add', array('data' => $a)), $a);
		$a = $r->getReturnValue();
		
		$a = $sql_object->DBescape($a);
		
		$a['status'] = 'unsent';
		
		if(!isset($a['priority'])) $a['priority'] = '2'; // priority as medium by default
		
		// if only one email is given we put it an array
		if(is_string($a['recipient'])) {
			$tmp = $a['recipient'];
			$a['recipient'] = array();
			array_push($a['recipient'], $tmp);
		}
		
		for($i=0; $i<count($a['recipient']); $i++) {
			
			$q = "INSERT INTO " . T_EMAIL_QUEUE . " (eq_recipient, eq_subject, eq_htmlbody, eq_textbody, eq_module, eq_priority, eq_status, eq_date_crea) VALUES('" . $a['recipient'][$i] . "', '" . $a['subject'] . "', '" . $a['html_body'] . "', '" . $a['txt_body'] . "', '" . $a['module'] . "', '"  . $a['priority'] . "', '" . $a['status']. "', now());";
			$last_id = $sql_object->DBInsert ($q, 1);
			
		}


		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'emailq.after_add', array('data' => $a, 'id' => $last_id)));

		return $last_id;
	}


	public function setSent($id, $sql_object) {

		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'emailq.set_sent', array('id' => $id)));

		$q = "UPDATE " . T_EMAIL_QUEUE . " SET eq_status = 'sent' WHERE eq_id = ".$id.";";

		$r = $sql_object->DBQuery ($q);

		return $r;
	}

	/*
	 * get queue
	*/
	public function getQueue($sql_object, $limit = false) {

		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'emailq.get_queue', array('limit' => $limit)));
		
		if($limit === false) {
			
			// we get MAIL_BULK by default if integer
			// else we set to default_limit 
			if(defined('MAIL_BULK') && is_int(MAIL_BULK)) {
				$limit = MAIL_BULK;
			}	else {
				$limit = $this->default_limit;
			}
			
		}
		
		$r = $sql_object->DBSelect(SQL_getEmailQueue($limit));
		
		return $r;
	}


	public function purge() {
		
		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'emailq.purge'));
		
		$q = "DELETE FROM " . T_EMAIL_QUEUE . " WHERE eq_status =  'sent';";
		$r = $sql_object->DBQuery ($q);
		
		return $r;
		
	}




}

?>