<?php
/**
 * Level class
 * 
 * Povides methods related to level module
 * 
 * @package linea21\core\level
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Level Management
 */
class level {
	/*
	 * @param
	 */
	var $TDB_LEVEL = T_LEVEL; // nom de la table.
	var $ID;
	var $NAME;
	var $CODE;
	var $LABEL;
	var $PARENT;
	var $DESC_PROJECT;
	var $DESC_DASHBOARD;
	var $DESC_PUBLICATION;
	var $DESC_NEWS;
	var $DESC_WORKSHOP;
	var $RANGE;
	var $DATE_CREA;
	var $STATUS;
	var $LAST_MODIFY;
	protected $dispatcher = null;
	public function __construct() {
		$this->dispatcher = $GLOBALS ['dispatcher'];
	}
	public function __call($method, $arguments) {
		$event = $this->dispatcher->notifyUntil ( new sfEvent ( $this, 'level.extensible_function', array (
				'method' => $method,
				'arguments' => $arguments 
		) ) );
		if (! $event->isProcessed ()) {
			throw new Exception ( sprintf ( 'Call to undefined method %s::%s.', get_class ( $this ), $method ) );
		}
		
		return $event->getReturnValue ();
	}
	
	/**
	 * level::CheckDataIntegrity()
	 * Vérification des données d'un niveau
	 *
	 * @access public
	 * @param array $a
	 *        	: contient les composants d'un niveau
	 * @return boolean si vrai renvoie true sinon message d'erreurs (string)
	 */
	function CheckDataIntegrity($a) {
		// Filter data event + return value
		$r = $this->dispatcher->filter ( new sfEvent ( $this, 'level.before_datacheck', array (
				'data' => $a 
		) ), $a );
		$a = $r->getReturnValue();
		
		if (strlen ( $a ['name'] ) < 2)
			return _t ( 'level', 'object_notname' );
		if (strlen ( $a ['label'] ) < 2)
			return _t ( 'level', 'object_notlabel' );
		
		// Notify the beginning of the current method
		$this->dispatcher->notify ( new sfEvent ( $this, 'level.after_datacheck', array (
				'data' => $a 
		) ) );
		
		return true;
	}
	
	/**
	 * level::AddLevel()
	 * Ajout d'un nouveau niveau
	 *
	 * @access public
	 * @param array $a
	 *        	: contient les composants d'un niveau
	 * @param object $sql_object        	
	 * @return integer $last_id
	 */
	function AddLevel($a, $sql_object) {
		
		global $l21auth;
		
		// Filter data event + return value
		$r = $this->dispatcher->filter ( new sfEvent ( $this, 'level.before_add', array (
				'data' => $a 
		) ), $a );
		$a = $r->getReturnValue ();
		
		$a = $sql_object->DBescape ( $a );
		
		$this->NAME = strip_input( trim ( $a['name']) );
		$this->LABEL = strip_input( trim ( $a['label']) );
		$this->CODE = strip_input( trim ( $a['code']) );
		$this->PARENT = strip_input( trim ( $a['parent']) );
		$this->DESC_PROJECT = strip_input ( trim ($a['desc_det_project']), true );
		$this->DESC_DASHBOARD = strip_input ( trim ($a['desc_det_dashboard']), true );
		$this->DESC_PUBLICATION = strip_input ( trim ($a['desc_det_publication']), true );
		$this->DESC_NEWS = strip_input ( trim ($a['desc_det_news']), true );
		$this->DESC_WORKSHOP = strip_input ( trim ($a['desc_det_workshop']), true );
		$this->RANGE = $a['range'];
		$this->STATUS = $a['status'];
		
		$query = "INSERT INTO " . $this->TDB_LEVEL . " (level_name, level_code, level_label, level_parent, level_desc_project, level_desc_dashboard, " . "level_desc_publication, level_desc_news, level_desc_workshop, level_range, ". "level_status, level_date_crea) " . "VALUES('" . $this->NAME . "', '". $this->CODE ."', '" . $this->LABEL . "', " . $this->PARENT . ", '" . $this->DESC_PROJECT . "', '" . $this->DESC_DASHBOARD . "', '" . $this->DESC_PUBLICATION . "', '" . $this->DESC_NEWS . "', '" . $this->DESC_WORKSHOP . "', " . $this->RANGE. ", '" . $this->STATUS . "', NOW());";
	
		$last_id = $sql_object->DBInsert ( $query, 1 );
		
		// we log add action
		if(is_numeric($last_id))	logfile(LOG_MAINFILE, array('[action] add level', 'ID='.$last_id, 'by_id='.$l21auth->GetSessionElement('id'), 'by_login='.$l21auth->GetSessionElement('login')));
		
		// Notify the beginning of the current method
		$this->dispatcher->notify ( new sfEvent ( $this, 'level.after_add', array (
				'data' => $a,
				'id' => $last_id 
		) ) );
		
		return $last_id;
	}
	
	/**
	 * level::ModifyLevel()
	 * modification d'un niveau
	 *
	 * @access public
	 * @param int $ID
	 *        	: identifiant du niveau
	 * @param array $a
	 *        	: contient les composants d'un niveau
	 * @param object $sql_object        	
	 * @return bool $result
	 */
	function ModifyLevel($ID, $a, $sql_object) {
		
		// Filter data event + return value
		$r = $this->dispatcher->filter ( new sfEvent ( $this, 'level.before_modify', array (
				'data' => $a,
				'id' => $ID 
		) ), $a );
		$a = $r->getReturnValue ();
		
		$a = $sql_object->DBescape ($a);
		
		if (is_numeric ( $ID )) {
			$this->ID = $ID;
		}
		
		$this->NAME = strip_input( trim ( $a['name']) );
		$this->LABEL = strip_input( trim ( $a['label']) );
		$this->CODE = strip_input( trim ( $a['code']) );
		$this->PARENT = strip_input( trim ( $a['parent']) );
		$this->DESC_PROJECT = strip_input ( trim ($a['desc_det_project']), true );
		$this->DESC_DASHBOARD = strip_input ( trim ($a['desc_det_dashboard']), true );
		$this->DESC_PUBLICATION = strip_input ( trim ($a['desc_det_publication']), true );
		$this->DESC_NEWS = strip_input ( trim ($a['desc_det_news']), true );
		$this->DESC_WORKSHOP = strip_input ( trim ($a['desc_det_workshop']), true );
		$this->STATUS = $a['status'];
		

			$query = "UPDATE  " . $this->TDB_LEVEL . " set level_name='" . $this->NAME . "', level_code='" . $this->CODE . "', level_label='" . $this->LABEL . "' , level_parent='" . $this->PARENT . "', level_desc_project='" . $this->DESC_PROJECT . "', level_desc_dashboard='" . $this->DESC_DASHBOARD . "',level_desc_publication= '" . $this->DESC_PUBLICATION . "', level_desc_news='" . $this->DESC_NEWS . "' , level_desc_workshop='" . $this->DESC_WORKSHOP . "' , level_status='" . $this->STATUS . "', level_last_modify=NOW() WHERE level_id='" . $this->ID . "';";
		
		
		$result = $sql_object->DBQuery ( $query );
		
		// Notify the beginning of the current method
		$this->dispatcher->notify ( new sfEvent ( $this, 'level.after_modify', array (
				'data' => $a,
				'id' => $this->ID 
		) ) );
		
		return $result;
	}
	
	/**
	 * level::StateLevel()
	 * modification du statut d'un niveau
	 * -- NE PREND PAS EN CHARGE l'EFFACEMENT --
	 *
	 * @access public
	 * @param int $ID
	 *        	identifiant
	 * @param string $state
	 *        	(facultatif) 'P' Public/'D' Draft
	 * @param object $sql_object        	
	 * @return bool $result
	 */
	function StateLevel($ID, $state, $sql_object) {
		// Notify the end of the current method
		$this->dispatcher->notify ( new sfEvent ( $this, 'level.change_state', array (
				'id' => $ID,
				'state' => $state 
		) ) );
		
		if (is_numeric ( $ID )) {
			$this->ID = $ID;
		}
		if ($state != '') {
			strtoupper ( $state );
			switch ($state) {
				case 'P' :
					$this->STATUS = $state;
					break;
				case 'D' :
					$this->STATUS = $state;
					break;
				default :
					$this->STATUS = $state;
					break;
			}
		} else
			$this->STATUS = 'P';
		$query = "UPDATE  " . $this->TDB_LEVEL . " set level_status='" . $this->STATUS . "', level_last_modify=NOW() WHERE level_id=" . $this->ID . ";";
		$result = $sql_object->DBQuery ( $query );
		return $result;
	}
	
	/**
	 * level::DeleteLevel()
	 * suppression d'un niveau
	 *
	 * @access public
	 * @param int $ID
	 *        	identifiant du niveau
	 * @param string $type
	 *        	'MASS_DELETE' toutes les ressources associées au niveau sont rendues inactives
	 *        	'MASS_MODIFY' remplacement de l'ancien niveau par $ID_new
	 * @param int $id_new
	 *        	nouvel id de rattachement
	 * @param object $sql_object        	
	 * @return bool $result
	 */
	function DeleteLevel($ID, $sql_object, $type, $ID_new = -1) {
		
		global $l21auth;
		
		$affected = 0;
		if (is_numeric ( $ID )) {
			$this->ID = $ID;
		}
		
		// Notify the end of the current method
		$this->dispatcher->notify ( new sfEvent ( $this, 'level.delete', array (
				'id' => $ID,
				'type' => $type,
				'new_id' => $ID_new 
		) ) );
		
		if ($type == 'MASS_MODIFY') {
			if ($ID_new != 0 && is_numeric ( $ID_new )) {
				$query = "UPDATE  " . $this->TDB_LEVEL . " set level_status='E', level_last_modify=NOW() WHERE level_id=" . $this->ID . ";";
				$result = $sql_object->DBQuery ( $query );
				
				if ($result == true) {
					$query_news = "UPDATE  " . T_NEWS . " set news_level=" . $ID_new . " WHERE  news_level=" . $this->ID . ";";
					$result = $sql_object->DBQuery ( $query_news );
					$affected += $sql_object->DBaffectedRow ();
					$query_project = "UPDATE  " . T_PROJECT . " set project_level_id=" . $ID_new . " WHERE  project_level_id=" . $this->ID . ";";
					$result = $sql_object->DBQuery ( $query_project );
					$affected += $sql_object->DBaffectedRow ();
					$query_publication = "UPDATE  " . T_PUBLI . " set publi_level=" . $ID_new . " WHERE  publi_level=" . $this->ID . ";";
					$result = $sql_object->DBQuery ( $query_publication );
					$affected += $sql_object->DBaffectedRow ();
					$query_workshop = "UPDATE  " . T_WORK . " set workshop_level=" . $ID_new . " WHERE  workshop_level=" . $this->ID . ";";
					$result = $sql_object->DBQuery ( $query_workshop );
					$affected += $sql_object->DBaffectedRow ();
					$query_sdiinfo = "UPDATE  " . T_SDI_INFO . " set sdii_level=" . $ID_new . " WHERE  sdii_level=" . $this->ID . ";";
					$result = $sql_object->DBQuery ( $query_workshop );
					$affected += $sql_object->DBaffectedRow ();
					$query_yellowpages = "UPDATE  " . T_YELLOWPAGES . " set yellowp_level=" . $ID_new . " WHERE  yellowp_level=" . $this->ID . ";";
					$result = $sql_object->DBQuery ( $query_yellowpages );
					$affected += $sql_object->DBaffectedRow ();
				}
			}
		}
		if ($type == 'MASS_DELETE') {
			$query = "UPDATE  " . $this->TDB_LEVEL . " SET level_status='E', level_last_modify=NOW() WHERE level_id=" . $this->ID . ";";
			$result = $sql_object->DBQuery ( $query );
			if ($result == true) {
				$query_news = "UPDATE  " . T_NEWS . " SET news_statut='E' WHERE  news_level=" . $this->ID . ";";
				$result = $sql_object->DBQuery ( $query_news );
				$affected += $sql_object->DBaffectedRow ();
				$query_project = "UPDATE  " . T_PROJECT . " SET project_statut='E' WHERE  project_level_id=" . $this->ID . ";";
				$result = $sql_object->DBQuery ( $query_project );
				$affected += $sql_object->DBaffectedRow ();
				$query_publication = "UPDATE  " . T_PUBLI . " SET publi_statut='E' WHERE  publi_level=" . $this->ID . ";";
				$result = $sql_object->DBQuery ( $query_publication );
				$affected += $sql_object->DBaffectedRow ();
				$query_workshop = "UPDATE  " . T_WORK . " SET workshop_statut='E' WHERE  workshop_level=" . $this->ID . ";";
				$result = $sql_object->DBQuery ( $query_workshop );
				$affected += $sql_object->DBaffectedRow ();
				$query_sdiinfo = "UPDATE " . T_SDI_INFO . " SET sdii_statut='E' WHERE  sdii_level=" . $this->ID . ";";
				$result = $sql_object->DBQuery ( $query_sdiinfo );
				$affected += $sql_object->DBaffectedRow ();
// 				$query_sdivalue = "UPDATE " . T_SDI_VALUE . " SET sdiv_statut='E' WHERE sdiv_sdi_info=" . $this->ID . ";";
// 				$result = $sql_object->DBQuery ( $query_sdivalue );
				$affected += $sql_object->DBaffectedRow ();
				$query_yellowpages = "UPDATE  " . T_YELLOWPAGES . " SET yellowp_statut='AA' WHERE  yellowp_level=" . $this->ID . ";";
				$result = $sql_object->DBQuery ( $query_yellowpages );
				$affected += $sql_object->DBaffectedRow ();
			}
		}
		
		// we log delete action
		if($result)	logfile(LOG_MAINFILE, array('[action] delete level ('.$type.')', 'ID='.$ID, 'ID_new='.$ID_new, 'affected_rows='.$affected, 'by_id='.$l21auth->GetSessionElement('id'), 'by_login='.$l21auth->GetSessionElement('login')));
		
		return $affected;
	}
}

?>
