<?php
/**
 * Plugin class
 * 
 * Povides methods related to plugin module
 * 
 * @package linea21\modules\plugin
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Plugin Management
 */

class plugin {

	private $info = array();
	protected $dispatcher = null;

	public function __construct($name) {

		$a = array();
		$this->dispatcher = $GLOBALS['dispatcher'];

		try{

			if(!@$flow=simplexml_load_file(SITE_PATH.'plugins/'.$name.'/plugin.xml')){
				throw new Exception($name.' plugin : xml file was not found');
			}

			$this->info['name'] = $name;
			$this->info['shortname'] = str_replace('l21_', '', $name);
			$this->info['description'] = $flow->description;
			$this->info['version'] = $flow->version;
			$this->info['date'] = $flow->date;
			$this->info['compatibility'] = $flow->compatibility;
			$this->info['author'] = $flow->author;
			$this->info['homepage'] = $flow->homepage;
			$this->info['settings'] = (integer) $flow->settings;
			$this->info['load_on_settings'] = (integer) $flow->load_on_settings;
			$this->info['default_language'] = $flow->default_language;
			$this->info['status'] = $flow->status;
			$this->info['image'] = $flow->image;
			$this->info['active_path'] = SITE_PATH.'plugins/'.$this->info['name'].'/.active';
			$this->info['active_url'] = SITE_ROOT_URL.'plugins/'.$this->info['name'].'/';
			$this->info['relative_url'] = '../plugins/'.$this->info['name'].'/';
			$this->info['absolute_url'] = SITE_ROOT_URL.'plugins/'.$this->info['name'].'/';
			
			$this->info['restricted_edition']['files'] = array();
			$this->info['restricted_edition']['folders'] = array();
			
			if(isset($flow->restricted_edition)) {
				
				if(isset($flow->restricted_edition->file)) {

					foreach($flow->restricted_edition->file as $el) {
						$this->info['restricted_edition']['files'][]=(string) '../plugins/'. $this->info['name']. '/'. $el;
					}

				}
			
				if(isset($flow->restricted_edition->folder)) {
					
					foreach($flow->restricted_edition->folder as $el) {
						$this->info['restricted_edition']['folders'][]=(string) '../plugins/'. $this->info['name']. '/'. $el;
					}					
				}
			}
			if(isset($flow->apps->app)) {
				foreach($flow->apps->app as $el) {
					$this->info['apps'][]=(string) $el;
				}
			}
		}
		catch(Exception $e){
			return $e->getMessage();
		}

	}

	public function __toString() {
		return $this->getVar('name');
	}

	public function hasImage() {

		if(!empty($this->info['image'])) return true;
		else return false;

	}

	public function hasAdvancedSettings() {

		if($this->info['settings'] == true) return true;
		else return false;

	}

	public function imagePath() {

		return '../plugins/'.$this->info['name'].'/'.$this->info['image'];

	}

	public function getPluginInfo() {

		return $this->info;

	}

	public function getVar($varname) {

		if(isset($this->info[$varname])) {
			return $this->info[$varname];
		} else {
			return false;
		}
	}

	public function getAvailablePlugins() {

		return availablePlugins();

	}

	public function loadPlugin() {

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'plugin.load'));

		// we check if the current app is concerned by the module or if we are in current plugin page (back-office)
		//if(($this->getVar('apps') && in_array(CURRENT_APP, $this->getVar('apps'))) || (isset($_REQUEST['current']) && isset($_REQUEST['rub']) && $_REQUEST['rub'] == 'plugins' && $_REQUEST['current'] == $this->info['name'])) {
		if(($this->getVar('apps') && in_array(CURRENT_APP, $this->getVar('apps'))) || $this->info['load_on_settings'] == true) {
					
			IncludeLanguagesPluginfiles($this);
			
			if(file_exists(SITE_PATH.'plugins/'.$this->info['name'].'/__init__.php')) {
				include_once(SITE_PATH.'plugins/'.$this->info['name'].'/__init__.php');
			}
			return true;
			
			// we are in the plugin settings page, we include at least language files
		} elseif (isset($_REQUEST['current']) && isset($_REQUEST['rub']) && $_REQUEST['rub'] == 'plugins' && $_REQUEST['current'] == $this->info['name']) {

			IncludeLanguagesPluginfiles($this);
			return true;
			
		} else {
			
			return true;
			
		}
	}

	public function enable() {

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'plugin.enable'));

		$fp = fopen($this->getVar('active_path'), "x");
		fclose($fp);

		if(file_exists(SITE_PATH.'plugins/'.$this->info['name'].'/__install__.php')) {
			include_once(SITE_PATH.'plugins/'.$this->info['name'].'/__install__.php');
		}

	}

	public function disable() {
		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'plugin.disable'));

		if(file_exists(SITE_PATH.'plugins/'.$this->info['name'].'/__uninstall__.php')) {
			include_once(SITE_PATH.'plugins/'.$this->info['name'].'/__uninstall__.php');
		}
		
		return unlink($this->getVar('active_path'));

	}

	public function is_active() {

		return file_exists($this->getVar('active_path'));

	}

	public function retrieveValues($sqlo) {

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'plugin.retrieve_values'));

		$q = 'SELECT plugin_values FROM '.T_PLUGIN. ' WHERE plugin_name = "'.$this->getVar('name').'"';
		$r = $sqlo->DBSelect($q);

		if(isset($r[0]['plugin_values'])){
			return unserialize($r[0]['plugin_values']);
		} else {
			return false;
		}
	}

	public function storeValues($array, $sqlo) {

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'plugin.store_values'));

		// test if plugin is already registerd
		if($this->isDatabaseRegistered($sqlo)) {

			$q = 'UPDATE '.T_PLUGIN. ' SET plugin_values="'.$sqlo->DBescape(serialize($array)).'" WHERE plugin_name = "'.$this->getVar('name').'";';
			$r = $sqlo->DBQuery($q);

		} else {

			$q = 'INSERT INTO '.T_PLUGIN. ' (plugin_name, plugin_values, plugin_date_crea) VALUES("'.$this->getVar('name').'",  "'.$sqlo->DBescape(serialize($array)).'", NOW());';
			$r = $sqlo->DBInsert($q);
		}

	return $r;

	}

	public function isDatabaseRegistered($sqlo) {

		$q = 'SELECT plugin_values FROM '.T_PLUGIN. ' WHERE plugin_name = "'.$this->getVar('name').'"';
		$r = $sqlo->DBSelect($q);

		if(isset($r[0]['plugin_values'])) return true;
		else return false;

	}


}

?>