<?php
/**
 *  Handle content for publication and workgroup report modules
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\content
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Content' module is used by 'Publication' and 'Workshop' modules
 */

include_once(override('../contents/'.SQL.'.inc.php'));

if(!function_exists('DisplayOneWorkshopPart')) {

  function DisplayOneWorkshopPart($work_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOneWorkshopParts($work_id, array('Y')));
    $content = '';

    if($data == 0) error_redirect();

    if(count($data)!=1) exit;
    else
    {
      $workrepcon_title=formatText($data[0]['workrepcon_title'], '2HTML');
      $workrepcon_body=linkin_content(formatText($data[0]['workrepcon_body'], '2HTML'));
      $workrepcon_date_crea_display=formatText($data[0]['workrepcon_date_crea_display'], '2HTML');
      $link_self = array('rub' => $GLOBALS['links'][U_L]['report-part']['linkvalue'], 'id' => $work_id, 'parentid' => $_REQUEST['parentid']);

      $content.='<h1>'.$workrepcon_title.'</h1>'.PHP_EOL;
      $content.='<p class="published_by">'.PHP_EOL;
      $content.= formatted_permalink($link_self);
      $content.='</p>'.PHP_EOL;
      $content.='<div class="body">'.$workrepcon_body.'</div>';

    }
    echo $content;
  }
}

if(!function_exists('DisplayOnePublicationPart')) {

  function DisplayOnePublicationPart($publi_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnePublicationParts($publi_id, array('Y')));
    $content = '';

    $link_self = array('rub' => $GLOBALS['links'][U_L]['publication-part']['linkvalue'], 'id' => $publi_id, 'parentid' => $_REQUEST['parentid']);

    if($data == 0) error_redirect();

    if(count($data)!=1) exit;
    else
    {
      $title=formatText($data[0]['publicon_title'], '2HTML');
      $body=linkin_content(formatText($data[0]['publicon_body'], '2HTML'));
      $publicon_date_crea_display=formatText($data[0]['publicon_date_crea_display'], '2HTML');

      $content.='<h1>'.$title.'</h1>'.PHP_EOL;
      $content.='<p class="published_by">'.PHP_EOL;
      $content.= formatted_permalink($link_self);
      $content.='</p>'.PHP_EOL;
      $content.='<div class="body">'.$body.'</div>';
      $content.='<hr />';

    }
    echo $content;
  }
}

if(!function_exists('DisplayWorkshopNameAndGroup')) {

  function DisplayWorkshopNameAndGroup($work_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopRepTitleAndGroup($work_id));
    $content = '';
    if(count($data)!=1) exit;
    else
    {
      $link_workshop= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[0]['workshop_id'], 'name' => $data[0]['workshop_denomination']);
      $link_workshoprep= array('rub'=> $GLOBALS['links'][U_L]['report']['linkvalue'],'id'=>$data[0]['workrep_id'], 'name' => $data[0]['workrep_title']);

      $workrep_title=formatText($data[0]['workrep_title'], '2HTML');
      $workshop_denomination=formatText($data[0]['workshop_denomination'], '2HTML');

      $content.='<p id="parentHeader">'.PHP_EOL;
      $content.='<span class="item-label">'.mb_ucfirst(_t('workshoprep','name')).' : </span>';
      $content.='<a href="'.HrefMaker($link_workshoprep).'" title="'.$GLOBALS['links'][U_L]['report']['desc']. ' ('.$workrep_title.')">'.$workrep_title.'</a>';
//       $content.=' | ';
//       $content.='<span class="workshopname">';
//       $content.='<a href="'.HrefMaker($link_workshop).'" title="'._t('workshoprep','workshop_product'). ' : '.formatText($workshop_denomination, '2ATT').'">'.$workshop_denomination.'</a>';
//       $content.='</span>';
      $content.='</p>'.PHP_EOL;

    }
    echo $content;
  }
}

if(!function_exists('DisplayPublicationTitle')) {

  function DisplayPublicationTitle($publi_id) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationTitle($publi_id));
    $content = '';
    if(count($data)!=1) exit;
    else
    {
      $link_publi= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'],'id'=>$data[0]['publi_id'], 'name'=> $data[0]['publi_title']);
      $publi_title=formatText($data[0]['publi_title'], '2HTML');

      $content.='<p id="parentHeader">'.PHP_EOL;
      $content.='<span class="item-label">'.mb_ucfirst(_t('publication','name')).' : </span>';
      $content.='<a href="'.HrefMaker($link_publi).'" title="'.$GLOBALS['links'][U_L]['publication']['desc']. ' ('.formatText($publi_title, '2ATT').')">'.$publi_title.'</a>';
      $content.='</p>'.PHP_EOL;

    }
    echo $content;
  }
}

if(!function_exists('DisplayWorkshopRepLinkinPart')) {

  function DisplayWorkshopRepLinkinPart($id, $parentid, $format='TEXT') {
    /**
     * $id -> partie courante
     * $parentid -> id du dossier
     * $format 'NUM' || 'TEXT'
     */
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopParts($parentid));
    $content = '';

    if($data!=0)
    {
      $content.='<div id="linkinparts">';
      $content.='<h2>'.mb_ucfirst(_t('workshoprep','name2')).'</h2>'.PHP_EOL;
      //$content.=_t('publication','goto').' : '.PHP_EOL;

      if($format=='TEXT') {
        $content.='<ol>'.PHP_EOL;
        for($i=0; $i<count($data); $i++)
        {
          $link_parts= array('rub'=> $GLOBALS['links'][U_L]['report-part']['linkvalue'],'id'=> $data[$i]['workrepcon_id'],'parentid'=>$parentid, 'name'=> $data[$i]['workrepcon_title']);
          $workrepcon_title=formatText($data[$i]['workrepcon_title'], '2HTML');
          $content.='<li>'.PHP_EOL;
          //$content.='<span class="num">'.($i +1).' - </span>'.PHP_EOL;
          if($id!=$data[$i]['workrepcon_id']) {
            $content.='<a href="'. HrefMaker($link_parts).'" title="'.formatText($workrepcon_title, '2ATT').'">';
            $content.=$workrepcon_title;
            $content.='</a>';
          } else {
            $content.='<span>'.$workrepcon_title. '</span>';
          }
          $content.='</li>'.PHP_EOL;
        }
        $content.='</ol>'.PHP_EOL;
      } else {
        $content.= _t('contents','name').' : '.PHP_EOL;
        $sep='';
        for($i=0; $i<count($data); $i++)
        {
          $link_parts= array('rub'=> $GLOBALS['links'][U_L]['report-part']['linkvalue'],'id'=> $data[$i]['workrepcon_id'],'parentid'=>$parentid, 'name'=> $data[$i]['workrepcon_title']);
          $workrepcon_title=formatText($data[$i]['workrepcon_title'], '2HTML');
          $content.=$sep;
          if($id!=$data[$i]['workrepcon_id']) {
            $content.='<a href="'. HrefMaker($link_parts).'" title="'.formatText($workrepcon_title, '2ATT').'">';
            $content.=($i +1);
            $content.='</a>';
          } else {
            $content.=($i +1);
          }
          $sep=' - ';
        }
      }
      $content.='</div>'.PHP_EOL;
    }
    echo $content;
  }
}


if(!function_exists('DisplayPublicationLinkinPart')) {

  function DisplayPublicationLinkinPart($id, $parentid, $format='TEXT') {
    /**
     * $id -> partie courante
     * $parentid -> id du dossier
     * $format 'NUM' || 'TEXT'
     */

    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationParts($parentid));
    $content = '';

    if($data!=0)
    {
      $content.='<div id="linkinparts">'.PHP_EOL;
      $content.='<h2>'.mb_ucfirst(_t('publication', 'summary')).'</h2>';
      if($format=='TEXT') {
        $content.='<ol>'.PHP_EOL;
        for($i=0; $i<count($data); $i++)
        {
          $link_parts= array('rub'=> $GLOBALS['links'][U_L]['publication-part']['linkvalue'],'id'=> $data[$i]['publicon_id'],'parentid'=>$parentid, 'name'=> $data[$i]['publicon_title']);
          $publicon_title=formatText($data[$i]['publicon_title'], '2HTML');
          $content.='<li>'.PHP_EOL;
          //$content.='<span class="num">'.($i +1).' - </span>'.PHP_EOL;
          if($id!=$data[$i]['publicon_id']) {
            $content.='<a href="'. HrefMaker($link_parts).'" title="'.formatText($publicon_title, '2ATT').'">';
            $content.=$publicon_title;
            $content.='</a>';
          } else {
            $content.='<span>' . $publicon_title . '</span>';
          }
          $content.='</li>'.PHP_EOL;
        }
        $content.='</ol>'.PHP_EOL;
      } else {
        $content.=''._t('publication','part_number2').' : '.PHP_EOL;
        $sep='';
        for($i=0; $i<count($data); $i++)
        {
          $link_parts= array('rub'=> $GLOBALS['links'][U_L]['publication-part']['linkvalue'],'id'=> $data[$i]['$publicon_id'],'parentid'=>$parentid, 'name'=> $data[$i]['publicon_title']);
          $publicon_title=formatText($data[$i]['$publicon_title'], '2HTML');
          $content.=$sep;
          if($id!=$data[$i]['workrepcon_id']) {
            $content.='<a href="'. HrefMaker($link_parts).'" title="'.formatText($publicon_title, '2ATT').'">';
            $content.=($i +1);
            $content.='</a>';
          } else {
            $content.=($i +1);
          }
          $sep=' - ';
        }
      }
      $content.='</div>'.PHP_EOL;

    }
    echo $content;
  }
}

if(!function_exists('DisplayLinkParts')) {

  function DisplayLinkParts($current_part, $parentid, $direction, $type) {

    if($type=='W') {
      $link_rub=$GLOBALS['links'][U_L]['report-part']['linkvalue'];
      $q = SQL_getWorkshopRepRangeAndDate($current_part);
      $r = $GLOBALS['sql_object']->DBSelect($q);
      $range = $r[0]['item_range'];
      $published_date = $r[0]['item_date_crea'];
    }
    if($type=='P') {
      $link_rub=$GLOBALS['links'][U_L]['publication-part']['linkvalue'];
      $q = SQL_getPublicationRangeAndDate($current_part);
      $r = $GLOBALS['sql_object']->DBSelect($q);
      $range = $r[0]['item_range'];
      $published_date = $r[0]['item_date_crea'];
    }

    if($direction=='NEXT') {
      if($type=='W') {
        if($range != 0) {
        	$q = SQL_getNextWorkshopRepPartsByRange($current_part, $parentid, $range);
        } else {
        	$q = SQL_getNextWorkshopRepPartsByDate($current_part, $parentid, $published_date);
        }
      }
      if($type=='P') {
        if($range != 0) {
        	$q = SQL_getNextPublicationPartsByRange($current_part, $parentid, $range);
        } else {
        	$q = SQL_getNextPublicationPartsByDate($current_part, $parentid, $published_date);
        }
      }
      $class='next';
      $prefix = ' | ';
      $suffix = ' →';
      $title=_t('publication','next_part');
    }
    if($direction=='PREVIOUS') {
      if($type=='W') {
        if($range != 0) {
        	$q = SQL_getPreviousWorkshopRepPartsByRange($current_part, $parentid, $range);
        } else {
        	$q = SQL_getPreviousWorkshopRepPartsByDate($current_part, $parentid, $published_date);
        }
      }
      if($type=='P') {
        if($range != 0) {
        	$q = SQL_getPreviousPublicationPartsByRange($current_part, $parentid, $range);
        } else {
        	$q = SQL_getPreviousPublicationPartsByDate($current_part, $parentid, $published_date);
        }
      }
      $class='previous';
      $prefix = '← ';
      $suffix = '';
      $title=_t('publication','prev_part');
    }
    $data=$GLOBALS['sql_object'] -> DBSelect($q);

    if($data==false || count($data)!=1) $content = '';
    else
    {
      $link_part= array('rub'=> $link_rub,'id'=>$data[0]['part_id'], 'parentid' =>$parentid, 'name'=> $data[0]['part_title']);
      $part_title=formatText(cutText($data[0]['part_title'], 45), '2HTML');
      $part_complete_title=formatText($data[0]['part_title'], '2HTML');

      $content ='<div class="'.$class.'">'.PHP_EOL;
      $content.=$prefix;
      $content.='<a href="'.HrefMaker($link_part).'" title="'.formatText($title.' : '.$part_complete_title, '2ATT').'">'.$part_title.'</a>';
      $content.=$suffix;
      $content.='</div>'.PHP_EOL;

    }
    echo $content;
  }
}

?>