<?php
/**
 * Dashboard module
 * 
 * Indicator detail page. Display all values entered for a specific indicators
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if(!isset($_GET['id']) && !isset($_POST['id'])) {
	$id="1";
} else {
	if(isset($_POST['id']))	$id=$_POST['id'];
	if(isset($_GET['id']))	$id=$_GET['id'];
}
if(!isset($_GET['scale_id']) && !isset($_POST['scale_id'])) {
	$scale_id=1;
} else {
	if(isset($_POST['scale_id']))	$scale_id=$_POST['scale_id'];
	if(isset($_GET['scale_id']))	$scale_id=$_GET['scale_id'];
}

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('dashboard') && !$l21auth->hasRight('indicator', $id)) ReloadIndex('admin');
////////////

include_once("../dashboard/common.php");

if(defined('CLIENT_CHARTS') && CLIENT_CHARTS == 1) {
	footerAddJS('../lib/js/Highcharts-4.1.8/js/highcharts.js');
	footerAddJS('../lib/js/Highcharts-4.1.8/js/modules/exporting.js');
	footerAddJS('../lib/js/generate-chart.js');
	//footerAddJS('../lib/js/Highcharts-4.1.8/js/themes/grid-light.js');
}

?>

<?php
$sdi_object= new sdi;
//$result_sdii=$sdi_object->GetInfoSdi($id, $sql_object);
//$result_e=$sdi_object->GetEvaluation( $id, $sql_object, $ID=-1);
//$result_p=$sdi_object->GetProvider( $id, $sql_object, $ID=-1);
//$result_r=$sdi_object->GetRules( $id, $sql_object, $ID=-1);
$req_sdii=SQL_getInfoSdi($id);
$result_sdii = $sql_object -> DBSelect($req_sdii);

// Do record exists?
if(!isset($result_sdii[0]['sdii_name'])) redirect_to('@module_default');

// setting $default_threshold value
// By default initial value
$default_threshold = $result_sdii[0]['sdii_threshold_value'];

$req_sdir=SQL_getRules( $id, $sql_object, $ID=-1);
$result_r = $sql_object -> DBSelect($req_sdir);

$req_sdie=SQL_getEvaluation( $id, $sql_object, $ID=-1);
$result_e = $sql_object -> DBSelect($req_sdie);

$req_sdip=SQL_getProvider( $id, $sql_object, $ID=-1);
$result_p = $sql_object -> DBSelect($req_sdip);

$req_sdiav=SQL_getAllValue("SCA", $scale_id, $id);
$result_value = $sql_object -> DBSelect($req_sdiav);

//$result_value=$sdi_object->GetAllValue("SCA", $scale_id, $id, $sql_object);
$req_scale=SQL_getonescale($scale_id);
$resultscale2 = $sql_object -> DBSelect($req_scale);

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_det_level="index.php?rub=level&amp;todo=det&amp;id=";
$link_det_indicator="index.php?rub=sdi&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;value_id=";
$link_mod=$rub_link."&amp;todo=mod&amp;value_id=";
$link_add=$rub_link."&amp;todo=add&amp;id=";
$navtitle=_t('dashboard','det')." : ".$result_sdii[0]['sdii_name'];
//valeur du graphique
?>

<script>
	var input = [];
	input['viz_title'] = "<?php echo formatText($result_sdii[0]['sdii_name'], '2HTML'); ?>";
	input['viz_type'] = "<?php echo $result_sdii[0]['sdii_detail_viz']; ?>";
	input['viz_vtype'] = "<?php echo $result_sdii[0]['sdii_value_type']; ?>"; // 'multiple' or 'unique'
	input['serie_name'] = "<?php echo formatText(_t('dashboard', 'value'), '2HTML'); ?>";
	input['threshold_name'] = "<?php echo formatText(_t('dashboard', 'threshold_value'), '2HTML'); ?>";
	input['yAxis_title'] = "<?php echo formatText($result_sdii[0]['sdii_unit'], '2HTML'); ?>";
	input['negative_notice'] = "<?php echo formatText(_t('dashboard', 'negative_values_notice')); ?>";
</script>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','dashboard')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle);	?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2($result_sdii[0]['sdii_name']); ?></h2>

<!--  Unique value export -->
<form id="report" action="../export/report.php" method="post" class="visually-hidden">
<input type="hidden" name="what" value="dashboard">
<input type="hidden" name="quick_export" value="1">
<input type="hidden" name="scale" value="all">
<input type="hidden" name="sdi" value="det">
<input type="hidden" name="eachsdi[]" value="<?php echo $id; ?>">
<input type="hidden" name="graphic" value="1">
<input type="hidden" name="table_value" value="1">
<input type="hidden" name="notpublished" value="1">
<input type="hidden" name="provider" value="1">
<input type="hidden" name="reglementation" value="1">
<input type="hidden" name="evaluation" value="1">
<input type="hidden" name="format_report" value="word"><!-- pdf / word / html -->
<input type="hidden" name="sauver" value="1">
</form>
<!-- dropdown container -->
<div class="dropdown export-button" id="export-report">
<!-- trigger button -->
<button><i class="icon-export"></i> <?php echo _t('export', 'action'); ?></button>
    <!-- dropdown menu -->
    <ul class="dropdown-menu">
        <li><a href="#report" data-format="pdf"><i class="icon-file-pdf"></i> <?php echo _t('export', 'format', 'pdf'); ?></a></li>
        <li><a href="#report" data-format="word"><i class="icon-file-word"></i> <?php echo _t('export', 'format', 'word'); ?></a></li>
        <li><a href="#report" data-format="html"><i class="icon-html5"></i> <?php echo _t('export', 'format', 'html'); ?></a></li>
    </ul>
</div>
<script>
$( "#export-report li a" ).click(function() {
	var format = $(this).attr('data-format');
	$( "#report input[name=format_report]").val(format);
  $( "#report" ).submit();
  return false;
});
</script>

<div class="iconetodo2">
<?php echo "<a href=\"".$link_add.$id."&amp;scale_id=".$scale_id."\" title=\""._t('dashboard','add')."\" class=\"ico_add2\">";?><i class="icon-plus-circled"></i><span><?php echo _t('dashboard','add'); ?></span></a>
<?php if ($l21auth->isSuperAdmin()) { echo "<a href=\"".$link_det_indicator.$id."\" title=\""._t('sdi','det')."\" class=\"ico_generic2 no-action\">";?><i class="icon-eye"></i><span><?php echo _t('sdi','det'); ?></span></a><?php } ?> 
</div>

<?php if ($result_value <> false) { ?> <br />
<?php if (count($result_value) > 2) {?>
	<?php 
	$slugname = Stringy\Stringy::create($result_sdii[0]['sdii_name'].'_'.$resultscale2[0]['scale_denomination'], CHARSET)->safeTruncate(50)->slugify(). '.png';
	$js_dlChart = "
 		$( 'div.chart-container')
			.on( 'mouseenter', function() {
				$('.download-chart').fadeIn(100);
			})
			.on( 'mouseleave', function() {
				$('.download-chart').fadeOut( 500 );
			});";
	footerAddInlineJS($js_dlChart);
	?>
	
	<?php if($result_sdii[0]['sdii_type'] == 'quantitative') { ?>
	<?php if(!defined('CLIENT_CHARTS') || CLIENT_CHARTS != 1) { ?>
		<div class="chart-container">
		<img src="<?php echo override('../dashboard/graph.php')?>?id=<?php echo $id; ?>&amp;scale_id=<?php echo $scale_id; ?>&amp;display=true" id="imggraph" class="graph" alt="<?php echo _t('dashboard','all_value');?>" />
		<a class="download-chart ico_generic2" title="<?php echo mb_ucfirst(_t('dashboard', 'download_chart')); ?>" href="<?php echo override('../dashboard/graph.php')?>?id=<?php echo $id; ?>&amp;scale_id=<?php echo $scale_id; ?>&amp;display=true" download="<?php echo $slugname; ?>"><i class="icon-download"></i><span> <?php echo mb_ucfirst(_t('dashboard', 'download_chart')); ?></span></a>
		</div>
	<?php } else { ?>
		<div id="main-chart-container"></div>
	<?php }  ?>
	<?php }  ?>
	<?php if($result_sdii[0]['sdii_type'] == 'qualitative') echo getQualitativeViz($result_value, $result_sdii[0]); ?>
<?php } ?>
<h2><?php echo formatTitleh2(_t('dashboard','all_value')." / ".$resultscale2[0]['scale_denomination']); ?></h2>
<?php
// check if we use multi-values or not
($result_sdii[0]['sdii_value_type'] == 'multiple') ? $tclass = ' multi-values' : $tclass = '';
?>
<table class="multisort<?php echo $tclass; ?>" id="indicator-values">
	<thead>
		<tr>
		<?php
		echo "<td>".mb_ucfirst(_t('dashboard','date'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('divers','by'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('dashboard','value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
		if($result_sdii[0]['sdii_value_type'] == 'multiple') echo "<td style=\"display:none\"  data-tableexport-display=\"always\">".mb_ucfirst(_t('dashboard','multivalue_distribution'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('dashboard','threshold_value'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('dashboard','rate'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('dashboard','comment'))."</td>\n";
		echo "<td class=\"sorter-false\">&nbsp;</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php
	for ($i=0;$i<count($result_value);$i++){
	  $comment = '';
	  $current_val = '';
	  $data_pie = '';
	  
	  $raw_multivalue = ''; // used to generate additional raw in excel export
	  
	  // seting default values
	  $display_min = empty_nc(fnumber_format($result_sdii[0]['sdii_min_value'], 'auto', false));
	  $display_max = empty_nc(fnumber_format($result_sdii[0]['sdii_max_value'], 'auto', false));
	  $display_threshold = empty_none(fnumber_format($result_sdii[0]['sdii_threshold_value'], 'auto', false));

	  // indicator is multivalues
	  if(!empty($result_value[$i]['sdiv_multivalue'])) {

	  	$data = unserialize($result_value[$i]['sdiv_multivalue']);

	  	foreach($data as &$val) {
	  		$current_val .= '<p class="indicator-multivalue">';
	  		if(!empty($val['label'])) $current_val .= '<span class="value-label" data-label="'.formatText($val['label'], '2HTML').'">'.formatText($val['label'], '2HTML'). '</span> : ';
	  		$current_val .= '<span class="value-value" data-value="'.$val['value'].'">'.fnumber_format($val['value'], 'auto', false). '</span> <span class="value-percent"> ('.fnumber_format($val['_percentage'], 2, false).' %)</span>';
	  		$current_val .= '</p>';
	  		
	  		$raw_multivalue .= formatText($val['label'], '2HTML') . ' : ' . $val['value'] . '<br />';
	  		$data_pie .= formatText($val['label'], '2HTML').'='.$val['value'].'||';
	  	}
	  	// we display the total
	  	$current_val .= '<p class="value-total indicator-multivalue">';
	  	$current_val .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : <span class="total-numeric" data-total="'.$data[0]['_total'].'">' . fnumber_format($data[0]['_total'], 'auto', false) . '</span>';
	  	$current_val .= ' <span>(<a class="ajaxload" data-date="'. formatText($result_value[$i]['date_p'], '2HTML').'" data-pie="'.$data_pie.'" href="'. override('../dashboard/pie.php').'?id='.$id.'&amp;value='.$result_value[$i]['sdiv_id'].'&amp;display=true">'._t('dashboard', 'to_detail_chart').'</a>)</span>';
	  	$current_val .= '</p>';
	  	
	  	$current_val_raw = $data[0]['_total'];

	  	if($i == 0) {
	  		$lastValue = $current_val_raw; // we store data to compute TCAM and global rate
	  		$year_end = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
	  	}
	  	if($i == count($result_value)-1) {
	  		$firstValue = $current_val_raw; // we store data to compute TCAM and global rate
	  		$year_start = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
	  	}
	  	
	  	// we compute rate
	  	if(isset($result_value[$i+1]['sdiv_multivalue'])) {
	  		$dataPlusOne = unserialize($result_value[$i+1]['sdiv_multivalue']);
	  		$evol = ($data[0]['_total'] - $dataPlusOne[0]['_total']) / $dataPlusOne[0]['_total'] * 100;
	  		// _debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$data[0]['_total']. ' - ' . $dataPlusOne[0]['_total']. ') / '. $dataPlusOne[0]['_total']);
	  		$evol = fnumber_format($evol, 2). ' %';
	  	} else {
	  		$evol = empty_nc('');
	  	}

	  	// indicator is NOT multivalues
	  } else {
	  	

	  	
	  	// If indicator is boolean or qualitative
	  	if($result_sdii[0]['sdii_type'] == 'boolean' || $result_sdii[0]['sdii_type'] == 'qualitative') {
	  		$a = getBooleanValues($result_sdii[0]);
	  		if($a) {
	  			$index = array();
	  			foreach ($a as $key => $value) {
	  				array_push($index, $key);
	  			}
	  			$current_val .= $a[$result_value[$i]['sdiv_value']];
	  			$current_val_raw = $result_value[$i]['sdiv_value'];

	  			$maskminvalue = $a[min($index)];
	  			$maskmaxvalue = $a[max($index)];
	  			if(is_null($result_value[$i]['sdiv_threshold'])) $threshold = empty_none('');
	  			else $threshold = $a[$result_value[$i]['sdiv_threshold']];
	  			
	  			
	  		} else {
	  			$current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
	  			$current_val_raw = $result_value[$i]['sdiv_value'];
	  		}
	  		
	  	} else {
	  		$current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
	  		$current_val_raw = $result_value[$i]['sdiv_value'];
	  		
	  		if($i == 0) {
	  			$lastValue = $current_val_raw; // we store data to compute TCAM and global rate
	  			$year_end = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
	  		}
	  		if($i == count($result_value)-1) {
	  			$firstValue = $current_val_raw; // we store data to compute TCAM and global rate
	  			$year_start = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
	  		}
	  	}

	  	$evol = empty_nc('');
	  	// we compute rate - 
	  	if($result_sdii[0]['sdii_type'] == 'quantitative') {
		  	if(isset($result_value[$i+1]['sdiv_value']) && is_numeric($result_value[$i+1]['sdiv_value'])) {
		  		$evol = ($result_value[$i]['sdiv_value'] - $result_value[$i+1]['sdiv_value']) / $result_value[$i+1]['sdiv_value'] * 100;
		  		// _debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$result_value[$i]['sdiv_value']. ' - ' . $result_value[$i+1]['sdiv_value']. ') / '. $result_value[$i+1]['sdiv_value']);
		  		$evol = fnumber_format($evol, 2). ' %';
		  	}
	  	}
	  }
	  
	  $threshold_raw = $default_threshold;

	  // default threshold values
	  if($result_sdii[0]['sdii_type'] == 'quantitative') {
	  	$threshold = empty_none(fnumber_format($default_threshold, 'auto', false));	  	
	  } else {
	  	
	  	if(is_null($default_threshold)) {
	  		$threshold = empty_none('');
	  	} else {
	  		$threshold = $a[$default_threshold];
	  	}
	  }
	  
	  // if set, we get it from the table
	  if(!is_null($result_value[$i]['sdiv_threshold'])) {
	  	if($result_sdii[0]['sdii_type'] == 'boolean' || $result_sdii[0]['sdii_type'] == 'qualitative') {
	  		$threshold = $a[$result_value[$i]['sdiv_threshold']];
		  	$threshold_raw = $result_value[$i]['sdiv_threshold'];
	  	} else {
	  		$threshold = fnumber_format($result_value[$i]['sdiv_threshold'], 'auto', false);
	  		$threshold_raw = $result_value[$i]['sdiv_threshold'];
	  	}
	  }


	  ($result_value[$i]['sdiv_comment_display'] == 'Y') ? $comment_status = _t('dashboard', 'public') : $comment_status = _t('dashboard', 'private');
	  if(!empty($result_value[$i]['sdiv_comment'])) {
	    $comment  = '<div class="valuecomment">';
	    $comment .= '<img src="'.THEME_ADMIN_PATH.'images/indic-comment.png" />';
	    $comment .= '<div class="cont"><strong>'.ucfirst(_t('dashboard', 'comment')).' ('.$comment_status.') :</strong> '.$result_value[$i]['sdiv_comment'].'</div>';
	    $comment .= '</div>';
	  }
	  echo "<tr>\n";
	  echo "<td class=\"date\" data-date=\"". formatText($result_value[$i]['date_p'], '2HTML')."\">". formatText($result_value[$i]['date_p'], '2HTML')."</td>\n";
	  echo "<td>". $result_value[$i]['user_login']."</td>\n";
	  echo "<td class=\"value\" data-value=\"". $current_val_raw."\">". formatText($current_val, '2HTML');
	  if($result_sdii[0]['sdii_value_type'] == 'multiple') echo "<td style=\"display:none\"  data-tableexport-display=\"always\">".$raw_multivalue."</td>\n";
	   
	  if ($result_value[$i]['sdiv_statut']=='D') {
	    echo "<span class=\"state\">".mb_ucfirst(_t('statut','draft'))."</span>";
	  }
	  echo "</td>\n";
	  echo "<td class=\"threshold\" data-threshold=\"". $threshold_raw ."\">". $threshold."</td>\n";
	  echo "<td class=\"rate\">". $evol."</td>\n";
	  echo "<td>". $comment."</td>\n";
	  echo "<td><div class=\"iconetab\"><a href=\"".$link_sup.$result_value[$i]['sdiv_id']."&amp;id=".$id."&amp;scale_id=".$scale_id."\" title=\""._t('dashboard','sup')."\" class=\"ico_sup\"><i class=\"icon-trash\"></i><span>" . _t('dashboard','sup') . "</span></a>";
	  echo "<a href=\"".$link_mod.$result_value[$i]['sdiv_id']."&amp;id=".$id."&amp;scale_id=".$scale_id."\" title=\""._t('dashboard','mod')."\" class=\"ico_mod\"><i class=\"icon-pencil\"></i><span>" . _t('dashboard','mod') . "</span></a></div></td>\n";
	  echo "</tr>\n";

	}

	// Ability to sort table
	addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
	footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
	$str = '$("table.multisort").tablesorter({	});';
	footerAddInlineJS($str);
	?>
	</tbody>
</table>
<?php 
if($result_sdii[0]['sdii_type'] == 'quantitative') echo getRates($firstValue, $lastValue, $year_start, $year_end);
?>

<!-- dropdown container -->
<div class="dropdown export-button" id="export-values">
<!-- trigger button -->
<button><i class="icon-export"></i> <?php echo _t('dashboard', 'export_values'); ?></button>
    <!-- dropdown menu -->
    <ul class="dropdown-menu">
        <li><a href="#export-values" data-format="excel"><i class="icon-file-excel"></i> <?php echo _t('export', 'format', 'excel'); ?></a></li>
        <li><a href="#export-values" data-format="csv"><i class="icon-file-code"></i> <?php echo _t('export', 'format', 'csv'); ?></a></li>
        <li><a href="#export-values" data-format="json"><i class="icon-file-code"></i> <?php echo _t('export', 'format', 'json'); ?></a></li>
        <li><a href="#export-values" data-format="png"><i class="icon-file-image"></i> <?php echo _t('export', 'format', 'png'); ?></a></li> 
    </ul>
    
</div>

<?php 
// Insert Javascript instructions to allow client Excel export
footerAddJS('../lib/js/tableExport.jquery.plugin/tableExport.min.js');
footerAddJS('../lib/js/tableExport.jquery.plugin/libs/html2canvas/html2canvas.min.js');

$slug_name = Stringy\Stringy::create($result_sdii[0]['sdii_name'], CHARSET)->safeTruncate(50)->slugify();


$str = '$("#export-values li a").click(function() {
						
						var format = $(this).attr("data-format");
						var ignoreCol = []; // set columns to ignore
		
						// if is multi-values table we dynamically change the content
						if( $("#indicator-values").hasClass("multi-values") && format != "png") {
							$el = $("#indicator-values").clone().attr("id", "indicator-values-clone"); // we create a clone
							ignoreCol.push(7);
							$el.find( "td.value" ).each(function( index ) {
								// we replace all values by total value only
								$( this ).text($( this ).find("p.value-total span.total-numeric").attr("data-total") );
							});

							$el.insertAfter("#export-values"); // if not displayed, the export does not work
						} else {
							$el = $("#indicator-values");
							ignoreCol.push(7);
						}
					if(format == "png") $("html, body").scrollTop(0);
  					$el.tableExport(
							{tableName:"'.mb_ucfirst($result_sdii[0]['sdii_name'] . ' - ' .$result_sdii[0]['sdii_unit'] . ' / '. $resultscale2[0]['scale_denomination']). '",type:format,escape:\'false\',ignoreColumn: ignoreCol,displayTableName:\'true\',htmlContent:\'false\',fileName:\'' . $slug_name . '\'});
						
						return false;
						});';
footerAddInlineJS($str);
?>


	<?php }
	else echo "<div class=\"info\">"._t('dashboard','novalue').": ".formatText($resultscale2[0]['scale_denomination'], '2HTML')."</div>";
	?>

<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','level')) ?> :</dt>
	<dd><?php
	if ($l21auth->isSuperAdmin())
	echo "<a href=\"".$link_det_level.$result_sdii[0]['sdii_level']."\" title=\"".formatText($result_sdii[0]['level_name'], '2HTML')."\">".formatText($result_sdii[0]['level_name'], '2HTML')."</a>";
	else echo formatText($result_sdii[0]['level_name'], '2HTML');
	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','description')) ?> :</dt>
	<dd><?php echo formatText($result_sdii[0]['sdii_description'], '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','threshold_relative')) ?> :</dt>
	<dd><?php
	if ($result_sdii[0]['sdii_threshold_relative']=='Y') echo mb_ucfirst(_t('sdi','threshold_relative_Y'));
	else echo mb_ucfirst(_t('sdi','threshold_relative_N'));
	?></dd>
</dl>


<h2><?php echo _t('sdi','info_mesure'); ?></h2>

<table>
	<thead>
		<tr>
		<?php
		echo "<td>".mb_ucfirst(_t('sdi','min_value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','max_value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','initial_threshold_value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','frequency'))."</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php
	
	isset($maskminvalue) ? $display_min = $maskminvalue : $display_min = empty_nc(fnumber_format($result_sdii[0]['sdii_min_value'], 'auto', false));
	isset($maskmaxvalue) ? $display_max = $maskmaxvalue : $display_max = empty_nc(fnumber_format($result_sdii[0]['sdii_max_value'], 'auto', false));
	
	echo "<tr>\n";
	echo "<td>". $display_min."</td>\n";
	echo "<td>". $display_max."</td>\n";
	echo "<td>". $display_threshold ."</td>\n";
	echo "<td>". formatText(fnumber_format($result_sdii[0]['sdii_frequency'], 'auto', false), '2HTML')."</td>\n";
	echo "</tr>\n";
	?>
	</tbody>
</table>

<div class="toggle_title">
	<a href="" id="affinfoge"><?php echo mb_ucfirst(_t('dashboard','det_sdi'));?></a>
</div>
<div id="general" style="display: none;" class="mtm">
<dl class="dl2">

<?php /*<dt><?php echo mb_ucfirst(_t('sdi','range')) ?> : </dt>
<dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_range']), '2HTML');?></dd> */ ?>
	<dt><?php echo mb_ucfirst(_t('sdi','comment')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_comment']), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','goal')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_goal']), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','consulting')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_consulting']), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','statut')) ?> :</dt>
	<dd><?php echo display_statut($result_sdii[0]['sdii_statut']);?></dd>
</dl>
</div>

<div class="toggle_title">
	<a href="#" id="affprovider"><?php echo _t('sdi','aff_sdi_p');?></a>
</div>
<div id="provider" style="display: none;" class="mtm"><?php if ($result_p[0]['sdip_name']=="") {
  echo "<h2 class=\"info\">"._t('divers','nodata')."</h2>";
}else {?> <?php
if(empty($result_p[0]['sdip_email'])) {
  $mailto_provider = empty_nc($result_p[0]['sdip_email']);
} else {
  $mailto_provider =  "<a href=\"mailto:".formatText(empty_nc($result_p[0]['sdip_email']), '2HTML')."\" title=\"".formatText(empty_nc($result_p[0]['sdip_email']), '2HTML')."\">".formatText(empty_nc($result_p[0]['sdip_email']), '2HTML')."</a>";
}
?>
<h2><?php echo formatText(empty_nc($result_p[0]['sdip_name']), '2HTML');?></h2>
<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','p_service')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_p[0]['sdip_service']), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_incharge')) ?>	:</dt>
	<dd><?php echo formatText(empty_nc($result_p[0]['sdip_incharge']), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_address')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_p[0]['sdip_address']), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_phone')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_p[0]['sdip_phone']), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_fax')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_p[0]['sdip_fax']), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_email')) ?> :</dt>
	<dd><?php echo $mailto_provider; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_description')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_p[0]['sdip_description']), '2HTML');?></dd>
</dl>
<?php } ?></div>

<div class="toggle_title">
	<a href="#" id="affeval"><?php echo _t('sdi','aff_sdi_e');?></a>
</div>
<div id="evaluation" style="display: none;" class="mtm">
<table>
	<thead>
		<tr>
		<?php
		echo "<td>".mb_ucfirst(_t('sdi','e_scale_compare'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_fiability'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_accessibility'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_lisibility'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_relevance'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_global_performance'))."</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php echo "<tr>\n";
	echo "<td>". empty_nc($result_e[0]['sdie_scale_compare'])."</td>\n";
	echo "<td>". empty_nc($result_e[0]['sdie_fiability'])."</td>\n";
	echo "<td>". empty_nc($result_e[0]['sdie_accessibility'])."</td>\n";
	echo "<td>". empty_nc($result_e[0]['sdie_lisibility'])."</td>\n";
	echo "<td>". empty_nc($result_e[0]['sdie_relevance'])."</td>\n";
	echo "<td>". empty_nc($result_e[0]['sdie_global_performance'])."</td>\n";
	echo "</tr>\n";
	?>
	</tbody>
</table>
</div>

<div class="toggle_title">
	<a href="#" id="affreg"><?php echo _t('sdi','aff_sdi_r');?></a>
</div>
<div id="reglementation" style="display: none;"  class="mtm"><?php if ($result_r[0]['sdir_title']=="") {
  echo "<h2 class=\"info\">"._t('divers','nodata')."</h2>";
}else {?> <?php
if(empty($result_r[0]['sdir_referer_uri'])) {
  $rules_link = empty_nc($result_r[0]['sdir_referer_uri']);
} else {
  $rules_link = "<a href=\"".formatText(empty_nc($result_r[0]['sdir_referer_uri']), '2HTML')."\" title=\"".formatText(empty_nc($result_r[0]['sdir_mask_uri']), '2HTML')."\" class=\"out\">".formatText(empty_nc($result_r[0]['sdir_mask_uri']), '2HTML')."</a>";
}
?>
<h2><?php echo formatText(empty_nc($result_r[0]['sdir_title']), '2HTML');?></h2>

<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','r_referer_uri')) ?> :</dt>
	<dd><?php echo $rules_link; "</dd>"; ?>
</dl>

<div>
  <?php echo formatText(empty_nc($result_r[0]['sdir_body']), '2HTML'); ?>
</div>
<?php } ?>
</div>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->

<script type="text/javascript">
$(document).ready(function() {
	$(".ajaxload").colorbox({iframe:true, width:"650px", height:"600px"});
	$(".valuecomment").hover(
		function() {
			$('.cont', this).fadeIn();
		},
		function() {
			$('.cont', this).hide();
		});
});
</script>