<?php
/**
 * Dashboard module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../dashboard/' . SQL . '.inc.php'));
include_once(override('../dashboard/common.php'));
/**
 * DisplayListValuesByLevels()
 * affichage du tableau de bord
 * @param integer $id_filter
 * @param integer $filter
 * @return
 **/

if(!function_exists('DisplayListValuesByLevels')) {

	function DisplayListValuesByLevels($id_filter = -1, $filter = -1)
	{
		$firstlevels = $GLOBALS['sql_object'] ->DBSelect(SQL_getLevelsList(true));
		
		$sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("P", $valueparam = 0));
		if(!isset($sdi[0]['sdii_id'])) return false;
		$sdi = add_root_level($sdi, 'sdii_level', 'level_root'); // we add extra field with level root
		
		$listing = "";

		$a = array(); // do not display an indicator twice

		$current_level = '';

		for ($i = 0;$i < count($firstlevels);$i++) {
			if ($firstlevels[$i]['level_id'] != $current_level && $current_level <> '') {
				$listing .= "</tbody>" . PHP_EOL;
				$listing .= "</table>" . PHP_EOL;
			}
			if ($firstlevels[$i]['level_id'] != $current_level) {

				$current_level = $firstlevels[$i]['level_id'];
				$listing .= "<h2 class=\"dashboard level-".$current_level."\">" . formatText($firstlevels[$i]['level_name'], '2HTML') . "</h2>".PHP_EOL;
				$listing .= '<table class="table_dashboard" summary="'.sprintf(_t('dashboard','list_public_summary'), formatText($firstlevels[$i]['level_name'], '2HTML')).'">' . PHP_EOL;
				$listing .= '<thead>' . PHP_EOL;
				$listing .= '<tr>' . PHP_EOL;
				$listing .= '<td class="graphic-values pt2">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . PHP_EOL;
				$listing .= '<td class="pt3">'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . PHP_EOL;
				$listing .= '</tr>' . PHP_EOL;
				$listing .= '</thead>' . PHP_EOL;
				$listing .= '<tbody>' . PHP_EOL;

			}
			for ($j = 0;$j < count($sdi);$j++) {
				if ($firstlevels[$i]['level_id'] == $sdi[$j]['level_root']) {

					// we display the value only if attached to dashboard
					// and if not yet displayed
					if ($sdi[$j]['sdii_to_dashboard']=='Y' && !in_array($sdi[$j]['sdii_id'], $a)) {
						// setting $threshold_value
						// By default initial value
						$threshold_value = $sdi[$j]['sdii_threshold_value'];
						// if set, we get the latest for the given scale
						$r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($sdi[$j]['sdii_id'], $id_filter));
						if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
							$threshold_value = $r[0]['sdiv_threshold'];
						}

						$link_det_sdi= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $sdi[$j]['sdii_name']);
						$listing .= "<tr>" . PHP_EOL;
						$listing .= "<td class=\"graphic-values indicator-".$sdi[$j]['sdii_type']."\">";
						$listing .= getViz($GLOBALS['sql_object'], $id_filter, $sdi[$j], $threshold_value);
						$listing .= "</td>";
						$listing .= "<td class=\"nomargin\"><a href=\"" . HrefMaker($link_det_sdi) . "\" title=\"" . formatText($sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText($sdi[$j]['sdii_name'], '2HTML') . "</a></td>" . PHP_EOL;
						$listing .= "</tr>" . PHP_EOL;

						array_push($a, $sdi[$j]['sdii_id']); // we add the id into array for not displaying it twice
					}
				}
			}
		}
		$listing .= "</tbody>" . PHP_EOL;
		$listing .= "</table>" . PHP_EOL;

		hoverJsBox();

		// including sparkline code
		footerAddJS('../lib/js/jquery.sparkline.min.js');
		footerAddInlineJS("$('.inlinebar').sparkline('html', {type: 'bar', barColor: '#8DA8CB'} );");

		echo $listing;
	}
}

/**
 * DisplayListValuesByProjects()
 * affichage du tableau de bord
 * @param integer $id_filter
 * @param integer $filter
 * @return
 **/

if(!function_exists('DisplayListValuesByProjects')) {

	function DisplayListValuesByProjects($id_filter = -1, $filter = -1)
	{
		$result = $GLOBALS['sql_object'] -> DBSelect(SQL_getListProjects());
		$result_sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("P", $valueparam = 0));
		if(!isset($result_sdi[0]['sdii_id'])) return false;
		
		$listing = "";

		$current_project = '';

		for ($i = 0;$i < count($result);$i++) {
			if ($result[$i]['project_id'] != $current_project && $current_project <> '') {
				$listing .= "</tbody>" . PHP_EOL;
				$listing .= "</table>" . PHP_EOL;
			}
			if ($result[$i]['project_id'] != $current_project) {

				$current_project = $result[$i]['project_id'];
				$listing .= "<h2 class=\"dashboard project-".$current_project."\">" . formatText($result[$i]['project_name'], '2HTML') . "</h2>".PHP_EOL;
				$listing .= '<table class="table_dashboard" summary="'.sprintf(_t('dashboard','list_public_summary'), formatText($result[$i]['project_name'], '2HTML')).'">' . PHP_EOL;
				$listing .= '<thead>' . PHP_EOL;
				$listing .= '<tr>' . PHP_EOL;
				$listing .= '<td class="graphic-values">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . PHP_EOL;
				$listing .= '<td>'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . PHP_EOL;
				$listing .= '</tr>' . PHP_EOL;
				$listing .= '</thead>' . PHP_EOL;
				$listing .= '<tbody>' . PHP_EOL;
					
			}
			for ($j = 0;$j < count($result_sdi);$j++) {
				if ($result[$i]['project_id'] == $result_sdi[$j]['jps_project_id']) {
						
					// we display the value only if attached to dashboard
					//if ($result_sdi[$j]['sdii_to_dashboard']=='Y') {
						// setting $threshold_value
						// By default initial value
						$threshold_value = $result_sdi[$j]['sdii_threshold_value'];
						// if set, we get the latest for the given scale
						$r = $GLOBALS['sql_object'] -> DBSelect(SQL_getlastInsertByPublicationDate($result_sdi[$j]['sdii_id'], $id_filter));
						if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
							$threshold_value = $r[0]['sdiv_threshold'];
						}
							
						$link_det_sdi= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$result_sdi[$j]['sdii_id'], 'parentid'=> $id_filter, 'name' => $result_sdi[$j]['sdii_name']);
						$listing .= "<tr>" . PHP_EOL;
						$listing .= "<td class=\"graphic-values indicator-".$result_sdi[$j]['sdii_type']."\">";
						$listing .= getViz($GLOBALS['sql_object'], $id_filter, $result_sdi[$j], $threshold_value);
						$listing .= "</td>";
						$listing .= "<td class=\"nomargin\"><a href=\"" . HrefMaker($link_det_sdi) . "\" title=\"" . formatText($result_sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText($result_sdi[$j]['sdii_name'], '2HTML') . "</a></td>" . PHP_EOL;
						$listing .= "</tr>" . PHP_EOL;
					//}
				}
			}
		}
		$listing .= "</tbody>" . PHP_EOL;
		$listing .= "</table>" . PHP_EOL;

		hoverJsBox();

		// including sparkline code
		footerAddJS('../lib/js/jquery.sparkline.min.js');
		footerAddInlineJS("$('.inlinebar').sparkline('html', {type: 'bar', barColor: '#8DA8CB'} );");
		
		echo $listing;
	}
}

function hoverJsBox() {

	$js = '<script type="text/javascript">
	$(document).ready(function() {
	$(".dashboard-indicator-gauge .cursor").removeAttr("title");
	$(".infobox").hover(
		function() {
			$(this).next().fadeIn("fast");
		},
		function() {
			$(this).next().hide();
		}
	);
	});
	</script>';
	footerAddInlineJS($js, 'default', false);
}


/**
 * DisplayOneSdi()
 * affichage d'un indicateur et infos résumé
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('DisplayOneSdi')) {

	function DisplayOneSdi($sdi_id, $scale_id)
	{
		echo GetSdiTitle($sdi_id, $scale_id);
		echo '<div id="tabs">';
		echo getDashboardNavigation($sdi_id,$scale_id);
		echo GetOneSdiInfoAndValues($sdi_id, $scale_id);
		echo GetOneSdiRules($sdi_id);
		echo GetOneSdiEvaluation($sdi_id);
		echo GetOneSdiProvider($sdi_id);
		echo '</div>';
	}
}


/**
 * GetAllValue()
 * afficahge de l'ensemble des valeurs publiques d'un IDD
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('GetAllValue')) {

	function GetAllValue($sdi_id, $scale_id)
	{
		
		if(defined('CLIENT_CHARTS') && CLIENT_CHARTS == 1) {
			echo '<script>var lang = "'.U_L.'";</script>';
			footerAddJS('../lib/js/Highcharts-4.1.8/js/highcharts.js');
			footerAddJS('../lib/js/Highcharts-4.1.8/js/modules/exporting.js');
			footerAddJS('../lib/js/generate-chart.js');
			//footerAddJS('../lib/js/Highcharts-4.1.8/js/themes/grid-light.js');
		}
		
		$result_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getAllValue("SCD", $scale_id, $sdi_id));
		$result_sdi_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getInfoSdiforvalue($sdi_id));

		// setting $default_threshold value
		// By default initial value
		$default_threshold = $result_sdi_value[0]['sdii_threshold_value'];
		
		$req_sdii=SQL_getInfoSdi($sdi_id);
		$result_sdii = $GLOBALS['sql_object'] -> DBSelect($req_sdii);
		// we init javascript vars for generating charts
		?>
		<script>
			var input = [];
			input['viz_title'] = "<?php echo formatText($result_sdii[0]['sdii_name'], '2HTML'); ?>";
			input['viz_type'] = "<?php echo $result_sdii[0]['sdii_detail_viz']; ?>";
			input['viz_vtype'] = "<?php echo $result_sdii[0]['sdii_value_type']; ?>"; // 'multiple' or 'unique'
			input['serie_name'] = "<?php echo formatText(_t('dashboard', 'value'), '2HTML'); ?>";
			input['threshold_name'] = "<?php echo formatText(_t('dashboard', 'threshold_value'), '2HTML'); ?>";
			input['yAxis_title'] = "<?php echo formatText($result_sdii[0]['sdii_unit'], '2HTML'); ?>";
			input['negative_notice'] = "<?php echo formatText(_t('dashboard', 'negative_values_notice')); ?>";
		</script>
		<?php

		$content = '<div id="indicator-value">' . PHP_EOL;
		$content .= '<h2 class="visually-hidden pal">'._t('dashboard','historic').'</h2>' . PHP_EOL;

		if ($result_value <> false) {
			if (count($result_value) > 2) {
				$content .= '<h3 class="visually-hidden">'._t('dashboard','rep_graph').' </h3>' . PHP_EOL;

				if($result_sdi_value[0]['sdii_type'] == 'quantitative') {
					if(!defined('CLIENT_CHARTS') || CLIENT_CHARTS != 1) {
						$graph_path = override('../dashboard/graph.php');
						$content .= "<img src=\"".$graph_path."?id=" . $sdi_id . "&amp;scale_id=" . $scale_id . "&amp;display=true\"  id=\"imggraph\" class=\"graph ptl\" alt=\"".formatText(_t('dashboard','rep_graph'), '2ATT')."\"/>" . PHP_EOL;
					} else {
						$content .= '<div id="main-chart-container"></div>';
					}
				}
				
				if($result_sdi_value[0]['sdii_type'] == 'qualitative') $content .= getQualitativeViz($result_value, $result_sdi_value[0]);
			}
			$content .= '<h3>'.mb_ucfirst(_t('dashboard','all_value')).'</h3>' . PHP_EOL;

			$content .= '<table class="indicator-values"  summary="'._t('dashboard','all_values_summary').'">' . PHP_EOL;
			$content .= '<thead>' . PHP_EOL;
			$content .= '<tr>' . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','date'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','value'))." (".$result_sdi_value[0]['sdii_unit'].")</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','threshold_value'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','rate'))."</td>" . PHP_EOL;
			$content .= "<td>".mb_ucfirst(_t('dashboard','comment'))."</td>" . PHP_EOL;
			$content .= "</tr>" . PHP_EOL;
			$content .= "</thead>" . PHP_EOL;
			$content .= "<tbody>" . PHP_EOL;
			
			for ($i = 0;$i < count($result_value);$i++) {
				$comment = '';
				$current_val = '';
				$data_pie = '';

				// indicator is multivalues
	 			if(!empty($result_value[$i]['sdiv_multivalue'])) {

	  			$data = unserialize($result_value[$i]['sdiv_multivalue']);
				
					foreach($data as &$val) {
						$current_val .= '<p class="indicator-multivalue">';
						if(!empty($val['label'])) $current_val .= '<span class="value-label" data-label="'.formatText($val['label'], '2HTML').'">'.formatText($val['label'], '2HTML'). '</span> : ';
						$current_val .= '<span class="value-value" data-value="'.$val['value'].'">'.fnumber_format($val['value'], 'auto', false). '</span> <span class="value-percent"> ('.fnumber_format($val['_percentage'], 2, false).' %)</span>';
						$current_val .= '</p>';
						$data_pie .= formatText($val['label'], '2HTML').'='.$val['value'].'||';
					}
					// we display the total
					$current_val .= '<p class="value-total indicator-multivalue">';
					$current_val .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : ' . fnumber_format($data[0]['_total'], 'auto', false);
					$current_val .= ' <span>(<a class="ajaxload" data-date="'. formatText($result_value[$i]['date_p'], '2HTML').'" data-pie="'.$data_pie.'" href="'. override('../dashboard/pie.php').'?id='.$sdi_id.'&amp;value='.$result_value[$i]['sdiv_id'].'&amp;display=true">'._t('dashboard', 'to_detail_chart').'</a>)</span>';
					$current_val .= '</p>';
					
					$current_val_raw = $data[0]['_total'];
					
		 			if($i == 0) {
				  		$lastValue = $current_val_raw; // we store data to compute TCAM and global rate
				  		$year_end = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
				  	}
				  	if($i == count($result_value)-1) {
				  		$firstValue = $current_val_raw; // we store data to compute TCAM and global rate
				  		$year_start = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
				  	}
					// we compute rate
					if(isset($result_value[$i+1]['sdiv_multivalue'])) {
						$dataPlusOne = unserialize($result_value[$i+1]['sdiv_multivalue']);
						$evol = ($data[0]['_total'] - $dataPlusOne[0]['_total']) / $dataPlusOne[0]['_total'] * 100;
						//_debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$data[0]['_total']. ' - ' . $dataPlusOne[0]['_total']. ') / '. $dataPlusOne[0]['_total']);
						$evol = fnumber_format($evol, 2). ' %';
					} else {
						$evol = empty_nc('');
					}

					// indicator is NOT multivalues
				} else {
					
					// If indicator is boolean
					if($result_sdi_value[0]['sdii_type'] == 'boolean' || $result_sdi_value[0]['sdii_type'] == 'qualitative') {
						$a = getBooleanValues($result_sdi_value[0]);
						if($a) {
							$current_val .= $a[$result_value[$i]['sdiv_value']];
							$current_val_raw = $result_value[$i]['sdiv_value'];
							
						} else {
							$current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
							$current_val_raw = $result_value[$i]['sdiv_value'];
						}
						 
					} else {
						$current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
						$current_val_raw = $result_value[$i]['sdiv_value'];
						
						if($i == 0) {
				  			$lastValue = $current_val_raw; // we store data to compute TCAM and global rate
				  			$year_end = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
				  		}
				  		if($i == count($result_value)-1) {
				  			$firstValue = $current_val_raw; // we store data to compute TCAM and global rate
				  			$year_start = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
				  		}
					}
					
					$evol = empty_nc('');
					// we compute rate
					if($result_sdii[0]['sdii_type'] == 'quantitative') {
						if(isset($result_value[$i+1]['sdiv_value']) && is_numeric($result_value[$i+1]['sdiv_value'])) {
							$evol = ($result_value[$i]['sdiv_value'] - $result_value[$i+1]['sdiv_value']) / $result_value[$i+1]['sdiv_value'] * 100;
							// _debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$result_value[$i]['sdiv_value']. ' - ' . $result_value[$i+1]['sdiv_value']. ') / '. $result_value[$i+1]['sdiv_value']);
							$evol = fnumber_format($evol, 2). ' %';
						} else {
							$evol = empty_nc('');
						}
					}
				}

				// if set, we get it from the table
				if(!is_null($result_value[$i]['sdiv_threshold'])) {
					if($result_sdi_value[0]['sdii_type'] == 'quantitative') {
						$threshold = fnumber_format($result_value[$i]['sdiv_threshold'], 'auto', false);
						$threshold_raw = $result_value[$i]['sdiv_threshold'];
					} else {
						$threshold = $a[$result_value[$i]['sdiv_threshold']];
						$threshold_raw = $result_value[$i]['sdiv_threshold'];
					}
				} else {
					$threshold = empty_none(fnumber_format($default_threshold, 'auto', false));
					$threshold_raw = $default_threshold;
				}
				$threshold_raw = $default_threshold;
				

			  if(!empty($result_value[$i]['sdiv_comment']) && $result_value[$i]['sdiv_comment_display']=='Y') {
			  	$comment  = '<div class="valuecomment">';
			  	$comment .= '<img src="'.PUBLIC_THEME_URL.'images/indic-comment.png" />';
			  	$comment .= '<div class="cont"><strong>'.ucfirst(_t('dashboard', 'comment')).' :</strong> '.$result_value[$i]['sdiv_comment'].'</div>';
			  	$comment .= '</div>';
			  }
			  $content .= "<tr>" . PHP_EOL;
			  $content .= "<td class=\"date\" data-date=\"". formatText($result_value[$i]['date_p'], '2HTML')."\">" . formatText($result_value[$i]['date_p'], '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td class=\"value\" data-value=\"". $current_val_raw."\">" . formatText($current_val, '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td class=\"threshold\" data-threshold=\"". $threshold_raw ."\">" . formatText($threshold, '2HTML') . "</td>" . PHP_EOL;
			  $content .= "<td class=\"rate\">". $evol. "</td>" . PHP_EOL;
			  $content .= "<td>". $comment. "</td>" . PHP_EOL;
			  $content .= "</tr>" . PHP_EOL;

			}

			$content .= "</tbody>" . PHP_EOL;
			$content .= "</table>" . PHP_EOL;
			
			if($result_sdii[0]['sdii_type'] == 'quantitative') $content .= getRates($firstValue, $lastValue, $year_start, $year_end);
			
			if(!empty($default_threshold)) $content .= '<div id="indicator-threshold" class="small txtright mrs">'.mb_ucfirst(_t('sdi','initial_threshold_value')).' : <span>'.$result_sdi_value[0]['sdii_threshold_value'].' '.$result_sdi_value[0]['sdii_unit'].'</span></div>' . PHP_EOL;
				
			$content .= '</div>' . PHP_EOL;
			
			
			return $content;
		}
	}
}

/**
 * GetSdiTitle()
 * affichage nom d'un indicateur
 * @param $sdi_id
 * @param $scale_id
 * @return
 **/
if(!function_exists('GetSdiTitle')) {

	function GetSdiTitle($sdi_id, $scale_id)
	{
		$link_self= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id' => $sdi_id, 'parentid' => $_REQUEST['parentid']);
		$data_sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getOnesdiname($sdi_id, array('P')));

		if($data_sdi == 0) error_redirect();

		$data_scale = $GLOBALS['sql_object'] -> DBSelect(SQL_getonescale($scale_id));
		$sdi_name = formatText($data_sdi[0]['sdii_name'], '2HTML');
		$sdi_description = formatText($data_sdi[0]['sdii_description'], '2HTML');
		$scale_name = formatText(cutText($data_scale[0]['scale_denomination'], 150), '2HTML');
		$content  = '<div id="indicator-main">' . PHP_EOL;
		$content .= '<h1>' . mb_ucfirst($sdi_name) . '</h1>' . PHP_EOL;
		$content .='<p class="published_by">'.PHP_EOL;
		$content .= formatted_permalink($link_self);
		$content .='</p>'.PHP_EOL;
		$content .= '<div id="indicator-description" class="body clear">' . $sdi_description . '</div>' . PHP_EOL;
		$content .= '<p class="scale">'._t('divers', 'scale').' : <span>' . $scale_name . '</span></p>' . PHP_EOL;
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiInfo()
 * récupération des infos générales d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiInfoAndValues')) {

	function GetOneSdiInfoAndValues($sdi_id, $scale_id)
	{

		$content = '<div id="indicator-values" class="tab-content current internal-content">' . PHP_EOL;
		$content .= GetAllValue($sdi_id, $scale_id);
		$content .= GetOneSdiInfo($sdi_id);
		$content .= '</div>' . PHP_EOL;
		return $content;
	}
}

/**
 * GetOneSdiInfo()
 * récupération des infos générales d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiInfo')) {

	function GetOneSdiInfo($sdi_id)
	{
		$data = $GLOBALS['sql_object'] -> DBSelect(SQL_getInfoSdi($sdi_id));

		$sdi_name = formatText($data[0]['sdii_name'], '2HTML');
		$sdi_description = formatText($data[0]['sdii_description'], '2HTML');
		$sdi_comment = formatText($data[0]['sdii_comment'], '2HTML');
		$sdi_goal = formatText($data[0]['sdii_goal'], '2HTML');
		$sdi_consulting = formatText($data[0]['sdii_consulting'], '2HTML');

		$content = '<div id="indicator-info">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('dashboard','det_sdi2')).'</h2>' . PHP_EOL;
		$content .= '<h3> '.mb_ucfirst(_t('sdi','goal_public')).' </h3>' . PHP_EOL;
		$content .= '<div id="indicator-goal" class="body">' . $sdi_goal . '</div>' . PHP_EOL;
		$content .= '<h3>'.mb_ucfirst(_t('sdi','consulting_public')).'</h3>' . PHP_EOL;
		$content .= '<div id="indicator-advices" class="body clear">' . $sdi_consulting . '</div>' . PHP_EOL;
		$content .= '</div>' . PHP_EOL;
		return $content;
	}
}

/**
 * GetOneSdiRules()
 * récupération des réglementations d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiRules')) {

	function GetOneSdiRules($sdi_id)
	{
		$result_r = $GLOBALS['sql_object'] -> DBSelect(SQL_getRules($sdi_id, $GLOBALS['sql_object'], -1));
		$r_title = formatText($result_r[0]['sdir_title'], '2HTML');
		$r_body = formatText($result_r[0]['sdir_body'], '2HTML');
		if(!empty($result_r[0]['sdir_referer_uri'])) {
			$url = "<a href=\"" . formatText($result_r[0]['sdir_referer_uri'], '2HTML') . "\" title=\"" . formatText($result_r[0]['sdir_mask_uri'], '2ATT') . "\">" . formatText($result_r[0]['sdir_mask_uri'], '2HTML') . "</a>";
		}

		$content = '<div id="indicator-rules" class="tab-content internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','r_body')).'</h2>' . PHP_EOL;
		if ($result_r[0]['sdir_title'] == "") {
			$content .= "<p class=\"info\">"._t('divers','nodata')." </p>" . PHP_EOL;
		} else {
			$content .= "<h3>" . $r_title . "</h3>" . PHP_EOL;
			$content .= "<div class=\"body clear\">" . $r_body . "</div>" . PHP_EOL;
			if(isset($url)) {
				$content .= "<p>" . $url . "</p>" . PHP_EOL;
			}
		}
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiEvaluation()
 * récupération des critères d'évaluation d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiEvaluation')) {

	function GetOneSdiEvaluation($sdi_id)
	{
		$result_e = $GLOBALS['sql_object'] -> DBSelect(SQL_getEvaluation($sdi_id, $GLOBALS['sql_object'], -1));

		$content = '<div id="indicator-assessment" class="tab-content internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','e_title')).'</h2>' . PHP_EOL;
		$content .= '<table class="table_dashboard_det" summary="'._t('dashboard','evaluation_values_summary').'">' . PHP_EOL;
		$content .= '<thead>' . PHP_EOL;
		$content .= '<tr>' . PHP_EOL;
		$content .= "<td>"._t('sdi','e_scale_compare')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_fiability')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_accessibility')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_lisibility')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_relevance')."</td>" . PHP_EOL;
		$content .= "<td>"._t('sdi','e_global_performance')."</td>" . PHP_EOL;
		$content .= "</tr>" . PHP_EOL;
		$content .= "</thead>" . PHP_EOL;
		$content .= "<tbody>" . PHP_EOL;
		$content .= "<tr>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_scale_compare'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_fiability'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_accessibility'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_lisibility'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_relevance'] . "</td>" . PHP_EOL;
		$content .= "<td>" . $result_e[0]['sdie_global_performance'] . "</td>" . PHP_EOL;
		$content .= "</tr>" . PHP_EOL;
		$content .= "</tbody>" . PHP_EOL;
		$content .= "</table>" . PHP_EOL;
		$content .= '</div>' . PHP_EOL;

		return $content;
	}
}

/**
 * GetOneSdiProvider()
 * récupération des infos du fournisseurs d'un indicateur
 * @param $sdi_id
 * @return
 **/
if(!function_exists('GetOneSdiProvider')) {

	function GetOneSdiProvider($sdi_id)
	{
		$result_p = $GLOBALS['sql_object'] -> DBSelect(SQL_getProvider($sdi_id, $GLOBALS['sql_object'], -1));

		$p_name = formatText($result_p[0]['sdip_name'], '2HTML');
		$p_description = formatText($result_p[0]['sdip_description'], '2HTML');

		$content = '<div id="indicator-provider" class="tab-content internal-content">' . PHP_EOL;
		$content .= '<h2>'.mb_ucfirst(_t('sdi','p_title')).'</h2>' . PHP_EOL;
		if ($result_p[0]['sdip_name'] == "") {
			$content .= "<p class=\"info\">"._t('divers','nodata')." </p>" . PHP_EOL;
		} else {
			$content .= '<p>' . $p_name . '</p>' . PHP_EOL;
			$content .= '<div class="body clear">' . $p_description . '</div>' . PHP_EOL;
		}
		$content .= '</div>' . PHP_EOL;
		return $content;
	}
}

/**
 * getDataVizMode()
 * return a link to switch display mode
 * @param $scale_id
 * @return string
 * @todo remove or use to display tabular data
 **/
if(!function_exists('getDataVizSwitcher')) {

	function getDataVizSwitcher($altmode, $scale_id)
	{
		if( $altmode )  {
			$link = array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $scale_id);
			$msg = _t('dashboard', 'mode_by_finality');
		} else {
			$link = array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $scale_id, 'altmode' => true);
			$msg = _t('dashboard', 'mode_by_project');
		}
		// adding these vars to url allow to display the right scale into filter box
		// @todo filters should be enhanced
		if(array_key_exists('filter', $_REQUEST) && $_REQUEST['filter'] == $GLOBALS['filters'][U_L]['scale']['linkvalue']) {
			$link = array_merge($link, array('filter' => $GLOBALS['filters'][U_L]['scale']['linkvalue']));
		}
		
		
		$str   = '<div class="switchnav">';
		$str  .= '<a class="button" href="'.HrefMaker($link).'" title="'.$msg.'">'.$msg.'</a>'.PHP_EOL;
		$str  .= '</div>';

		return $str;
	}
}


/**
 * getDashboardNavigation()
 * Return a string with the internal navigation
 * @param int
 * @param int
 * @return string
 **/
if(!function_exists('getDashboardNavigation')) {

	function getDashboardNavigation($sdi_id,$scale_id)
	{

		// including easyTabs
		footerAddJS('../lib/js/jQuery-EasyTabs/vendor/jquery.hashchange.min.js');
		footerAddJS('../lib/js/jQuery-EasyTabs/lib/jquery.easytabs.min.js');
		footerAddInlineJS("$('#tabs').easytabs({animate:false});");
		
		$content  ="<ul class=\"internal-nav\" id=\"indicator-navigation\">". PHP_EOL;
		$content .="<li class=\"tab\">". PHP_EOL;
		$content .= '<a href="#indicator-values">' . _t('dashboard','mode_aff_info') . '</a>' . PHP_EOL;
		$content .="</li><!-- @whitespace". PHP_EOL;
		$content .="--><li class=\"tab\">". PHP_EOL;
		$content .= '<a href="#indicator-rules">' . _t('dashboard','mode_aff_rules') . '</a>' . PHP_EOL;
		$content .="</li><!-- @whitespace". PHP_EOL;
		$content .="--><li class=\"tab\">". PHP_EOL;
		$content .= '<a href="#indicator-provider">' . _t('dashboard','mode_aff_provider') . '</a>' . PHP_EOL;
		$content .="</li><!-- @whitespace". PHP_EOL;
		$content .="--><li class=\"tab\">". PHP_EOL;
		$content .= '<a href="#indicator-assessment">' . _t('dashboard','mode_aff_evaluation') . '</a>' . PHP_EOL;
		$content .="</li>". PHP_EOL;
		$content .="</ul>". PHP_EOL;

		return $content;
	}
}

?>