<?php
/**
 * Export module - pdf
 * 
 * Define constants used for generating pdf file
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

set_time_limit(60*10);

define('DOC_POLICE', 'sourcesanspro');
define('DOC_STYLE', '');
define('DOC_SIZE', 9);
define('DOC_HEIGHT', 4);	// hauteur des cellules
define('DOC_INTERVAL', 3);	//integer -- marge entre paragraphe
define('PARAGRAPH_BREAK', 8);	//integer -- saut de lignes entre parties

define('GRAPH_WIDTH', 300);
define('GRAPH_HEIGHT', 200);

define('DOC_TITLE_SIZE', 18);
define('DOC_TITLE_STYLE', 'B');

define('EM_STYLE', 'I');
define('MIN_SIZE', 8);

define('SDI_TITLE_STYLE', 'B');
define('SDI_TITLE_SIZE', 10);

define('SDI_ITEM_STYLE', 'B');
define('SDI_ITEM_SIZE', 9);

define('SDI_INFO_STYLE', 'B');
define('SDI_INFO_SIZE', 10);

define('ARRAY_DATA_STYLE', 'I');
define('ARRAY_DATA_SIZE', 7);

///////// Document colors settings ////////////
// Predefined colors are set here
//////////////////////////////////////////////
/**
 * getColor()
 *
 * @param string $ink
 * @return
 */
function getColor($ink = 'DOC_COLOR')
{
  $r = 0;
  $g = 0;
  $b = 0;

  switch ($ink) {
    case 'DOC_COLOR':
      $r = 0;
      $g = 0;
      $b = 0;
      break;
    case 'DOC_COLOR_HEADER':
      $r = 100;
      $g = 100;
      $b = 100;
      break;
    case 'DOC_COLOR_BORDER';
      $r = 34;
      $g = 122;
      $b = 155;
      break;
    case 'DOC_TITLE_COLOR';
      $r = 34;
      $g = 122;
      $b = 155;
      break;
    case 'DOC_ADVISE_COLOR':
      $r = 113;
      $g = 114;
      $b = 115;
      break;
    case 'SDI_TITLE_COLOR':
      $r = 82;
      $g = 117;
      $b = 181;
      break;
    case 'SDI_ITEM_COLOR':
//       $r = 236; // orange
//       $g = 158; // orange
//       $b = 22; // orange
			// #444444 hexa equivalent
			$r = 68;
			$g = 68;
			$b = 68;
      break;
    case 'SDI_INFO_COLOR':
      $r = 255;
      $g = 255;
      $b = 255;
//       $r = 68;
//       $g = 96;
//       $b = 96;
      break;
    case 'BCKG_PROVIDER':
      $r = 226;
      $g = 234;
      $b = 249;
      break;
    case 'BCKG_ITEM':
      $r = 226;
      $g = 234;
      $b = 249;
      break;
    case 'BCKG_INFO':
      $r = 119;
      $g = 152;
      $b = 183;
      $r = 158;
      $g = 158;
      $b = 158;
      break;

  }
  return array($r, $g, $b);
}


///////// DOCUMENT INFOS ////////////
$pdf->SetAuthor( $report_settings['author'] );
$pdf->SetCreator( SITE_LINEA_NAME );
$pdf->SetTitle( $report_settings['title'] );
$pdf->SetKeywords( $report_settings['title'] );
$pdf->SetSubject( $report_settings['title'] );
//////////////////////////////////

// set header data
$today = date("d-m-Y");
$pdf->SetHeaderData('', 0, SITE_NAME, formatText($report_settings['title']) .' - '.$today);

// set footer date

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

//set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);


///////// INITIALISATION DU DOCUMENT ////////////
$pdf->SetDisplayMode('fullwidth', 'single');
$pdf->SetAutoPageBreak(true, 17);
$pdf->SetTextColorArray(getColor('DOC_COLOR'));
$pdf->SetDrawColorArray(getColor('DOC_COLOR_BORDER'));
$pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
/////////////////////////////////////////////////
?>