<?php
/**
 * Export module - pdf
 * 
 * Write pdf report last page
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

///////////////////////////////////
// Récupération de données
///////////////////////////////////



$selected_scales = '';
$selected_indicators = '';
$selected_projects = '';

if($report_settings['export_module'] == 'dashboard') {
	
	$scale_content='';
	$sdi_content='';
	
	// liste des échelles sélectionées
	for($i=0; $i<count($scale_array); $i++) {
	  $scale_content.=$scale_denomination_array[$scale_array[$i]].'<br />'.PHP_EOL;
	}
	
	$selected_scales = '<tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['selected_scale']) .' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.$scale_content.'</td>
    </tr>';
	
	// liste des indicateurs sélectionés
	for($i=0; $i<count($sdi); $i++) {
	  $sdi_content.=$sdi[$i]['sdii_name'].'<br />'.PHP_EOL;
	}
	
	$selected_indicators = '<tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['selected_indicators']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.$sdi_content.'</td>
    </tr>';

}

if($report_settings['export_module'] == 'project') {

	$projects_content='';
	
	// liste des indicateurs sélectionés
	for($i=0; $i<count($project); $i++) {
		$projects_content.=$project[$i]['project_name'].'<br />'.PHP_EOL;
	}

	$selected_projects = '<tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['selected_projects']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.$projects_content.'</td>
    </tr>';

}

//////////////////////////////////

$pdf->AddPage();
$pdf->SetY($pdf->GetY()+20);
$pdf->SetX($pdf->GetX()+152);
$pdf->Bookmark($lang['report']['infopubli']);
// logo
// @todo - to finish
// if(file_exists(THEME_PUBLIC_PATH.'override/export/inc_report/logo_p.svg'))) $image_file = THEME_PUBLIC_PATH.'override/export/inc_report/logo_p.svg';
// if(file_exists(THEME_PUBLIC_PATH.'override/export/inc_report/logo_p.eps'))) $image_file = THEME_PUBLIC_PATH.'override/export/inc_report/logo_p.eps';

$image_file = override('../export/inc_report/logo_p.png', THEME_PUBLIC_PATH);
$pdf->Image($image_file,$pdf->GetX(), $pdf->GetY(), 0, 0, 'PNG', SITE_LINEA_URL);


//////////////////////////////////
// 	tableau récapitulatif
//////////////////////////////////
$margin = 20;
$pdf->SetY($pdf->GetY()+20);
$pdf->SetFont(DOC_POLICE, ARRAY_DATA_STYLE, ARRAY_DATA_SIZE);

$tbl = '
<table cellspacing="0" cellpadding="5">
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['title']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['title']).'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['divers']['date_crea']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.date("d-m-Y H:i:s").'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['author']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['author']).'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['mail_author']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['mail_author']).'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['service']).' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['service_author']).'</td>
    </tr>
    <tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['address']) .' : </td>
        <td width="70%" style="border-bottom:1px solid #E5E5E5">'.formatText($report_settings['adress_author']).'</td>
    </tr>'
        		. $selected_indicators .

    ''
        		. $selected_scales .
    ''
        		. $selected_projects .

    '<tr>
        <td width="30%" align="right">'.mb_ucfirst($lang['report']['generated'].'('.$lang['divers']['seconds'].')').' : </td>
        <td>'.round($total_time, 2).'</td>
    </tr>
</table>';

$pdf->writeHTML($tbl, true, false, false, false, '');

$pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
?>